/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.juniform.ui.tree;

import java.util.Arrays;
import java.util.Iterator;
import javafx.collections.ListChangeListener;
import javafx.scene.control.TreeCell;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.util.Callback;
import org.applied_geodesy.adjustment.geometry.Feature;
import org.applied_geodesy.adjustment.geometry.FeatureAdjustment;
import org.applied_geodesy.adjustment.geometry.FeatureChangeListener;
import org.applied_geodesy.adjustment.geometry.FeatureEvent;
import org.applied_geodesy.adjustment.geometry.FeatureType;
import org.applied_geodesy.adjustment.geometry.GeometricPrimitive;
import org.applied_geodesy.adjustment.geometry.PrimitiveType;
import org.applied_geodesy.adjustment.geometry.curve.primitive.Curve;
import org.applied_geodesy.adjustment.geometry.surface.primitive.Surface;
import org.applied_geodesy.juniform.ui.dialog.GeometricPrimitiveDialog;
import org.applied_geodesy.juniform.ui.i18n.I18N;
import org.applied_geodesy.juniform.ui.tabpane.UITabPaneBuilder;
import org.applied_geodesy.juniform.ui.tree.AdjustmentTreeItemValue;
import org.applied_geodesy.juniform.ui.tree.CurveTreeItemValue;
import org.applied_geodesy.juniform.ui.tree.EditableMenuTreeCell;
import org.applied_geodesy.juniform.ui.tree.FeatureTreeItemValue;
import org.applied_geodesy.juniform.ui.tree.GeometricPrimitivesTreeItemValue;
import org.applied_geodesy.juniform.ui.tree.SurfaceTreeItemValue;
import org.applied_geodesy.juniform.ui.tree.TreeItemType;
import org.applied_geodesy.juniform.ui.tree.TreeItemValue;

public class UITreeBuilder
implements FeatureChangeListener {
    private final I18N i18n = I18N.getInstance();
    private static UITreeBuilder treeBuilder = new UITreeBuilder();
    private UITabPaneBuilder tabPaneBuilder = UITabPaneBuilder.getInstance();
    private TreeView<TreeItemValue<?>> treeView;
    private GeometricPrimitiveListChangeListener geometricPrimitiveListChangeListener = new GeometricPrimitiveListChangeListener();
    private TreeListSelectionChangeListener treeListSelectionChangeListener = new TreeListSelectionChangeListener();
    private FeatureType featureType = FeatureType.SURFACE;
    private TreeItem<TreeItemValue<?>> lastValidSelectedTreeItem = null;

    private UITreeBuilder() {
    }

    public static UITreeBuilder getInstance() {
        treeBuilder.init();
        return treeBuilder;
    }

    public TreeView<TreeItemValue<?>> getTree() {
        return this.treeView;
    }

    private void init() {
        if (this.treeView != null) {
            return;
        }
        this.treeView = new TreeView();
        this.treeView.setEditable(true);
        this.treeView.setCellFactory(new Callback<TreeView<TreeItemValue<?>>, TreeCell<TreeItemValue<?>>>(){

            public TreeCell<TreeItemValue<?>> call(TreeView<TreeItemValue<?>> treeView) {
                return new EditableMenuTreeCell();
            }
        });
        AdjustmentTreeItemValue adjustmentTreeItemValue = new AdjustmentTreeItemValue(this.i18n.getString("UITreeBuilder.root", "JUniForm"));
        FeatureTreeItemValue featureTreeItemValue = new FeatureTreeItemValue(this.i18n.getString("UITreeBuilder.feature.label", "Feature"));
        TreeItem<TreeItemValue<?>> rootItem = this.createItem(adjustmentTreeItemValue);
        TreeItem<TreeItemValue<?>> featureItem = this.createItem(featureTreeItemValue);
        rootItem.getChildren().addAll(Arrays.asList(featureItem));
        this.treeView.setRoot(rootItem);
        this.treeView.setShowRoot(false);
        this.treeView.getSelectionModel().getSelectedItems().addListener((ListChangeListener)this.treeListSelectionChangeListener);
        this.treeView.getSelectionModel().select(0);
    }

    public void handleTreeSelections() {
        this.handleTreeSelections(this.lastValidSelectedTreeItem);
    }

    private TreeItem<TreeItemValue<?>> createItem(TreeItemValue<?> value) {
        TreeItem item = new TreeItem(value);
        item.setExpanded(true);
        return item;
    }

    private TreeItem<TreeItemValue<?>> searchTreeItem(TreeItem<TreeItemValue<?>> item, Object object) {
        if (item == null) {
            return null;
        }
        if (((TreeItemValue)item.getValue()).getObject() == object) {
            return item;
        }
        TreeItem<TreeItemValue<?>> result = null;
        for (TreeItem child : item.getChildren()) {
            result = this.searchTreeItem(child, object);
            if (result == null) continue;
            return result;
        }
        return result;
    }

    private TreeItem<TreeItemValue<?>> searchTreeItem(TreeItem<TreeItemValue<?>> item, TreeItemType treeItemType) {
        if (item == null) {
            return null;
        }
        if (((TreeItemValue)item.getValue()).getTreeItemType() == treeItemType) {
            return item;
        }
        TreeItem<TreeItemValue<?>> result = null;
        for (TreeItem child : item.getChildren()) {
            result = this.searchTreeItem(child, treeItemType);
            if (result == null) continue;
            return result;
        }
        return result;
    }

    public GeometricPrimitive getSelectedGeometry() {
        TreeItem item = (TreeItem)this.treeView.getSelectionModel().getSelectedItem();
        TreeItemValue itemValue = (TreeItemValue)item.getValue();
        if (itemValue instanceof CurveTreeItemValue) {
            return (GeometricPrimitive)((CurveTreeItemValue)item.getValue()).getObject();
        }
        if (itemValue instanceof SurfaceTreeItemValue) {
            return (GeometricPrimitive)((SurfaceTreeItemValue)item.getValue()).getObject();
        }
        return null;
    }

    public FeatureAdjustment getFeatureAdjustment() {
        TreeItem rootItem = this.treeView.getRoot();
        if (rootItem != null) {
            return (FeatureAdjustment)((AdjustmentTreeItemValue)rootItem.getValue()).getObject();
        }
        return null;
    }

    public void setFeatureType(FeatureType featureType) {
        this.setFeature(null);
        TreeItem<TreeItemValue<?>> featureItem = this.searchTreeItem(this.treeView.getRoot(), TreeItemType.FEATURE);
        if (featureItem != null) {
            ((TreeItemValue)featureItem.getValue()).setName(this.i18n.getString("UITreeBuilder.feature.label", "Feature"));
        }
        this.getFeatureAdjustment().setFeature(null);
        this.featureType = featureType;
    }

    private void setFeature(Feature feature) {
        this.treeView.getSelectionModel().select(0);
        TreeItem<TreeItemValue<?>> featureItem = null;
        featureItem = this.searchTreeItem(this.treeView.getRoot(), TreeItemType.FEATURE);
        if (featureItem != null) {
            if (feature != null) {
                this.featureType = feature.getFeatureType();
            }
            ((TreeItemValue)featureItem.getValue()).setName(this.featureType == FeatureType.CURVE ? this.i18n.getString("UITreeBuilder.feature.curves", "Curves") : this.i18n.getString("UITreeBuilder.feature.surfaces", "Surfaces"));
            for (TreeItem primitives : featureItem.getChildren()) {
                primitives.getChildren().clear();
            }
            featureItem.getChildren().clear();
            if (feature != null) {
                Iterator<GeometricPrimitive> iterator = feature.getGeometricPrimitives().iterator();
                while (iterator.hasNext()) {
                    GeometricPrimitive geometricPrimitive = iterator.next();
                    this.addItem(geometricPrimitive);
                }
            } else if (feature == null && this.getFeatureAdjustment().getFeature() != null) {
                this.getFeatureAdjustment().getFeature().getGeometricPrimitives().removeListener(this.geometricPrimitiveListChangeListener);
            }
            this.treeView.getSelectionModel().select(featureItem);
        }
    }

    private TreeItem<TreeItemValue<?>> removeItem(GeometricPrimitive geometry) {
        TreeItem<TreeItemValue<?>> treeItem = this.searchTreeItem(this.treeView.getRoot(), geometry);
        if (treeItem == null) {
            return null;
        }
        TreeItem parent = treeItem.getParent();
        parent.getChildren().remove(treeItem);
        if (parent.getChildren().size() == 0) {
            TreeItem featureItem = parent.getParent();
            featureItem.getChildren().remove((Object)parent);
        }
        return treeItem;
    }

    private TreeItem<TreeItemValue<?>> addItem(GeometricPrimitive geometry) {
        TreeItem<TreeItemValue<?>> featureItem = this.searchTreeItem(this.treeView.getRoot(), TreeItemType.FEATURE);
        TreeItem<TreeItemValue<?>> newItem = null;
        TreeItem<TreeItemValue<?>> parent = null;
        if (featureItem == null) {
            return null;
        }
        if (geometry != null) {
            String geometryName = geometry.getName();
            if (geometryName == null || geometryName.isBlank()) {
                GeometricPrimitiveDialog.setDefaultName(geometry);
            }
            TreeItemType treeItemType = null;
            String parentLabel = null;
            if (this.featureType == FeatureType.CURVE) {
                if (geometry.getPrimitiveType() == PrimitiveType.LINE) {
                    treeItemType = TreeItemType.LINE;
                    parentLabel = this.i18n.getString("UITreeBuilder.curves.lines", "Lines");
                } else if (geometry.getPrimitiveType() == PrimitiveType.CIRCLE) {
                    treeItemType = TreeItemType.CIRCLE;
                    parentLabel = this.i18n.getString("UITreeBuilder.curves.circles", "Circles");
                } else if (geometry.getPrimitiveType() == PrimitiveType.ELLIPSE) {
                    treeItemType = TreeItemType.ELLIPSE;
                    parentLabel = this.i18n.getString("UITreeBuilder.curves.ellipses", "Ellipses");
                } else if (geometry.getPrimitiveType() == PrimitiveType.QUADRATIC_CURVE) {
                    treeItemType = TreeItemType.QUADRATIC_CURVE;
                    parentLabel = this.i18n.getString("UITreeBuilder.curves.quadrics", "Quadratic curves");
                } else {
                    throw new IllegalArgumentException("Error, unknown primitive type " + String.valueOf((Object)geometry.getPrimitiveType()) + "!");
                }
                parent = this.searchTreeItem(featureItem, treeItemType);
                if (parent == null) {
                    parent = this.createItem(new GeometricPrimitivesTreeItemValue(parentLabel, treeItemType));
                    featureItem.getChildren().addAll(Arrays.asList(parent));
                }
                CurveTreeItemValue itemValue = new CurveTreeItemValue(geometry.getName(), treeItemType);
                itemValue.setObject((Curve)geometry);
                newItem = this.createItem(itemValue);
            } else if (this.featureType == FeatureType.SURFACE) {
                if (geometry.getPrimitiveType() == PrimitiveType.PLANE) {
                    treeItemType = TreeItemType.PLANE;
                    parentLabel = this.i18n.getString("UITreeBuilder.surfaces.planes", "Planes");
                } else if (geometry.getPrimitiveType() == PrimitiveType.SPHERE) {
                    treeItemType = TreeItemType.SPHERE;
                    parentLabel = this.i18n.getString("UITreeBuilder.surfaces.spheres", "Spheres");
                } else if (geometry.getPrimitiveType() == PrimitiveType.ELLIPSOID) {
                    treeItemType = TreeItemType.ELLIPSOID;
                    parentLabel = this.i18n.getString("UITreeBuilder.surfaces.ellipsoids", "Ellipsoids");
                } else if (geometry.getPrimitiveType() == PrimitiveType.CYLINDER) {
                    treeItemType = TreeItemType.CYLINDER;
                    parentLabel = this.i18n.getString("UITreeBuilder.surfaces.cylinders", "Cylinders");
                } else if (geometry.getPrimitiveType() == PrimitiveType.CONE) {
                    treeItemType = TreeItemType.CONE;
                    parentLabel = this.i18n.getString("UITreeBuilder.surfaces.cones", "Cones");
                } else if (geometry.getPrimitiveType() == PrimitiveType.PARABOLOID) {
                    treeItemType = TreeItemType.PARABOLOID;
                    parentLabel = this.i18n.getString("UITreeBuilder.surfaces.paraboloids", "Paraboloids");
                } else if (geometry.getPrimitiveType() == PrimitiveType.TORUS) {
                    treeItemType = TreeItemType.TORUS;
                    parentLabel = this.i18n.getString("UITreeBuilder.surfaces.tori", "Tori");
                } else if (geometry.getPrimitiveType() == PrimitiveType.QUADRATIC_SURFACE) {
                    treeItemType = TreeItemType.QUADRATIC_SURFACE;
                    parentLabel = this.i18n.getString("UITreeBuilder.surfaces.quadrics", "Quadratic surfaces");
                } else {
                    throw new IllegalArgumentException("Error, unknown primitive type " + String.valueOf((Object)geometry.getPrimitiveType()) + "!");
                }
                parent = this.searchTreeItem(featureItem, treeItemType);
                if (parent == null) {
                    parent = this.createItem(new GeometricPrimitivesTreeItemValue(parentLabel, treeItemType));
                    featureItem.getChildren().addAll(Arrays.asList(parent));
                }
                SurfaceTreeItemValue itemValue = new SurfaceTreeItemValue(geometry.getName(), treeItemType);
                itemValue.setObject((Surface)geometry);
                newItem = this.createItem(itemValue);
            } else {
                newItem = null;
            }
        }
        if (parent != null && newItem != null && parent.getChildren().add(newItem)) {
            geometry.nameProperty().bindBidirectional(((TreeItemValue)newItem.getValue()).nameProperty());
            parent.setExpanded(true);
        }
        return newItem;
    }

    private void handleTreeSelections(TreeItem<TreeItemValue<?>> currentTreeItem) {
        this.lastValidSelectedTreeItem = currentTreeItem;
        if (currentTreeItem == null) {
            return;
        }
        this.tabPaneBuilder.setTreeItemValue((TreeItemValue)currentTreeItem.getValue());
    }

    @Override
    public void featureChanged(FeatureEvent evt) {
        if (evt.getEventType() == FeatureEvent.FeatureEventType.FEATURE_ADDED) {
            this.setFeature(evt.getSource());
            evt.getSource().getGeometricPrimitives().addListener(this.geometricPrimitiveListChangeListener);
        } else if (evt.getEventType() == FeatureEvent.FeatureEventType.FEATURE_REMOVED) {
            evt.getSource().getGeometricPrimitives().removeListener(this.geometricPrimitiveListChangeListener);
        }
    }

    private class GeometricPrimitiveListChangeListener
    implements ListChangeListener<GeometricPrimitive> {
        private GeometricPrimitiveListChangeListener() {
        }

        public void onChanged(ListChangeListener.Change<? extends GeometricPrimitive> change) {
            while (change.next()) {
                if (change.wasAdded()) {
                    for (GeometricPrimitive geometry : change.getAddedSubList()) {
                        UITreeBuilder.this.addItem(geometry);
                    }
                    continue;
                }
                if (!change.wasRemoved()) continue;
                for (GeometricPrimitive geometry : change.getRemoved()) {
                    UITreeBuilder.this.removeItem(geometry);
                }
            }
        }
    }

    private class TreeListSelectionChangeListener
    implements ListChangeListener<TreeItem<TreeItemValue<?>>> {
        private TreeListSelectionChangeListener() {
        }

        public void onChanged(ListChangeListener.Change<? extends TreeItem<TreeItemValue<?>>> change) {
            if (change != null && change.next() && UITreeBuilder.this.treeView != null && UITreeBuilder.this.treeView.getSelectionModel() != null && UITreeBuilder.this.treeView.getSelectionModel().getSelectedItems().size() > 0) {
                TreeItem treeItem = null;
                boolean hasValidTreeItem = false;
                try {
                    if ((change.wasAdded() || change.wasReplaced()) && change.getAddedSubList() != null && !change.getAddedSubList().isEmpty()) {
                        treeItem = (TreeItem)change.getAddedSubList().get(0);
                        hasValidTreeItem = true;
                    }
                }
                catch (Exception e) {
                    hasValidTreeItem = false;
                    e.printStackTrace();
                }
                if (!hasValidTreeItem) {
                    treeItem = (TreeItem)UITreeBuilder.this.treeView.getSelectionModel().getSelectedItem();
                    int treeItemIndex = UITreeBuilder.this.treeView.getSelectionModel().getSelectedIndex();
                    if (treeItemIndex < 0 || treeItem == null || !UITreeBuilder.this.treeView.getSelectionModel().isSelected(treeItemIndex)) {
                        treeItem = (TreeItem)UITreeBuilder.this.treeView.getSelectionModel().getSelectedItems().get(0);
                    }
                }
                UITreeBuilder.this.handleTreeSelections(treeItem);
            }
        }
    }
}

