/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.juniform.ui.tree;

import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.TextField;
import javafx.scene.control.TreeCell;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import org.applied_geodesy.adjustment.geometry.GeometricPrimitive;
import org.applied_geodesy.juniform.ui.tree.TreeItemValue;

public class EditableMenuTreeCell
extends TreeCell<TreeItemValue<?>> {
    private TextField textField;

    public void commitEdit(TreeItemValue<?> item) {
        if (!this.isEditing() && !item.equals(this.getItem())) {
            TreeItem treeItem = this.getTreeItem();
            TreeView treeView = this.getTreeView();
            if (treeView != null) {
                treeView.fireEvent((Event)new TreeView.EditEvent(treeView, TreeView.editCommitEvent(), treeItem, (Object)((TreeItemValue)this.getItem()), item));
            }
        }
        super.commitEdit(item);
    }

    public void startEdit() {
        super.startEdit();
        if (this.textField == null) {
            this.createTextField();
        }
        if (this.getItem() != null && ((TreeItemValue)this.getItem()).getObject() instanceof GeometricPrimitive) {
            this.setText(null);
            this.setGraphic((Node)this.textField);
            this.textField.setText(this.getString());
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    EditableMenuTreeCell.this.textField.selectAll();
                    EditableMenuTreeCell.this.textField.requestFocus();
                }
            });
        }
    }

    public void cancelEdit() {
        super.cancelEdit();
        this.setText(((TreeItemValue)this.getItem()).toString());
        this.setGraphic(this.getTreeItem().getGraphic());
    }

    public void updateItem(TreeItemValue<?> item, boolean empty) {
        super.updateItem(item, empty);
        if (empty) {
            this.setText(null);
        } else if (this.isEditing()) {
            if (this.textField != null) {
                this.textField.setText(this.getString());
            }
            this.setText(null);
            this.setGraphic((Node)this.textField);
        } else {
            this.setText(this.getString());
            this.setGraphic(this.getTreeItem().getGraphic());
        }
    }

    private void createTextField() {
        this.textField = new TextField("");
        this.textField.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                if (EditableMenuTreeCell.this.getTreeItem() != null) {
                    TreeItemValue item = (TreeItemValue)EditableMenuTreeCell.this.getTreeItem().getValue();
                    item.setName(EditableMenuTreeCell.this.textField.getText());
                    EditableMenuTreeCell.this.commitEdit(item);
                }
            }
        });
        this.textField.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                if (!newValue.booleanValue()) {
                    TreeItemValue item = (TreeItemValue)EditableMenuTreeCell.this.getTreeItem().getValue();
                    item.setName(EditableMenuTreeCell.this.textField.getText());
                    EditableMenuTreeCell.this.commitEdit(item);
                }
            }
        });
        this.textField.addEventFilter(KeyEvent.KEY_PRESSED, (EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent event) {
                if (event.getCode() == KeyCode.ESCAPE) {
                    EditableMenuTreeCell.this.textField.setText(EditableMenuTreeCell.this.getString());
                    EditableMenuTreeCell.this.cancelEdit();
                    event.consume();
                }
            }
        });
    }

    private String getString() {
        return this.getItem() == null ? "" : ((TreeItemValue)this.getItem()).toString();
    }
}

