/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.juniform.ui.tabpane;

import java.util.Collection;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import javafx.geometry.Side;
import javafx.scene.Node;
import javafx.scene.control.SingleSelectionModel;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.Tooltip;
import org.applied_geodesy.adjustment.geometry.GeometricPrimitive;
import org.applied_geodesy.adjustment.geometry.parameter.UnknownParameter;
import org.applied_geodesy.adjustment.geometry.point.FeaturePoint;
import org.applied_geodesy.juniform.ui.i18n.I18N;
import org.applied_geodesy.juniform.ui.propertiespane.UIPointSelectionPaneBuilder;
import org.applied_geodesy.juniform.ui.table.UIParameterTableBuilder;
import org.applied_geodesy.juniform.ui.table.UIPointTableBuilder;
import org.applied_geodesy.juniform.ui.tabpane.TabType;
import org.applied_geodesy.juniform.ui.tree.CurveTreeItemValue;
import org.applied_geodesy.juniform.ui.tree.SurfaceTreeItemValue;
import org.applied_geodesy.juniform.ui.tree.TreeItemType;
import org.applied_geodesy.juniform.ui.tree.TreeItemValue;
import org.applied_geodesy.ui.table.ColumnType;

public class UITabPaneBuilder {
    private TabPane tabPane = null;
    private static UITabPaneBuilder tabPaneBuilder = new UITabPaneBuilder();
    private I18N i18n = I18N.getInstance();
    private TabSelectionChangeListener tabSelectionChangeListener = new TabSelectionChangeListener();
    private UIPointTableBuilder pointTableBuilder = UIPointTableBuilder.getInstance();
    private UIParameterTableBuilder parameterTableBuilder = UIParameterTableBuilder.getInstance();
    private ObservableMap<TabType, Tab> tapMap = FXCollections.observableHashMap();
    private TreeItemValue<?> lastTreeItemValue = null;
    private Tab lastSelectedTab = null;

    public static UITabPaneBuilder getInstance() {
        return tabPaneBuilder;
    }

    public TabPane getTabPane() {
        if (this.tabPane == null) {
            this.init();
        }
        return this.tabPane;
    }

    private void init() {
        this.createTab(this.i18n.getString("UITabPaneBuilder.tab.point.selection.label", "Point selection"), this.i18n.getString("UITabPaneBuilder.tab.point.selection.title", "Select points of geometric primitive"), TabType.POINT_SELECTION, null);
        this.createTab(this.i18n.getString("UITabPaneBuilder.tab.point.apriori.label", "Observed points"), this.i18n.getString("UITabPaneBuilder.tab.point.apriori.title", "Table of observed points"), TabType.APRIORI_POINT, null);
        this.createTab(this.i18n.getString("UITabPaneBuilder.tab.point.aposteriori.label", "Estimated points"), this.i18n.getString("UITabPaneBuilder.tab.point.aposteriori.title", "Table of estimated points"), TabType.APOSTERIORI_POINT, null);
        this.createTab(this.i18n.getString("UITabPaneBuilder.tab.parameter.aposteriori.label", "Estimated parameters"), this.i18n.getString("UITabPaneBuilder.tab.parameter.aposteriori.title", "Table of estimated parameters"), TabType.APOSTERIORI_PARAMETER, null);
        this.tabPane = new TabPane();
        this.tabPane.setSide(Side.BOTTOM);
        this.tabPane.getSelectionModel().selectedItemProperty().addListener((ChangeListener)this.tabSelectionChangeListener);
    }

    private Tab createTab(String name, String tooltip, TabType type, Node node) {
        Tab tab = new Tab(name, node);
        tab.setClosable(false);
        tab.setTooltip(new Tooltip(tooltip));
        tab.setUserData((Object)type);
        this.tapMap.put((Object)type, (Object)tab);
        return tab;
    }

    private Node getNode(TabType tabType) {
        if (this.lastTreeItemValue == null || tabType == null) {
            return null;
        }
        Node node = null;
        TreeItemType treeItemType = this.lastTreeItemValue.getTreeItemType();
        switch (treeItemType) {
            case ADJUSTMENT: {
                break;
            }
            case FEATURE: {
                if (tabType == TabType.APRIORI_POINT || tabType == TabType.APOSTERIORI_POINT) {
                    TableView<FeaturePoint> pointTableView = this.pointTableBuilder.getTable();
                    this.setTableColumnView(tabType, pointTableView);
                    node = pointTableView;
                    break;
                }
                if (tabType != TabType.APOSTERIORI_PARAMETER) break;
                TableView<UnknownParameter> parameterTableView = this.parameterTableBuilder.getTable();
                this.setTableColumnView(tabType, parameterTableView);
                node = parameterTableView;
                break;
            }
            case LINE: 
            case CIRCLE: 
            case ELLIPSE: 
            case QUADRATIC_CURVE: 
            case PLANE: 
            case SPHERE: 
            case ELLIPSOID: 
            case CYLINDER: 
            case CONE: 
            case PARABOLOID: 
            case TORUS: 
            case QUADRATIC_SURFACE: {
                GeometricPrimitive geometry = null;
                if (this.lastTreeItemValue instanceof CurveTreeItemValue) {
                    geometry = (GeometricPrimitive)((CurveTreeItemValue)this.lastTreeItemValue).getObject();
                } else if (this.lastTreeItemValue instanceof SurfaceTreeItemValue) {
                    geometry = (GeometricPrimitive)((SurfaceTreeItemValue)this.lastTreeItemValue).getObject();
                }
                if (tabType == TabType.APOSTERIORI_PARAMETER) {
                    TableView<UnknownParameter> parameterTableView = this.parameterTableBuilder.getTable(geometry);
                    this.setTableColumnView(tabType, parameterTableView);
                    node = parameterTableView;
                    break;
                }
                if (geometry == null || tabType != TabType.POINT_SELECTION) break;
                TableView<FeaturePoint> pointTableView = this.pointTableBuilder.getTable();
                node = UIPointSelectionPaneBuilder.getInstance().getNode((ObservableList<FeaturePoint>)pointTableView.getItems(), geometry);
                break;
            }
            default: {
                throw new IllegalArgumentException("Error, unknown tree item type " + String.valueOf((Object)treeItemType) + "!");
            }
        }
        return node;
    }

    private void setTableColumnView(TabType tabType, TableView<?> tableView) {
        int columnCount = tableView.getColumns().size();
        int columnIndex = 0;
        while (columnIndex < columnCount) {
            TableColumn column = (TableColumn)tableView.getColumns().get(columnIndex);
            if (column.getUserData() instanceof ColumnType) {
                ColumnType columnType = (ColumnType)((Object)column.getUserData());
                switch (columnType) {
                    case VISIBLE: {
                        column.setVisible(true);
                        break;
                    }
                    case HIDDEN: {
                        column.setVisible(false);
                        break;
                    }
                    case APRIORI_POINT: {
                        column.setVisible(tabType == TabType.APRIORI_POINT);
                        break;
                    }
                    case APOSTERIORI_POINT: {
                        column.setVisible(tabType == TabType.APOSTERIORI_POINT);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Error, unsupported column type " + String.valueOf((Object)columnType) + "!");
                    }
                }
            }
            ++columnIndex;
        }
    }

    public void setTreeItemValue(TreeItemValue<?> treeItemValue) {
        if (this.tabPane == null) {
            this.init();
        }
        SingleSelectionModel selectionModel = this.tabPane.getSelectionModel();
        this.lastSelectedTab = this.lastSelectedTab != null ? this.lastSelectedTab : (Tab)selectionModel.getSelectedItem();
        selectionModel.clearSelection();
        this.lastTreeItemValue = treeItemValue;
        if (this.tabPane != null && treeItemValue != null) {
            TabType[] newTabTypes = treeItemValue.getTabTypes();
            if (newTabTypes != null && newTabTypes.length > 0) {
                boolean equalTabOrderAndTypes;
                Tab selectedTab = null;
                ObservableList oldTabList = this.tabPane.getTabs();
                boolean bl = equalTabOrderAndTypes = oldTabList.size() == newTabTypes.length;
                if (equalTabOrderAndTypes) {
                    int idx = 0;
                    while (idx < newTabTypes.length) {
                        Tab tab = (Tab)oldTabList.get(idx);
                        if (tab.getUserData() == null || tab.getUserData() != newTabTypes[idx]) {
                            equalTabOrderAndTypes = false;
                            break;
                        }
                        ++idx;
                    }
                }
                if (!equalTabOrderAndTypes) {
                    ObservableList newTabList = FXCollections.observableArrayList();
                    this.tabPane.getTabs().clear();
                    TabType[] tabTypeArray = newTabTypes;
                    int n = newTabTypes.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TabType tabType = tabTypeArray[n2];
                        if (this.tapMap.containsKey((Object)tabType)) {
                            newTabList.add((Object)((Tab)this.tapMap.get((Object)tabType)));
                            if (this.lastSelectedTab != null && this.lastSelectedTab.getUserData() == tabType) {
                                selectedTab = (Tab)this.tapMap.get((Object)tabType);
                            }
                        }
                        ++n2;
                    }
                    this.tabPane.getTabs().setAll((Collection)newTabList);
                } else {
                    boolean validLastSelectedTabType = false;
                    TabType[] tabTypeArray = newTabTypes;
                    int n = newTabTypes.length;
                    int n3 = 0;
                    while (n3 < n) {
                        TabType newType = tabTypeArray[n3];
                        if (this.lastSelectedTab.getUserData() == newType) {
                            validLastSelectedTabType = true;
                            break;
                        }
                        ++n3;
                    }
                    Tab tab = selectedTab = validLastSelectedTabType ? this.lastSelectedTab : null;
                }
                if (selectedTab == null && this.tabPane.getTabs().size() > 0) {
                    selectedTab = (Tab)this.tabPane.getTabs().get(0);
                }
                selectionModel.select((Object)selectedTab);
            } else {
                this.tabPane.getTabs().clear();
                System.out.println(this.getClass().getSimpleName() + " : No known tab types " + String.valueOf(newTabTypes) + " for " + String.valueOf(treeItemValue));
            }
        }
    }

    private class TabSelectionChangeListener
    implements ChangeListener<Tab> {
        private TabSelectionChangeListener() {
        }

        public void changed(ObservableValue<? extends Tab> observable, Tab oldTab, Tab newTab) {
            Tab tab = UITabPaneBuilder.this.lastSelectedTab = newTab == null ? UITabPaneBuilder.this.lastSelectedTab : newTab;
            if (oldTab != null) {
                oldTab.setContent(null);
            }
            if (newTab != null && newTab.getUserData() instanceof TabType) {
                TabType tabType = (TabType)((Object)newTab.getUserData());
                newTab.setContent(UITabPaneBuilder.this.getNode(tabType));
            }
        }
    }
}

