/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.juniform.ui.table;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Function;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.SortedList;
import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.ListView;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TablePosition;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.CheckBoxTableCell;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.KeyEvent;
import javafx.util.Callback;
import org.applied_geodesy.juniform.ui.i18n.I18N;
import org.applied_geodesy.ui.table.ColumnTooltipHeader;
import org.applied_geodesy.ui.table.ColumnType;
import org.applied_geodesy.ui.table.EditableCell;
import org.applied_geodesy.ui.table.EditableDoubleCellConverter;
import org.applied_geodesy.ui.table.EditableIntegerCellConverter;
import org.applied_geodesy.ui.table.EditableStringCellConverter;
import org.applied_geodesy.util.CellValueType;
import org.applied_geodesy.util.FormatterChangedListener;
import org.applied_geodesy.util.FormatterEvent;
import org.applied_geodesy.util.FormatterOptions;

public abstract class UITableBuilder<T> {
    final NumberAndUnitFormatterChangedListener numberAndUnitFormatterChangedListener = new NumberAndUnitFormatterChangedListener();
    static FormatterOptions options = FormatterOptions.getInstance();
    static I18N i18n = I18N.getInstance();
    TableView<T> table = this.createTable();

    UITableBuilder() {
        options.addFormatterChangedListener(this.numberAndUnitFormatterChangedListener);
    }

    TableView<T> createTable() {
        this.table = new TableView();
        ObservableList tableModel = FXCollections.observableArrayList();
        SortedList sortedList = new SortedList(tableModel);
        sortedList.comparatorProperty().bind((ObservableValue)this.table.comparatorProperty());
        this.table.setItems((ObservableList)sortedList);
        this.table.setColumnResizePolicy(TableView.UNCONSTRAINED_RESIZE_POLICY);
        this.table.setTableMenuButtonVisible(false);
        this.table.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        this.table.setOnKeyPressed((EventHandler)new TableKeyEventHandler());
        ListView placeholderList = new ListView();
        placeholderList.getItems().add((Object)new String());
        placeholderList.setDisable(true);
        this.table.setPlaceholder((Node)placeholderList);
        return this.table;
    }

    static <T> Callback<TableColumn<T, Integer>, TableCell<T, Integer>> getIntegerCallback() {
        return new Callback<TableColumn<T, Integer>, TableCell<T, Integer>>(){

            public TableCell<T, Integer> call(TableColumn<T, Integer> cell) {
                EditableCell tableCell = new EditableCell(new EditableIntegerCellConverter());
                tableCell.setAlignment(Pos.CENTER_RIGHT);
                return tableCell;
            }
        };
    }

    static <T> Callback<TableColumn<T, Double>, TableCell<T, Double>> getDoubleCallback(CellValueType cellValueType) {
        return UITableBuilder.getDoubleCallback(cellValueType, false);
    }

    static <T> Callback<TableColumn<T, Double>, TableCell<T, Double>> getDoubleCallback(final CellValueType cellValueType, final boolean displayUnit) {
        return new Callback<TableColumn<T, Double>, TableCell<T, Double>>(){

            public TableCell<T, Double> call(TableColumn<T, Double> cell) {
                EditableCell tableCell = new EditableCell(new EditableDoubleCellConverter(cellValueType, displayUnit));
                tableCell.setAlignment(Pos.CENTER_RIGHT);
                return tableCell;
            }
        };
    }

    static <T> Callback<TableColumn<T, String>, TableCell<T, String>> getStringCallback() {
        return new Callback<TableColumn<T, String>, TableCell<T, String>>(){

            public TableCell<T, String> call(TableColumn<T, String> cell) {
                EditableCell tableCell = new EditableCell(new EditableStringCellConverter());
                tableCell.setAlignment(Pos.CENTER_LEFT);
                return tableCell;
            }
        };
    }

    static <T> Callback<TableColumn<T, Boolean>, TableCell<T, Boolean>> getBooleanCallback() {
        return new Callback<TableColumn<T, Boolean>, TableCell<T, Boolean>>(){

            public TableCell<T, Boolean> call(TableColumn<T, Boolean> cell) {
                CheckBoxTableCell tableCell = new CheckBoxTableCell();
                tableCell.setAlignment(Pos.CENTER);
                return tableCell;
            }
        };
    }

    <S> TableColumn<T, S> getColumn(ColumnTooltipHeader header, final Function<T, ObservableValue<S>> property, Callback<TableColumn<T, S>, TableCell<T, S>> callback, ColumnType type, int columnIndex, boolean editable) {
        TableCellEvent tableCellEvent = new TableCellEvent(columnIndex);
        TableColumn column = new TableColumn();
        Label columnLabel = header.getLabel();
        columnLabel.getStyleClass().add((Object)"column-header-label");
        columnLabel.setMaxWidth(Double.MAX_VALUE);
        columnLabel.setTooltip(header.getTooltip());
        column.setUserData((Object)type);
        column.setEditable(editable);
        column.setGraphic((Node)columnLabel);
        column.setMinWidth(25.0);
        column.setPrefWidth(125.0);
        column.setCellValueFactory(new Callback<TableColumn.CellDataFeatures<T, S>, ObservableValue<S>>(){

            public ObservableValue<S> call(TableColumn.CellDataFeatures<T, S> param) {
                ObservableValue observableValue = (ObservableValue)property.apply(param.getValue());
                return observableValue;
            }
        });
        column.setCellFactory(callback);
        column.setOnEditCommit(tableCellEvent);
        return column;
    }

    public void refreshTable() {
        if (this.table != null) {
            this.table.refresh();
        }
    }

    abstract void setValue(T var1, int var2, Object var3, Object var4);

    public TableView<T> getTable() {
        return this.table;
    }

    public ObservableList<T> getTableModel(TableView<T> tableView) {
        if (tableView.getItems() instanceof SortedList) {
            SortedList sortedList = (SortedList)tableView.getItems();
            return sortedList.getSource();
        }
        return tableView.getItems();
    }

    public static void copySelectionToClipboard(TableView<?> table) {
        StringBuilder clipboardString = new StringBuilder();
        for (TablePosition position : table.getSelectionModel().getSelectedCells()) {
            int rowIndex = position.getRow();
            if (rowIndex < 0 || rowIndex >= table.getItems().size()) continue;
            for (TableColumn column : table.getColumns()) {
                if (!column.isVisible()) continue;
                Object cell = column.getCellData(rowIndex);
                if (cell == null) {
                    cell = " ";
                }
                clipboardString.append(cell.toString()).append('\t');
            }
            clipboardString.append("\r\n");
        }
        ClipboardContent clipboardContent = new ClipboardContent();
        clipboardContent.putString(clipboardString.toString());
        Clipboard.getSystemClipboard().setContent((Map)clipboardContent);
    }

    public static Object getValueAt(TableView<?> table, int columnIndex, int rowIndex) {
        return ((TableColumn)table.getColumns().get(columnIndex)).getCellObservableValue(rowIndex).getValue();
    }

    class NumberAndUnitFormatterChangedListener
    implements FormatterChangedListener {
        NumberAndUnitFormatterChangedListener() {
        }

        @Override
        public void formatterChanged(FormatterEvent evt) {
            if (UITableBuilder.this.table != null) {
                UITableBuilder.this.table.refresh();
            }
        }
    }

    class TableCellChangeListener<S>
    implements ChangeListener<S> {
        private final int columnIndex;
        private final T rowData;

        TableCellChangeListener(int columnIndex, T rowData) {
            this.columnIndex = columnIndex;
            this.rowData = rowData;
        }

        public void changed(ObservableValue<? extends S> observable, S oldValue, S newValue) {
            if (this.rowData != null) {
                Object selectedItems = UITableBuilder.this.table.getSelectionModel().getSelectedItems();
                if (selectedItems == null || selectedItems.isEmpty() || !selectedItems.contains(this.rowData)) {
                    selectedItems = new ArrayList(1);
                    selectedItems.add(this.rowData);
                    UITableBuilder.this.table.getSelectionModel().clearSelection();
                    UITableBuilder.this.table.getSelectionModel().select(this.rowData);
                }
                Iterator iterator = selectedItems.iterator();
                while (iterator.hasNext()) {
                    Object item = iterator.next();
                    UITableBuilder.this.setValue(item, this.columnIndex, oldValue, newValue);
                }
                if (selectedItems.size() > 1) {
                    UITableBuilder.this.table.refresh();
                }
            }
        }
    }

    class TableCellEvent<S>
    implements EventHandler<TableColumn.CellEditEvent<T, S>> {
        private final int columnIndex;

        TableCellEvent(int columnIndex) {
            this.columnIndex = columnIndex;
        }

        public void handle(TableColumn.CellEditEvent<T, S> event) {
            if (event.getTableColumn().isEditable()) {
                UITableBuilder.this.setValue(event.getRowValue(), this.columnIndex, event.getOldValue(), event.getNewValue());
            }
        }
    }

    class TableKeyEventHandler
    implements EventHandler<KeyEvent> {
        KeyCodeCombination copyKeyCodeCompination = new KeyCodeCombination(KeyCode.C, new KeyCombination.Modifier[]{KeyCombination.CONTROL_ANY});

        TableKeyEventHandler() {
        }

        public void handle(KeyEvent keyEvent) {
            if (this.copyKeyCodeCompination.match(keyEvent) && keyEvent.getSource() instanceof TableView) {
                UITableBuilder.copySelectionToClipboard((TableView)keyEvent.getSource());
                keyEvent.consume();
            }
        }
    }
}

