/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.juniform.ui.table;

import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javafx.application.Platform;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.Tooltip;
import javafx.scene.input.MouseEvent;
import javafx.util.Callback;
import no.uib.cipr.matrix.Matrix;
import org.applied_geodesy.adjustment.geometry.Feature;
import org.applied_geodesy.adjustment.geometry.FeatureChangeListener;
import org.applied_geodesy.adjustment.geometry.FeatureEvent;
import org.applied_geodesy.adjustment.geometry.FeatureType;
import org.applied_geodesy.adjustment.geometry.GeometricPrimitive;
import org.applied_geodesy.adjustment.geometry.point.FeaturePoint;
import org.applied_geodesy.adjustment.geometry.point.Point;
import org.applied_geodesy.juniform.ui.dialog.MatrixDialog;
import org.applied_geodesy.juniform.ui.table.UIEditableTableBuilder;
import org.applied_geodesy.juniform.ui.table.UITableBuilder;
import org.applied_geodesy.ui.table.AbsoluteValueComparator;
import org.applied_geodesy.ui.table.ColumnTooltipHeader;
import org.applied_geodesy.ui.table.ColumnType;
import org.applied_geodesy.ui.table.NaturalOrderTableColumnComparator;
import org.applied_geodesy.util.CellValueType;

public class UIPointTableBuilder
extends UIEditableTableBuilder<FeaturePoint>
implements FeatureChangeListener {
    private FeatureType featureType = FeatureType.CURVE;
    private Map<FeatureType, TableView<FeaturePoint>> tables = new HashMap<FeatureType, TableView<FeaturePoint>>(2);
    private static UIPointTableBuilder tableBuilder = new UIPointTableBuilder();

    private UIPointTableBuilder() {
    }

    public static UIPointTableBuilder getInstance() {
        return tableBuilder;
    }

    public void setFeatureType(FeatureType featureType) {
        if (this.featureType != featureType) {
            this.getTableModel(this.table).clear();
            this.table.refresh();
            this.featureType = featureType;
        }
    }

    @Override
    public TableView<FeaturePoint> getTable() {
        this.init();
        return this.table;
    }

    private void init() {
        int columnIndex;
        if (this.tables.containsKey((Object)this.featureType)) {
            this.table = this.tables.get((Object)this.featureType);
            return;
        }
        TableColumn<FeaturePoint, Boolean> booleanColumn = null;
        TableColumn<FeaturePoint, String> stringColumn = null;
        TableColumn<FeaturePoint, Double> doubleColumn = null;
        TableColumn<FeaturePoint, Matrix> matrixColumn = null;
        TableView table = this.createTable();
        final int columnIndexEnable = columnIndex = table.getColumns().size();
        String labelText = i18n.getString("UIPointTableBuilder.tableheader.enable.label", "Enable");
        String tooltipText = i18n.getString("UIPointTableBuilder.tableheader.enable.tooltip", "State of the point");
        CellValueType cellValueType = CellValueType.BOOLEAN;
        ColumnTooltipHeader header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText);
        booleanColumn = this.getColumn(header, FeaturePoint::enableProperty, UIPointTableBuilder.getBooleanCallback(), ColumnType.VISIBLE, columnIndex, true);
        booleanColumn.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<FeaturePoint, Boolean>, ObservableValue<Boolean>>(){

            public ObservableValue<Boolean> call(TableColumn.CellDataFeatures<FeaturePoint, Boolean> param) {
                UITableBuilder.TableCellChangeListener enableChangeListener = new UITableBuilder.TableCellChangeListener(UIPointTableBuilder.this, columnIndexEnable, (FeaturePoint)param.getValue());
                SimpleBooleanProperty booleanProp = new SimpleBooleanProperty(((FeaturePoint)param.getValue()).isEnable());
                booleanProp.addListener(enableChangeListener);
                return booleanProp;
            }
        });
        table.getColumns().add(booleanColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UIPointTableBuilder.tableheader.station.name.label", "Point-Id");
        tooltipText = i18n.getString("UIPointTableBuilder.tableheader.station.name.tooltip", "Id of the point");
        cellValueType = CellValueType.STRING;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText);
        stringColumn = this.getColumn(header, Point::nameProperty, UIPointTableBuilder.getStringCallback(), ColumnType.VISIBLE, columnIndex, true);
        stringColumn.setComparator(new NaturalOrderTableColumnComparator<String>(stringColumn));
        table.getColumns().add(stringColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UIPointTableBuilder.tableheader.x0.label", "x0");
        tooltipText = i18n.getString("UIPointTableBuilder.tableheader.x0.tooltip", "A-priori x-component of the point");
        cellValueType = CellValueType.LENGTH;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText, options.getFormatterOptions().get((Object)cellValueType).getUnit());
        doubleColumn = this.getColumn(header, Point::x0Property, UIPointTableBuilder.getDoubleCallback(cellValueType), ColumnType.APRIORI_POINT, columnIndex, true);
        table.getColumns().add(doubleColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UIPointTableBuilder.tableheader.y0.label", "y0");
        tooltipText = i18n.getString("UIPointTableBuilder.tableheader.y0.tooltip", "A-priori y-component of the point");
        cellValueType = CellValueType.LENGTH;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText, options.getFormatterOptions().get((Object)cellValueType).getUnit());
        doubleColumn = this.getColumn(header, Point::y0Property, UIPointTableBuilder.getDoubleCallback(cellValueType), ColumnType.APRIORI_POINT, columnIndex, true);
        table.getColumns().add(doubleColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UIPointTableBuilder.tableheader.z0.label", "z0");
        tooltipText = i18n.getString("UIPointTableBuilder.tableheader.z0.tooltip", "A-priori z-component of the point");
        cellValueType = CellValueType.LENGTH;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText, options.getFormatterOptions().get((Object)cellValueType).getUnit());
        doubleColumn = this.getColumn(header, Point::z0Property, UIPointTableBuilder.getDoubleCallback(cellValueType), this.featureType == FeatureType.SURFACE ? ColumnType.APRIORI_POINT : ColumnType.HIDDEN, columnIndex, true);
        table.getColumns().add(doubleColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UIPointTableBuilder.tableheader.covariance.label", "Uncertainties");
        tooltipText = i18n.getString("UIPointTableBuilder.tableheader.covariance.tooltip", "A-priori variance-covariance matrix");
        cellValueType = CellValueType.STATISTIC;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText);
        matrixColumn = this.getColumn(header, FeaturePoint::dispersionAprioriProperty, UIPointTableBuilder.getMatrixCallback(), ColumnType.APRIORI_POINT, columnIndex, true);
        table.getColumns().add(matrixColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UIPointTableBuilder.tableheader.x.label", "x");
        tooltipText = i18n.getString("UIPointTableBuilder.tableheader.x.tooltip", "A-posteriori x-component of the point");
        cellValueType = CellValueType.LENGTH;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText, options.getFormatterOptions().get((Object)cellValueType).getUnit());
        doubleColumn = this.getColumn(header, FeaturePoint::xProperty, UIPointTableBuilder.getDoubleCallback(cellValueType), ColumnType.APOSTERIORI_POINT, columnIndex, false);
        table.getColumns().add(doubleColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UIPointTableBuilder.tableheader.y.label", "y");
        tooltipText = i18n.getString("UIPointTableBuilder.tableheader.y.tooltip", "A-posteriori y-component of the point");
        cellValueType = CellValueType.LENGTH;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText, options.getFormatterOptions().get((Object)cellValueType).getUnit());
        doubleColumn = this.getColumn(header, FeaturePoint::yProperty, UIPointTableBuilder.getDoubleCallback(cellValueType), ColumnType.APOSTERIORI_POINT, columnIndex, false);
        table.getColumns().add(doubleColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UIPointTableBuilder.tableheader.z.label", "z");
        tooltipText = i18n.getString("UIPointTableBuilder.tableheader.z.tooltip", "A-posteriori z-component of the point");
        cellValueType = CellValueType.LENGTH;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText, options.getFormatterOptions().get((Object)cellValueType).getUnit());
        doubleColumn = this.getColumn(header, FeaturePoint::zProperty, UIPointTableBuilder.getDoubleCallback(cellValueType), this.featureType == FeatureType.SURFACE ? ColumnType.APOSTERIORI_POINT : ColumnType.HIDDEN, columnIndex, false);
        table.getColumns().add(doubleColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UIPointTableBuilder.tableheader.uncertainty.x.label", "\u03c3x");
        tooltipText = i18n.getString("UIPointTableBuilder.tableheader.uncertainty.x.tooltip", "A-posteriori uncertainty of x-component");
        cellValueType = CellValueType.LENGTH_UNCERTAINTY;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText, options.getFormatterOptions().get((Object)cellValueType).getUnit());
        doubleColumn = this.getColumn(header, FeaturePoint::uncertaintyXProperty, UIPointTableBuilder.getDoubleCallback(cellValueType), ColumnType.APOSTERIORI_POINT, columnIndex, false);
        doubleColumn.setComparator((Comparator)new AbsoluteValueComparator());
        table.getColumns().add(doubleColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UIPointTableBuilder.tableheader.uncertainty.y.label", "\u03c3y");
        tooltipText = i18n.getString("UIPointTableBuilder.tableheader.uncertainty.y.tooltip", "A-posteriori uncertainty of y-component");
        cellValueType = CellValueType.LENGTH_UNCERTAINTY;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText, options.getFormatterOptions().get((Object)cellValueType).getUnit());
        doubleColumn = this.getColumn(header, FeaturePoint::uncertaintyYProperty, UIPointTableBuilder.getDoubleCallback(cellValueType), ColumnType.APOSTERIORI_POINT, columnIndex, false);
        doubleColumn.setComparator((Comparator)new AbsoluteValueComparator());
        table.getColumns().add(doubleColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UIPointTableBuilder.tableheader.uncertainty.z.label", "\u03c3z");
        tooltipText = i18n.getString("UIPointTableBuilder.tableheader.uncertainty.z.tooltip", "A-posteriori uncertainty of z-component");
        cellValueType = CellValueType.LENGTH_UNCERTAINTY;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText, options.getFormatterOptions().get((Object)cellValueType).getUnit());
        doubleColumn = this.getColumn(header, FeaturePoint::uncertaintyZProperty, UIPointTableBuilder.getDoubleCallback(cellValueType), this.featureType == FeatureType.SURFACE ? ColumnType.APOSTERIORI_POINT : ColumnType.HIDDEN, columnIndex, false);
        doubleColumn.setComparator((Comparator)new AbsoluteValueComparator());
        table.getColumns().add(doubleColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UIPointTableBuilder.tableheader.redundancy.x.label", "rx");
        tooltipText = i18n.getString("UIPointTableBuilder.tableheader.redundancy.x.tooltip", "Redundancy of x-component");
        cellValueType = CellValueType.PERCENTAGE;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText, options.getFormatterOptions().get((Object)cellValueType).getUnit());
        doubleColumn = this.getColumn(header, FeaturePoint::redundancyXProperty, UIPointTableBuilder.getDoubleCallback(cellValueType), ColumnType.APOSTERIORI_POINT, columnIndex, false);
        doubleColumn.setComparator((Comparator)new AbsoluteValueComparator());
        table.getColumns().add(doubleColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UIPointTableBuilder.tableheader.redundancy.y.label", "ry");
        tooltipText = i18n.getString("UIPointTableBuilder.tableheader.redundancy.y.tooltip", "Redundancy of y-component");
        cellValueType = CellValueType.PERCENTAGE;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText, options.getFormatterOptions().get((Object)cellValueType).getUnit());
        doubleColumn = this.getColumn(header, FeaturePoint::redundancyYProperty, UIPointTableBuilder.getDoubleCallback(cellValueType), ColumnType.APOSTERIORI_POINT, columnIndex, false);
        doubleColumn.setComparator((Comparator)new AbsoluteValueComparator());
        table.getColumns().add(doubleColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UIPointTableBuilder.tableheader.redundancy.z.label", "rz");
        tooltipText = i18n.getString("UIPointTableBuilder.tableheader.redundancy.z.tooltip", "Redundancy of z-component");
        cellValueType = CellValueType.PERCENTAGE;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText, options.getFormatterOptions().get((Object)cellValueType).getUnit());
        doubleColumn = this.getColumn(header, FeaturePoint::redundancyZProperty, UIPointTableBuilder.getDoubleCallback(cellValueType), this.featureType == FeatureType.SURFACE ? ColumnType.APOSTERIORI_POINT : ColumnType.HIDDEN, columnIndex, false);
        doubleColumn.setComparator((Comparator)new AbsoluteValueComparator());
        table.getColumns().add(doubleColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UIPointTableBuilder.tableheader.residual.x.label", "\u03b5x");
        tooltipText = i18n.getString("UIPointTableBuilder.tableheader.residual.x.tooltip", "Residual of x-component, i.e. computed minus observed");
        cellValueType = CellValueType.LENGTH_RESIDUAL;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText, options.getFormatterOptions().get((Object)cellValueType).getUnit());
        doubleColumn = this.getColumn(header, FeaturePoint::residualXProperty, UIPointTableBuilder.getDoubleCallback(cellValueType), ColumnType.APOSTERIORI_POINT, columnIndex, false);
        doubleColumn.setComparator((Comparator)new AbsoluteValueComparator());
        table.getColumns().add(doubleColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UIPointTableBuilder.tableheader.residual.y.label", "\u03b5y");
        tooltipText = i18n.getString("UIPointTableBuilder.tableheader.residual.y.tooltip", "Residual of y-component, i.e. computed minus observed");
        cellValueType = CellValueType.LENGTH_RESIDUAL;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText, options.getFormatterOptions().get((Object)cellValueType).getUnit());
        doubleColumn = this.getColumn(header, FeaturePoint::residualYProperty, UIPointTableBuilder.getDoubleCallback(cellValueType), ColumnType.APOSTERIORI_POINT, columnIndex, false);
        doubleColumn.setComparator((Comparator)new AbsoluteValueComparator());
        table.getColumns().add(doubleColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UIPointTableBuilder.tableheader.residual.z.label", "\u03b5z");
        tooltipText = i18n.getString("UIPointTableBuilder.tableheader.residual.z.tooltip", "Residual of z-component, i.e. computed minus observed");
        cellValueType = CellValueType.LENGTH_RESIDUAL;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText, options.getFormatterOptions().get((Object)cellValueType).getUnit());
        doubleColumn = this.getColumn(header, FeaturePoint::residualZProperty, UIPointTableBuilder.getDoubleCallback(cellValueType), this.featureType == FeatureType.SURFACE ? ColumnType.APOSTERIORI_POINT : ColumnType.HIDDEN, columnIndex, false);
        doubleColumn.setComparator((Comparator)new AbsoluteValueComparator());
        table.getColumns().add(doubleColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UIPointTableBuilder.tableheader.grosserror.x.label", "\u2207x");
        tooltipText = i18n.getString("UIPointTableBuilder.tableheader.grosserror.x.tooltip", "Gross-error in x");
        cellValueType = CellValueType.LENGTH_RESIDUAL;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText, options.getFormatterOptions().get((Object)cellValueType).getUnit());
        doubleColumn = this.getColumn(header, FeaturePoint::grossErrorXProperty, UIPointTableBuilder.getDoubleCallback(cellValueType), ColumnType.APOSTERIORI_POINT, columnIndex, false);
        doubleColumn.setComparator((Comparator)new AbsoluteValueComparator());
        table.getColumns().add(doubleColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UIPointTableBuilder.tableheader.grosserror.y.label", "\u2207y");
        tooltipText = i18n.getString("UIPointTableBuilder.tableheader.grosserror.y.tooltip", "Gross-error in y");
        cellValueType = CellValueType.LENGTH_RESIDUAL;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText, options.getFormatterOptions().get((Object)cellValueType).getUnit());
        doubleColumn = this.getColumn(header, FeaturePoint::grossErrorYProperty, UIPointTableBuilder.getDoubleCallback(cellValueType), ColumnType.APOSTERIORI_POINT, columnIndex, false);
        doubleColumn.setComparator((Comparator)new AbsoluteValueComparator());
        table.getColumns().add(doubleColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UIPointTableBuilder.tableheader.grosserror.z.label", "\u2207z");
        tooltipText = i18n.getString("UIPointTableBuilder.tableheader.grosserror.z.tooltip", "Gross-error in z");
        cellValueType = CellValueType.LENGTH_RESIDUAL;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText, options.getFormatterOptions().get((Object)cellValueType).getUnit());
        doubleColumn = this.getColumn(header, FeaturePoint::grossErrorZProperty, UIPointTableBuilder.getDoubleCallback(cellValueType), this.featureType == FeatureType.SURFACE ? ColumnType.APOSTERIORI_POINT : ColumnType.HIDDEN, columnIndex, false);
        doubleColumn.setComparator((Comparator)new AbsoluteValueComparator());
        table.getColumns().add(doubleColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UIPointTableBuilder.tableheader.maximumtolerablebias.x.label", "\u2207x(1)");
        tooltipText = i18n.getString("UIPointTableBuilder.tableheader.maximumtolerablebias.x.tooltip", "Maximum tolerable bias in x");
        cellValueType = CellValueType.LENGTH_RESIDUAL;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText, options.getFormatterOptions().get((Object)cellValueType).getUnit());
        doubleColumn = this.getColumn(header, FeaturePoint::maximumTolerableBiasXProperty, UIPointTableBuilder.getDoubleCallback(cellValueType), ColumnType.APOSTERIORI_POINT, columnIndex, false);
        doubleColumn.setComparator((Comparator)new AbsoluteValueComparator());
        table.getColumns().add(doubleColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UIPointTableBuilder.tableheader.maximumtolerablebias.y.label", "\u2207y(1)");
        tooltipText = i18n.getString("UIPointTableBuilder.tableheader.maximumtolerablebias.y.tooltip", "Maximum tolerable bias in y");
        cellValueType = CellValueType.LENGTH_RESIDUAL;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText, options.getFormatterOptions().get((Object)cellValueType).getUnit());
        doubleColumn = this.getColumn(header, FeaturePoint::maximumTolerableBiasYProperty, UIPointTableBuilder.getDoubleCallback(cellValueType), ColumnType.APOSTERIORI_POINT, columnIndex, false);
        doubleColumn.setComparator((Comparator)new AbsoluteValueComparator());
        table.getColumns().add(doubleColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UIPointTableBuilder.tableheader.maximumtolerablebias.z.label", "\u2207z(1)");
        tooltipText = i18n.getString("UIPointTableBuilder.tableheader.maximumtolerablebias.z.tooltip", "Maximum tolerable bias in z");
        cellValueType = CellValueType.LENGTH_RESIDUAL;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText, options.getFormatterOptions().get((Object)cellValueType).getUnit());
        doubleColumn = this.getColumn(header, FeaturePoint::maximumTolerableBiasZProperty, UIPointTableBuilder.getDoubleCallback(cellValueType), this.featureType == FeatureType.SURFACE ? ColumnType.APOSTERIORI_POINT : ColumnType.HIDDEN, columnIndex, false);
        doubleColumn.setComparator((Comparator)new AbsoluteValueComparator());
        table.getColumns().add(doubleColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UIPointTableBuilder.tableheader.minimaldetectablebias.x.label", "\u2207x(\u03bb)");
        tooltipText = i18n.getString("UIPointTableBuilder.tableheader.minimaldetectablebias.x.tooltip", "Minimal detectable bias in x");
        cellValueType = CellValueType.LENGTH_RESIDUAL;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText, options.getFormatterOptions().get((Object)cellValueType).getUnit());
        doubleColumn = this.getColumn(header, FeaturePoint::minimalDetectableBiasXProperty, UIPointTableBuilder.getDoubleCallback(cellValueType), ColumnType.APOSTERIORI_POINT, columnIndex, false);
        doubleColumn.setComparator((Comparator)new AbsoluteValueComparator());
        table.getColumns().add(doubleColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UIPointTableBuilder.tableheader.minimaldetectablebias.y.label", "\u2207y(\u03bb)");
        tooltipText = i18n.getString("UIPointTableBuilder.tableheader.minimaldetectablebias.y.tooltip", "Minimal detectable bias in y");
        cellValueType = CellValueType.LENGTH_RESIDUAL;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText, options.getFormatterOptions().get((Object)cellValueType).getUnit());
        doubleColumn = this.getColumn(header, FeaturePoint::minimalDetectableBiasYProperty, UIPointTableBuilder.getDoubleCallback(cellValueType), ColumnType.APOSTERIORI_POINT, columnIndex, false);
        doubleColumn.setComparator((Comparator)new AbsoluteValueComparator());
        table.getColumns().add(doubleColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UIPointTableBuilder.tableheader.minimaldetectablebias.z.label", "\u2207z(\u03bb)");
        tooltipText = i18n.getString("UIPointTableBuilder.tableheader.minimaldetectablebias.z.tooltip", "Minimal detectable bias in z");
        cellValueType = CellValueType.LENGTH_RESIDUAL;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText, options.getFormatterOptions().get((Object)cellValueType).getUnit());
        doubleColumn = this.getColumn(header, FeaturePoint::minimalDetectableBiasZProperty, UIPointTableBuilder.getDoubleCallback(cellValueType), this.featureType == FeatureType.SURFACE ? ColumnType.APOSTERIORI_POINT : ColumnType.HIDDEN, columnIndex, false);
        doubleColumn.setComparator((Comparator)new AbsoluteValueComparator());
        table.getColumns().add(doubleColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UIPointTableBuilder.tableheader.pvalue.apriori.label", "log(Pprio)");
        tooltipText = i18n.getString("UIPointTableBuilder.tableheader.pvalue.apriori.tooltip", "A-priori p-value in logarithmic representation");
        cellValueType = CellValueType.STATISTIC;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText);
        doubleColumn = this.getColumn(header, FeaturePoint::pValueAprioriProperty, UIPointTableBuilder.getDoubleCallback(cellValueType), ColumnType.APOSTERIORI_POINT, columnIndex, false);
        doubleColumn.setComparator((Comparator)new AbsoluteValueComparator());
        table.getColumns().add(doubleColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UIPointTableBuilder.tableheader.pvalue.aposteriori.label", "log(Ppost)");
        tooltipText = i18n.getString("UIPointTableBuilder.tableheader.pvalue.aposteriori.tooltip", "A-posteriori p-value in logarithmic representation");
        cellValueType = CellValueType.STATISTIC;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText);
        doubleColumn = this.getColumn(header, FeaturePoint::pValueAposterioriProperty, UIPointTableBuilder.getDoubleCallback(cellValueType), ColumnType.APOSTERIORI_POINT, columnIndex, false);
        doubleColumn.setComparator((Comparator)new AbsoluteValueComparator());
        table.getColumns().add(doubleColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UIPointTableBuilder.tableheader.teststatistic.apriori.label", "Tprio");
        tooltipText = i18n.getString("UIPointTableBuilder.tableheader.teststatistic.apriori.tooltip", "A-priori test statistic");
        cellValueType = CellValueType.STATISTIC;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText);
        doubleColumn = this.getColumn(header, FeaturePoint::testStatisticAprioriProperty, UIPointTableBuilder.getDoubleCallback(cellValueType), ColumnType.APOSTERIORI_POINT, columnIndex, false);
        doubleColumn.setComparator((Comparator)new AbsoluteValueComparator());
        table.getColumns().add(doubleColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UIPointTableBuilder.tableheader.teststatistic.aposteriori.label", "Tpost");
        tooltipText = i18n.getString("UIPointTableBuilder.tableheader.teststatistic.aposteriori.tooltip", "A-posteriori test statistic");
        cellValueType = CellValueType.STATISTIC;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText);
        doubleColumn = this.getColumn(header, FeaturePoint::testStatisticAposterioriProperty, UIPointTableBuilder.getDoubleCallback(cellValueType), ColumnType.APOSTERIORI_POINT, columnIndex, false);
        doubleColumn.setComparator((Comparator)new AbsoluteValueComparator());
        table.getColumns().add(doubleColumn);
        final int columnIndexSignificant = columnIndex = table.getColumns().size();
        labelText = i18n.getString("UIPointTableBuilder.tableheader.testdecision.label", "Significant");
        tooltipText = i18n.getString("UIPointTableBuilder.tableheader.testdecision.tooltip", "Checked, if null-hypothesis is rejected");
        cellValueType = CellValueType.BOOLEAN;
        header = new ColumnTooltipHeader(cellValueType, labelText, tooltipText);
        booleanColumn = this.getColumn(header, FeaturePoint::significantProperty, UIPointTableBuilder.getBooleanCallback(), ColumnType.APOSTERIORI_POINT, columnIndex, false);
        booleanColumn.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<FeaturePoint, Boolean>, ObservableValue<Boolean>>(){

            public ObservableValue<Boolean> call(TableColumn.CellDataFeatures<FeaturePoint, Boolean> param) {
                UITableBuilder.TableCellChangeListener significantChangeListener = new UITableBuilder.TableCellChangeListener(UIPointTableBuilder.this, columnIndexSignificant, (FeaturePoint)param.getValue());
                SimpleBooleanProperty booleanProp = new SimpleBooleanProperty(((FeaturePoint)param.getValue()).isSignificant());
                booleanProp.addListener(significantChangeListener);
                return booleanProp;
            }
        });
        table.getColumns().add(booleanColumn);
        this.tables.put(this.featureType, table);
        this.table = table;
    }

    @Override
    void setValue(final FeaturePoint featurePoint, int columnIndex, Object oldValue, Object newValue) {
        switch (columnIndex) {
            case 0: {
                featurePoint.setEnable(newValue != null && newValue instanceof Boolean && (Boolean)newValue != false);
                break;
            }
            case 1: {
                if (newValue != null && !newValue.toString().trim().isEmpty()) {
                    featurePoint.setName(newValue.toString().trim());
                    break;
                }
                featurePoint.setName(oldValue == null ? null : oldValue.toString().trim());
                break;
            }
            case 2: {
                if (newValue != null && newValue instanceof Double) {
                    featurePoint.setX0((Double)newValue);
                    break;
                }
                featurePoint.setX0(oldValue != null && oldValue instanceof Double ? (Double)oldValue : null);
                break;
            }
            case 3: {
                if (newValue != null && newValue instanceof Double) {
                    featurePoint.setY0((Double)newValue);
                    break;
                }
                featurePoint.setY0(oldValue != null && oldValue instanceof Double ? (Double)oldValue : null);
                break;
            }
            case 5: {
                if (newValue != null && newValue instanceof Double) {
                    featurePoint.setZ0((Double)newValue);
                    break;
                }
                featurePoint.setZ0(oldValue != null && oldValue instanceof Double ? (Double)oldValue : null);
                break;
            }
            default: {
                System.err.println(this.getClass().getSimpleName() + " : Editable column exceed " + columnIndex);
            }
        }
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                UIPointTableBuilder.this.table.refresh();
                UIPointTableBuilder.this.table.requestFocus();
                UIPointTableBuilder.this.table.getSelectionModel().clearSelection();
                UIPointTableBuilder.this.table.getSelectionModel().select((Object)featurePoint);
                UIPointTableBuilder.this.table.sort();
            }
        });
    }

    private void setPointsToFeature(Feature feature) {
        ObservableList tableModel = this.getTableModel(this.table);
        for (FeaturePoint featurePoint : tableModel) {
            featurePoint.clear();
        }
        if (feature != null) {
            for (GeometricPrimitive geometricPrimitive : feature) {
                geometricPrimitive.getFeaturePoints().setAll((Collection)tableModel);
            }
        }
    }

    @Override
    public void featureChanged(FeatureEvent evt) {
        if (evt.getEventType() == FeatureEvent.FeatureEventType.FEATURE_ADDED) {
            this.setPointsToFeature(evt.getSource());
        } else if (evt.getEventType() == FeatureEvent.FeatureEventType.FEATURE_REMOVED) {
            this.setPointsToFeature(null);
        }
    }

    private static Callback<TableColumn<FeaturePoint, Matrix>, TableCell<FeaturePoint, Matrix>> getMatrixCallback() {
        return new Callback<TableColumn<FeaturePoint, Matrix>, TableCell<FeaturePoint, Matrix>>(){

            public TableCell<FeaturePoint, Matrix> call(TableColumn<FeaturePoint, Matrix> cell) {
                TableCell<FeaturePoint, Matrix> tableCell = new TableCell<FeaturePoint, Matrix>(){
                    final Button button = UIPointTableBuilder.createButton(i18n.getString("UIPointTableBuilder.dispersion.button.label", "Dispersion"), "");

                    public void updateItem(Matrix item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (empty) {
                            this.setGraphic(null);
                            this.setText(null);
                        } else {
                            this.button.getTooltip().setText(String.format(Locale.ENGLISH, i18n.getString("UIPointTableBuilder.dispersion.button.tooltip", "Show dispersion of point %s"), this.getTableRow().getItem() == null || ((FeaturePoint)this.getTableRow().getItem()).getName() == null ? "" : ((FeaturePoint)this.getTableRow().getItem()).getName()));
                            this.button.setOnMousePressed((EventHandler)new EventHandler<MouseEvent>(){

                                public void handle(MouseEvent event) {
                                    this.getTableView().getSelectionModel().clearAndSelect(this.getTableRow().getIndex());
                                }
                            });
                            this.button.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                                public void handle(ActionEvent event) {
                                    TableView.TableViewSelectionModel tableViewSelectionModel = this.getTableView().getSelectionModel();
                                    tableViewSelectionModel.clearAndSelect(this.getTableRow().getIndex());
                                    MatrixDialog.showAndWait((TableView.TableViewSelectionModel<FeaturePoint>)tableViewSelectionModel);
                                }
                            });
                            this.setGraphic((Node)this.button);
                            this.setText(null);
                        }
                    }
                };
                tableCell.setAlignment(Pos.CENTER);
                return tableCell;
            }
        };
    }

    static Button createButton(String title, String tooltip) {
        Label label = new Label(title);
        label.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        label.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        label.setAlignment(Pos.CENTER);
        label.setPadding(new Insets(0.0, 0.0, 0.0, 0.0));
        Button button = new Button();
        button.setGraphic((Node)label);
        button.setTooltip(new Tooltip(tooltip));
        return button;
    }
}

