/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.juniform.ui.table;

import java.util.Collection;
import java.util.function.Predicate;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.collections.transformation.FilteredList;
import javafx.geometry.Pos;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.TextFieldTableCell;
import javafx.util.Callback;
import javafx.util.StringConverter;
import org.applied_geodesy.adjustment.geometry.Feature;
import org.applied_geodesy.adjustment.geometry.FeatureChangeListener;
import org.applied_geodesy.adjustment.geometry.FeatureEvent;
import org.applied_geodesy.adjustment.geometry.GeometricPrimitive;
import org.applied_geodesy.adjustment.geometry.parameter.Parameter;
import org.applied_geodesy.adjustment.geometry.parameter.ParameterType;
import org.applied_geodesy.adjustment.geometry.parameter.UnknownParameter;
import org.applied_geodesy.juniform.ui.dialog.UnknownParameterTypeDialog;
import org.applied_geodesy.juniform.ui.table.ParameterDoubleCell;
import org.applied_geodesy.juniform.ui.table.UIEditableTableBuilder;
import org.applied_geodesy.ui.table.ColumnTooltipHeader;
import org.applied_geodesy.ui.table.ColumnType;
import org.applied_geodesy.ui.table.DisplayCellFormatType;
import org.applied_geodesy.ui.table.NaturalOrderTableColumnComparator;
import org.applied_geodesy.util.CellValueType;
import org.applied_geodesy.util.ObservableUniqueList;

public class UIParameterTableBuilder
extends UIEditableTableBuilder<UnknownParameter>
implements FeatureChangeListener {
    private static UIParameterTableBuilder tableBuilder = new UIParameterTableBuilder();
    private boolean isInitialize = false;
    private ObservableUniqueList<UnknownParameter> unknownFeatureParameters;
    private Predicate<UnknownParameter> visiblePredicate = new Predicate<UnknownParameter>(){

        @Override
        public boolean test(UnknownParameter unknownParameter) {
            return unknownParameter.isVisible();
        }
    };

    private UIParameterTableBuilder() {
    }

    public static UIParameterTableBuilder getInstance() {
        tableBuilder.init();
        return tableBuilder;
    }

    @Override
    public TableView<UnknownParameter> getTable() {
        return this.getTable(null);
    }

    public TableView<UnknownParameter> getTable(GeometricPrimitive geometry) {
        if (geometry == null) {
            if (this.unknownFeatureParameters != null) {
                FilteredList filteredFeatureParameters = new FilteredList(this.unknownFeatureParameters, this.visiblePredicate);
                this.getTableModel(this.table).setAll((Collection)filteredFeatureParameters);
            }
        } else {
            this.getTableModel(this.table).setAll((Collection)FXCollections.observableArrayList(geometry.getUnknownParameters()));
        }
        return this.table;
    }

    private void init() {
        if (this.isInitialize) {
            return;
        }
        TableColumn<UnknownParameter, ParameterType> parameterTypeColumn = null;
        TableColumn<UnknownParameter, Double> doubleColumn = null;
        TableColumn<UnknownParameter, String> stringColumn = null;
        TableView table = this.createTable();
        int columnIndex = table.getColumns().size();
        String labelText = i18n.getString("UIParameterTableBuilder.tableheader.name.label", "Name");
        String tooltipText = i18n.getString("UIParameterTableBuilder.tableheader.name.tooltip", "Name of the model parameter");
        ColumnTooltipHeader header = new ColumnTooltipHeader(CellValueType.STRING, labelText, tooltipText);
        stringColumn = this.getColumn(header, Parameter::nameProperty, UIParameterTableBuilder.getStringCallback(), ColumnType.VISIBLE, columnIndex, true);
        stringColumn.setComparator(new NaturalOrderTableColumnComparator<String>(stringColumn));
        table.getColumns().add(stringColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UIParameterTableBuilder.tableheader.type.label", "Type");
        tooltipText = i18n.getString("UIParameterTableBuilder.tableheader.type.tooltip", "Type of the model parameter");
        header = new ColumnTooltipHeader(CellValueType.STRING, labelText, tooltipText);
        parameterTypeColumn = this.getColumn(header, Parameter::parameterTypeProperty, UIParameterTableBuilder.getParameterTypeCallback(), ColumnType.VISIBLE, columnIndex, false);
        parameterTypeColumn.setComparator(new NaturalOrderTableColumnComparator<ParameterType>(parameterTypeColumn));
        table.getColumns().add(parameterTypeColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UIParameterTableBuilder.tableheader.value.aposteriori.label", "Estimated value");
        tooltipText = i18n.getString("UIParameterTableBuilder.tableheader.value.aposteriori.tooltip", "Estimated value of model parameter");
        header = new ColumnTooltipHeader(CellValueType.STRING, labelText, tooltipText);
        doubleColumn = this.getColumn(header, UnknownParameter::valueProperty, UIParameterTableBuilder.getDoubleValueWithUnitCallback(DisplayCellFormatType.NORMAL), ColumnType.VISIBLE, columnIndex, false);
        table.getColumns().add(doubleColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UIParameterTableBuilder.tableheader.uncertainty.label", "\u03c3");
        tooltipText = i18n.getString("UIParameterTableBuilder.tableheader.uncertainty.tooltip", "A-posteriori uncertainty of parameter");
        header = new ColumnTooltipHeader(CellValueType.STRING, labelText, tooltipText);
        doubleColumn = this.getColumn(header, UnknownParameter::uncertaintyProperty, UIParameterTableBuilder.getDoubleValueWithUnitCallback(DisplayCellFormatType.UNCERTAINTY), ColumnType.VISIBLE, columnIndex, false);
        table.getColumns().add(doubleColumn);
        columnIndex = table.getColumns().size();
        labelText = i18n.getString("UIParameterTableBuilder.tableheader.description.label", "Description");
        tooltipText = i18n.getString("UIParameterTableBuilder.tableheader.description.tooltip", "User-defined description of the parameter");
        header = new ColumnTooltipHeader(CellValueType.STRING, labelText, tooltipText);
        stringColumn = this.getColumn(header, Parameter::descriptionProperty, UIParameterTableBuilder.getStringCallback(), ColumnType.VISIBLE, columnIndex, true);
        stringColumn.setComparator(new NaturalOrderTableColumnComparator<String>(stringColumn));
        table.getColumns().add(stringColumn);
        table.setColumnResizePolicy(TableView.CONSTRAINED_RESIZE_POLICY_FLEX_LAST_COLUMN);
        this.table = table;
        this.isInitialize = true;
    }

    private static Callback<TableColumn<UnknownParameter, ParameterType>, TableCell<UnknownParameter, ParameterType>> getParameterTypeCallback() {
        return new Callback<TableColumn<UnknownParameter, ParameterType>, TableCell<UnknownParameter, ParameterType>>(){

            public TableCell<UnknownParameter, ParameterType> call(TableColumn<UnknownParameter, ParameterType> cell) {
                TextFieldTableCell tableCell = new TextFieldTableCell((StringConverter)new StringConverter<ParameterType>(){

                    public String toString(ParameterType parameterType) {
                        return UnknownParameterTypeDialog.getParameterTypeLabel(parameterType);
                    }

                    public ParameterType fromString(String string) {
                        return ParameterType.valueOf(string);
                    }
                });
                tableCell.setAlignment(Pos.CENTER_LEFT);
                return tableCell;
            }
        };
    }

    private static Callback<TableColumn<UnknownParameter, Double>, TableCell<UnknownParameter, Double>> getDoubleValueWithUnitCallback(final DisplayCellFormatType displayFormatType) {
        return new Callback<TableColumn<UnknownParameter, Double>, TableCell<UnknownParameter, Double>>(){

            public TableCell<UnknownParameter, Double> call(TableColumn<UnknownParameter, Double> cell) {
                return new ParameterDoubleCell(displayFormatType);
            }
        };
    }

    private void setFeature(Feature feature) {
        this.unknownFeatureParameters = feature == null ? new ObservableUniqueList(0) : feature.getUnknownParameters();
    }

    @Override
    void setValue(final UnknownParameter unknownParameter, int columnIndex, Object oldValue, Object newValue) {
        boolean valid = !(oldValue != null && !oldValue.toString().trim().isEmpty() || newValue != null && !newValue.toString().trim().isEmpty());
        switch (columnIndex) {
            case 0: {
                if (newValue != null && !newValue.toString().trim().isEmpty()) {
                    unknownParameter.setName(newValue.toString().trim());
                    valid = true;
                    break;
                }
                unknownParameter.setName(oldValue == null ? null : oldValue.toString().trim());
                break;
            }
            case 4: {
                if (newValue != null && !newValue.toString().trim().isEmpty()) {
                    unknownParameter.setDescription(newValue.toString().trim());
                    valid = true;
                    break;
                }
                unknownParameter.setDescription(oldValue == null ? null : oldValue.toString().trim());
                break;
            }
            default: {
                System.err.println(this.getClass().getSimpleName() + " : Editable column exceed " + columnIndex);
                valid = false;
            }
        }
        if (!valid) {
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    UIParameterTableBuilder.this.table.refresh();
                    UIParameterTableBuilder.this.table.requestFocus();
                    UIParameterTableBuilder.this.table.getSelectionModel().clearSelection();
                    UIParameterTableBuilder.this.table.getSelectionModel().select((Object)unknownParameter);
                }
            });
        }
    }

    @Override
    public void featureChanged(FeatureEvent evt) {
        if (evt.getEventType() == FeatureEvent.FeatureEventType.FEATURE_ADDED) {
            this.setFeature(evt.getSource());
        } else if (evt.getEventType() == FeatureEvent.FeatureEventType.FEATURE_REMOVED) {
            this.setFeature(null);
        }
    }
}

