/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.juniform.ui.table;

import javafx.geometry.Pos;
import javafx.scene.control.TableRow;
import org.applied_geodesy.adjustment.geometry.parameter.UnknownParameter;
import org.applied_geodesy.ui.table.DisplayCellFormatType;
import org.applied_geodesy.ui.table.EditableCell;
import org.applied_geodesy.ui.table.EditableDoubleCellConverter;
import org.applied_geodesy.util.CellValueType;
import org.applied_geodesy.util.FormatterChangedListener;
import org.applied_geodesy.util.FormatterEvent;
import org.applied_geodesy.util.FormatterOptions;

class ParameterDoubleCell
extends EditableCell<UnknownParameter, Double>
implements FormatterChangedListener {
    private DisplayCellFormatType displayFormatType;
    private EditableDoubleCellConverter editableDoubleCellConverter;
    private FormatterOptions options = FormatterOptions.getInstance();

    ParameterDoubleCell(DisplayCellFormatType displayFormatType) {
        super(new EditableDoubleCellConverter(CellValueType.LENGTH, true));
        this.editableDoubleCellConverter = (EditableDoubleCellConverter)this.getEditableCellConverter();
        this.displayFormatType = displayFormatType;
        this.setAlignment(Pos.CENTER_RIGHT);
        this.options.addFormatterChangedListener(this);
    }

    protected void updateItem(Double value, boolean empty) {
        int currentIndex = this.indexProperty().getValue();
        if (!empty && currentIndex >= 0 && currentIndex < this.getTableView().getItems().size()) {
            UnknownParameter paramRow = (UnknownParameter)this.getTableView().getItems().get(currentIndex);
            this.setCellValueTypeOfUnknownParameter(paramRow);
        }
        super.updateItem((Object)value, empty);
    }

    private void setCellValueTypeOfUnknownParameter(UnknownParameter paramRow) {
        if (paramRow != null && paramRow.getParameterType() != null) {
            switch (paramRow.getParameterType()) {
                case ORIGIN_COORDINATE_X: 
                case ORIGIN_COORDINATE_Y: 
                case ORIGIN_COORDINATE_Z: 
                case PRIMARY_FOCAL_COORDINATE_X: 
                case PRIMARY_FOCAL_COORDINATE_Y: 
                case PRIMARY_FOCAL_COORDINATE_Z: 
                case SECONDARY_FOCAL_COORDINATE_X: 
                case SECONDARY_FOCAL_COORDINATE_Y: 
                case SECONDARY_FOCAL_COORDINATE_Z: 
                case COORDINATE_X: 
                case COORDINATE_Y: 
                case COORDINATE_Z: 
                case RADIUS: 
                case LENGTH: {
                    if (this.displayFormatType == DisplayCellFormatType.NORMAL) {
                        this.editableDoubleCellConverter.setCellValueType(CellValueType.LENGTH);
                        break;
                    }
                    if (this.displayFormatType == DisplayCellFormatType.UNCERTAINTY) {
                        this.editableDoubleCellConverter.setCellValueType(CellValueType.LENGTH_UNCERTAINTY);
                        break;
                    }
                    if (this.displayFormatType != DisplayCellFormatType.RESIDUAL) break;
                    this.editableDoubleCellConverter.setCellValueType(CellValueType.LENGTH_RESIDUAL);
                    break;
                }
                case VECTOR_X: 
                case VECTOR_Y: 
                case VECTOR_Z: 
                case VECTOR_LENGTH: {
                    if (this.displayFormatType == DisplayCellFormatType.NORMAL) {
                        this.editableDoubleCellConverter.setCellValueType(CellValueType.VECTOR);
                        break;
                    }
                    if (this.displayFormatType == DisplayCellFormatType.UNCERTAINTY) {
                        this.editableDoubleCellConverter.setCellValueType(CellValueType.VECTOR_UNCERTAINTY);
                        break;
                    }
                    if (this.displayFormatType != DisplayCellFormatType.RESIDUAL) break;
                    this.editableDoubleCellConverter.setCellValueType(CellValueType.VECTOR_RESIDUAL);
                    break;
                }
                case ANGLE: {
                    if (this.displayFormatType == DisplayCellFormatType.NORMAL) {
                        this.editableDoubleCellConverter.setCellValueType(CellValueType.ANGLE);
                        break;
                    }
                    if (this.displayFormatType == DisplayCellFormatType.UNCERTAINTY) {
                        this.editableDoubleCellConverter.setCellValueType(CellValueType.ANGLE_UNCERTAINTY);
                        break;
                    }
                    if (this.displayFormatType != DisplayCellFormatType.RESIDUAL) break;
                    this.editableDoubleCellConverter.setCellValueType(CellValueType.ANGLE_RESIDUAL);
                    break;
                }
                case MAJOR_AXIS_COEFFICIENT: 
                case MINOR_AXIS_COEFFICIENT: 
                case MIDDLE_AXIS_COEFFICIENT: 
                case ROTATION_COMPONENT_R11: 
                case ROTATION_COMPONENT_R12: 
                case ROTATION_COMPONENT_R13: 
                case ROTATION_COMPONENT_R21: 
                case ROTATION_COMPONENT_R22: 
                case ROTATION_COMPONENT_R23: 
                case ROTATION_COMPONENT_R31: 
                case ROTATION_COMPONENT_R32: 
                case ROTATION_COMPONENT_R33: 
                case POLYNOMIAL_COEFFICIENT_A: 
                case POLYNOMIAL_COEFFICIENT_B: 
                case POLYNOMIAL_COEFFICIENT_C: 
                case POLYNOMIAL_COEFFICIENT_D: 
                case POLYNOMIAL_COEFFICIENT_E: 
                case POLYNOMIAL_COEFFICIENT_F: 
                case POLYNOMIAL_COEFFICIENT_G: 
                case POLYNOMIAL_COEFFICIENT_H: 
                case POLYNOMIAL_COEFFICIENT_I: 
                case CONSTANT: {
                    this.editableDoubleCellConverter.setCellValueType(CellValueType.DOUBLE);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Error, unknown type of parameter " + String.valueOf((Object)paramRow.getParameterType()));
                }
            }
        }
    }

    @Override
    public void formatterChanged(FormatterEvent evt) {
        TableRow tableRow = this.getTableRow();
        if (tableRow == null || tableRow.isEmpty() || this.getTableRow().getItem() == null) {
            return;
        }
        UnknownParameter paramRow = (UnknownParameter)this.getTableRow().getItem();
        this.setCellValueTypeOfUnknownParameter(paramRow);
    }
}

