/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.juniform.ui.propertiespane;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.function.Predicate;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TextField;
import javafx.scene.control.TitledPane;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.util.Callback;
import org.applied_geodesy.adjustment.geometry.GeometricPrimitive;
import org.applied_geodesy.adjustment.geometry.point.FeaturePoint;
import org.applied_geodesy.juniform.ui.i18n.I18N;
import org.applied_geodesy.util.ObservableUniqueList;

public class UIPointSelectionPaneBuilder {
    private static UIPointSelectionPaneBuilder pointSelectionPaneBuilder = new UIPointSelectionPaneBuilder();
    private Node pointSelectionNode = null;
    private ListView<FeaturePoint> sourceListView;
    private ListView<FeaturePoint> targetListView;
    private FilteredList<FeaturePoint> filteredTargetPointList;
    private FilteredList<FeaturePoint> filteredSourcePointList;
    private ObservableUniqueList<FeaturePoint> targetPointList;
    private ObservableList<FeaturePoint> sourcePointList;
    private CheckBox regExpSourceListFilterCheckBox;
    private CheckBox regExpTargetListFilterCheckBox;
    private TextField sourceListFilterTextField;
    private TextField targetListFilterTextField;
    private I18N i18n = I18N.getInstance();

    private UIPointSelectionPaneBuilder() {
    }

    public static UIPointSelectionPaneBuilder getInstance() {
        pointSelectionPaneBuilder.init();
        return pointSelectionPaneBuilder;
    }

    public Node getNode(ObservableList<FeaturePoint> sourcePoints, GeometricPrimitive geometricPrimitive) {
        this.targetPointList = geometricPrimitive.getFeaturePoints();
        this.filteredTargetPointList = new FilteredList(this.targetPointList);
        this.filteredSourcePointList = new FilteredList(sourcePoints);
        this.filteredSourcePointList.setPredicate((Predicate)new Predicate<FeaturePoint>(){

            @Override
            public boolean test(FeaturePoint featurePoint) {
                return !UIPointSelectionPaneBuilder.this.targetPointList.contains(featurePoint);
            }
        });
        this.sourcePointList = FXCollections.observableArrayList(this.filteredSourcePointList);
        this.filteredSourcePointList = new FilteredList(this.sourcePointList);
        this.sourceListView.setItems(this.filteredSourcePointList);
        this.targetListView.setItems(this.filteredTargetPointList);
        ListType[] listTypeArray = ListType.values();
        int n = listTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ListType listType = listTypeArray[n2];
            this.filterList(listType, null);
            ++n2;
        }
        return this.pointSelectionNode;
    }

    private void init() {
        if (this.pointSelectionNode != null) {
            return;
        }
        this.sourceListView = this.createListView();
        this.targetListView = this.createListView();
        this.regExpSourceListFilterCheckBox = this.createCheckBox(this.i18n.getString("UIPointSelectionPaneBuilder.mode.regex.global.label", "Regular expression"), this.i18n.getString("UIPointSelectionPaneBuilder.mode.regex.global.tooltip", "If selected, regular expression mode will be applied to global point list"), ListType.GLOBAL_POINTS);
        this.regExpTargetListFilterCheckBox = this.createCheckBox(this.i18n.getString("UIPointSelectionPaneBuilder.mode.regex.geometry.label", "Regular expression"), this.i18n.getString("UIPointSelectionPaneBuilder.mode.regex.geometry.tooltip", "If selected, regular expression mode will be applied to geometry point list"), ListType.GEOMETRY_POINTS);
        this.sourceListFilterTextField = this.createTextField(this.i18n.getString("UIPointSelectionPaneBuilder.filter.list.global.prompt", "Enter filter sequence"), this.i18n.getString("UIPointSelectionPaneBuilder.filter.list.global.tooltip", "Filtering global point list by character sequence"), ListType.GLOBAL_POINTS);
        this.targetListFilterTextField = this.createTextField(this.i18n.getString("UIPointSelectionPaneBuilder.filter.list.geometry.prompt", "Enter filter sequence"), this.i18n.getString("UIPointSelectionPaneBuilder.filter.list.geometry.tooltip", "Filtering geometry point list by character sequence"), ListType.GEOMETRY_POINTS);
        PointSelectionEventHandler pointSelectionEventHandler = new PointSelectionEventHandler();
        Button addSelectedPointsButton = this.createButton(this.i18n.getString("UIPointSelectionPaneBuilder.add.selection.label", "Add selection \u25b7"), this.i18n.getString("UIPointSelectionPaneBuilder.add.selection.tooltip", "Add selected points to geometric primitive."), pointSelectionEventHandler, SelectionEventType.ADD);
        Button removeSelectedPointsButton = this.createButton(this.i18n.getString("UIPointSelectionPaneBuilder.remove.selection.label", "\u25c1 Remove selection"), this.i18n.getString("UIPointSelectionPaneBuilder.remove.selection.tooltip", "Remove selected points from geometric primitive"), pointSelectionEventHandler, SelectionEventType.REMOVE);
        Button addAllPointsButton = this.createButton(this.i18n.getString("UIPointSelectionPaneBuilder.add.all.label", "Add all \u25b6"), this.i18n.getString("UIPointSelectionPaneBuilder.add.all.tooltip", "Add all points to geometric primitive"), pointSelectionEventHandler, SelectionEventType.ADD_ALL);
        Button removeAllPointsButton = this.createButton(this.i18n.getString("UIPointSelectionPaneBuilder.remove.all.label", "\u25c0 Remove all"), this.i18n.getString("UIPointSelectionPaneBuilder.remove.all.tooltip", "Remove all points from geometric primitive"), pointSelectionEventHandler, SelectionEventType.REMOVE_ALL);
        TitledPane sourceTitledPane = this.createTitledPane(this.i18n.getString("UIPointSelectionPaneBuilder.pointlist.global.title", "Points of project"));
        TitledPane targetTitledPane = this.createTitledPane(this.i18n.getString("UIPointSelectionPaneBuilder.pointlist.geometry.title", "Points of geometry"));
        sourceTitledPane.setContent(this.sourceListView);
        targetTitledPane.setContent(this.targetListView);
        VBox topVbox = new VBox();
        topVbox.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        topVbox.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        VBox bottomVbox = new VBox();
        bottomVbox.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        bottomVbox.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        VBox buttonVbox = new VBox();
        buttonVbox.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        buttonVbox.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        VBox.setMargin((Node)addSelectedPointsButton, (Insets)new Insets(5.0, 10.0, 5.0, 10.0));
        VBox.setMargin((Node)removeSelectedPointsButton, (Insets)new Insets(5.0, 10.0, 10.0, 10.0));
        VBox.setMargin((Node)addAllPointsButton, (Insets)new Insets(10.0, 10.0, 5.0, 10.0));
        VBox.setMargin((Node)removeAllPointsButton, (Insets)new Insets(5.0, 10.0, 5.0, 10.0));
        VBox.setVgrow((Node)addSelectedPointsButton, (Priority)Priority.ALWAYS);
        VBox.setVgrow((Node)removeSelectedPointsButton, (Priority)Priority.ALWAYS);
        VBox.setVgrow((Node)addAllPointsButton, (Priority)Priority.ALWAYS);
        VBox.setVgrow((Node)removeAllPointsButton, (Priority)Priority.ALWAYS);
        buttonVbox.getChildren().addAll((Object[])new Node[]{addSelectedPointsButton, removeSelectedPointsButton, addAllPointsButton, removeAllPointsButton});
        GridPane gridPane = this.createGridPane();
        GridPane.setMargin((Node)sourceTitledPane, (Insets)new Insets(2.0, 5.0, 2.0, 2.0));
        GridPane.setMargin((Node)targetTitledPane, (Insets)new Insets(2.0, 2.0, 2.0, 5.0));
        GridPane.setMargin((Node)this.regExpSourceListFilterCheckBox, (Insets)new Insets(0.0, 5.0, 2.0, 2.0));
        GridPane.setMargin((Node)this.regExpTargetListFilterCheckBox, (Insets)new Insets(0.0, 2.0, 2.0, 5.0));
        GridPane.setMargin((Node)this.sourceListFilterTextField, (Insets)new Insets(2.0, 5.0, 0.0, 2.0));
        GridPane.setMargin((Node)this.targetListFilterTextField, (Insets)new Insets(2.0, 2.0, 0.0, 5.0));
        gridPane.setAlignment(Pos.TOP_CENTER);
        GridPane.setHgrow((Node)this.sourceListFilterTextField, (Priority)Priority.ALWAYS);
        GridPane.setVgrow((Node)this.sourceListFilterTextField, (Priority)Priority.NEVER);
        GridPane.setHgrow((Node)this.targetListFilterTextField, (Priority)Priority.ALWAYS);
        GridPane.setVgrow((Node)this.targetListFilterTextField, (Priority)Priority.NEVER);
        GridPane.setHgrow((Node)this.regExpSourceListFilterCheckBox, (Priority)Priority.NEVER);
        GridPane.setVgrow((Node)this.regExpSourceListFilterCheckBox, (Priority)Priority.NEVER);
        GridPane.setHgrow((Node)this.regExpTargetListFilterCheckBox, (Priority)Priority.NEVER);
        GridPane.setVgrow((Node)this.regExpTargetListFilterCheckBox, (Priority)Priority.NEVER);
        GridPane.setHgrow((Node)sourceTitledPane, (Priority)Priority.ALWAYS);
        GridPane.setVgrow((Node)sourceTitledPane, (Priority)Priority.ALWAYS);
        GridPane.setHgrow((Node)targetTitledPane, (Priority)Priority.ALWAYS);
        GridPane.setVgrow((Node)targetTitledPane, (Priority)Priority.ALWAYS);
        GridPane.setHgrow((Node)topVbox, (Priority)Priority.NEVER);
        GridPane.setVgrow((Node)topVbox, (Priority)Priority.ALWAYS);
        GridPane.setHgrow((Node)buttonVbox, (Priority)Priority.NEVER);
        GridPane.setVgrow((Node)buttonVbox, (Priority)Priority.NEVER);
        GridPane.setHgrow((Node)bottomVbox, (Priority)Priority.NEVER);
        GridPane.setVgrow((Node)bottomVbox, (Priority)Priority.ALWAYS);
        int row = 0;
        gridPane.add((Node)this.sourceListFilterTextField, 0, row);
        gridPane.add((Node)this.targetListFilterTextField, 2, row++);
        gridPane.add((Node)this.regExpSourceListFilterCheckBox, 0, row);
        gridPane.add((Node)this.regExpTargetListFilterCheckBox, 2, row++);
        gridPane.add((Node)sourceTitledPane, 0, row, 1, 3);
        gridPane.add((Node)targetTitledPane, 2, row, 1, 3);
        gridPane.add((Node)topVbox, 1, row++);
        gridPane.add((Node)buttonVbox, 1, row++);
        gridPane.add((Node)bottomVbox, 1, row++);
        gridPane.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
        this.pointSelectionNode = gridPane;
    }

    private Button createButton(String title, String tooltip, PointSelectionEventHandler pointSelectionEventHandler, SelectionEventType selectionEventType) {
        Label label = new Label(title);
        label.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        label.setMaxSize(Double.MAX_VALUE, Double.NEGATIVE_INFINITY);
        label.setAlignment(Pos.CENTER);
        label.setPadding(new Insets(0.0, 0.0, 0.0, 3.0));
        Button button = new Button();
        button.setGraphic((Node)label);
        button.setTooltip(new Tooltip(tooltip));
        button.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        button.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        button.setUserData((Object)selectionEventType);
        button.setOnAction((EventHandler)pointSelectionEventHandler);
        return button;
    }

    private ListView<FeaturePoint> createListView() {
        ListView listView = new ListView();
        listView.setCellFactory(UIPointSelectionPaneBuilder.createFeaturePointCellFactory());
        listView.setMinSize(50.0, 100.0);
        listView.setPrefSize(50.0, 100.0);
        listView.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        listView.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        ListView placeholderListView = new ListView();
        placeholderListView.setDisable(true);
        placeholderListView.getItems().add((Object)new String());
        listView.setPlaceholder((Node)placeholderListView);
        return listView;
    }

    public static Callback<ListView<FeaturePoint>, ListCell<FeaturePoint>> createFeaturePointCellFactory() {
        return new Callback<ListView<FeaturePoint>, ListCell<FeaturePoint>>(){

            public ListCell<FeaturePoint> call(ListView<FeaturePoint> listView) {
                return new ListCell<FeaturePoint>(){

                    protected void updateItem(FeaturePoint featurePoint, boolean empty) {
                        super.updateItem((Object)featurePoint, empty);
                        if (empty || featurePoint == null || featurePoint.getName() == null) {
                            this.setText(null);
                            this.setGraphic(null);
                        } else {
                            this.setText(featurePoint.getName());
                        }
                    }
                };
            }
        };
    }

    private void filterList(ListType listType, String value) {
        FilteredList<FeaturePoint> filteredList = null;
        CheckBox regExpFilterCheckBox = null;
        TextField listFilterTextField = null;
        switch (listType) {
            case GLOBAL_POINTS: {
                regExpFilterCheckBox = this.regExpSourceListFilterCheckBox;
                listFilterTextField = this.sourceListFilterTextField;
                filteredList = this.filteredSourcePointList;
                break;
            }
            case GEOMETRY_POINTS: {
                regExpFilterCheckBox = this.regExpTargetListFilterCheckBox;
                listFilterTextField = this.targetListFilterTextField;
                filteredList = this.filteredTargetPointList;
            }
        }
        if (filteredList != null && listFilterTextField != null) {
            String filterText;
            String string = filterText = value == null || value.isBlank() ? listFilterTextField.getText() : value;
            if (filterText == null || filterText.isBlank()) {
                filteredList.setPredicate(null);
            } else {
                final boolean regExp = regExpFilterCheckBox != null && regExpFilterCheckBox.isSelected();
                filteredList.setPredicate((Predicate)new Predicate<FeaturePoint>(){

                    @Override
                    public boolean test(FeaturePoint featurePoint) {
                        if (!regExp) {
                            return featurePoint.getName().contains(filterText);
                        }
                        try {
                            return featurePoint.getName().matches(filterText);
                        }
                        catch (Exception exception) {
                            return true;
                        }
                    }
                });
            }
        }
    }

    private TitledPane createTitledPane(String title) {
        TitledPane titledPane = new TitledPane();
        titledPane.setMinSize(Double.NEGATIVE_INFINITY, 200.0);
        titledPane.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        titledPane.setCollapsible(false);
        titledPane.setAnimated(false);
        titledPane.setText(title);
        return titledPane;
    }

    private TextField createTextField(String promptText, String tooltipText, ListType listType) {
        TextField field = new TextField();
        field.setTooltip(new Tooltip(tooltipText));
        field.setPromptText(promptText);
        field.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        field.setMaxSize(Double.MAX_VALUE, Double.NEGATIVE_INFINITY);
        field.textProperty().addListener((ChangeListener)new FilterTextChangeListener(listType));
        return field;
    }

    private CheckBox createCheckBox(String text, String tooltip, ListType listType) {
        Label label = new Label(text);
        label.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        label.setPadding(new Insets(0.0, 0.0, 0.0, 3.0));
        CheckBox checkBox = new CheckBox();
        checkBox.setGraphic((Node)label);
        checkBox.setTooltip(new Tooltip(tooltip));
        checkBox.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        checkBox.setMaxSize(Double.MAX_VALUE, Double.NEGATIVE_INFINITY);
        checkBox.selectedProperty().addListener((ChangeListener)new FilterModeChangeListener(listType));
        return checkBox;
    }

    private GridPane createGridPane() {
        GridPane gridPane = new GridPane();
        gridPane.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        gridPane.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        gridPane.setHgap(10.0);
        gridPane.setVgap(10.0);
        return gridPane;
    }

    private class FilterModeChangeListener
    implements ChangeListener<Boolean> {
        private final ListType listType;

        private FilterModeChangeListener(ListType listType) {
            this.listType = listType;
        }

        public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
            UIPointSelectionPaneBuilder.this.filterList(this.listType, null);
        }
    }

    private class FilterTextChangeListener
    implements ChangeListener<String> {
        private final ListType listType;

        private FilterTextChangeListener(ListType listType) {
            this.listType = listType;
        }

        public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
            UIPointSelectionPaneBuilder.this.filterList(this.listType, newValue);
        }
    }

    private static enum ListType {
        GLOBAL_POINTS,
        GEOMETRY_POINTS;

    }

    private class PointSelectionEventHandler
    implements EventHandler<ActionEvent> {
        private PointSelectionEventHandler() {
        }

        public void handle(ActionEvent event) {
            if (event.getSource() instanceof Button && ((Button)event.getSource()).getUserData() instanceof SelectionEventType) {
                Button button = (Button)event.getSource();
                SelectionEventType selectionEventType = (SelectionEventType)((Object)button.getUserData());
                switch (selectionEventType) {
                    case ADD: {
                        LinkedHashSet selectedSourceItems = new LinkedHashSet(UIPointSelectionPaneBuilder.this.sourceListView.getSelectionModel().getSelectedItems());
                        UIPointSelectionPaneBuilder.this.sourcePointList.removeAll(selectedSourceItems);
                        UIPointSelectionPaneBuilder.this.targetPointList.addAll(selectedSourceItems);
                        UIPointSelectionPaneBuilder.this.targetListView.getSelectionModel().clearSelection();
                        break;
                    }
                    case ADD_ALL: {
                        LinkedHashSet<FeaturePoint> filteredSourceItems = new LinkedHashSet<FeaturePoint>((Collection<FeaturePoint>)UIPointSelectionPaneBuilder.this.filteredSourcePointList);
                        UIPointSelectionPaneBuilder.this.sourcePointList.removeAll(new HashSet<FeaturePoint>(filteredSourceItems));
                        UIPointSelectionPaneBuilder.this.targetPointList.addAll(filteredSourceItems);
                        break;
                    }
                    case REMOVE: {
                        LinkedHashSet selectedTargetItems = new LinkedHashSet(UIPointSelectionPaneBuilder.this.targetListView.getSelectionModel().getSelectedItems());
                        UIPointSelectionPaneBuilder.this.targetPointList.removeAll(selectedTargetItems);
                        UIPointSelectionPaneBuilder.this.sourcePointList.addAll(selectedTargetItems);
                        UIPointSelectionPaneBuilder.this.sourceListView.getSelectionModel().clearSelection();
                        break;
                    }
                    case REMOVE_ALL: {
                        LinkedHashSet<FeaturePoint> filteredTargetItems = new LinkedHashSet<FeaturePoint>((Collection<FeaturePoint>)UIPointSelectionPaneBuilder.this.filteredTargetPointList);
                        UIPointSelectionPaneBuilder.this.targetPointList.removeAll(new HashSet<FeaturePoint>(filteredTargetItems));
                        UIPointSelectionPaneBuilder.this.sourcePointList.addAll(filteredTargetItems);
                    }
                }
            }
        }
    }

    private static enum SelectionEventType {
        ADD,
        REMOVE,
        ADD_ALL,
        REMOVE_ALL;

    }
}

