/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.juniform.ui.menu;

import java.io.File;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuBar;
import javafx.scene.control.MenuItem;
import javafx.scene.control.RadioMenuItem;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleGroup;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.stage.FileChooser;
import javafx.stage.Window;
import org.applied_geodesy.adjustment.geometry.FeatureChangeListener;
import org.applied_geodesy.adjustment.geometry.FeatureEvent;
import org.applied_geodesy.adjustment.geometry.FeatureType;
import org.applied_geodesy.adjustment.geometry.GeometricPrimitive;
import org.applied_geodesy.adjustment.geometry.point.FeaturePoint;
import org.applied_geodesy.juniform.io.reader.FeaturePointFileReader;
import org.applied_geodesy.juniform.io.reader.InitialGuessFileReader;
import org.applied_geodesy.juniform.io.writer.FTLReport;
import org.applied_geodesy.juniform.io.writer.MatlabFeatureAdjustmentResultWriter;
import org.applied_geodesy.juniform.ui.JUniForm;
import org.applied_geodesy.juniform.ui.dialog.ReadFileProgressDialog;
import org.applied_geodesy.juniform.ui.i18n.I18N;
import org.applied_geodesy.juniform.ui.menu.MenuEventHandler;
import org.applied_geodesy.juniform.ui.menu.MenuItemType;
import org.applied_geodesy.juniform.ui.menu.PathMenuItem;
import org.applied_geodesy.juniform.ui.table.UIPointTableBuilder;
import org.applied_geodesy.juniform.ui.tree.UITreeBuilder;
import org.applied_geodesy.ui.dialog.OptionDialog;
import org.applied_geodesy.ui.io.DefaultFileChooser;
import org.applied_geodesy.util.ObservableUniqueList;

public class UIMenuBuilder
implements FeatureChangeListener {
    private static UIMenuBuilder menuBuilder = new UIMenuBuilder();
    private I18N i18n = I18N.getInstance();
    private MenuEventHandler menuEventHandler = new MenuEventHandler(this);
    private MenuBar menuBar;
    private ToggleGroup featureToggleGroup;
    private GeometricPrimitiveListChangeListener geometricPrimitiveListChangeListener = new GeometricPrimitiveListChangeListener();
    private Menu initialGuessMenu;
    private Menu reportMenu;

    private UIMenuBuilder() {
    }

    public static UIMenuBuilder getInstance() {
        return menuBuilder;
    }

    public MenuBar getMenuBar() {
        if (this.menuBar == null) {
            this.init();
        }
        return this.menuBar;
    }

    private void init() {
        this.featureToggleGroup = new ToggleGroup();
        this.menuBar = new MenuBar();
        Menu fileMenu = UIMenuBuilder.createMenu(this.i18n.getString("UIMenuBuilder.menu.file.label", "_File"), true);
        Menu curveMenu = UIMenuBuilder.createMenu(this.i18n.getString("UIMenuBuilder.menu.feature.curve.label", "_Curves"), true);
        Menu surfaceMenu = UIMenuBuilder.createMenu(this.i18n.getString("UIMenuBuilder.menu.feature.surface.label", "_Surfaces"), true);
        Menu propertiesMenu = UIMenuBuilder.createMenu(this.i18n.getString("UIMenuBuilder.menu.properties.label", "Propert_ies"), true);
        Menu adjustmentMenu = UIMenuBuilder.createMenu(this.i18n.getString("UIMenuBuilder.menu.adjustment.label", "Ad_justment"), true);
        Menu analysisMenu = UIMenuBuilder.createMenu(this.i18n.getString("UIMenuBuilder.menu.analysis.label", "Anal_ysis"), true);
        this.reportMenu = UIMenuBuilder.createMenu(this.i18n.getString("UIMenuBuilder.menu.report.label", "Repor_t"), true);
        Menu helpMenu = UIMenuBuilder.createMenu(this.i18n.getString("UIMenuBuilder.menu.help.label", "_?"), true);
        this.createFileMenu(fileMenu);
        this.createCurveFeatureMenu(curveMenu, this.featureToggleGroup);
        this.createSurfaceFeatureMenu(surfaceMenu, this.featureToggleGroup);
        this.createPropertiesMenu(propertiesMenu);
        this.createAdjustmentMenu(adjustmentMenu);
        this.createAnalysisMenu(analysisMenu);
        this.createReportMenu(this.reportMenu);
        this.createHelpMenu(helpMenu);
        this.menuBar.getMenus().addAll((Object[])new Menu[]{fileMenu, curveMenu, surfaceMenu, propertiesMenu, adjustmentMenu, analysisMenu, this.reportMenu, helpMenu});
    }

    private void createFileMenu(Menu parentMenu) {
        MenuItem importCurvePointsItem = UIMenuBuilder.createMenuItem(this.i18n.getString("UIMenuBuilder.menu.file.import.points.curve.label", "Import c_urve points"), true, MenuItemType.IMPORT_CURVE_POINTS, new KeyCodeCombination(KeyCode.U, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}), this.menuEventHandler, false);
        MenuItem importSurfacePointsItem = UIMenuBuilder.createMenuItem(this.i18n.getString("UIMenuBuilder.menu.file.import.points.surface.label", "Imp_ort surface points"), true, MenuItemType.IMPORT_SURFACE_POINTS, new KeyCodeCombination(KeyCode.O, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}), this.menuEventHandler, false);
        MenuItem exitItem = UIMenuBuilder.createMenuItem(this.i18n.getString("UIMenuBuilder.menu.file.exit.label", "_Exit"), true, MenuItemType.EXIT, new KeyCodeCombination(KeyCode.E, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}), this.menuEventHandler, false);
        this.initialGuessMenu = UIMenuBuilder.createMenu(this.i18n.getString("UIMenuBuilder.menu.file.import.initial.label", "Initial _guess"), true);
        this.initialGuessMenu.setDisable(true);
        parentMenu.getItems().addAll((Object[])new MenuItem[]{importCurvePointsItem, importSurfacePointsItem, new SeparatorMenuItem(), this.initialGuessMenu, new SeparatorMenuItem(), exitItem});
    }

    private void createAdjustmentMenu(Menu parentMenu) {
        MenuItem leastSquaresItem = UIMenuBuilder.createMenuItem(this.i18n.getString("UIMenuBuilder.menu.adjustment.leastsquares.label", "_Least-squares"), true, MenuItemType.LEAST_SQUARES, new KeyCodeCombination(KeyCode.L, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}), this.menuEventHandler, true);
        MenuItem teststatisticItem = UIMenuBuilder.createMenuItem(this.i18n.getString("UIMenuBuilder.menu.adjustment.teststatistic.label", "Test st_atistic"), true, MenuItemType.TEST_STATISTIC, new KeyCodeCombination(KeyCode.T, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}), this.menuEventHandler, true);
        MenuItem preferencesItem = UIMenuBuilder.createMenuItem(this.i18n.getString("UIMenuBuilder.menu.adjustment.preferences.label", "Preferen_ces"), true, MenuItemType.PREFERENCES, new KeyCodeCombination(KeyCode.ENTER, new KeyCombination.Modifier[]{KeyCombination.ALT_DOWN}), this.menuEventHandler, false);
        parentMenu.getItems().addAll((Object[])new MenuItem[]{leastSquaresItem, teststatisticItem, new SeparatorMenuItem(), preferencesItem});
    }

    private void createPropertiesMenu(Menu parentMenu) {
        MenuItem featurePropertiesItem = UIMenuBuilder.createMenuItem(this.i18n.getString("UIMenuBuilder.menu.setting.feature.label", "_Feature"), true, MenuItemType.FEATURE_PROPERTIES, new KeyCodeCombination(KeyCode.F, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}), this.menuEventHandler, true);
        MenuItem paramameterPropertiesItem = UIMenuBuilder.createMenuItem(this.i18n.getString("UIMenuBuilder.menu.setting.parameter.label", "P_arameter"), true, MenuItemType.PARAMETER_PROPERTIES, new KeyCodeCombination(KeyCode.P, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}), this.menuEventHandler, true);
        MenuItem restrictionPropertiesItem = UIMenuBuilder.createMenuItem(this.i18n.getString("UIMenuBuilder.menu.setting.restriction.label", "_Restriction"), true, MenuItemType.RESTRICTION_PROPERTIES, new KeyCodeCombination(KeyCode.R, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}), this.menuEventHandler, true);
        MenuItem postprocessingPropertiesItem = UIMenuBuilder.createMenuItem(this.i18n.getString("UIMenuBuilder.menu.setting.postprocessing.label", "_Post processing"), true, MenuItemType.POSTPROCESSING_PROPERTIES, new KeyCodeCombination(KeyCode.G, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}), this.menuEventHandler, true);
        parentMenu.getItems().addAll((Object[])new MenuItem[]{featurePropertiesItem, paramameterPropertiesItem, restrictionPropertiesItem, postprocessingPropertiesItem});
    }

    private void createAnalysisMenu(Menu parentMenu) {
        MenuItem quantileItem = UIMenuBuilder.createMenuItem(this.i18n.getString("UIMenuBuilder.menu.analysis.quantile.label", "_Quantiles"), true, MenuItemType.QUANTILES, new KeyCodeCombination(KeyCode.Q, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}), this.menuEventHandler, true);
        MenuItem varianceComponentItem = UIMenuBuilder.createMenuItem(this.i18n.getString("UIMenuBuilder.menu.analysis.variance_component.label", "_Variance components"), true, MenuItemType.VARIANCE_COMPONENT_ESTIMATION, new KeyCodeCombination(KeyCode.V, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}), this.menuEventHandler, true);
        parentMenu.getItems().addAll((Object[])new MenuItem[]{varianceComponentItem, quantileItem});
    }

    private void createCurveFeatureMenu(Menu parentMenu, ToggleGroup toggleGroup) {
        RadioMenuItem lineItem = UIMenuBuilder.createRadioMenuItem(this.i18n.getString("UIMenuBuilder.menu.feature.curve.line.label", "Line"), true, MenuItemType.LINE, null, this.menuEventHandler, true);
        RadioMenuItem circleItem = UIMenuBuilder.createRadioMenuItem(this.i18n.getString("UIMenuBuilder.menu.feature.curve.circle.label", "Circle"), true, MenuItemType.CIRCLE, null, this.menuEventHandler, true);
        RadioMenuItem ellipseItem = UIMenuBuilder.createRadioMenuItem(this.i18n.getString("UIMenuBuilder.menu.feature.curve.ellipse.label", "Ellipse"), true, MenuItemType.ELLIPSE, null, this.menuEventHandler, true);
        RadioMenuItem quadraticCurveItem = UIMenuBuilder.createRadioMenuItem(this.i18n.getString("UIMenuBuilder.menu.feature.curve.quadric.label", "Quadratic curve"), true, MenuItemType.QUADRATIC_CURVE, null, this.menuEventHandler, true);
        RadioMenuItem modifiedCurveItem = UIMenuBuilder.createRadioMenuItem(this.i18n.getString("UIMenuBuilder.menu.feature.curve.userdefined.label", "User defined curve"), true, MenuItemType.MODIFIABLE_CURVE, null, this.menuEventHandler, true);
        toggleGroup.getToggles().addAll((Object[])new Toggle[]{lineItem, circleItem, ellipseItem, quadraticCurveItem, modifiedCurveItem});
        parentMenu.getItems().addAll((Object[])new MenuItem[]{lineItem, circleItem, ellipseItem, quadraticCurveItem, new SeparatorMenuItem(), modifiedCurveItem});
    }

    private void createSurfaceFeatureMenu(Menu parentMenu, ToggleGroup toggleGroup) {
        RadioMenuItem planeItem = UIMenuBuilder.createRadioMenuItem(this.i18n.getString("UIMenuBuilder.menu.feature.surface.plane.label", "Plane"), true, MenuItemType.PLANE, null, this.menuEventHandler, true);
        RadioMenuItem sphereItem = UIMenuBuilder.createRadioMenuItem(this.i18n.getString("UIMenuBuilder.menu.feature.surface.sphere.label", "Sphere"), true, MenuItemType.SPHERE, null, this.menuEventHandler, true);
        RadioMenuItem ellipsoidItem = UIMenuBuilder.createRadioMenuItem(this.i18n.getString("UIMenuBuilder.menu.feature.surface.ellipsoid.label", "Ellipsoid"), true, MenuItemType.ELLIPSOID, null, this.menuEventHandler, true);
        RadioMenuItem spatialLineItem = UIMenuBuilder.createRadioMenuItem(this.i18n.getString("UIMenuBuilder.menu.feature.surface.line.label", "Spatial line"), true, MenuItemType.SPATIAL_LINE, null, this.menuEventHandler, true);
        RadioMenuItem spatialCircleItem = UIMenuBuilder.createRadioMenuItem(this.i18n.getString("UIMenuBuilder.menu.feature.surface.circle.label", "Spatial circle"), true, MenuItemType.SPATIAL_CIRCLE, null, this.menuEventHandler, true);
        RadioMenuItem spatialEllipseItem = UIMenuBuilder.createRadioMenuItem(this.i18n.getString("UIMenuBuilder.menu.feature.surface.ellipse.label", "Spatial ellipse"), true, MenuItemType.SPATIAL_ELLIPSE, null, this.menuEventHandler, true);
        RadioMenuItem cicularConeItem = UIMenuBuilder.createRadioMenuItem(this.i18n.getString("UIMenuBuilder.menu.feature.surface.cone.circular.label", "Circular cone"), true, MenuItemType.CIRCULAR_CONE, null, this.menuEventHandler, true);
        RadioMenuItem coneItem = UIMenuBuilder.createRadioMenuItem(this.i18n.getString("UIMenuBuilder.menu.feature.surface.cone.elliptic.label", "Cone"), true, MenuItemType.CONE, null, this.menuEventHandler, true);
        RadioMenuItem circularParaboloidItem = UIMenuBuilder.createRadioMenuItem(this.i18n.getString("UIMenuBuilder.menu.feature.surface.paraboloid.circular.label", "Circular paraboloid"), true, MenuItemType.CIRCULAR_PARABOLOID, null, this.menuEventHandler, true);
        RadioMenuItem paraboloidItem = UIMenuBuilder.createRadioMenuItem(this.i18n.getString("UIMenuBuilder.menu.feature.surface.paraboloid.elliptic.label", "Paraboloid"), true, MenuItemType.PARABOLOID, null, this.menuEventHandler, true);
        RadioMenuItem cicularCylinderItem = UIMenuBuilder.createRadioMenuItem(this.i18n.getString("UIMenuBuilder.menu.feature.surface.cylinder.circular.label", "Circular cylinder"), true, MenuItemType.CIRCULAR_CYLINDER, null, this.menuEventHandler, true);
        RadioMenuItem cylinderItem = UIMenuBuilder.createRadioMenuItem(this.i18n.getString("UIMenuBuilder.menu.feature.surface.cylinder.elliptic.label", "Cylinder"), true, MenuItemType.CYLINDER, null, this.menuEventHandler, true);
        RadioMenuItem torusItem = UIMenuBuilder.createRadioMenuItem(this.i18n.getString("UIMenuBuilder.menu.feature.surface.torus.label", "Torus"), true, MenuItemType.TORUS, null, this.menuEventHandler, true);
        RadioMenuItem quadraticSurfaceItem = UIMenuBuilder.createRadioMenuItem(this.i18n.getString("UIMenuBuilder.menu.feature.surface.quadric.label", "Quadratic surface"), true, MenuItemType.QUADRATIC_SURFACE, null, this.menuEventHandler, true);
        RadioMenuItem modifiedSurfaceItem = UIMenuBuilder.createRadioMenuItem(this.i18n.getString("UIMenuBuilder.menu.feature.surface.userdefined.label", "User defined surface"), true, MenuItemType.MODIFIABLE_SURFACE, null, this.menuEventHandler, true);
        toggleGroup.getToggles().addAll((Object[])new Toggle[]{planeItem, sphereItem, ellipsoidItem, spatialLineItem, spatialCircleItem, spatialEllipseItem, cicularCylinderItem, cylinderItem, cicularConeItem, coneItem, circularParaboloidItem, paraboloidItem, torusItem, quadraticSurfaceItem, modifiedSurfaceItem});
        parentMenu.getItems().addAll((Object[])new MenuItem[]{spatialLineItem, spatialCircleItem, spatialEllipseItem, new SeparatorMenuItem(), planeItem, sphereItem, ellipsoidItem, cicularCylinderItem, cylinderItem, cicularConeItem, coneItem, circularParaboloidItem, paraboloidItem, torusItem, quadraticSurfaceItem, new SeparatorMenuItem(), modifiedSurfaceItem});
    }

    private void createReportMenu(Menu parentMenu) {
        MenuItem matlabItem = UIMenuBuilder.createMenuItem(this.i18n.getString("UIMenuBuilder.menu.report.matlab.label", "_Matlab file"), true, MenuItemType.EXPORT_MATLAB, new KeyCodeCombination(KeyCode.M, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}), this.menuEventHandler, true);
        parentMenu.getItems().add((Object)matlabItem);
        List<Path> templates = FTLReport.getTemplates();
        if (templates != null && !templates.isEmpty()) {
            for (Path templatePath : templates) {
                MenuItem templateFileItem = UIMenuBuilder.createMenuItem(templatePath.getFileName().toString(), false, MenuItemType.REPORT, templatePath, null, this.menuEventHandler, true);
                parentMenu.getItems().add((Object)templateFileItem);
            }
        }
    }

    private void createHelpMenu(Menu parentMenu) {
        MenuItem aboutItem = UIMenuBuilder.createMenuItem(this.i18n.getString("UIMenuBuilder.menu.help.about.label", "A_bout JUniForm"), true, MenuItemType.ABOUT, new KeyCodeCombination(KeyCode.B, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}), this.menuEventHandler, false);
        parentMenu.getItems().addAll((Object[])new MenuItem[]{aboutItem});
    }

    void setFeatureType(FeatureType featureType) {
        DisableStateType disableStateType = null;
        if (featureType == FeatureType.CURVE) {
            disableStateType = DisableStateType.CURVE_TYPE;
        } else if (featureType == FeatureType.SURFACE) {
            disableStateType = DisableStateType.SURFACE_TYPE;
        } else {
            return;
        }
        this.disableMenu(disableStateType);
        for (Toggle toggle : this.featureToggleGroup.getToggles()) {
            toggle.setSelected(false);
        }
    }

    void disableMenu(DisableStateType disableStateType) {
        ObservableList menus = this.menuBar.getMenus();
        for (Menu menu : menus) {
            this.disableMenu(menu, disableStateType);
        }
    }

    private void disableMenu(Menu menu, DisableStateType disableStateType) {
        ObservableList items = menu.getItems();
        block7: for (MenuItem item : items) {
            if (item instanceof Menu) {
                this.disableMenu((Menu)item, disableStateType);
                continue;
            }
            if (item.getUserData() == null || !(item.getUserData() instanceof MenuItemType)) continue;
            MenuItemType itemType = (MenuItemType)((Object)item.getUserData());
            switch (itemType) {
                case FEATURE_PROPERTIES: 
                case PARAMETER_PROPERTIES: 
                case RESTRICTION_PROPERTIES: 
                case POSTPROCESSING_PROPERTIES: {
                    if (disableStateType != DisableStateType.FEATURE) break;
                    item.setDisable(false);
                    break;
                }
                case TEST_STATISTIC: 
                case LEAST_SQUARES: 
                case QUANTILES: 
                case VARIANCE_COMPONENT_ESTIMATION: {
                    item.setDisable(disableStateType == DisableStateType.CURVE_TYPE || disableStateType == DisableStateType.SURFACE_TYPE);
                    break;
                }
                case LINE: 
                case CIRCLE: 
                case ELLIPSE: 
                case QUADRATIC_CURVE: 
                case MODIFIABLE_CURVE: {
                    if (disableStateType != DisableStateType.CURVE_TYPE && disableStateType != DisableStateType.SURFACE_TYPE) continue block7;
                    item.setDisable(disableStateType != DisableStateType.CURVE_TYPE);
                    break;
                }
                case PLANE: 
                case SPHERE: 
                case ELLIPSOID: 
                case CIRCULAR_CYLINDER: 
                case CYLINDER: 
                case CIRCULAR_CONE: 
                case CONE: 
                case CIRCULAR_PARABOLOID: 
                case PARABOLOID: 
                case TORUS: 
                case SPATIAL_CIRCLE: 
                case SPATIAL_ELLIPSE: 
                case SPATIAL_LINE: 
                case QUADRATIC_SURFACE: 
                case MODIFIABLE_SURFACE: {
                    if (disableStateType != DisableStateType.CURVE_TYPE && disableStateType != DisableStateType.SURFACE_TYPE) continue block7;
                    item.setDisable(disableStateType != DisableStateType.SURFACE_TYPE);
                    break;
                }
                case EXPORT_MATLAB: 
                case REPORT: {
                    this.setReportMenuDisable(true);
                    break;
                }
            }
        }
    }

    public ToggleGroup getToggleGroup() {
        return this.featureToggleGroup;
    }

    private static Menu createMenu(String label, boolean mnemonicParsing) {
        Menu menu = new Menu(label);
        menu.setMnemonicParsing(mnemonicParsing);
        return menu;
    }

    private static MenuItem createMenuItem(MenuItem menuItem, boolean mnemonicParsing, Object userDate, KeyCodeCombination keyCodeCombination, MenuEventHandler menuEventHandler, boolean disable) {
        menuItem.setMnemonicParsing(mnemonicParsing);
        if (keyCodeCombination != null) {
            menuItem.setAccelerator((KeyCombination)keyCodeCombination);
        }
        menuItem.setOnAction((EventHandler)menuEventHandler);
        menuItem.setDisable(disable);
        menuItem.setUserData(userDate);
        return menuItem;
    }

    private static MenuItem createMenuItem(String label, boolean mnemonicParsing, MenuItemType menuItemType, KeyCodeCombination keyCodeCombination, MenuEventHandler menuEventHandler, boolean disable) {
        MenuItem menuItem = UIMenuBuilder.createMenuItem(new MenuItem(label), mnemonicParsing, (Object)menuItemType, keyCodeCombination, menuEventHandler, disable);
        return menuItem;
    }

    private static MenuItem createMenuItem(String label, boolean mnemonicParsing, GeometricPrimitive geometry, KeyCodeCombination keyCodeCombination, MenuEventHandler menuEventHandler, boolean disable) {
        MenuItem menuItem = UIMenuBuilder.createMenuItem(new MenuItem(label), mnemonicParsing, (Object)geometry, keyCodeCombination, menuEventHandler, disable);
        return menuItem;
    }

    private static RadioMenuItem createRadioMenuItem(String label, boolean mnemonicParsing, MenuItemType menuItemType, KeyCodeCombination keyCodeCombination, MenuEventHandler menuEventHandler, boolean disable) {
        RadioMenuItem menuItem = (RadioMenuItem)UIMenuBuilder.createMenuItem((MenuItem)new RadioMenuItem(label), mnemonicParsing, (Object)menuItemType, keyCodeCombination, menuEventHandler, disable);
        return menuItem;
    }

    private static MenuItem createMenuItem(String label, boolean mnemonicParsing, MenuItemType menuItemType, Path path, KeyCodeCombination keyCodeCombination, MenuEventHandler menuEventHandler, boolean disable) {
        PathMenuItem menuItem = (PathMenuItem)UIMenuBuilder.createMenuItem(new PathMenuItem(label), mnemonicParsing, (Object)menuItemType, keyCodeCombination, menuEventHandler, disable);
        menuItem.setPath(path);
        return menuItem;
    }

    private void addGeometricPrimitiveItem(GeometricPrimitive geometry) {
        MenuItem geometryItem = UIMenuBuilder.createMenuItem(geometry.getName(), true, geometry, null, this.menuEventHandler, false);
        geometryItem.textProperty().bind(geometry.nameProperty());
        this.initialGuessMenu.getItems().add((Object)geometryItem);
        this.initialGuessMenu.setDisable(false);
    }

    private void removeGeometricPrimitiveItem(GeometricPrimitive geometry) {
        MenuItem geometryItem = null;
        for (MenuItem item : this.initialGuessMenu.getItems()) {
            if (item.getUserData() != geometry) continue;
            geometryItem = item;
            break;
        }
        if (geometryItem != null) {
            geometryItem.textProperty().unbind();
            this.initialGuessMenu.getItems().remove(geometryItem);
        }
        this.initialGuessMenu.setDisable(this.initialGuessMenu.getItems().isEmpty());
    }

    @Override
    public void featureChanged(FeatureEvent evt) {
        if (evt.getEventType() == FeatureEvent.FeatureEventType.FEATURE_ADDED) {
            Iterator<GeometricPrimitive> iterator = evt.getSource().getGeometricPrimitives().iterator();
            while (iterator.hasNext()) {
                GeometricPrimitive geometry = iterator.next();
                this.addGeometricPrimitiveItem(geometry);
            }
            evt.getSource().getGeometricPrimitives().addListener(this.geometricPrimitiveListChangeListener);
        } else if (evt.getEventType() == FeatureEvent.FeatureEventType.FEATURE_REMOVED) {
            Iterator<GeometricPrimitive> iterator = evt.getSource().getGeometricPrimitives().iterator();
            while (iterator.hasNext()) {
                GeometricPrimitive geometry = iterator.next();
                this.removeGeometricPrimitiveItem(geometry);
            }
            evt.getSource().getGeometricPrimitives().removeListener(this.geometricPrimitiveListChangeListener);
        }
    }

    void importFile(FeaturePointFileReader fileReader, FileChooser.ExtensionFilter[] extensionFilters, String title) {
        List<File> selectedFiles = DefaultFileChooser.showOpenMultipleDialog((Window)JUniForm.getStage(), title, null, extensionFilters);
        if (selectedFiles == null || selectedFiles.isEmpty()) {
            return;
        }
        this.importFile(fileReader, selectedFiles);
    }

    void importFile(FeaturePointFileReader fileReader, List<File> selectedFiles) {
        if (selectedFiles == null || selectedFiles.isEmpty()) {
            return;
        }
        ObservableUniqueList<FeaturePoint> points = null;
        ReadFileProgressDialog<ObservableUniqueList<FeaturePoint>> dialog = new ReadFileProgressDialog<ObservableUniqueList<FeaturePoint>>();
        Optional<ObservableUniqueList<FeaturePoint>> optional = dialog.showAndWait(fileReader, selectedFiles);
        if (optional.isPresent()) {
            points = optional.get();
        }
        if (points != null) {
            FeatureType prevFeatureType = UITreeBuilder.getInstance().getFeatureAdjustment().getFeature() != null ? UITreeBuilder.getInstance().getFeatureAdjustment().getFeature().getFeatureType() : null;
            Toggle toggle = this.featureToggleGroup.getSelectedToggle();
            this.fireFeatureTypeChanged(fileReader.getFeatureType());
            UIPointTableBuilder.getInstance().getTableModel(UIPointTableBuilder.getInstance().getTable()).setAll(points);
            if (prevFeatureType == fileReader.getFeatureType() && toggle != null && toggle instanceof MenuItem) {
                toggle.setSelected(true);
                this.menuEventHandler.handleAction((MenuItem)toggle);
            }
            UITreeBuilder.getInstance().handleTreeSelections();
        }
    }

    void importInitialGuess(GeometricPrimitive geometry) {
        File selectedFile = DefaultFileChooser.showOpenDialog((Window)JUniForm.getStage(), this.i18n.getString("UIMenuBuilder.filechooser.import.initialguess.title", "Import initial guess from flat files"), null, InitialGuessFileReader.getExtensionFilters());
        if (selectedFile == null) {
            return;
        }
        ReadFileProgressDialog<GeometricPrimitive> dialog = new ReadFileProgressDialog<GeometricPrimitive>();
        InitialGuessFileReader fileReader = new InitialGuessFileReader(geometry);
        Optional<GeometricPrimitive> optional = dialog.showAndWait(fileReader, List.of(selectedFile));
        if (optional.isPresent()) {
            optional.get();
        }
    }

    void createMatlabFile() {
        try {
            if (UITreeBuilder.getInstance().getFeatureAdjustment().getFeature() == null) {
                return;
            }
            FileChooser.ExtensionFilter extensionFilter = new FileChooser.ExtensionFilter(this.i18n.getString("UIMenuBuilder.report.extension.mat", "Binary Matlab file"), new String[]{"*.mat", "*.MAT"});
            String fileNameSuggestion = "feature.mat";
            MatlabFeatureAdjustmentResultWriter matWriter = new MatlabFeatureAdjustmentResultWriter();
            File binFile = DefaultFileChooser.showSaveDialog((Window)JUniForm.getStage(), this.i18n.getString("UIMenuBuilder.filechooser.export.matlab.title", "Save Matlab file"), fileNameSuggestion, extensionFilter);
            if (binFile != null && matWriter != null) {
                matWriter.toFile(binFile, UITreeBuilder.getInstance().getFeatureAdjustment());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            OptionDialog.showThrowableDialog(this.i18n.getString("UIMenuBuilder.message.error.export.matlab.exception.title", "I/O Error"), this.i18n.getString("UIMenuBuilder.message.error.export.matlab.exception.header", "Error, could not binary Matlab file."), this.i18n.getString("UIMenuBuilder.message.error.export.matlab.exception.message", "An exception has occurred during file creation."), e);
        }
    }

    void createReport(Path template) {
        try {
            if (UITreeBuilder.getInstance().getFeatureAdjustment().getFeature() == null) {
                return;
            }
            Pattern pattern = Pattern.compile(".*?\\.(\\.)?(\\w+)\\.ftlh$", 2);
            Matcher matcher = pattern.matcher(template.getFileName().toString().toLowerCase());
            String extension = "html";
            boolean openFileInSystemApplication = true;
            FileChooser.ExtensionFilter extensionFilter = new FileChooser.ExtensionFilter(this.i18n.getString("UIMenuBuilder.report.extension.html", "Hypertext Markup Language"), new String[]{"*.html", "*.htm", "*.HTML", "*.HTM"});
            if (matcher.find() && matcher.groupCount() == 2) {
                openFileInSystemApplication = matcher.group(1) == null;
                extension = matcher.group(2);
                extensionFilter = new FileChooser.ExtensionFilter(String.format(Locale.ENGLISH, this.i18n.getString("UIMenuBuilder.report.extension.template", "%s-File"), extension), new String[]{"*." + extension});
            }
            String fileNameSuggestion = "report." + extension;
            FTLReport ftl = new FTLReport(UITreeBuilder.getInstance().getFeatureAdjustment());
            File reportFile = DefaultFileChooser.showSaveDialog((Window)JUniForm.getStage(), this.i18n.getString("UIMenuBuilder.filechooser.export.report.title", "Save adjustment report"), fileNameSuggestion, extensionFilter);
            if (reportFile != null && ftl != null) {
                ftl.setTemplate(template.getFileName().toString());
                ftl.toFilePath(reportFile.toPath(), openFileInSystemApplication);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            OptionDialog.showThrowableDialog(this.i18n.getString("UIMenuBuilder.message.error.export.report.exception.title", "I/O Error"), this.i18n.getString("UIMenuBuilder.message.error.export.report.exception.header", "Error, could not create adjustment report."), this.i18n.getString("UIMenuBuilder.message.error.export.report.exception.message", "An exception has occurred during report creation."), e);
        }
    }

    private void fireFeatureTypeChanged(FeatureType featureType) {
        this.setFeatureType(featureType);
        UIPointTableBuilder.getInstance().setFeatureType(featureType);
        UITreeBuilder.getInstance().setFeatureType(featureType);
    }

    public void setReportMenuDisable(boolean disable) {
        for (MenuItem item : this.reportMenu.getItems()) {
            item.setDisable(disable);
        }
    }

    static enum DisableStateType {
        CURVE_TYPE,
        SURFACE_TYPE,
        FEATURE;

    }

    private class GeometricPrimitiveListChangeListener
    implements ListChangeListener<GeometricPrimitive> {
        private GeometricPrimitiveListChangeListener() {
        }

        public void onChanged(ListChangeListener.Change<? extends GeometricPrimitive> change) {
            while (change.next()) {
                if (change.wasAdded()) {
                    for (GeometricPrimitive geometry : change.getAddedSubList()) {
                        UIMenuBuilder.this.addGeometricPrimitiveItem(geometry);
                    }
                    continue;
                }
                if (!change.wasRemoved()) continue;
                for (GeometricPrimitive geometry : change.getRemoved()) {
                    UIMenuBuilder.this.removeGeometricPrimitiveItem(geometry);
                }
            }
        }
    }
}

