/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.juniform.ui.dialog;

import java.util.Collections;
import java.util.Optional;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.control.ListView;
import javafx.scene.control.TextField;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.util.Callback;
import javafx.util.StringConverter;
import org.applied_geodesy.adjustment.geometry.parameter.UnknownParameter;
import org.applied_geodesy.adjustment.geometry.restriction.VectorAngleRestriction;
import org.applied_geodesy.juniform.ui.dialog.DialogUtil;
import org.applied_geodesy.juniform.ui.dialog.UnknownParameterDialog;
import org.applied_geodesy.juniform.ui.i18n.I18N;
import org.applied_geodesy.ui.tex.LaTexLabel;

public class VectorAngleRestrictionDialog {
    private static I18N i18N = I18N.getInstance();
    private static VectorAngleRestrictionDialog restrictionTypeDialog = new VectorAngleRestrictionDialog();
    private Dialog<VectorAngleRestriction> dialog = null;
    private LaTexLabel latexLabel;
    private ComboBox<UnknownParameter> regressorAComboBox;
    private ComboBox<UnknownParameter> regressorBComboBox;
    private ListView<UnknownParameter> regressorAListView;
    private ListView<UnknownParameter> regressorBListView;
    private Button addParameterAButtom;
    private Button removeParameterAButtom;
    private Button moveUpParameterAButtom;
    private Button moveDownParameterAButtom;
    private Button addParameterBButtom;
    private Button removeParameterBButtom;
    private Button moveUpParameterBButtom;
    private Button moveDownParameterBButtom;
    private ComboBox<UnknownParameter> regressandComboBox;
    private TextField descriptionTextField;
    private Window window;
    private VectorAngleRestriction restriction;

    private VectorAngleRestrictionDialog() {
    }

    public static void setOwner(Window owner) {
        VectorAngleRestrictionDialog.restrictionTypeDialog.window = owner;
    }

    public static Optional<VectorAngleRestriction> showAndWait(ObservableList<UnknownParameter> unknownParameters, VectorAngleRestriction VectorAngleRestriction2) {
        restrictionTypeDialog.init();
        restrictionTypeDialog.setUnknownParameters(unknownParameters);
        restrictionTypeDialog.setRestriction(VectorAngleRestriction2);
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    VectorAngleRestrictionDialog.restrictionTypeDialog.dialog.getDialogPane().requestLayout();
                    Stage stage = (Stage)VectorAngleRestrictionDialog.restrictionTypeDialog.dialog.getDialogPane().getScene().getWindow();
                    stage.sizeToScene();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        return VectorAngleRestrictionDialog.restrictionTypeDialog.dialog.showAndWait();
    }

    private void setUnknownParameters(ObservableList<UnknownParameter> unknownParameters) {
        ObservableList unknownParameterList = FXCollections.observableArrayList(unknownParameters);
        this.regressorAComboBox.setItems(unknownParameterList);
        this.regressorBComboBox.setItems(unknownParameterList);
        this.regressandComboBox.setItems(unknownParameterList);
    }

    private void setRestriction(VectorAngleRestriction restriction) {
        this.moveUpParameterAButtom.setDisable(true);
        this.moveDownParameterAButtom.setDisable(true);
        this.moveUpParameterBButtom.setDisable(true);
        this.moveDownParameterBButtom.setDisable(true);
        if (this.restriction != null) {
            this.descriptionTextField.textProperty().unbindBidirectional(this.restriction.descriptionProperty());
            this.regressandComboBox.valueProperty().unbindBidirectional(this.restriction.regressandProperty());
            this.regressorAListView.setItems(FXCollections.emptyObservableList());
            this.regressorBListView.setItems(FXCollections.emptyObservableList());
        }
        this.restriction = restriction;
        this.descriptionTextField.textProperty().bindBidirectional(this.restriction.descriptionProperty());
        this.regressandComboBox.valueProperty().bindBidirectional(this.restriction.regressandProperty());
        this.regressorAListView.setItems(this.restriction.getRegressorsA());
        this.regressorBListView.setItems(this.restriction.getRegressorsB());
        this.latexLabel.setTex(this.restriction.toLaTex());
        this.regressorAListView.setDisable(restriction.isIndispensable());
        this.regressorBListView.setDisable(restriction.isIndispensable());
        this.regressorAComboBox.setDisable(restriction.isIndispensable());
        this.regressorBComboBox.setDisable(restriction.isIndispensable());
        this.regressandComboBox.setDisable(restriction.isIndispensable());
        this.addParameterAButtom.setDisable(restriction.isIndispensable());
        this.removeParameterAButtom.setDisable(restriction.isIndispensable());
        this.moveUpParameterAButtom.setDisable(restriction.isIndispensable());
        this.moveDownParameterAButtom.setDisable(restriction.isIndispensable());
        this.addParameterBButtom.setDisable(restriction.isIndispensable());
        this.removeParameterBButtom.setDisable(restriction.isIndispensable());
        this.moveUpParameterBButtom.setDisable(restriction.isIndispensable());
        this.moveDownParameterBButtom.setDisable(restriction.isIndispensable());
        if (!restriction.isIndispensable()) {
            UnknownParameter regressand = this.restriction.getRegressand();
            if (regressand == null) {
                this.regressandComboBox.getSelectionModel().clearAndSelect(0);
            }
            this.regressorAComboBox.getSelectionModel().clearAndSelect(0);
            this.regressorBComboBox.getSelectionModel().clearAndSelect(0);
        } else {
            this.regressorAComboBox.getSelectionModel().clearSelection();
            this.regressorBComboBox.getSelectionModel().clearSelection();
        }
    }

    private void init() {
        if (this.dialog != null) {
            return;
        }
        this.dialog = new Dialog();
        this.dialog.setTitle(i18N.getString("VectorAngleRestrictionDialog.title", "Angle restriction"));
        this.dialog.setHeaderText(i18N.getString("VectorAngleRestrictionDialog.header", "Angle between two vectors"));
        this.dialog.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{ButtonType.OK});
        this.dialog.initModality(Modality.APPLICATION_MODAL);
        this.dialog.initOwner(this.window);
        this.dialog.getDialogPane().setContent(this.createPane());
        this.dialog.setResizable(true);
        this.dialog.setResultConverter((Callback)new Callback<ButtonType, VectorAngleRestriction>(){

            public VectorAngleRestriction call(ButtonType buttonType) {
                if (buttonType == ButtonType.OK) {
                    return VectorAngleRestrictionDialog.this.restriction;
                }
                return null;
            }
        });
    }

    private Node createPane() {
        GridPane gridPane = DialogUtil.createGridPane();
        Label equationLabel = new Label(i18N.getString("VectorAngleRestrictionDialog.equation.label", "Equation:"));
        Label descriptionLabel = new Label(i18N.getString("VectorAngleRestrictionDialog.description.label", "Description:"));
        Label regressandLabel = new Label(i18N.getString("VectorAngleRestrictionDialog.regressand.label", "Regressand c:"));
        Label regressorALabel = new Label(i18N.getString("VectorAngleRestrictionDialog.regressor.a.label", "Regressor a:"));
        Label regressorBLabel = new Label(i18N.getString("VectorAngleRestrictionDialog.regressor.b.label", "Regressor b:"));
        regressorALabel.setPrefSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        regressorALabel.setMaxWidth(Double.MAX_VALUE);
        regressorBLabel.setPrefSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        regressorBLabel.setMaxWidth(Double.MAX_VALUE);
        this.descriptionTextField = DialogUtil.createTextField(i18N.getString("VectorAngleRestrictionDialog.description.tooltip", "Description of parameter restriction"), i18N.getString("VectorAngleRestrictionDialog.description.prompt", "Restriction description"));
        this.regressorAComboBox = DialogUtil.createUnknownParameterComboBox(UnknownParameterDialog.createUnknownParameterCellFactory(), i18N.getString("VectorAngleRestrictionDialog.regressor.a.tooltip", "Select regressor a"));
        this.regressorBComboBox = DialogUtil.createUnknownParameterComboBox(UnknownParameterDialog.createUnknownParameterCellFactory(), i18N.getString("VectorAngleRestrictionDialog.regressor.b.tooltip", "Select regressor b"));
        this.regressandComboBox = DialogUtil.createUnknownParameterComboBox(UnknownParameterDialog.createUnknownParameterCellFactory(), i18N.getString("VectorAngleRestrictionDialog.regressand.tooltip", "Select regressand c"));
        this.latexLabel = new LaTexLabel();
        this.latexLabel.setPrefSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        this.latexLabel.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        this.regressorAListView = DialogUtil.createParameterListView(UnknownParameterDialog.createUnknownParameterCellFactory());
        this.regressorBListView = DialogUtil.createParameterListView(UnknownParameterDialog.createUnknownParameterCellFactory());
        RegressorEventHandler regressorEventHandler = new RegressorEventHandler();
        this.addParameterAButtom = DialogUtil.createButton(i18N.getString("VectorAngleRestrictionDialog.regressor.a.add.label", "+"), i18N.getString("VectorAngleRestrictionDialog.regressor.a.add.tooltip", "Add parameter to regressor list"));
        this.removeParameterAButtom = DialogUtil.createButton(i18N.getString("VectorAngleRestrictionDialog.regressor.a.remove.label", "-"), i18N.getString("VectorAngleRestrictionDialog.regressor.a.remove.tooltip", "Remove regressor"));
        this.moveUpParameterAButtom = DialogUtil.createButton(i18N.getString("VectorAngleRestrictionDialog.regressor.a.up.label", "\u25b2"), i18N.getString("VectorAngleRestrictionDialog.regressor.a.up.tooltip", "Move up (change order)"));
        this.moveDownParameterAButtom = DialogUtil.createButton(i18N.getString("VectorAngleRestrictionDialog.regressor.a.down.label", "\u25bc"), i18N.getString("VectorAngleRestrictionDialog.regressor.a.down.tooltip", "Move down (change order)"));
        this.addParameterAButtom.setOnAction((EventHandler)regressorEventHandler);
        this.removeParameterAButtom.setOnAction((EventHandler)regressorEventHandler);
        this.moveUpParameterAButtom.setOnAction((EventHandler)regressorEventHandler);
        this.moveDownParameterAButtom.setOnAction((EventHandler)regressorEventHandler);
        HBox buttonBoxA = new HBox(5.0);
        HBox.setHgrow((Node)this.addParameterAButtom, (Priority)Priority.NEVER);
        HBox.setHgrow((Node)this.removeParameterAButtom, (Priority)Priority.NEVER);
        HBox.setHgrow((Node)this.moveUpParameterAButtom, (Priority)Priority.NEVER);
        HBox.setHgrow((Node)this.moveDownParameterAButtom, (Priority)Priority.NEVER);
        buttonBoxA.getChildren().addAll((Object[])new Node[]{this.addParameterAButtom, this.removeParameterAButtom, this.moveUpParameterAButtom, this.moveDownParameterAButtom});
        this.addParameterBButtom = DialogUtil.createButton(i18N.getString("VectorAngleRestrictionDialog.regressor.b.add.label", "+"), i18N.getString("VectorAngleRestrictionDialog.regressor.b.add.tooltip", "Add parameter to regressor list"));
        this.removeParameterBButtom = DialogUtil.createButton(i18N.getString("VectorAngleRestrictionDialog.regressor.b.remove.label", "-"), i18N.getString("VectorAngleRestrictionDialog.regressor.b.remove.tooltip", "Remove regressor"));
        this.moveUpParameterBButtom = DialogUtil.createButton(i18N.getString("VectorAngleRestrictionDialog.regressor.b.up.label", "\u25b2"), i18N.getString("VectorAngleRestrictionDialog.regressor.b.up.tooltip", "Move up (change order)"));
        this.moveDownParameterBButtom = DialogUtil.createButton(i18N.getString("VectorAngleRestrictionDialog.regressor.b.down.label", "\u25bc"), i18N.getString("VectorAngleRestrictionDialog.regressor.b.down.tooltip", "Move down (change order)"));
        this.addParameterBButtom.setOnAction((EventHandler)regressorEventHandler);
        this.removeParameterBButtom.setOnAction((EventHandler)regressorEventHandler);
        this.moveUpParameterBButtom.setOnAction((EventHandler)regressorEventHandler);
        this.moveDownParameterBButtom.setOnAction((EventHandler)regressorEventHandler);
        HBox buttonBoxB = new HBox(5.0);
        HBox.setHgrow((Node)this.addParameterBButtom, (Priority)Priority.NEVER);
        HBox.setHgrow((Node)this.removeParameterBButtom, (Priority)Priority.NEVER);
        HBox.setHgrow((Node)this.moveUpParameterBButtom, (Priority)Priority.NEVER);
        HBox.setHgrow((Node)this.moveDownParameterBButtom, (Priority)Priority.NEVER);
        buttonBoxB.getChildren().addAll((Object[])new Node[]{this.addParameterBButtom, this.removeParameterBButtom, this.moveUpParameterBButtom, this.moveDownParameterBButtom});
        this.regressorAListView.getSelectionModel().selectedIndexProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                VectorAngleRestrictionDialog.this.moveUpParameterAButtom.setDisable(newValue == null || newValue.intValue() == 0);
                VectorAngleRestrictionDialog.this.moveDownParameterAButtom.setDisable(newValue == null || newValue.intValue() == VectorAngleRestrictionDialog.this.regressorAListView.getItems().size() - 1);
            }
        });
        this.regressorBListView.getSelectionModel().selectedIndexProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                VectorAngleRestrictionDialog.this.moveUpParameterBButtom.setDisable(newValue == null || newValue.intValue() == 0);
                VectorAngleRestrictionDialog.this.moveDownParameterBButtom.setDisable(newValue == null || newValue.intValue() == VectorAngleRestrictionDialog.this.regressorBListView.getItems().size() - 1);
            }
        });
        equationLabel.setLabelFor((Node)this.latexLabel);
        descriptionLabel.setLabelFor((Node)this.descriptionTextField);
        regressandLabel.setLabelFor(this.regressandComboBox);
        regressorALabel.setLabelFor(this.regressorAComboBox);
        regressorBLabel.setLabelFor(this.regressorBComboBox);
        regressorALabel.setAlignment(Pos.TOP_CENTER);
        regressorBLabel.setAlignment(Pos.TOP_CENTER);
        HBox regressorsBox = new HBox(10.0);
        VBox regressorABox = new VBox(5.0);
        VBox regressorBBox = new VBox(5.0);
        regressorsBox.setPrefHeight(200.0);
        HBox.setHgrow((Node)regressorABox, (Priority)Priority.ALWAYS);
        HBox.setHgrow((Node)regressorBBox, (Priority)Priority.ALWAYS);
        VBox.setVgrow((Node)regressorALabel, (Priority)Priority.NEVER);
        VBox.setVgrow((Node)regressorBLabel, (Priority)Priority.NEVER);
        VBox.setVgrow(this.regressorAComboBox, (Priority)Priority.NEVER);
        VBox.setVgrow(this.regressorBComboBox, (Priority)Priority.NEVER);
        VBox.setVgrow(this.regressorAListView, (Priority)Priority.ALWAYS);
        VBox.setVgrow(this.regressorBListView, (Priority)Priority.ALWAYS);
        regressorABox.getChildren().addAll((Object[])new Node[]{regressorALabel, this.regressorAComboBox, this.regressorAListView, buttonBoxA});
        regressorBBox.getChildren().addAll((Object[])new Node[]{regressorBLabel, this.regressorBComboBox, this.regressorBListView, buttonBoxB});
        regressorsBox.getChildren().addAll((Object[])new Node[]{regressorABox, regressorBBox});
        GridPane.setHgrow((Node)equationLabel, (Priority)Priority.NEVER);
        GridPane.setHgrow((Node)descriptionLabel, (Priority)Priority.NEVER);
        GridPane.setHgrow((Node)regressandLabel, (Priority)Priority.NEVER);
        GridPane.setHgrow((Node)this.latexLabel, (Priority)Priority.ALWAYS);
        GridPane.setHgrow((Node)this.descriptionTextField, (Priority)Priority.ALWAYS);
        GridPane.setHgrow(this.regressandComboBox, (Priority)Priority.ALWAYS);
        GridPane.setHgrow((Node)regressorsBox, (Priority)Priority.ALWAYS);
        GridPane.setVgrow((Node)regressorsBox, (Priority)Priority.ALWAYS);
        Insets insetsLeft = new Insets(5.0, 7.0, 5.0, 5.0);
        Insets insetsRight = new Insets(5.0, 0.0, 5.0, 7.0);
        GridPane.setMargin((Node)equationLabel, (Insets)insetsLeft);
        GridPane.setMargin((Node)regressandLabel, (Insets)insetsLeft);
        GridPane.setMargin((Node)descriptionLabel, (Insets)insetsLeft);
        GridPane.setMargin((Node)this.latexLabel, (Insets)insetsRight);
        GridPane.setMargin(this.regressandComboBox, (Insets)insetsRight);
        GridPane.setMargin((Node)this.descriptionTextField, (Insets)insetsRight);
        GridPane.setMargin((Node)regressorsBox, (Insets)new Insets(10.0, 5.0, 5.0, 5.0));
        int row = 0;
        gridPane.add((Node)equationLabel, 0, row);
        gridPane.add((Node)this.latexLabel, 1, row++);
        gridPane.add((Node)descriptionLabel, 0, row);
        gridPane.add((Node)this.descriptionTextField, 1, row++);
        gridPane.add((Node)regressandLabel, 0, row);
        gridPane.add(this.regressandComboBox, 1, row++);
        gridPane.add((Node)regressorsBox, 0, row++, 2, 1);
        return gridPane;
    }

    static StringConverter<Boolean> createArithmeticOperationTypeStringConverter() {
        return new StringConverter<Boolean>(){

            public String toString(Boolean type) {
                if (type == null) {
                    return null;
                }
                if (type != null && type == Boolean.TRUE) {
                    return i18N.getString("VectorAngleRestrictionDialog.arithmetic.type.addition", "Addition");
                }
                return i18N.getString("VectorAngleRestrictionDialog.arithmetic.type.subtraction", "Subtraction");
            }

            public Boolean fromString(String string) {
                return Boolean.valueOf(string);
            }
        };
    }

    private class RegressorEventHandler
    implements EventHandler<ActionEvent> {
        private RegressorEventHandler() {
        }

        public void handle(ActionEvent event) {
            int index;
            if (event.getSource() == VectorAngleRestrictionDialog.this.addParameterAButtom) {
                UnknownParameter parameter = (UnknownParameter)VectorAngleRestrictionDialog.this.regressorAComboBox.getValue();
                if (parameter != null) {
                    VectorAngleRestrictionDialog.this.regressorAListView.getItems().add((Object)parameter);
                }
            } else if (event.getSource() == VectorAngleRestrictionDialog.this.addParameterBButtom) {
                UnknownParameter parameter = (UnknownParameter)VectorAngleRestrictionDialog.this.regressorBComboBox.getValue();
                if (parameter != null) {
                    VectorAngleRestrictionDialog.this.regressorBListView.getItems().add((Object)parameter);
                }
            } else if (event.getSource() == VectorAngleRestrictionDialog.this.removeParameterAButtom) {
                UnknownParameter parameter = (UnknownParameter)VectorAngleRestrictionDialog.this.regressorAListView.getSelectionModel().getSelectedItem();
                if (parameter != null) {
                    VectorAngleRestrictionDialog.this.regressorAListView.getItems().remove((Object)parameter);
                }
            } else if (event.getSource() == VectorAngleRestrictionDialog.this.removeParameterBButtom) {
                UnknownParameter parameter = (UnknownParameter)VectorAngleRestrictionDialog.this.regressorBListView.getSelectionModel().getSelectedItem();
                if (parameter != null) {
                    VectorAngleRestrictionDialog.this.regressorBListView.getItems().remove((Object)parameter);
                }
            } else if (event.getSource() == VectorAngleRestrictionDialog.this.moveUpParameterAButtom) {
                int index2 = VectorAngleRestrictionDialog.this.regressorAListView.getSelectionModel().getSelectedIndex();
                if (index2 > 0) {
                    Collections.swap(VectorAngleRestrictionDialog.this.regressorAListView.getItems(), index2, index2 - 1);
                }
            } else if (event.getSource() == VectorAngleRestrictionDialog.this.moveDownParameterAButtom) {
                int index3 = VectorAngleRestrictionDialog.this.regressorAListView.getSelectionModel().getSelectedIndex();
                if (index3 < VectorAngleRestrictionDialog.this.regressorAListView.getItems().size() - 1) {
                    Collections.swap(VectorAngleRestrictionDialog.this.regressorAListView.getItems(), index3, index3 + 1);
                }
            } else if (event.getSource() == VectorAngleRestrictionDialog.this.moveUpParameterBButtom) {
                int index4 = VectorAngleRestrictionDialog.this.regressorBListView.getSelectionModel().getSelectedIndex();
                if (index4 > 0) {
                    Collections.swap(VectorAngleRestrictionDialog.this.regressorBListView.getItems(), index4, index4 - 1);
                }
            } else if (event.getSource() == VectorAngleRestrictionDialog.this.moveDownParameterBButtom && (index = VectorAngleRestrictionDialog.this.regressorBListView.getSelectionModel().getSelectedIndex()) < VectorAngleRestrictionDialog.this.regressorBListView.getItems().size() - 1) {
                Collections.swap(VectorAngleRestrictionDialog.this.regressorBListView.getItems(), index, index + 1);
            }
        }
    }
}

