/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.juniform.ui.dialog;

import java.util.Iterator;
import java.util.Optional;
import java.util.function.Predicate;
import javafx.application.Platform;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableStringValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.transformation.FilteredList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;
import javafx.scene.text.TextFlow;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.util.Callback;
import javafx.util.StringConverter;
import org.applied_geodesy.adjustment.geometry.Feature;
import org.applied_geodesy.adjustment.geometry.GeometricPrimitive;
import org.applied_geodesy.adjustment.geometry.parameter.ParameterType;
import org.applied_geodesy.adjustment.geometry.parameter.ProcessingType;
import org.applied_geodesy.adjustment.geometry.parameter.UnknownParameter;
import org.applied_geodesy.adjustment.geometry.restriction.Restriction;
import org.applied_geodesy.juniform.ui.dialog.DialogUtil;
import org.applied_geodesy.juniform.ui.dialog.UnknownParameterTypeDialog;
import org.applied_geodesy.juniform.ui.i18n.I18N;
import org.applied_geodesy.juniform.ui.tree.UITreeBuilder;
import org.applied_geodesy.ui.textfield.DoubleTextField;
import org.applied_geodesy.util.CellValueType;

public class UnknownParameterDialog {
    private static I18N i18N = I18N.getInstance();
    private static UnknownParameterDialog unknownParameterDialog = new UnknownParameterDialog();
    private Dialog<Void> dialog = null;
    private DoubleTextField initialGuessTextField;
    private TextField descriptionTextField;
    private TextField nameTextField;
    private Label parameterOwner;
    private ComboBox<ParameterType> parameterTypeComboBox;
    private ComboBox<ProcessingType> processingTypeComboBox;
    private FilteredList<ProcessingType> filteredProcessingTypeList;
    private ListView<UnknownParameter> parameterList;
    private Button addParameterButton;
    private Button removeParameterButton;
    private Button moveUpParameterButtom;
    private Button moveDownParameterButtom;
    private UnknownParameter unknownParameter;
    private CheckBox visibleCheckBox;
    private Window window;
    private Feature feature;
    private VisibleChangeListener visibleChangeListener = new VisibleChangeListener();

    private UnknownParameterDialog() {
    }

    public static void setOwner(Window owner) {
        UnknownParameterDialog.unknownParameterDialog.window = owner;
    }

    public static Optional<Void> showAndWait(Feature feature) {
        unknownParameterDialog.init();
        unknownParameterDialog.setFeature(feature);
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    UnknownParameterDialog.unknownParameterDialog.dialog.getDialogPane().requestLayout();
                    Stage stage = (Stage)UnknownParameterDialog.unknownParameterDialog.dialog.getDialogPane().getScene().getWindow();
                    stage.sizeToScene();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        return UnknownParameterDialog.unknownParameterDialog.dialog.showAndWait();
    }

    private void init() {
        if (this.dialog != null) {
            return;
        }
        this.dialog = new Dialog();
        this.dialog.setTitle(i18N.getString("UnknownParameterDialog.title", "Unknown parameter"));
        this.dialog.setHeaderText(i18N.getString("UnknownParameterDialog.header", "Unknown parameter properties"));
        this.dialog.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{ButtonType.OK});
        this.dialog.initModality(Modality.APPLICATION_MODAL);
        this.dialog.initOwner(this.window);
        this.dialog.getDialogPane().setContent(this.createPane());
        this.dialog.setResizable(true);
        this.dialog.setResultConverter((Callback)new Callback<ButtonType, Void>(){

            public Void call(ButtonType buttonType) {
                return null;
            }
        });
    }

    private void setUnknownParameter(UnknownParameter unknownParameter) {
        if (this.unknownParameter != null) {
            this.processingTypeComboBox.valueProperty().unbindBidirectional(this.unknownParameter.processingTypeProperty());
            this.parameterTypeComboBox.valueProperty().unbindBidirectional(this.unknownParameter.parameterTypeProperty());
            this.nameTextField.textProperty().unbindBidirectional(this.unknownParameter.nameProperty());
            this.descriptionTextField.textProperty().unbindBidirectional(this.unknownParameter.descriptionProperty());
            this.initialGuessTextField.numberProperty().unbindBidirectional(this.unknownParameter.value0Property());
            this.visibleCheckBox.selectedProperty().unbindBidirectional(this.unknownParameter.visibleProperty());
        }
        this.unknownParameter = unknownParameter;
        this.visibleCheckBox.selectedProperty().removeListener((ChangeListener)this.visibleChangeListener);
        if (unknownParameter == null) {
            this.processingTypeComboBox.setDisable(true);
            this.parameterTypeComboBox.setDisable(true);
            this.nameTextField.setDisable(true);
            this.descriptionTextField.setDisable(true);
            this.initialGuessTextField.setDisable(true);
            this.removeParameterButton.setDisable(true);
            this.parameterOwner.setText("");
            this.visibleCheckBox.setDisable(true);
            this.moveUpParameterButtom.setDisable(true);
            this.moveDownParameterButtom.setDisable(true);
        } else {
            final boolean indispensable = this.unknownParameter.isIndispensable();
            this.filteredProcessingTypeList.setPredicate((Predicate)new Predicate<ProcessingType>(){

                @Override
                public boolean test(ProcessingType processingType) {
                    return processingType != ProcessingType.POSTPROCESSING || !indispensable;
                }
            });
            this.visibleCheckBox.setVisible(true);
            this.processingTypeComboBox.setDisable(false);
            this.parameterTypeComboBox.setDisable(indispensable);
            this.nameTextField.setDisable(false);
            this.descriptionTextField.setDisable(false);
            this.initialGuessTextField.setDisable(false);
            this.moveUpParameterButtom.setDisable(this.parameterList.getItems().isEmpty() || !this.parameterList.getItems().isEmpty() && this.parameterList.getSelectionModel().getSelectedIndex() == 0);
            this.moveDownParameterButtom.setDisable(this.parameterList.getItems().isEmpty() || !this.parameterList.getItems().isEmpty() && this.parameterList.getSelectionModel().getSelectedIndex() == this.parameterList.getItems().size() - 1);
            this.processingTypeComboBox.valueProperty().bindBidirectional(this.unknownParameter.processingTypeProperty());
            this.parameterTypeComboBox.valueProperty().bindBidirectional(this.unknownParameter.parameterTypeProperty());
            this.nameTextField.textProperty().bindBidirectional(this.unknownParameter.nameProperty());
            this.visibleCheckBox.selectedProperty().bindBidirectional(this.unknownParameter.visibleProperty());
            this.descriptionTextField.textProperty().bindBidirectional(this.unknownParameter.descriptionProperty());
            this.initialGuessTextField.numberProperty().bindBidirectional(this.unknownParameter.value0Property());
            this.initialGuessTextField.setCellValueType(UnknownParameterDialog.getCorrespondingCellValueType(this.unknownParameter.getParameterType()));
            this.removeParameterButton.setDisable(indispensable);
            if (!indispensable && this.feature != null) {
                Restriction restriction;
                Iterator<Restriction> iterator = this.feature.getRestrictions().iterator();
                while (iterator.hasNext()) {
                    restriction = iterator.next();
                    if (!restriction.contains(this.unknownParameter)) continue;
                    this.removeParameterButton.setDisable(true);
                    break;
                }
                iterator = this.feature.getPostProcessingCalculations().iterator();
                while (iterator.hasNext()) {
                    restriction = iterator.next();
                    if (!restriction.contains(this.unknownParameter)) continue;
                    this.removeParameterButton.setDisable(true);
                    break;
                }
            }
            if (this.feature != null) {
                boolean foundOwner = false;
                Iterator<GeometricPrimitive> iterator = this.feature.getGeometricPrimitives().iterator();
                while (iterator.hasNext()) {
                    GeometricPrimitive geometry = iterator.next();
                    if (!geometry.contains(this.unknownParameter)) continue;
                    this.parameterOwner.setText(geometry.getName());
                    foundOwner = true;
                    break;
                }
                if (!foundOwner) {
                    this.parameterOwner.setText(i18N.getString("UnknownParameterDialog.parameter.owner.default", "Auxially parameter"));
                }
            }
        }
        this.visibleCheckBox.selectedProperty().addListener((ChangeListener)this.visibleChangeListener);
    }

    private Node createPane() {
        GridPane gridPane = DialogUtil.createGridPane();
        Label parameterTypeLabel = new Label(i18N.getString("UnknownParameterDialog.parameter.type.label", "Parameter type:"));
        Label processingTypeLabel = new Label(i18N.getString("UnknownParameterDialog.processing.type.label", "Processing type:"));
        Label initialGuessLabel = new Label(i18N.getString("UnknownParameterDialog.initial.guess.label", "Initial guess:"));
        Label descriptionLabel = new Label(i18N.getString("UnknownParameterDialog.parameter.description.label", "Description:"));
        Label nameLabel = new Label(i18N.getString("UnknownParameterDialog.parameter.name.label", "Name:"));
        Label ownerLabel = new Label(i18N.getString("UnknownParameterDialog.parameter.owner.label", "Owner:"));
        this.initialGuessTextField = DialogUtil.createDoubleTextField(CellValueType.LENGTH, 0.0, i18N.getString("UnknownParameterDialog.initial.guess.tooltip", "Initial guess of parameter"));
        this.nameTextField = DialogUtil.createTextField(i18N.getString("UnknownParameterDialog.parameter.name.tooltip", "Name of parameter"), i18N.getString("UnknownParameterDialog.parameter.name.prompt", "Parameter name"));
        this.descriptionTextField = DialogUtil.createTextField(i18N.getString("UnknownParameterDialog.parameter.description.tooltip", "Description of parameter or properties"), i18N.getString("UnknownParameterDialog.parameter.description.prompt", "Parameter description"));
        this.visibleCheckBox = DialogUtil.createCheckBox(i18N.getString("UnknownParameterDialog.parameter.visible.label", "Show parameter in parameter table"), i18N.getString("UnknownParameterDialog.parameter.visible.tooltip", "If checked, the parameter will be shown in the parameter table of the feature"));
        TextFlow noticeFlowPane = new TextFlow();
        noticeFlowPane.setPadding(new Insets(10.0, 5.0, 10.0, 5.0));
        noticeFlowPane.setTextAlignment(TextAlignment.JUSTIFY);
        noticeFlowPane.setLineSpacing(2.0);
        Text noticeLabel = new Text(i18N.getString("UnknownParameterDialog.warning.initial_guess.label", "Please note:"));
        noticeLabel.setFill((Paint)Color.DARKRED);
        Text noticeMessage = new Text(i18N.getString("UnknownParameterDialog.warning.initial_guess.message", "For some options the automatic estimation of an initial guess must be disabled, and appropriate approximations have to be specified manually."));
        noticeMessage.setFill((Paint)Color.BLACK);
        noticeFlowPane.getChildren().addAll((Object[])new Node[]{noticeLabel, new Text(" "), noticeMessage});
        this.visibleCheckBox.selectedProperty().addListener((ChangeListener)this.visibleChangeListener);
        this.parameterOwner = new Label();
        this.parameterOwner.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        this.parameterOwner.setMaxWidth(Double.MAX_VALUE);
        this.parameterTypeComboBox = DialogUtil.createParameterTypeComboBox(UnknownParameterTypeDialog.createParameterTypeStrincConverter(), i18N.getString("UnknownParameterDialog.parameter.type.tooltip", "Select parameter type"));
        this.filteredProcessingTypeList = new FilteredList(FXCollections.observableArrayList((Object[])ProcessingType.values()));
        this.processingTypeComboBox = DialogUtil.createProcessingTypeComboBox(UnknownParameterDialog.createProcessingTypeStringConverter(), i18N.getString("UnknownParameterDialog.processing.type.tooltip", "Select processing type of unknown parameter"));
        this.processingTypeComboBox.setItems(this.filteredProcessingTypeList);
        this.parameterList = DialogUtil.createParameterListView(UnknownParameterDialog.createUnknownParameterCellFactory());
        this.parameterList.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new UnknownParameterSelectionChangeListener());
        UnknwonParameterEventHandler unknwonParameterEventHandler = new UnknwonParameterEventHandler();
        VBox buttonBox = new VBox(3.0);
        this.addParameterButton = DialogUtil.createButton(i18N.getString("UnknownParameterDialog.button.add.label", "Add"), i18N.getString("UnknownParameterDialog.button.add.tooltip", "Add new unknown parameter"));
        this.removeParameterButton = DialogUtil.createButton(i18N.getString("UnknownParameterDialog.button.remove.label", "Remove"), i18N.getString("UnknownParameterDialog.button.remove.tooltip", "Remove selected unknown parameter"));
        this.addParameterButton.setOnAction((EventHandler)unknwonParameterEventHandler);
        this.removeParameterButton.setOnAction((EventHandler)unknwonParameterEventHandler);
        VBox.setVgrow((Node)this.addParameterButton, (Priority)Priority.ALWAYS);
        VBox.setVgrow((Node)this.removeParameterButton, (Priority)Priority.ALWAYS);
        buttonBox.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        buttonBox.getChildren().addAll((Object[])new Node[]{this.addParameterButton, this.removeParameterButton});
        HBox orderButtonBox = new HBox(3.0);
        this.moveUpParameterButtom = DialogUtil.createButton(i18N.getString("UnknownParameterDialog.parameter.up.label", "\u25b2"), i18N.getString("UnknownParameterDialog.parameter.up.tooltip", "Move up (change order)"));
        this.moveDownParameterButtom = DialogUtil.createButton(i18N.getString("UnknownParameterDialog.parameter.down.label", "\u25bc"), i18N.getString("UnknownParameterDialog.parameter.down.tooltip", "Move down (change order)"));
        this.moveUpParameterButtom.setOnAction((EventHandler)unknwonParameterEventHandler);
        this.moveDownParameterButtom.setOnAction((EventHandler)unknwonParameterEventHandler);
        HBox.setHgrow((Node)this.moveUpParameterButtom, (Priority)Priority.NEVER);
        HBox.setHgrow((Node)this.moveDownParameterButtom, (Priority)Priority.NEVER);
        orderButtonBox.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        orderButtonBox.getChildren().addAll((Object[])new Node[]{this.moveUpParameterButtom, this.moveDownParameterButtom});
        Region spacer = new Region();
        parameterTypeLabel.setLabelFor(this.parameterTypeComboBox);
        processingTypeLabel.setLabelFor(this.processingTypeComboBox);
        initialGuessLabel.setLabelFor((Node)this.initialGuessTextField);
        descriptionLabel.setLabelFor((Node)this.descriptionTextField);
        nameLabel.setLabelFor((Node)this.nameTextField);
        ownerLabel.setLabelFor((Node)this.parameterOwner);
        parameterTypeLabel.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        processingTypeLabel.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        initialGuessLabel.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        descriptionLabel.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        nameLabel.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        ownerLabel.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        noticeFlowPane.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        noticeFlowPane.setPrefSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        parameterTypeLabel.setMaxWidth(Double.MAX_VALUE);
        processingTypeLabel.setMaxWidth(Double.MAX_VALUE);
        initialGuessLabel.setMaxWidth(Double.MAX_VALUE);
        descriptionLabel.setMaxWidth(Double.MAX_VALUE);
        nameLabel.setMaxWidth(Double.MAX_VALUE);
        ownerLabel.setMaxWidth(Double.MAX_VALUE);
        Insets insetsLeft = new Insets(5.0, 7.0, 5.0, 5.0);
        Insets insetsRight = new Insets(5.0, 0.0, 5.0, 7.0);
        GridPane.setMargin(this.parameterList, (Insets)new Insets(5.0, 10.0, 5.0, 0.0));
        GridPane.setMargin((Node)orderButtonBox, (Insets)new Insets(5.0, 10.0, 5.0, 0.0));
        GridPane.setMargin((Node)parameterTypeLabel, (Insets)insetsLeft);
        GridPane.setMargin((Node)processingTypeLabel, (Insets)insetsLeft);
        GridPane.setMargin((Node)initialGuessLabel, (Insets)insetsLeft);
        GridPane.setMargin((Node)descriptionLabel, (Insets)insetsLeft);
        GridPane.setMargin((Node)nameLabel, (Insets)insetsLeft);
        GridPane.setMargin((Node)ownerLabel, (Insets)insetsLeft);
        GridPane.setMargin((Node)buttonBox, (Insets)insetsLeft);
        GridPane.setMargin((Node)this.nameTextField, (Insets)insetsRight);
        GridPane.setMargin(this.parameterTypeComboBox, (Insets)insetsRight);
        GridPane.setMargin(this.processingTypeComboBox, (Insets)insetsRight);
        GridPane.setMargin((Node)this.initialGuessTextField, (Insets)insetsRight);
        GridPane.setMargin((Node)this.descriptionTextField, (Insets)insetsRight);
        GridPane.setMargin((Node)this.parameterOwner, (Insets)insetsRight);
        GridPane.setMargin((Node)this.visibleCheckBox, (Insets)new Insets(5.0, 5.0, 5.0, 5.0));
        GridPane.setHgrow((Node)parameterTypeLabel, (Priority)Priority.NEVER);
        GridPane.setHgrow((Node)processingTypeLabel, (Priority)Priority.NEVER);
        GridPane.setHgrow((Node)initialGuessLabel, (Priority)Priority.NEVER);
        GridPane.setHgrow((Node)descriptionLabel, (Priority)Priority.NEVER);
        GridPane.setHgrow((Node)nameLabel, (Priority)Priority.NEVER);
        GridPane.setHgrow((Node)ownerLabel, (Priority)Priority.NEVER);
        GridPane.setHgrow((Node)buttonBox, (Priority)Priority.NEVER);
        GridPane.setHgrow((Node)orderButtonBox, (Priority)Priority.NEVER);
        GridPane.setHgrow((Node)noticeFlowPane, (Priority)Priority.ALWAYS);
        GridPane.setHgrow((Node)this.nameTextField, (Priority)Priority.ALWAYS);
        GridPane.setHgrow(this.parameterTypeComboBox, (Priority)Priority.ALWAYS);
        GridPane.setHgrow(this.processingTypeComboBox, (Priority)Priority.ALWAYS);
        GridPane.setHgrow((Node)this.initialGuessTextField, (Priority)Priority.ALWAYS);
        GridPane.setHgrow((Node)this.descriptionTextField, (Priority)Priority.ALWAYS);
        GridPane.setHgrow(this.parameterList, (Priority)Priority.NEVER);
        GridPane.setHgrow((Node)this.parameterOwner, (Priority)Priority.ALWAYS);
        GridPane.setHgrow((Node)this.visibleCheckBox, (Priority)Priority.ALWAYS);
        GridPane.setVgrow((Node)buttonBox, (Priority)Priority.NEVER);
        GridPane.setVgrow((Node)orderButtonBox, (Priority)Priority.NEVER);
        GridPane.setVgrow((Node)noticeFlowPane, (Priority)Priority.NEVER);
        GridPane.setVgrow(this.parameterList, (Priority)Priority.ALWAYS);
        GridPane.setHgrow((Node)spacer, (Priority)Priority.ALWAYS);
        GridPane.setVgrow((Node)spacer, (Priority)Priority.ALWAYS);
        int row = 0;
        gridPane.add((Node)ownerLabel, 1, row);
        gridPane.add((Node)this.parameterOwner, 2, row++);
        gridPane.add((Node)nameLabel, 1, row);
        gridPane.add((Node)this.nameTextField, 2, row++);
        gridPane.add((Node)parameterTypeLabel, 1, row);
        gridPane.add(this.parameterTypeComboBox, 2, row++);
        gridPane.add((Node)processingTypeLabel, 1, row);
        gridPane.add(this.processingTypeComboBox, 2, row++);
        gridPane.add((Node)initialGuessLabel, 1, row);
        gridPane.add((Node)this.initialGuessTextField, 2, row++);
        gridPane.add((Node)descriptionLabel, 1, row);
        gridPane.add((Node)this.descriptionTextField, 2, row++);
        gridPane.add((Node)this.visibleCheckBox, 1, row++, 2, 1);
        gridPane.add((Node)noticeFlowPane, 1, row++, 2, 1);
        gridPane.add((Node)spacer, 1, row++, 2, 1);
        gridPane.add((Node)buttonBox, 1, row++);
        gridPane.add(this.parameterList, 0, 0, 1, row++);
        gridPane.add((Node)orderButtonBox, 0, row);
        this.parameterTypeComboBox.valueProperty().addListener((ChangeListener)new ChangeListener<ParameterType>(){

            public void changed(ObservableValue<? extends ParameterType> observable, ParameterType oldValue, ParameterType newValue) {
                if (newValue == null) {
                    return;
                }
                CellValueType cellValueType = UnknownParameterDialog.this.initialGuessTextField.getCellValueType();
                cellValueType = UnknownParameterDialog.getCorrespondingCellValueType(newValue);
                if (UnknownParameterDialog.this.initialGuessTextField.getCellValueType() != cellValueType) {
                    UnknownParameterDialog.this.initialGuessTextField.setCellValueType(cellValueType);
                }
            }
        });
        gridPane.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        gridPane.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                UnknownParameterDialog.this.parameterList.requestFocus();
                if (UnknownParameterDialog.this.parameterList.getItems().size() > 0) {
                    UnknownParameterDialog.this.parameterList.getSelectionModel().clearAndSelect(0);
                    UnknownParameterDialog.this.setUnknownParameter((UnknownParameter)UnknownParameterDialog.this.parameterList.getItems().get(0));
                }
            }
        });
        return gridPane;
    }

    static CellValueType getCorrespondingCellValueType(ParameterType parameterType) {
        CellValueType cellValueType = CellValueType.DOUBLE;
        switch (parameterType) {
            case ORIGIN_COORDINATE_X: 
            case ORIGIN_COORDINATE_Y: 
            case ORIGIN_COORDINATE_Z: 
            case PRIMARY_FOCAL_COORDINATE_X: 
            case PRIMARY_FOCAL_COORDINATE_Y: 
            case PRIMARY_FOCAL_COORDINATE_Z: 
            case SECONDARY_FOCAL_COORDINATE_X: 
            case SECONDARY_FOCAL_COORDINATE_Y: 
            case SECONDARY_FOCAL_COORDINATE_Z: 
            case COORDINATE_X: 
            case COORDINATE_Y: 
            case COORDINATE_Z: 
            case RADIUS: 
            case LENGTH: {
                cellValueType = CellValueType.LENGTH;
                break;
            }
            case VECTOR_X: 
            case VECTOR_Y: 
            case VECTOR_Z: 
            case VECTOR_LENGTH: {
                cellValueType = CellValueType.VECTOR;
                break;
            }
            case ANGLE: {
                cellValueType = CellValueType.ANGLE;
                break;
            }
            case MAJOR_AXIS_COEFFICIENT: 
            case MINOR_AXIS_COEFFICIENT: 
            case MIDDLE_AXIS_COEFFICIENT: 
            case ROTATION_COMPONENT_R11: 
            case ROTATION_COMPONENT_R12: 
            case ROTATION_COMPONENT_R13: 
            case ROTATION_COMPONENT_R21: 
            case ROTATION_COMPONENT_R22: 
            case ROTATION_COMPONENT_R23: 
            case ROTATION_COMPONENT_R31: 
            case ROTATION_COMPONENT_R32: 
            case ROTATION_COMPONENT_R33: 
            case POLYNOMIAL_COEFFICIENT_A: 
            case POLYNOMIAL_COEFFICIENT_B: 
            case POLYNOMIAL_COEFFICIENT_C: 
            case POLYNOMIAL_COEFFICIENT_D: 
            case POLYNOMIAL_COEFFICIENT_E: 
            case POLYNOMIAL_COEFFICIENT_F: 
            case POLYNOMIAL_COEFFICIENT_G: 
            case POLYNOMIAL_COEFFICIENT_H: 
            case POLYNOMIAL_COEFFICIENT_I: 
            case CONSTANT: {
                cellValueType = CellValueType.DOUBLE;
            }
        }
        return cellValueType;
    }

    static StringConverter<ProcessingType> createProcessingTypeStringConverter() {
        return new StringConverter<ProcessingType>(){

            public String toString(ProcessingType type) {
                if (type == null) {
                    return null;
                }
                switch (type) {
                    case ADJUSTMENT: {
                        return i18N.getString("UnknownParameterDialog.processing.type.adjusting", "Adjusting");
                    }
                    case FIXED: {
                        return i18N.getString("UnknownParameterDialog.processing.type.fixing", "Fixing");
                    }
                    case POSTPROCESSING: {
                        return i18N.getString("UnknownParameterDialog.processing.type.postprocessing", "Post processing");
                    }
                }
                return "";
            }

            public ProcessingType fromString(String string) {
                return ProcessingType.valueOf(string);
            }
        };
    }

    static Callback<ListView<UnknownParameter>, ListCell<UnknownParameter>> createUnknownParameterCellFactory() {
        return new Callback<ListView<UnknownParameter>, ListCell<UnknownParameter>>(){

            public ListCell<UnknownParameter> call(ListView<UnknownParameter> listView) {
                return new ListCell<UnknownParameter>(){

                    protected void updateItem(UnknownParameter unknownParameter, boolean empty) {
                        super.updateItem((Object)unknownParameter, empty);
                        this.textProperty().unbind();
                        if (empty || unknownParameter == null) {
                            this.setText(null);
                            this.setTooltip(null);
                            this.setGraphic(null);
                        } else {
                            this.textProperty().bind((ObservableValue)Bindings.when((ObservableBooleanValue)unknownParameter.nameProperty().isEqualTo((Object)"")).then((ObservableStringValue)Bindings.concat((Object[])new Object[]{UnknownParameterTypeDialog.getParameterTypeLabel(unknownParameter.getParameterType())})).otherwise((ObservableStringValue)Bindings.concat((Object[])new Object[]{unknownParameter.nameProperty()}).concat((Object)" (").concat((Object)UnknownParameterTypeDialog.getParameterTypeLabel(unknownParameter.getParameterType())).concat((Object)")")));
                            if (unknownParameter.getDescription() != null && !unknownParameter.getDescription().isBlank()) {
                                this.setTooltip(new Tooltip(unknownParameter.getDescription()));
                            }
                        }
                    }
                };
            }
        };
    }

    private void addParameter() {
        Optional<UnknownParameter> optional;
        if (this.feature != null && (optional = UnknownParameterTypeDialog.showAndWait()).isPresent()) {
            UnknownParameter unknownParameter = optional.get();
            this.feature.getUnknownParameters().add(unknownParameter);
            this.parameterList.getSelectionModel().select((Object)unknownParameter);
        }
    }

    private void removeParameter() {
        if (this.feature != null && this.unknownParameter != null && !this.unknownParameter.isIndispensable()) {
            this.feature.getUnknownParameters().remove(this.unknownParameter);
        }
    }

    private void setFeature(Feature feature) {
        this.feature = feature;
        if (feature != null) {
            this.parameterList.setItems(this.feature.getUnknownParameters());
            this.parameterList.requestFocus();
            if (this.parameterList.getItems().size() > 0) {
                this.setUnknownParameter((UnknownParameter)this.parameterList.getItems().get(0));
                this.parameterList.getSelectionModel().clearAndSelect(0);
            }
        }
    }

    private class UnknownParameterSelectionChangeListener
    implements ChangeListener<UnknownParameter> {
        private UnknownParameterSelectionChangeListener() {
        }

        public void changed(ObservableValue<? extends UnknownParameter> observable, UnknownParameter oldValue, UnknownParameter newValue) {
            UnknownParameterDialog.this.setUnknownParameter(newValue);
        }
    }

    private class UnknwonParameterEventHandler
    implements EventHandler<ActionEvent> {
        private UnknwonParameterEventHandler() {
        }

        public void handle(ActionEvent event) {
            int index;
            if (event.getSource() == UnknownParameterDialog.this.addParameterButton) {
                UnknownParameterDialog.this.addParameter();
            } else if (event.getSource() == UnknownParameterDialog.this.removeParameterButton) {
                UnknownParameterDialog.this.removeParameter();
            } else if (event.getSource() == UnknownParameterDialog.this.moveUpParameterButtom) {
                int index2 = UnknownParameterDialog.this.parameterList.getSelectionModel().getSelectedIndex();
                if (index2 > 0) {
                    UnknownParameter dummyElement = UnknownParameterTypeDialog.getUnknownParameter(((UnknownParameter)UnknownParameterDialog.this.parameterList.getSelectionModel().getSelectedItem()).getParameterType());
                    UnknownParameter firstElement = (UnknownParameter)UnknownParameterDialog.this.parameterList.getItems().set(index2, (Object)dummyElement);
                    UnknownParameter secondElement = (UnknownParameter)UnknownParameterDialog.this.parameterList.getItems().set(index2 - 1, (Object)firstElement);
                    UnknownParameterDialog.this.parameterList.getItems().set(index2, (Object)secondElement);
                    UnknownParameterDialog.this.parameterList.getSelectionModel().clearAndSelect(index2 - 1);
                }
            } else if (event.getSource() == UnknownParameterDialog.this.moveDownParameterButtom && (index = UnknownParameterDialog.this.parameterList.getSelectionModel().getSelectedIndex()) < UnknownParameterDialog.this.parameterList.getItems().size() - 1) {
                UnknownParameter dummyElement = UnknownParameterTypeDialog.getUnknownParameter(((UnknownParameter)UnknownParameterDialog.this.parameterList.getSelectionModel().getSelectedItem()).getParameterType());
                UnknownParameter firstElement = (UnknownParameter)UnknownParameterDialog.this.parameterList.getItems().set(index, (Object)dummyElement);
                UnknownParameter secondElement = (UnknownParameter)UnknownParameterDialog.this.parameterList.getItems().set(index + 1, (Object)firstElement);
                UnknownParameterDialog.this.parameterList.getItems().set(index, (Object)secondElement);
                UnknownParameterDialog.this.parameterList.getSelectionModel().clearAndSelect(index + 1);
            }
        }
    }

    private class VisibleChangeListener
    implements ChangeListener<Boolean> {
        private VisibleChangeListener() {
        }

        public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
            UITreeBuilder.getInstance().handleTreeSelections();
        }
    }
}

