/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.juniform.ui.dialog;

import java.util.Optional;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.util.Callback;
import javafx.util.StringConverter;
import org.applied_geodesy.adjustment.geometry.parameter.UnknownParameter;
import org.applied_geodesy.adjustment.geometry.restriction.TrigonometricRestriction;
import org.applied_geodesy.juniform.ui.dialog.DialogUtil;
import org.applied_geodesy.juniform.ui.dialog.UnknownParameterDialog;
import org.applied_geodesy.juniform.ui.i18n.I18N;
import org.applied_geodesy.ui.tex.LaTexLabel;

public class TrigonometricRestrictionDialog {
    private static I18N i18N = I18N.getInstance();
    private static TrigonometricRestrictionDialog restrictionTypeDialog = new TrigonometricRestrictionDialog();
    private Dialog<TrigonometricRestriction> dialog = null;
    private LaTexLabel latexLabel;
    private CheckBox invertCheckbox;
    private ComboBox<TrigonometricRestriction.TrigonometricFunctionType> trigonometricTypeComboBox;
    private ComboBox<UnknownParameter> regressorComboBox;
    private ComboBox<UnknownParameter> regressandComboBox;
    private TextField descriptionTextField;
    private Window window;
    private TrigonometricRestriction restriction;

    private TrigonometricRestrictionDialog() {
    }

    public static void setOwner(Window owner) {
        TrigonometricRestrictionDialog.restrictionTypeDialog.window = owner;
    }

    public static Optional<TrigonometricRestriction> showAndWait(ObservableList<UnknownParameter> unknownParameters, TrigonometricRestriction trigonometricRestriction) {
        restrictionTypeDialog.init();
        restrictionTypeDialog.setUnknownParameters(unknownParameters);
        restrictionTypeDialog.setRestriction(trigonometricRestriction);
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    TrigonometricRestrictionDialog.restrictionTypeDialog.dialog.getDialogPane().requestLayout();
                    Stage stage = (Stage)TrigonometricRestrictionDialog.restrictionTypeDialog.dialog.getDialogPane().getScene().getWindow();
                    stage.sizeToScene();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        return TrigonometricRestrictionDialog.restrictionTypeDialog.dialog.showAndWait();
    }

    private void setUnknownParameters(ObservableList<UnknownParameter> unknownParameters) {
        ObservableList unknownParameterList = FXCollections.observableArrayList(unknownParameters);
        this.regressorComboBox.setItems(unknownParameterList);
        this.regressandComboBox.setItems(unknownParameterList);
    }

    private void setRestriction(TrigonometricRestriction restriction) {
        if (this.restriction != null) {
            this.descriptionTextField.textProperty().unbindBidirectional(this.restriction.descriptionProperty());
            this.regressandComboBox.valueProperty().unbindBidirectional(this.restriction.regressandProperty());
            this.regressorComboBox.valueProperty().unbindBidirectional(this.restriction.regressorProperty());
            this.invertCheckbox.selectedProperty().unbindBidirectional(this.restriction.invertProperty());
            this.trigonometricTypeComboBox.valueProperty().unbindBidirectional(this.restriction.trigonometricFunctionTypeProperty());
        }
        this.restriction = restriction;
        this.descriptionTextField.textProperty().bindBidirectional(this.restriction.descriptionProperty());
        this.regressandComboBox.valueProperty().bindBidirectional(this.restriction.regressandProperty());
        this.regressorComboBox.valueProperty().bindBidirectional(this.restriction.regressorProperty());
        this.invertCheckbox.selectedProperty().bindBidirectional(this.restriction.invertProperty());
        this.trigonometricTypeComboBox.valueProperty().bindBidirectional(this.restriction.trigonometricFunctionTypeProperty());
        this.latexLabel.setTex(this.restriction.toLaTex());
        this.regressorComboBox.setDisable(restriction.isIndispensable());
        this.regressandComboBox.setDisable(restriction.isIndispensable());
        this.trigonometricTypeComboBox.setDisable(restriction.isIndispensable());
        this.invertCheckbox.setDisable(restriction.isIndispensable());
        if (!restriction.isIndispensable()) {
            UnknownParameter regressand = this.restriction.getRegressand();
            UnknownParameter regressor = this.restriction.getRegressor();
            TrigonometricRestriction.TrigonometricFunctionType type = this.restriction.getTrigonometricFunctionType();
            if (regressand == null) {
                this.regressandComboBox.getSelectionModel().clearAndSelect(0);
            }
            if (regressor == null) {
                this.regressorComboBox.getSelectionModel().clearAndSelect(0);
            }
            if (type == null) {
                this.trigonometricTypeComboBox.getSelectionModel().clearAndSelect(0);
            }
        }
    }

    private void init() {
        if (this.dialog != null) {
            return;
        }
        this.dialog = new Dialog();
        this.dialog.setTitle(i18N.getString("TrigonometricRestrictionDialog.title", "Trigonometric restriction"));
        this.dialog.setHeaderText(i18N.getString("TrigonometricRestrictionDialog.header", "Trigonometric function"));
        this.dialog.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{ButtonType.OK});
        this.dialog.initModality(Modality.APPLICATION_MODAL);
        this.dialog.initOwner(this.window);
        this.dialog.getDialogPane().setContent(this.createPane());
        this.dialog.setResizable(true);
        this.dialog.setResultConverter((Callback)new Callback<ButtonType, TrigonometricRestriction>(){

            public TrigonometricRestriction call(ButtonType buttonType) {
                if (buttonType == ButtonType.OK) {
                    return TrigonometricRestrictionDialog.this.restriction;
                }
                return null;
            }
        });
    }

    private Node createPane() {
        GridPane gridPane = DialogUtil.createGridPane();
        Label equationLabel = new Label(i18N.getString("TrigonometricRestrictionDialog.equation.label", "Equation:"));
        Label descriptionLabel = new Label(i18N.getString("TrigonometricRestrictionDialog.description.label", "Description:"));
        Label regressandLabel = new Label(i18N.getString("TrigonometricRestrictionDialog.regressand.label", "Regressand c:"));
        Label regressorLabel = new Label(i18N.getString("TrigonometricRestrictionDialog.regressor.label", "Regressor a:"));
        Label functionTypeLabel = new Label(i18N.getString("TrigonometricRestrictionDialog.trigonometry.type.label", "Trigonometric function:"));
        regressorLabel.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        regressorLabel.setMaxWidth(Double.MAX_VALUE);
        regressandLabel.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        regressandLabel.setMaxWidth(Double.MAX_VALUE);
        equationLabel.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        equationLabel.setMaxWidth(Double.MAX_VALUE);
        descriptionLabel.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        descriptionLabel.setMaxWidth(Double.MAX_VALUE);
        functionTypeLabel.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        functionTypeLabel.setMaxWidth(Double.MAX_VALUE);
        this.descriptionTextField = DialogUtil.createTextField(i18N.getString("TrigonometricRestrictionDialog.description.tooltip", "Description of parameter restriction"), i18N.getString("TrigonometricRestrictionDialog.description.prompt", "Restriction description"));
        this.regressorComboBox = DialogUtil.createUnknownParameterComboBox(UnknownParameterDialog.createUnknownParameterCellFactory(), i18N.getString("TrigonometricRestrictionDialog.regressor.tooltip", "Select regressor a"));
        this.regressandComboBox = DialogUtil.createUnknownParameterComboBox(UnknownParameterDialog.createUnknownParameterCellFactory(), i18N.getString("TrigonometricRestrictionDialog.regressand.tooltip", "Select regressand c"));
        this.trigonometricTypeComboBox = DialogUtil.createTrigonometricFunctionTypeComboBox(TrigonometricRestrictionDialog.createTrigonometricFunctionTypeStringConverter(), i18N.getString("TrigonometricRestrictionDialog.trigonometry.type.tooltip", "Select trigonometric function"));
        this.invertCheckbox = DialogUtil.createCheckBox(i18N.getString("TrigonometricRestrictionDialog.trigonometry.invert.label", "Inverted trigonometric function"), i18N.getString("TrigonometricRestrictionDialog.trigonometry.invert.tooltip", "If checked, the inverted trigonometric function will be used, i.e., asin(a), acos(a), atan(a), or acot(a)"));
        this.latexLabel = new LaTexLabel();
        this.latexLabel.setPrefSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        this.latexLabel.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        equationLabel.setLabelFor((Node)this.latexLabel);
        descriptionLabel.setLabelFor((Node)this.descriptionTextField);
        regressandLabel.setLabelFor(this.regressandComboBox);
        regressorLabel.setLabelFor(this.regressorComboBox);
        functionTypeLabel.setLabelFor(this.trigonometricTypeComboBox);
        GridPane.setHgrow((Node)equationLabel, (Priority)Priority.NEVER);
        GridPane.setHgrow((Node)descriptionLabel, (Priority)Priority.NEVER);
        GridPane.setHgrow((Node)regressandLabel, (Priority)Priority.NEVER);
        GridPane.setHgrow((Node)regressorLabel, (Priority)Priority.NEVER);
        GridPane.setHgrow((Node)functionTypeLabel, (Priority)Priority.NEVER);
        GridPane.setHgrow((Node)this.latexLabel, (Priority)Priority.ALWAYS);
        GridPane.setHgrow((Node)this.invertCheckbox, (Priority)Priority.ALWAYS);
        GridPane.setHgrow((Node)this.descriptionTextField, (Priority)Priority.ALWAYS);
        GridPane.setHgrow(this.regressandComboBox, (Priority)Priority.ALWAYS);
        GridPane.setHgrow(this.regressorComboBox, (Priority)Priority.ALWAYS);
        GridPane.setVgrow(this.trigonometricTypeComboBox, (Priority)Priority.ALWAYS);
        Insets insetsLeft = new Insets(5.0, 7.0, 5.0, 5.0);
        Insets insetsRight = new Insets(5.0, 0.0, 5.0, 7.0);
        GridPane.setMargin((Node)equationLabel, (Insets)insetsLeft);
        GridPane.setMargin((Node)regressandLabel, (Insets)insetsLeft);
        GridPane.setMargin((Node)regressorLabel, (Insets)insetsLeft);
        GridPane.setMargin((Node)descriptionLabel, (Insets)insetsLeft);
        GridPane.setMargin((Node)functionTypeLabel, (Insets)insetsLeft);
        GridPane.setMargin((Node)this.latexLabel, (Insets)insetsRight);
        GridPane.setMargin(this.regressandComboBox, (Insets)insetsRight);
        GridPane.setMargin(this.regressorComboBox, (Insets)insetsRight);
        GridPane.setMargin((Node)this.descriptionTextField, (Insets)insetsRight);
        GridPane.setMargin(this.trigonometricTypeComboBox, (Insets)insetsRight);
        GridPane.setMargin((Node)this.invertCheckbox, (Insets)new Insets(5.0, 7.0, 5.0, 7.0));
        int row = 0;
        gridPane.add((Node)equationLabel, 0, row);
        gridPane.add((Node)this.latexLabel, 1, row++);
        gridPane.add((Node)descriptionLabel, 0, row);
        gridPane.add((Node)this.descriptionTextField, 1, row++);
        gridPane.add((Node)regressandLabel, 0, row);
        gridPane.add(this.regressandComboBox, 1, row++);
        gridPane.add((Node)regressorLabel, 0, row);
        gridPane.add(this.regressorComboBox, 1, row++);
        gridPane.add((Node)functionTypeLabel, 0, row);
        gridPane.add(this.trigonometricTypeComboBox, 1, row++);
        gridPane.add((Node)this.invertCheckbox, 0, row++, 2, 1);
        return gridPane;
    }

    static StringConverter<TrigonometricRestriction.TrigonometricFunctionType> createTrigonometricFunctionTypeStringConverter() {
        return new StringConverter<TrigonometricRestriction.TrigonometricFunctionType>(){

            public String toString(TrigonometricRestriction.TrigonometricFunctionType functionType) {
                return TrigonometricRestrictionDialog.getTrigonometricFunctionTypeLabel(functionType);
            }

            public TrigonometricRestriction.TrigonometricFunctionType fromString(String string) {
                return TrigonometricRestriction.TrigonometricFunctionType.valueOf(string);
            }
        };
    }

    static String getTrigonometricFunctionTypeLabel(TrigonometricRestriction.TrigonometricFunctionType functionType) {
        if (functionType == null) {
            return null;
        }
        switch (functionType) {
            case SINE: {
                return i18N.getString("TrigonometricRestrictionDialog.trigonometry.type.sine", "Sine sin(a)");
            }
            case COSINE: {
                return i18N.getString("TrigonometricRestrictionDialog.trigonometry.type.cosine", "Cosine cos(a)");
            }
            case TANGENT: {
                return i18N.getString("TrigonometricRestrictionDialog.trigonometry.type.tangent", "Tangent tan(a)");
            }
            case COTANGENT: {
                return i18N.getString("TrigonometricRestrictionDialog.trigonometry.type.cotangent", "Cotangent cot(a)");
            }
        }
        throw new IllegalArgumentException("Error, unknown trigonometric function type " + String.valueOf((Object)functionType) + "!");
    }
}

