/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.juniform.ui.dialog;

import java.util.Locale;
import java.util.Optional;
import javafx.application.Platform;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.control.SpinnerValueFactory;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.util.Callback;
import javafx.util.StringConverter;
import org.applied_geodesy.adjustment.statistic.TestStatisticDefinition;
import org.applied_geodesy.adjustment.statistic.TestStatisticType;
import org.applied_geodesy.juniform.ui.dialog.DialogUtil;
import org.applied_geodesy.juniform.ui.i18n.I18N;
import org.applied_geodesy.ui.spinner.DoubleSpinner;
import org.applied_geodesy.util.CellValueType;
import org.applied_geodesy.util.FormatterChangedListener;
import org.applied_geodesy.util.FormatterEvent;
import org.applied_geodesy.util.FormatterEventType;
import org.applied_geodesy.util.FormatterOptions;

public class TestStatisticDialog
implements FormatterChangedListener {
    private static I18N i18N = I18N.getInstance();
    private static TestStatisticDialog testStatisticDialog = new TestStatisticDialog();
    private FormatterOptions options = FormatterOptions.getInstance();
    private Dialog<TestStatisticDefinition> dialog = null;
    private DoubleSpinner probabilityValueSpinner;
    private DoubleSpinner testPowerSpinner;
    private ComboBox<TestStatisticType> testStatisticTypeComboBox;
    private CheckBox familywiseErrorRateCheckBox;
    private Window window;
    private TestStatisticDefinition testStatisticDefinition;
    private Label probabilityValueLabel;
    private Label testPowerLabel;

    private TestStatisticDialog() {
    }

    public static void setOwner(Window owner) {
        TestStatisticDialog.testStatisticDialog.window = owner;
    }

    public static Optional<TestStatisticDefinition> showAndWait(TestStatisticDefinition testStatisticDefinition) {
        testStatisticDialog.init();
        testStatisticDialog.setTestStatisticDefinition(testStatisticDefinition);
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    TestStatisticDialog.testStatisticDialog.dialog.getDialogPane().requestLayout();
                    Stage stage = (Stage)TestStatisticDialog.testStatisticDialog.dialog.getDialogPane().getScene().getWindow();
                    stage.sizeToScene();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        return TestStatisticDialog.testStatisticDialog.dialog.showAndWait();
    }

    private void setTestStatisticDefinition(TestStatisticDefinition testStatisticDefinition) {
        this.testStatisticDefinition = testStatisticDefinition;
        this.familywiseErrorRateCheckBox.setSelected(this.testStatisticDefinition.isFamilywiseErrorRate());
        this.testStatisticTypeComboBox.getSelectionModel().select((Object)this.testStatisticDefinition.getTestStatisticType());
        SpinnerValueFactory.DoubleSpinnerValueFactory probabilityValueSpinnerFactory = (SpinnerValueFactory.DoubleSpinnerValueFactory)this.probabilityValueSpinner.getValueFactory();
        SpinnerValueFactory.DoubleSpinnerValueFactory testPowerSpinnerFactory = (SpinnerValueFactory.DoubleSpinnerValueFactory)this.testPowerSpinner.getValueFactory();
        double probabilityValue = this.testStatisticDefinition.getProbabilityValue();
        double powerOfTest = this.testStatisticDefinition.getPowerOfTest();
        probabilityValue = Math.max(Math.min(this.options.convertPercentToView(probabilityValue), probabilityValueSpinnerFactory.getMax()), probabilityValueSpinnerFactory.getMin());
        powerOfTest = Math.max(Math.min(this.options.convertPercentToView(powerOfTest), testPowerSpinnerFactory.getMax()), testPowerSpinnerFactory.getMin());
        probabilityValueSpinnerFactory.setValue((Object)probabilityValue);
        testPowerSpinnerFactory.setValue((Object)powerOfTest);
    }

    private void init() {
        if (this.dialog != null) {
            return;
        }
        this.dialog = new Dialog();
        this.dialog.setTitle(i18N.getString("TestStatisticDialog.title", "Test statistic"));
        this.dialog.setHeaderText(i18N.getString("TestStatisticDialog.header", "Test statistic properties"));
        this.dialog.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{ButtonType.OK, ButtonType.CANCEL});
        this.dialog.initModality(Modality.APPLICATION_MODAL);
        this.dialog.initOwner(this.window);
        this.dialog.getDialogPane().setContent(this.createPane());
        this.dialog.setResizable(true);
        this.dialog.setResultConverter((Callback)new Callback<ButtonType, TestStatisticDefinition>(){

            public TestStatisticDefinition call(ButtonType buttonType) {
                if (buttonType == ButtonType.OK) {
                    double probabilityValue = TestStatisticDialog.this.probabilityValueSpinner.getNumber().doubleValue();
                    double powerOfTest = TestStatisticDialog.this.testPowerSpinner.getNumber().doubleValue();
                    boolean familywiseErrorRate = TestStatisticDialog.this.familywiseErrorRateCheckBox.isSelected();
                    TestStatisticType testStatisticType = (TestStatisticType)((Object)TestStatisticDialog.this.testStatisticTypeComboBox.getSelectionModel().getSelectedItem());
                    TestStatisticDialog.this.testStatisticDefinition.setTestStatisticType(testStatisticType);
                    TestStatisticDialog.this.testStatisticDefinition.setFamilywiseErrorRate(familywiseErrorRate);
                    TestStatisticDialog.this.testStatisticDefinition.setProbabilityValue(probabilityValue);
                    TestStatisticDialog.this.testStatisticDefinition.setPowerOfTest(powerOfTest);
                    return TestStatisticDialog.this.testStatisticDefinition;
                }
                return null;
            }
        });
        this.options.addFormatterChangedListener(this);
    }

    private Node createPane() {
        String frmPercentUnit = this.options.getFormatterOptions().get((Object)CellValueType.PERCENTAGE).getUnit().toFormattedAbbreviation();
        String labelProbabilityValue = String.format(Locale.ENGLISH, "%s%s:", i18N.getString("TestStatisticDialog.probability.label", "Probability value \u03b1"), frmPercentUnit.isBlank() ? "" : " " + frmPercentUnit);
        String labelTestPower = String.format(Locale.ENGLISH, "%s%s:", i18N.getString("TestStatisticDialog.testpower.label", "Power of test 1 - \u03b2"), frmPercentUnit.isBlank() ? "" : " " + frmPercentUnit);
        String tooltipProbabilityValue = i18N.getString("TestStatisticDialog.probability.tooltip", "Set probability value (type I error)");
        String tooltipTestPower = i18N.getString("TestStatisticDialog.testpower.tooltip", "Set power of test (type II error)");
        String labelFamilywiseErrorRate = i18N.getString("TestStatisticDialog.familywiseerror.label", "Familywise error rate");
        String tooltipFamilywiseErrorRate = i18N.getString("TestStatisticDialog.familywiseerror.tooltip", "If checked, probability value \u03b1 defines familywise error rate");
        this.probabilityValueLabel = new Label(labelProbabilityValue);
        this.testPowerLabel = new Label(labelTestPower);
        this.familywiseErrorRateCheckBox = DialogUtil.createCheckBox(labelFamilywiseErrorRate, tooltipFamilywiseErrorRate);
        this.probabilityValueSpinner = DialogUtil.createDoubleSpinner(CellValueType.PERCENTAGE, 5.0E-4, 0.3, 0.01, tooltipProbabilityValue);
        this.testPowerSpinner = DialogUtil.createDoubleSpinner(CellValueType.PERCENTAGE, 0.5, 0.9995, 0.01, tooltipTestPower);
        this.testStatisticTypeComboBox = DialogUtil.createTestStatisticTypeComboBox(TestStatisticDialog.createTestStatisticTypeStringConverter(), i18N.getString("TestStatisticDialog.type.tooltip", "Select method for type I error adaption"));
        this.probabilityValueLabel.setLabelFor((Node)this.probabilityValueSpinner);
        this.testPowerLabel.setLabelFor((Node)this.testPowerSpinner);
        GridPane gridPane = DialogUtil.createGridPane();
        this.probabilityValueLabel.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        this.testPowerLabel.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        this.probabilityValueLabel.setMaxWidth(Double.MAX_VALUE);
        this.testPowerLabel.setMaxWidth(Double.MAX_VALUE);
        GridPane.setHgrow((Node)this.probabilityValueLabel, (Priority)Priority.NEVER);
        GridPane.setHgrow((Node)this.testPowerLabel, (Priority)Priority.NEVER);
        GridPane.setHgrow(this.testStatisticTypeComboBox, (Priority)Priority.ALWAYS);
        GridPane.setHgrow((Node)this.familywiseErrorRateCheckBox, (Priority)Priority.ALWAYS);
        GridPane.setHgrow((Node)this.probabilityValueSpinner, (Priority)Priority.ALWAYS);
        GridPane.setHgrow((Node)this.testPowerSpinner, (Priority)Priority.ALWAYS);
        Insets insetsLeft = new Insets(5.0, 7.0, 5.0, 2.0);
        Insets insetsRight = new Insets(5.0, 2.0, 5.0, 7.0);
        Insets insetsCenter = new Insets(5.0, 2.0, 5.0, 2.0);
        GridPane.setMargin(this.testStatisticTypeComboBox, (Insets)insetsCenter);
        GridPane.setMargin((Node)this.familywiseErrorRateCheckBox, (Insets)insetsCenter);
        GridPane.setMargin((Node)this.probabilityValueLabel, (Insets)insetsLeft);
        GridPane.setMargin((Node)this.testPowerLabel, (Insets)insetsLeft);
        GridPane.setMargin((Node)this.probabilityValueSpinner, (Insets)insetsRight);
        GridPane.setMargin((Node)this.testPowerSpinner, (Insets)insetsRight);
        int row = 0;
        gridPane.add(this.testStatisticTypeComboBox, 0, ++row, 2, 1);
        gridPane.add((Node)this.familywiseErrorRateCheckBox, 0, ++row, 2, 1);
        gridPane.add((Node)this.probabilityValueLabel, 0, ++row);
        gridPane.add((Node)this.probabilityValueSpinner, 1, row);
        gridPane.add((Node)this.testPowerLabel, 0, ++row);
        gridPane.add((Node)this.testPowerSpinner, 1, row);
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                TestStatisticDialog.this.testStatisticTypeComboBox.requestFocus();
            }
        });
        gridPane.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        gridPane.setMaxSize(Double.MAX_VALUE, Double.NEGATIVE_INFINITY);
        return gridPane;
    }

    static StringConverter<TestStatisticType> createTestStatisticTypeStringConverter() {
        return new StringConverter<TestStatisticType>(){

            public String toString(TestStatisticType type) {
                if (type == null) {
                    return null;
                }
                switch (type) {
                    case BAARDA_METHOD: {
                        return i18N.getString("TestStatisticDialog.type.baarda", "Baardas B-method");
                    }
                    case SIDAK: {
                        return i18N.getString("TestStatisticDialog.type.sidak", "\u0160id\u00e1k correction");
                    }
                    case NONE: {
                        return i18N.getString("TestStatisticDialog.type.none", "None");
                    }
                }
                return "";
            }

            public TestStatisticType fromString(String string) {
                return TestStatisticType.valueOf(string);
            }
        };
    }

    @Override
    public void formatterChanged(FormatterEvent evt) {
        if (evt != null && evt.getCellType() == CellValueType.PERCENTAGE && evt.getEventType() == FormatterEventType.UNIT_CHANGED) {
            String frmPercentUnit = this.options.getFormatterOptions().get((Object)CellValueType.PERCENTAGE).getUnit().toFormattedAbbreviation();
            String labelProbabilityValue = String.format(Locale.ENGLISH, "%s%s:", i18N.getString("TestStatisticDialog.probability.label", "Probability value \u03b1"), frmPercentUnit.isBlank() ? "" : " " + frmPercentUnit);
            String labelTestPower = String.format(Locale.ENGLISH, "%s%s:", i18N.getString("TestStatisticDialog.testpower.label", "Power of test 1 - \u03b2"), frmPercentUnit.isBlank() ? "" : " " + frmPercentUnit);
            this.probabilityValueLabel.setText(labelProbabilityValue);
            this.testPowerLabel.setText(labelTestPower);
        }
    }
}

