/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.juniform.ui.dialog;

import java.util.Optional;
import javafx.application.Platform;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.util.Callback;
import javafx.util.StringConverter;
import org.applied_geodesy.adjustment.geometry.restriction.RestrictionType;
import org.applied_geodesy.juniform.ui.dialog.DialogUtil;
import org.applied_geodesy.juniform.ui.i18n.I18N;

public class RestrictionTypeDialog {
    private static I18N i18N = I18N.getInstance();
    private static RestrictionTypeDialog restrictionTypeDialog = new RestrictionTypeDialog();
    private Dialog<RestrictionType> dialog = null;
    private ComboBox<RestrictionType> restrictionTypeComboBox;
    private Window window;

    private RestrictionTypeDialog() {
    }

    public static void setOwner(Window owner) {
        RestrictionTypeDialog.restrictionTypeDialog.window = owner;
    }

    public static Optional<RestrictionType> showAndWait() {
        restrictionTypeDialog.init();
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    RestrictionTypeDialog.restrictionTypeDialog.dialog.getDialogPane().requestLayout();
                    Stage stage = (Stage)RestrictionTypeDialog.restrictionTypeDialog.dialog.getDialogPane().getScene().getWindow();
                    stage.sizeToScene();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        return RestrictionTypeDialog.restrictionTypeDialog.dialog.showAndWait();
    }

    private void init() {
        if (this.dialog != null) {
            return;
        }
        this.dialog = new Dialog();
        this.dialog.setTitle(i18N.getString("RestrictionTypeDialog.title", "Restrictions"));
        this.dialog.setHeaderText(i18N.getString("RestrictionTypeDialog.header", "Parameter restrictions"));
        this.dialog.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{ButtonType.OK, ButtonType.CANCEL});
        this.dialog.initModality(Modality.APPLICATION_MODAL);
        this.dialog.initOwner(this.window);
        this.dialog.getDialogPane().setContent(this.createPane());
        this.dialog.setResizable(true);
        this.dialog.setResultConverter((Callback)new Callback<ButtonType, RestrictionType>(){

            public RestrictionType call(ButtonType buttonType) {
                if (buttonType == ButtonType.OK) {
                    return (RestrictionType)((Object)RestrictionTypeDialog.this.restrictionTypeComboBox.getValue());
                }
                return null;
            }
        });
    }

    private Node createPane() {
        GridPane gridPane = DialogUtil.createGridPane();
        Label restrictionTypeLabel = new Label(i18N.getString("RestrictionTypeDialog.restriction.type.label", "Restriction type:"));
        this.restrictionTypeComboBox = DialogUtil.createRestrictionTypeComboBox(RestrictionTypeDialog.createRestrictionTypeStringConverter(), i18N.getString("RestrictionTypeDialog.restriction.type.tooltip", "Select restriction type"));
        restrictionTypeLabel.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        restrictionTypeLabel.setMaxWidth(Double.MAX_VALUE);
        restrictionTypeLabel.setLabelFor(this.restrictionTypeComboBox);
        Insets insetsLeft = new Insets(5.0, 7.0, 5.0, 5.0);
        Insets insetsRight = new Insets(5.0, 0.0, 5.0, 7.0);
        GridPane.setMargin((Node)restrictionTypeLabel, (Insets)insetsLeft);
        GridPane.setMargin(this.restrictionTypeComboBox, (Insets)insetsRight);
        GridPane.setHgrow((Node)restrictionTypeLabel, (Priority)Priority.NEVER);
        GridPane.setHgrow(this.restrictionTypeComboBox, (Priority)Priority.ALWAYS);
        gridPane.add((Node)restrictionTypeLabel, 0, 0);
        gridPane.add(this.restrictionTypeComboBox, 1, 0);
        return gridPane;
    }

    static StringConverter<RestrictionType> createRestrictionTypeStringConverter() {
        return new StringConverter<RestrictionType>(){

            public String toString(RestrictionType restrictionType) {
                return RestrictionTypeDialog.getRestrictionTypeLabel(restrictionType);
            }

            public RestrictionType fromString(String string) {
                return RestrictionType.valueOf(string);
            }
        };
    }

    static String getRestrictionTypeLabel(RestrictionType restrictionType) {
        if (restrictionType == null) {
            return null;
        }
        switch (restrictionType) {
            case AVERAGE: {
                return i18N.getString("RestrictionTypeDialog.restriction.type.average", "Average value");
            }
            case PRODUCT_SUM: {
                return i18N.getString("RestrictionTypeDialog.restriction.type.productsum", "k-th Power of product sum");
            }
            case TRIGONOMERTIC_FUNCTION: {
                return i18N.getString("RestrictionTypeDialog.restriction.type.trigonometry", "Trigonometric function");
            }
            case FEATURE_POINT: {
                return i18N.getString("RestrictionTypeDialog.restriction.type.featurepoint", "Feature point");
            }
            case VECTOR_ANGLE: {
                return i18N.getString("RestrictionTypeDialog.restriction.type.vectorangle", "Vector angle");
            }
        }
        throw new IllegalArgumentException("Error, unknown restriction type " + String.valueOf((Object)restrictionType) + "!");
    }
}

