/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.juniform.ui.dialog;

import java.util.Iterator;
import java.util.Optional;
import java.util.function.Predicate;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TextField;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;
import javafx.scene.text.TextFlow;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.util.Callback;
import org.applied_geodesy.adjustment.geometry.Feature;
import org.applied_geodesy.adjustment.geometry.GeometricPrimitive;
import org.applied_geodesy.adjustment.geometry.parameter.ProcessingType;
import org.applied_geodesy.adjustment.geometry.parameter.UnknownParameter;
import org.applied_geodesy.adjustment.geometry.point.FeaturePoint;
import org.applied_geodesy.adjustment.geometry.restriction.AverageRestriction;
import org.applied_geodesy.adjustment.geometry.restriction.FeaturePointRestriction;
import org.applied_geodesy.adjustment.geometry.restriction.ProductSumRestriction;
import org.applied_geodesy.adjustment.geometry.restriction.Restriction;
import org.applied_geodesy.adjustment.geometry.restriction.RestrictionType;
import org.applied_geodesy.adjustment.geometry.restriction.TrigonometricRestriction;
import org.applied_geodesy.adjustment.geometry.restriction.VectorAngleRestriction;
import org.applied_geodesy.juniform.ui.dialog.AverageRestrictionDialog;
import org.applied_geodesy.juniform.ui.dialog.DialogUtil;
import org.applied_geodesy.juniform.ui.dialog.FeaturePointRestrictionDialog;
import org.applied_geodesy.juniform.ui.dialog.ProductSumRestrictionDialog;
import org.applied_geodesy.juniform.ui.dialog.RestrictionTypeDialog;
import org.applied_geodesy.juniform.ui.dialog.TrigonometricRestrictionDialog;
import org.applied_geodesy.juniform.ui.dialog.VectorAngleRestrictionDialog;
import org.applied_geodesy.juniform.ui.i18n.I18N;
import org.applied_geodesy.juniform.ui.table.UIPointTableBuilder;
import org.applied_geodesy.ui.tex.LaTexLabel;

public class RestrictionDialog {
    private I18N i18n = I18N.getInstance();
    private static RestrictionDialog restrictionDialog = new RestrictionDialog();
    private Dialog<Void> dialog = null;
    private LaTexLabel latexLabel;
    private TextField descriptionTextField;
    private Label restrictionTypeLabel;
    private Label parameterOwner;
    private ListView<Restriction> restrictionList;
    private Button addRestrictionButton;
    private Button editRestrictionButton;
    private Button removeRestrictionButton;
    private Button moveUpRestrictionButtom;
    private Button moveDownRestrictionButtom;
    private Restriction restriction;
    private Window window;
    private Feature feature;
    private boolean enablePostProcessing = false;
    private FilteredList<UnknownParameter> filteredUnknownParameters = null;

    private RestrictionDialog() {
    }

    public static void setOwner(Window owner) {
        RestrictionDialog.restrictionDialog.window = owner;
    }

    public static Optional<Void> showAndWait(Feature feature, boolean enablePostProcessing) {
        restrictionDialog.init();
        restrictionDialog.setFeature(feature, enablePostProcessing);
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    RestrictionDialog.restrictionDialog.dialog.getDialogPane().requestLayout();
                    Stage stage = (Stage)RestrictionDialog.restrictionDialog.dialog.getDialogPane().getScene().getWindow();
                    stage.sizeToScene();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        return RestrictionDialog.restrictionDialog.dialog.showAndWait();
    }

    private void init() {
        if (this.dialog != null) {
            return;
        }
        this.dialog = new Dialog();
        this.dialog.setTitle(this.i18n.getString("RestrictionDialog.title", "Restrictions"));
        this.dialog.setHeaderText(this.i18n.getString("RestrictionDialog.header", "Parameter restrictions"));
        this.dialog.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{ButtonType.OK});
        this.dialog.initModality(Modality.APPLICATION_MODAL);
        this.dialog.initOwner(this.window);
        this.dialog.getDialogPane().setContent(this.createPane());
        this.dialog.setResizable(true);
        this.dialog.setResultConverter((Callback)new Callback<ButtonType, Void>(){

            public Void call(ButtonType buttonType) {
                return null;
            }
        });
    }

    private void setRestriction(Restriction restriction) {
        if (this.restriction != null) {
            this.descriptionTextField.textProperty().unbindBidirectional(this.restriction.descriptionProperty());
        }
        this.restriction = restriction;
        if (restriction == null) {
            this.descriptionTextField.setDisable(true);
            this.editRestrictionButton.setDisable(true);
            this.removeRestrictionButton.setDisable(true);
            this.latexLabel.setTex("");
            this.restrictionTypeLabel.setText("");
            this.parameterOwner.setText("");
            this.moveUpRestrictionButtom.setDisable(true);
            this.moveDownRestrictionButtom.setDisable(true);
        } else {
            boolean indispensable = this.restriction.isIndispensable();
            this.descriptionTextField.setDisable(false);
            this.editRestrictionButton.setDisable(false);
            this.removeRestrictionButton.setDisable(indispensable);
            this.moveUpRestrictionButtom.setDisable(indispensable || this.restrictionList.getItems().isEmpty() || !this.restrictionList.getItems().isEmpty() && this.restrictionList.getSelectionModel().getSelectedIndex() == 0);
            this.moveDownRestrictionButtom.setDisable(indispensable || this.restrictionList.getItems().isEmpty() || !this.restrictionList.getItems().isEmpty() && this.restrictionList.getSelectionModel().getSelectedIndex() == this.restrictionList.getItems().size() - 1);
            this.latexLabel.setTex(restriction.toLaTex());
            this.restrictionTypeLabel.setText(RestrictionTypeDialog.getRestrictionTypeLabel(this.restriction.getRestrictionType()));
            this.descriptionTextField.textProperty().bindBidirectional(this.restriction.descriptionProperty());
            boolean foundOwner = false;
            Iterator<GeometricPrimitive> iterator = this.feature.getGeometricPrimitives().iterator();
            while (iterator.hasNext()) {
                GeometricPrimitive geometry = iterator.next();
                if (!geometry.getRestrictions().contains(restriction)) continue;
                this.parameterOwner.setText(geometry.getName());
                foundOwner = true;
                break;
            }
            if (!foundOwner) {
                this.parameterOwner.setText(this.i18n.getString("RestrictionDialog.restriction.owner.default", "Auxially restriction"));
            }
        }
    }

    private Node createPane() {
        GridPane gridPane = DialogUtil.createGridPane();
        Label ownerLabel = new Label(this.i18n.getString("RestrictionDialog.restriction.owner.label", "Owner:"));
        Label equationLabel = new Label(this.i18n.getString("RestrictionDialog.equation.label", "Equation:"));
        Label restrictionTypeLabel = new Label(this.i18n.getString("RestrictionDialog.restriction.type.label", "Restriction type:"));
        Label descriptionLabel = new Label(this.i18n.getString("RestrictionDialog.description.label", "Description:"));
        this.restrictionTypeLabel = new Label("");
        this.restrictionList = this.createRestrictionListView();
        this.descriptionTextField = DialogUtil.createTextField(this.i18n.getString("RestrictionDialog.description.tooltip", "Description of parameter restriction"), this.i18n.getString("RestrictionDialog.description.prompt", "Restriction description"));
        this.parameterOwner = new Label();
        this.parameterOwner.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        this.parameterOwner.setMaxWidth(Double.MAX_VALUE);
        this.latexLabel = new LaTexLabel();
        this.latexLabel.setMinSize(225.0, Double.NEGATIVE_INFINITY);
        this.latexLabel.setMaxSize(Double.MAX_VALUE, Double.NEGATIVE_INFINITY);
        RestrictionEventHandler restrictionEventHandler = new RestrictionEventHandler();
        VBox buttonBox = new VBox(3.0);
        this.addRestrictionButton = DialogUtil.createButton(this.i18n.getString("RestrictionDialog.restriction.add.label", "Add"), this.i18n.getString("RestrictionDialog.restriction.add.tooltip", "Add new parameter restriction"));
        this.editRestrictionButton = DialogUtil.createButton(this.i18n.getString("RestrictionDialog.restriction.edit.label", "Edit"), this.i18n.getString("RestrictionDialog.restriction.edit.tooltip", "Edit selected restriction"));
        this.removeRestrictionButton = DialogUtil.createButton(this.i18n.getString("RestrictionDialog.restriction.remove.label", "Remove"), this.i18n.getString("RestrictionDialog.restriction.remove.tooltip", "Remove selected restriction"));
        TextFlow noticeFlowPane = new TextFlow();
        noticeFlowPane.setPadding(new Insets(10.0, 5.0, 10.0, 5.0));
        noticeFlowPane.setTextAlignment(TextAlignment.JUSTIFY);
        noticeFlowPane.setLineSpacing(2.0);
        Text noticeLabel = new Text(this.i18n.getString("RestrictionDialog.warning.initial_guess.label", "Please note:"));
        noticeLabel.setFill((Paint)Color.DARKRED);
        Text noticeMessage = new Text(this.i18n.getString("RestrictionDialog.warning.initial_guess.message", "For some options the automatic estimation of an initial guess must be disabled, and appropriate approximations have to be specified manually."));
        noticeMessage.setFill((Paint)Color.BLACK);
        noticeFlowPane.getChildren().addAll((Object[])new Node[]{noticeLabel, new Text(" "), noticeMessage});
        this.addRestrictionButton.setOnAction((EventHandler)restrictionEventHandler);
        this.editRestrictionButton.setOnAction((EventHandler)restrictionEventHandler);
        this.removeRestrictionButton.setOnAction((EventHandler)restrictionEventHandler);
        VBox.setVgrow((Node)this.addRestrictionButton, (Priority)Priority.ALWAYS);
        VBox.setVgrow((Node)this.editRestrictionButton, (Priority)Priority.ALWAYS);
        VBox.setVgrow((Node)this.removeRestrictionButton, (Priority)Priority.ALWAYS);
        buttonBox.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        buttonBox.getChildren().addAll((Object[])new Node[]{this.addRestrictionButton, this.editRestrictionButton, this.removeRestrictionButton});
        HBox orderButtonBox = new HBox(3.0);
        this.moveUpRestrictionButtom = DialogUtil.createButton(this.i18n.getString("RestrictionDialog.restriction.up.label", "\u25b2"), this.i18n.getString("RestrictionDialog.restriction.up.tooltip", "Move up (change order)"));
        this.moveDownRestrictionButtom = DialogUtil.createButton(this.i18n.getString("RestrictionDialog.restriction.down.label", "\u25bc"), this.i18n.getString("RestrictionDialog.restriction.down.tooltip", "Move down (change order)"));
        this.moveUpRestrictionButtom.setOnAction((EventHandler)restrictionEventHandler);
        this.moveDownRestrictionButtom.setOnAction((EventHandler)restrictionEventHandler);
        HBox.setHgrow((Node)this.moveUpRestrictionButtom, (Priority)Priority.NEVER);
        HBox.setHgrow((Node)this.moveDownRestrictionButtom, (Priority)Priority.NEVER);
        orderButtonBox.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        orderButtonBox.getChildren().addAll((Object[])new Node[]{this.moveUpRestrictionButtom, this.moveDownRestrictionButtom});
        ownerLabel.setLabelFor((Node)this.parameterOwner);
        equationLabel.setLabelFor((Node)this.latexLabel);
        restrictionTypeLabel.setLabelFor((Node)this.restrictionTypeLabel);
        descriptionLabel.setLabelFor((Node)this.descriptionTextField);
        Insets insetsLeft = new Insets(5.0, 7.0, 5.0, 5.0);
        Insets insetsRight = new Insets(5.0, 0.0, 5.0, 7.0);
        GridPane.setMargin(this.restrictionList, (Insets)new Insets(5.0, 10.0, 5.0, 0.0));
        GridPane.setMargin((Node)orderButtonBox, (Insets)new Insets(5.0, 10.0, 5.0, 0.0));
        GridPane.setMargin((Node)restrictionTypeLabel, (Insets)insetsLeft);
        GridPane.setMargin((Node)descriptionLabel, (Insets)insetsLeft);
        GridPane.setMargin((Node)equationLabel, (Insets)insetsLeft);
        GridPane.setMargin((Node)buttonBox, (Insets)insetsLeft);
        GridPane.setMargin((Node)ownerLabel, (Insets)insetsLeft);
        GridPane.setMargin((Node)this.restrictionTypeLabel, (Insets)insetsRight);
        GridPane.setMargin((Node)this.descriptionTextField, (Insets)insetsRight);
        GridPane.setMargin((Node)this.latexLabel, (Insets)insetsRight);
        GridPane.setMargin((Node)this.parameterOwner, (Insets)insetsRight);
        this.restrictionTypeLabel.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        restrictionTypeLabel.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        descriptionLabel.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        equationLabel.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        ownerLabel.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        noticeFlowPane.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        noticeFlowPane.setPrefSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        this.restrictionTypeLabel.setMaxWidth(Double.MAX_VALUE);
        restrictionTypeLabel.setMaxWidth(Double.MAX_VALUE);
        descriptionLabel.setMaxWidth(Double.MAX_VALUE);
        equationLabel.setMaxWidth(Double.MAX_VALUE);
        ownerLabel.setMaxWidth(Double.MAX_VALUE);
        Region spacer = new Region();
        GridPane.setHgrow((Node)equationLabel, (Priority)Priority.NEVER);
        GridPane.setHgrow((Node)restrictionTypeLabel, (Priority)Priority.NEVER);
        GridPane.setHgrow((Node)descriptionLabel, (Priority)Priority.NEVER);
        GridPane.setHgrow((Node)ownerLabel, (Priority)Priority.NEVER);
        GridPane.setHgrow((Node)this.latexLabel, (Priority)Priority.ALWAYS);
        GridPane.setHgrow((Node)this.restrictionTypeLabel, (Priority)Priority.ALWAYS);
        GridPane.setHgrow((Node)this.parameterOwner, (Priority)Priority.ALWAYS);
        GridPane.setHgrow(this.restrictionList, (Priority)Priority.SOMETIMES);
        GridPane.setHgrow((Node)buttonBox, (Priority)Priority.NEVER);
        GridPane.setHgrow((Node)orderButtonBox, (Priority)Priority.NEVER);
        GridPane.setHgrow((Node)noticeFlowPane, (Priority)Priority.ALWAYS);
        GridPane.setVgrow(this.restrictionList, (Priority)Priority.ALWAYS);
        GridPane.setVgrow((Node)this.latexLabel, (Priority)Priority.NEVER);
        GridPane.setVgrow((Node)this.restrictionTypeLabel, (Priority)Priority.NEVER);
        GridPane.setVgrow((Node)buttonBox, (Priority)Priority.NEVER);
        GridPane.setVgrow((Node)orderButtonBox, (Priority)Priority.NEVER);
        GridPane.setHgrow((Node)noticeFlowPane, (Priority)Priority.NEVER);
        GridPane.setHgrow((Node)spacer, (Priority)Priority.ALWAYS);
        GridPane.setVgrow((Node)spacer, (Priority)Priority.ALWAYS);
        GridPane.setValignment((Node)equationLabel, (VPos)VPos.TOP);
        int row = 0;
        gridPane.add((Node)ownerLabel, 1, row);
        gridPane.add((Node)this.parameterOwner, 2, row++);
        gridPane.add((Node)equationLabel, 1, row);
        gridPane.add((Node)this.latexLabel, 2, row++);
        gridPane.add((Node)restrictionTypeLabel, 1, row);
        gridPane.add((Node)this.restrictionTypeLabel, 2, row++);
        gridPane.add((Node)descriptionLabel, 1, row);
        gridPane.add((Node)this.descriptionTextField, 2, row++);
        gridPane.add((Node)noticeFlowPane, 1, row++, 2, 1);
        gridPane.add((Node)spacer, 1, row++, 2, 1);
        gridPane.add((Node)buttonBox, 1, row++);
        gridPane.add(this.restrictionList, 0, 0, 1, row++);
        gridPane.add((Node)orderButtonBox, 0, row);
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                RestrictionDialog.this.restrictionList.requestFocus();
                if (RestrictionDialog.this.restrictionList.getItems().size() > 0) {
                    RestrictionDialog.this.restrictionList.getSelectionModel().clearAndSelect(0);
                    RestrictionDialog.this.setRestriction((Restriction)RestrictionDialog.this.restrictionList.getItems().get(0));
                }
            }
        });
        return gridPane;
    }

    private ListView<Restriction> createRestrictionListView() {
        ListView list = new ListView();
        list.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<Restriction>(){

            public void changed(ObservableValue<? extends Restriction> observable, Restriction oldValue, Restriction newValue) {
                RestrictionDialog.this.setRestriction(newValue);
            }
        });
        list.setCellFactory((Callback)new Callback<ListView<Restriction>, ListCell<Restriction>>(){

            public ListCell<Restriction> call(ListView<Restriction> listView) {
                return new ListCell<Restriction>(){

                    protected void updateItem(Restriction restriction, boolean empty) {
                        super.updateItem((Object)restriction, empty);
                        if (empty || restriction == null) {
                            this.setText(null);
                        } else {
                            this.setText(RestrictionTypeDialog.getRestrictionTypeLabel(restriction.getRestrictionType()));
                        }
                    }
                };
            }
        });
        list.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        list.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        list.getSelectionModel().setSelectionMode(SelectionMode.SINGLE);
        ListView placeholderList = new ListView();
        placeholderList.getItems().add((Object)new String());
        placeholderList.setDisable(true);
        list.setPlaceholder((Node)placeholderList);
        return list;
    }

    private void editRestriction(Restriction restriction) {
        RestrictionType restrictionType = restriction.getRestrictionType();
        switch (restrictionType) {
            case AVERAGE: {
                AverageRestrictionDialog.showAndWait(this.filteredUnknownParameters, (AverageRestriction)restriction);
                break;
            }
            case PRODUCT_SUM: {
                ProductSumRestrictionDialog.showAndWait(this.filteredUnknownParameters, (ProductSumRestriction)restriction);
                break;
            }
            case FEATURE_POINT: {
                FeaturePointRestrictionDialog.showAndWait(this.feature.getGeometricPrimitives(), (ObservableList<FeaturePoint>)UIPointTableBuilder.getInstance().getTable().getItems(), (FeaturePointRestriction)restriction);
                break;
            }
            case VECTOR_ANGLE: {
                VectorAngleRestrictionDialog.showAndWait(this.filteredUnknownParameters, (VectorAngleRestriction)restriction);
                break;
            }
            case TRIGONOMERTIC_FUNCTION: {
                TrigonometricRestrictionDialog.showAndWait(this.filteredUnknownParameters, (TrigonometricRestriction)restriction);
            }
        }
    }

    private void removeRestriction(Restriction restriction) {
        if (restriction.isIndispensable()) {
            return;
        }
        this.restrictionList.getItems().remove((Object)restriction);
        this.removeRestrictionButton.setDisable(this.restrictionList.getItems().size() == 0 || this.restrictionList.getItems().size() > 0 && this.restrictionList.getSelectionModel().getSelectedItem() != null && ((Restriction)this.restrictionList.getSelectionModel().getSelectedItem()).isIndispensable());
    }

    private Restriction createRestriction(RestrictionType restrictionType) {
        switch (restrictionType) {
            case AVERAGE: {
                return new AverageRestriction();
            }
            case PRODUCT_SUM: {
                return new ProductSumRestriction();
            }
            case FEATURE_POINT: {
                return new FeaturePointRestriction();
            }
            case VECTOR_ANGLE: {
                return new VectorAngleRestriction();
            }
            case TRIGONOMERTIC_FUNCTION: {
                return new TrigonometricRestriction();
            }
        }
        return null;
    }

    private void setUnknownParameters(ObservableList<UnknownParameter> unknownParameters) {
        if (unknownParameters != null) {
            this.filteredUnknownParameters = new FilteredList(unknownParameters, (Predicate)new PostProcessingPredicate());
        }
    }

    private void setFeature(Feature feature, boolean enablePostProcessing) {
        this.enablePostProcessing = enablePostProcessing;
        this.feature = feature;
        if (this.feature != null) {
            if (enablePostProcessing) {
                this.setUnknownParameters(feature.getUnknownParameters());
                this.setEquations(feature.getPostProcessingCalculations());
            } else {
                this.setUnknownParameters(feature.getUnknownParameters());
                this.setEquations(feature.getRestrictions());
            }
        }
    }

    private void setEquations(ObservableList<Restriction> equations) {
        if (equations != null) {
            this.editRestrictionButton.setDisable(equations.size() == 0);
            this.removeRestrictionButton.setDisable(equations.size() == 0);
            this.restrictionList.setItems(equations);
            this.restrictionList.requestFocus();
            if (this.restrictionList.getItems().size() > 0) {
                this.setRestriction((Restriction)this.restrictionList.getItems().get(0));
                this.restrictionList.getSelectionModel().clearAndSelect(0);
            }
        }
    }

    private class PostProcessingPredicate
    implements Predicate<UnknownParameter> {
        private PostProcessingPredicate() {
        }

        @Override
        public boolean test(UnknownParameter unknownParameter) {
            return RestrictionDialog.this.enablePostProcessing || unknownParameter.getProcessingType() != ProcessingType.POSTPROCESSING;
        }
    }

    private class RestrictionEventHandler
    implements EventHandler<ActionEvent> {
        private RestrictionEventHandler() {
        }

        public void handle(ActionEvent event) {
            int index;
            if (event.getSource() == RestrictionDialog.this.addRestrictionButton) {
                Optional<RestrictionType> optional = RestrictionTypeDialog.showAndWait();
                if (optional.isPresent()) {
                    RestrictionType restrictionType = optional.get();
                    if (restrictionType == null) {
                        return;
                    }
                    Restriction restriction = RestrictionDialog.this.createRestriction(restrictionType);
                    if (restriction == null) {
                        return;
                    }
                    RestrictionDialog.this.restrictionList.getItems().add((Object)restriction);
                    RestrictionDialog.this.restrictionList.getSelectionModel().clearSelection();
                    RestrictionDialog.this.restrictionList.getSelectionModel().select((Object)restriction);
                    RestrictionDialog.this.editRestriction(restriction);
                    RestrictionDialog.this.editRestrictionButton.setDisable(RestrictionDialog.this.restrictionList.getItems().size() == 0);
                    RestrictionDialog.this.removeRestrictionButton.setDisable(RestrictionDialog.this.restrictionList.getItems().size() == 0);
                }
            } else if (event.getSource() == RestrictionDialog.this.editRestrictionButton) {
                Restriction restriction = (Restriction)RestrictionDialog.this.restrictionList.getSelectionModel().getSelectedItem();
                if (restriction != null) {
                    RestrictionDialog.this.editRestriction(restriction);
                }
            } else if (event.getSource() == RestrictionDialog.this.removeRestrictionButton) {
                Restriction restriction = (Restriction)RestrictionDialog.this.restrictionList.getSelectionModel().getSelectedItem();
                if (restriction != null) {
                    RestrictionDialog.this.removeRestriction(restriction);
                }
            } else if (event.getSource() == RestrictionDialog.this.moveUpRestrictionButtom) {
                int index2 = RestrictionDialog.this.restrictionList.getSelectionModel().getSelectedIndex();
                if (index2 > 0) {
                    Restriction dummyElement = RestrictionDialog.this.createRestriction(((Restriction)RestrictionDialog.this.restrictionList.getSelectionModel().getSelectedItem()).getRestrictionType());
                    Restriction firstElement = (Restriction)RestrictionDialog.this.restrictionList.getItems().set(index2, (Object)dummyElement);
                    Restriction secondElement = (Restriction)RestrictionDialog.this.restrictionList.getItems().set(index2 - 1, (Object)firstElement);
                    RestrictionDialog.this.restrictionList.getItems().set(index2, (Object)secondElement);
                    RestrictionDialog.this.restrictionList.getSelectionModel().clearAndSelect(index2 - 1);
                }
            } else if (event.getSource() == RestrictionDialog.this.moveDownRestrictionButtom && (index = RestrictionDialog.this.restrictionList.getSelectionModel().getSelectedIndex()) < RestrictionDialog.this.restrictionList.getItems().size() - 1) {
                Restriction dummyElement = RestrictionDialog.this.createRestriction(((Restriction)RestrictionDialog.this.restrictionList.getSelectionModel().getSelectedItem()).getRestrictionType());
                Restriction firstElement = (Restriction)RestrictionDialog.this.restrictionList.getItems().set(index, (Object)dummyElement);
                Restriction secondElement = (Restriction)RestrictionDialog.this.restrictionList.getItems().set(index + 1, (Object)firstElement);
                RestrictionDialog.this.restrictionList.getItems().set(index, (Object)secondElement);
                RestrictionDialog.this.restrictionList.getSelectionModel().clearAndSelect(index + 1);
            }
        }
    }
}

