/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.juniform.ui.dialog;

import java.util.Optional;
import javafx.application.Platform;
import javafx.collections.ObservableList;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.TableView;
import javafx.scene.layout.VBox;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.util.Callback;
import org.applied_geodesy.adjustment.statistic.TestStatisticParameterSet;
import org.applied_geodesy.adjustment.statistic.TestStatisticParameters;
import org.applied_geodesy.juniform.ui.i18n.I18N;
import org.applied_geodesy.juniform.ui.table.UIQuantileTableBuilder;

public class QuantilesDialog {
    private static I18N i18N = I18N.getInstance();
    private static QuantilesDialog quantilesDialog = new QuantilesDialog();
    private Dialog<Void> dialog = null;
    private Window window;
    private VBox contentPane;
    private ObservableList<TestStatisticParameterSet> tableModel;

    private QuantilesDialog() {
    }

    public static void setOwner(Window owner) {
        QuantilesDialog.quantilesDialog.window = owner;
    }

    public static Optional<Void> showAndWait(TestStatisticParameters testStatisticParameters) {
        quantilesDialog.init();
        quantilesDialog.setTestStatisticParameters(testStatisticParameters);
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    QuantilesDialog.quantilesDialog.dialog.getDialogPane().requestLayout();
                    Stage stage = (Stage)QuantilesDialog.quantilesDialog.dialog.getDialogPane().getScene().getWindow();
                    stage.sizeToScene();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        return QuantilesDialog.quantilesDialog.dialog.showAndWait();
    }

    private void setTestStatisticParameters(TestStatisticParameters testStatisticParameters) {
        if (testStatisticParameters != null) {
            Object[] quantiles = testStatisticParameters.getTestStatisticParameterSets();
            this.tableModel.setAll(quantiles);
            this.contentPane.setPrefHeight(this.contentPane.getMinHeight() + (double)(quantiles.length * 30));
        } else {
            this.tableModel.clear();
        }
    }

    private void init() {
        if (this.dialog != null) {
            return;
        }
        this.contentPane = this.createPane();
        this.dialog = new Dialog();
        this.dialog.setTitle(i18N.getString("QuantilesDialog.title", "Quantiles of Fisher distribution"));
        this.dialog.setHeaderText(i18N.getString("QuantilesDialog.header", "Adjusted quantiles of Fisher distribution"));
        this.dialog.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{ButtonType.CLOSE});
        this.dialog.initModality(Modality.APPLICATION_MODAL);
        this.dialog.initOwner(this.window);
        this.dialog.getDialogPane().setContent((Node)this.contentPane);
        this.dialog.setResizable(true);
        this.dialog.setResultConverter((Callback)new Callback<ButtonType, Void>(){

            public Void call(ButtonType buttonType) {
                return null;
            }
        });
    }

    private VBox createPane() {
        TableView quantileTableView = UIQuantileTableBuilder.getInstance().getTable();
        this.tableModel = UIQuantileTableBuilder.getInstance().getTableModel(quantileTableView);
        VBox contentPane = new VBox();
        contentPane.setPadding(new Insets(5.0, 10.0, 5.0, 10.0));
        contentPane.getChildren().setAll((Object[])new Node[]{quantileTableView});
        contentPane.setMinHeight(75.0);
        return contentPane;
    }
}

