/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.juniform.ui.dialog;

import java.util.Collections;
import java.util.Optional;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.control.ListView;
import javafx.scene.control.TextField;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.util.Callback;
import javafx.util.StringConverter;
import org.applied_geodesy.adjustment.geometry.parameter.UnknownParameter;
import org.applied_geodesy.adjustment.geometry.restriction.ProductSumRestriction;
import org.applied_geodesy.juniform.ui.dialog.DialogUtil;
import org.applied_geodesy.juniform.ui.dialog.UnknownParameterDialog;
import org.applied_geodesy.juniform.ui.i18n.I18N;
import org.applied_geodesy.ui.tex.LaTexLabel;
import org.applied_geodesy.ui.textfield.DoubleTextField;
import org.applied_geodesy.util.CellValueType;

public class ProductSumRestrictionDialog {
    private static I18N i18N = I18N.getInstance();
    private static ProductSumRestrictionDialog restrictionTypeDialog = new ProductSumRestrictionDialog();
    private Dialog<ProductSumRestriction> dialog = null;
    private LaTexLabel latexLabel;
    private ComboBox<UnknownParameter> regressorAComboBox;
    private ComboBox<UnknownParameter> regressorBComboBox;
    private ListView<ProductSumRestriction.SignType> signTypeListView;
    private ListView<UnknownParameter> regressorAListView;
    private ListView<UnknownParameter> regressorBListView;
    private Button addParameterAButtom;
    private Button removeParameterAButtom;
    private Button moveUpParameterAButtom;
    private Button moveDownParameterAButtom;
    private Button addParameterBButtom;
    private Button removeParameterBButtom;
    private Button moveUpParameterBButtom;
    private Button moveDownParameterBButtom;
    private DoubleTextField exponentTextField;
    private ComboBox<UnknownParameter> regressandComboBox;
    private TextField descriptionTextField;
    private Window window;
    private ProductSumRestriction restriction;

    private ProductSumRestrictionDialog() {
    }

    public static void setOwner(Window owner) {
        ProductSumRestrictionDialog.restrictionTypeDialog.window = owner;
    }

    public static Optional<ProductSumRestriction> showAndWait(ObservableList<UnknownParameter> unknownParameters, ProductSumRestriction productSumRestriction) {
        restrictionTypeDialog.init();
        restrictionTypeDialog.setUnknownParameters(unknownParameters);
        restrictionTypeDialog.setRestriction(productSumRestriction);
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    ProductSumRestrictionDialog.restrictionTypeDialog.dialog.getDialogPane().requestLayout();
                    Stage stage = (Stage)ProductSumRestrictionDialog.restrictionTypeDialog.dialog.getDialogPane().getScene().getWindow();
                    stage.sizeToScene();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        return ProductSumRestrictionDialog.restrictionTypeDialog.dialog.showAndWait();
    }

    private void setUnknownParameters(ObservableList<UnknownParameter> unknownParameters) {
        ObservableList unknownParameterList = FXCollections.observableArrayList(unknownParameters);
        this.regressorAComboBox.setItems(unknownParameterList);
        this.regressorBComboBox.setItems(unknownParameterList);
        this.regressandComboBox.setItems(unknownParameterList);
    }

    private void setRestriction(ProductSumRestriction restriction) {
        this.moveUpParameterAButtom.setDisable(true);
        this.moveDownParameterAButtom.setDisable(true);
        this.moveUpParameterBButtom.setDisable(true);
        this.moveDownParameterBButtom.setDisable(true);
        if (this.restriction != null) {
            this.exponentTextField.numberProperty().unbindBidirectional(this.restriction.exponentProperty());
            this.descriptionTextField.textProperty().unbindBidirectional(this.restriction.descriptionProperty());
            this.regressandComboBox.valueProperty().unbindBidirectional(this.restriction.regressandProperty());
            this.signTypeListView.setItems(FXCollections.emptyObservableList());
            this.regressorAListView.setItems(FXCollections.emptyObservableList());
            this.regressorBListView.setItems(FXCollections.emptyObservableList());
        }
        this.restriction = restriction;
        this.descriptionTextField.textProperty().bindBidirectional(this.restriction.descriptionProperty());
        this.exponentTextField.numberProperty().bindBidirectional(this.restriction.exponentProperty());
        this.regressandComboBox.valueProperty().bindBidirectional(this.restriction.regressandProperty());
        this.signTypeListView.setItems(this.restriction.getCoefficientSigns());
        this.regressorAListView.setItems(this.restriction.getRegressorsA());
        this.regressorBListView.setItems(this.restriction.getRegressorsB());
        this.latexLabel.setTex(this.restriction.toLaTex());
        this.exponentTextField.setValue(this.restriction.getExponent());
        this.exponentTextField.setDisable(restriction.isIndispensable());
        this.signTypeListView.setDisable(restriction.isIndispensable());
        this.regressorAListView.setDisable(restriction.isIndispensable());
        this.regressorBListView.setDisable(restriction.isIndispensable());
        this.regressorAComboBox.setDisable(restriction.isIndispensable());
        this.regressorBComboBox.setDisable(restriction.isIndispensable());
        this.regressandComboBox.setDisable(restriction.isIndispensable());
        this.addParameterAButtom.setDisable(restriction.isIndispensable());
        this.removeParameterAButtom.setDisable(restriction.isIndispensable());
        this.moveUpParameterAButtom.setDisable(restriction.isIndispensable());
        this.moveDownParameterAButtom.setDisable(restriction.isIndispensable());
        this.addParameterBButtom.setDisable(restriction.isIndispensable());
        this.removeParameterBButtom.setDisable(restriction.isIndispensable());
        this.moveUpParameterBButtom.setDisable(restriction.isIndispensable());
        this.moveDownParameterBButtom.setDisable(restriction.isIndispensable());
        if (!restriction.isIndispensable()) {
            UnknownParameter regressand = this.restriction.getRegressand();
            if (regressand == null) {
                this.regressandComboBox.getSelectionModel().clearAndSelect(0);
            }
            this.regressorAComboBox.getSelectionModel().clearAndSelect(0);
            this.regressorBComboBox.getSelectionModel().clearAndSelect(0);
        } else {
            this.regressorAComboBox.getSelectionModel().clearSelection();
            this.regressorBComboBox.getSelectionModel().clearSelection();
        }
    }

    private void init() {
        if (this.dialog != null) {
            return;
        }
        this.dialog = new Dialog();
        this.dialog.setTitle(i18N.getString("ProductSumRestrictionDialog.title", "Product sum restriction"));
        this.dialog.setHeaderText(i18N.getString("ProductSumRestrictionDialog.header", "k-th Power of product sum"));
        this.dialog.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{ButtonType.OK});
        this.dialog.initModality(Modality.APPLICATION_MODAL);
        this.dialog.initOwner(this.window);
        this.dialog.getDialogPane().setContent(this.createPane());
        this.dialog.setResizable(true);
        this.dialog.setResultConverter((Callback)new Callback<ButtonType, ProductSumRestriction>(){

            public ProductSumRestriction call(ButtonType buttonType) {
                if (buttonType == ButtonType.OK) {
                    return ProductSumRestrictionDialog.this.restriction;
                }
                return null;
            }
        });
    }

    private Node createPane() {
        GridPane gridPane = DialogUtil.createGridPane();
        Label equationLabel = new Label(i18N.getString("ProductSumRestrictionDialog.equation.label", "Equation:"));
        Label exponentLabel = new Label(i18N.getString("ProductSumRestrictionDialog.exponent.label", "Exponent k:"));
        Label descriptionLabel = new Label(i18N.getString("ProductSumRestrictionDialog.description.label", "Description:"));
        Label regressandLabel = new Label(i18N.getString("ProductSumRestrictionDialog.regressand.label", "Regressand c:"));
        Label regressorALabel = new Label(i18N.getString("ProductSumRestrictionDialog.regressor.a.label", "Regressor a:"));
        Label regressorBLabel = new Label(i18N.getString("ProductSumRestrictionDialog.regressor.b.label", "Regressor b:"));
        regressorALabel.setPrefSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        regressorALabel.setMaxWidth(Double.MAX_VALUE);
        regressorBLabel.setPrefSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        regressorBLabel.setMaxWidth(Double.MAX_VALUE);
        this.exponentTextField = DialogUtil.createDoubleTextField(CellValueType.DOUBLE, 1.0, Boolean.FALSE, DoubleTextField.ValueSupport.NON_NULL_VALUE_SUPPORT, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, i18N.getString("ProductSumRestrictionDialog.exponent.tooltip", "Select exponent k"));
        this.descriptionTextField = DialogUtil.createTextField(i18N.getString("ProductSumRestrictionDialog.description.tooltip", "Description of parameter restriction"), i18N.getString("ProductSumRestrictionDialog.description.prompt", "Restriction description"));
        this.signTypeListView = DialogUtil.createSignTypeListView(ProductSumRestrictionDialog.createSignTypeStringConverter());
        this.signTypeListView.setPrefWidth(50.0);
        this.regressorAComboBox = DialogUtil.createUnknownParameterComboBox(UnknownParameterDialog.createUnknownParameterCellFactory(), i18N.getString("ProductSumRestrictionDialog.regressor.a.tooltip", "Select regressor a"));
        this.regressorBComboBox = DialogUtil.createUnknownParameterComboBox(UnknownParameterDialog.createUnknownParameterCellFactory(), i18N.getString("ProductSumRestrictionDialog.regressor.b.tooltip", "Select regressor b"));
        this.regressandComboBox = DialogUtil.createUnknownParameterComboBox(UnknownParameterDialog.createUnknownParameterCellFactory(), i18N.getString("ProductSumRestrictionDialog.regressand.tooltip", "Select regressand c"));
        this.latexLabel = new LaTexLabel();
        this.latexLabel.setPrefSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        this.latexLabel.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        this.regressorAListView = DialogUtil.createParameterListView(UnknownParameterDialog.createUnknownParameterCellFactory());
        this.regressorBListView = DialogUtil.createParameterListView(UnknownParameterDialog.createUnknownParameterCellFactory());
        RegressorEventHandler regressorEventHandler = new RegressorEventHandler();
        this.addParameterAButtom = DialogUtil.createButton(i18N.getString("ProductSumRestrictionDialog.regressor.a.add.label", "+"), i18N.getString("ProductSumRestrictionDialog.regressor.a.add.tooltip", "Add parameter to regressor list"));
        this.removeParameterAButtom = DialogUtil.createButton(i18N.getString("ProductSumRestrictionDialog.regressor.a.remove.label", "-"), i18N.getString("ProductSumRestrictionDialog.regressor.a.remove.tooltip", "Remove regressor"));
        this.moveUpParameterAButtom = DialogUtil.createButton(i18N.getString("ProductSumRestrictionDialog.regressor.a.up.label", "\u25b2"), i18N.getString("ProductSumRestrictionDialog.regressor.a.up.tooltip", "Move up (change order)"));
        this.moveDownParameterAButtom = DialogUtil.createButton(i18N.getString("ProductSumRestrictionDialog.regressor.a.down.label", "\u25bc"), i18N.getString("ProductSumRestrictionDialog.regressor.a.down.tooltip", "Move down (change order)"));
        this.addParameterAButtom.setOnAction((EventHandler)regressorEventHandler);
        this.removeParameterAButtom.setOnAction((EventHandler)regressorEventHandler);
        this.moveUpParameterAButtom.setOnAction((EventHandler)regressorEventHandler);
        this.moveDownParameterAButtom.setOnAction((EventHandler)regressorEventHandler);
        HBox buttonBoxA = new HBox(5.0);
        HBox.setHgrow((Node)this.addParameterAButtom, (Priority)Priority.NEVER);
        HBox.setHgrow((Node)this.removeParameterAButtom, (Priority)Priority.NEVER);
        HBox.setHgrow((Node)this.moveUpParameterAButtom, (Priority)Priority.NEVER);
        HBox.setHgrow((Node)this.moveDownParameterAButtom, (Priority)Priority.NEVER);
        buttonBoxA.getChildren().addAll((Object[])new Node[]{this.addParameterAButtom, this.removeParameterAButtom, this.moveUpParameterAButtom, this.moveDownParameterAButtom});
        this.addParameterBButtom = DialogUtil.createButton(i18N.getString("ProductSumRestrictionDialog.regressor.b.add.label", "+"), i18N.getString("ProductSumRestrictionDialog.regressor.b.add.tooltip", "Add parameter to regressor list"));
        this.removeParameterBButtom = DialogUtil.createButton(i18N.getString("ProductSumRestrictionDialog.regressor.b.remove.label", "-"), i18N.getString("ProductSumRestrictionDialog.regressor.b.remove.tooltip", "Remove regressor"));
        this.moveUpParameterBButtom = DialogUtil.createButton(i18N.getString("ProductSumRestrictionDialog.regressor.b.up.label", "\u25b2"), i18N.getString("ProductSumRestrictionDialog.regressor.b.up.tooltip", "Move up (change order)"));
        this.moveDownParameterBButtom = DialogUtil.createButton(i18N.getString("ProductSumRestrictionDialog.regressor.b.down.label", "\u25bc"), i18N.getString("ProductSumRestrictionDialog.regressor.b.down.tooltip", "Move down (change order)"));
        this.addParameterBButtom.setOnAction((EventHandler)regressorEventHandler);
        this.removeParameterBButtom.setOnAction((EventHandler)regressorEventHandler);
        this.moveUpParameterBButtom.setOnAction((EventHandler)regressorEventHandler);
        this.moveDownParameterBButtom.setOnAction((EventHandler)regressorEventHandler);
        HBox buttonBoxB = new HBox(5.0);
        HBox.setHgrow((Node)this.addParameterBButtom, (Priority)Priority.NEVER);
        HBox.setHgrow((Node)this.removeParameterBButtom, (Priority)Priority.NEVER);
        HBox.setHgrow((Node)this.moveUpParameterBButtom, (Priority)Priority.NEVER);
        HBox.setHgrow((Node)this.moveDownParameterBButtom, (Priority)Priority.NEVER);
        buttonBoxB.getChildren().addAll((Object[])new Node[]{this.addParameterBButtom, this.removeParameterBButtom, this.moveUpParameterBButtom, this.moveDownParameterBButtom});
        this.regressorAListView.getSelectionModel().selectedIndexProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                ProductSumRestrictionDialog.this.moveUpParameterAButtom.setDisable(newValue == null || newValue.intValue() == 0);
                ProductSumRestrictionDialog.this.moveDownParameterAButtom.setDisable(newValue == null || newValue.intValue() == ProductSumRestrictionDialog.this.regressorAListView.getItems().size() - 1);
            }
        });
        this.regressorBListView.getSelectionModel().selectedIndexProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                ProductSumRestrictionDialog.this.moveUpParameterBButtom.setDisable(newValue == null || newValue.intValue() == 0);
                ProductSumRestrictionDialog.this.moveDownParameterBButtom.setDisable(newValue == null || newValue.intValue() == ProductSumRestrictionDialog.this.regressorBListView.getItems().size() - 1);
            }
        });
        exponentLabel.setLabelFor((Node)this.exponentTextField);
        equationLabel.setLabelFor((Node)this.latexLabel);
        descriptionLabel.setLabelFor((Node)this.descriptionTextField);
        regressandLabel.setLabelFor(this.regressandComboBox);
        regressorALabel.setLabelFor(this.regressorAComboBox);
        regressorBLabel.setLabelFor(this.regressorBComboBox);
        regressorALabel.setAlignment(Pos.TOP_CENTER);
        regressorBLabel.setAlignment(Pos.TOP_CENTER);
        GridPane.setHgrow((Node)exponentLabel, (Priority)Priority.NEVER);
        GridPane.setHgrow((Node)equationLabel, (Priority)Priority.NEVER);
        GridPane.setHgrow((Node)descriptionLabel, (Priority)Priority.NEVER);
        GridPane.setHgrow((Node)regressandLabel, (Priority)Priority.NEVER);
        GridPane.setVgrow((Node)regressorALabel, (Priority)Priority.NEVER);
        GridPane.setVgrow((Node)regressorBLabel, (Priority)Priority.NEVER);
        GridPane.setHgrow((Node)this.latexLabel, (Priority)Priority.ALWAYS);
        GridPane.setHgrow(this.regressorAComboBox, (Priority)Priority.ALWAYS);
        GridPane.setHgrow(this.regressorBComboBox, (Priority)Priority.ALWAYS);
        GridPane.setVgrow(this.regressorAComboBox, (Priority)Priority.NEVER);
        GridPane.setVgrow(this.regressorBComboBox, (Priority)Priority.NEVER);
        GridPane.setHgrow((Node)this.exponentTextField, (Priority)Priority.ALWAYS);
        GridPane.setHgrow((Node)this.descriptionTextField, (Priority)Priority.ALWAYS);
        GridPane.setHgrow(this.regressandComboBox, (Priority)Priority.ALWAYS);
        GridPane.setHgrow(this.regressorAListView, (Priority)Priority.ALWAYS);
        GridPane.setVgrow(this.regressorAListView, (Priority)Priority.ALWAYS);
        GridPane.setHgrow(this.regressorBListView, (Priority)Priority.ALWAYS);
        GridPane.setVgrow(this.regressorBListView, (Priority)Priority.ALWAYS);
        GridPane.setHgrow(this.signTypeListView, (Priority)Priority.NEVER);
        GridPane.setVgrow(this.signTypeListView, (Priority)Priority.ALWAYS);
        GridPane regressorsPane = DialogUtil.createGridPane();
        regressorsPane.setPrefHeight(200.0);
        regressorsPane.setHgap(10.0);
        regressorsPane.setVgap(5.0);
        regressorsPane.setPadding(new Insets(0.0, 0.0, 0.0, 0.0));
        int row = 0;
        regressorsPane.add((Node)regressorALabel, 1, row);
        regressorsPane.add((Node)regressorBLabel, 2, row++);
        regressorsPane.add(this.regressorAComboBox, 1, row);
        regressorsPane.add(this.regressorBComboBox, 2, row++);
        regressorsPane.add(this.signTypeListView, 0, row);
        regressorsPane.add(this.regressorAListView, 1, row);
        regressorsPane.add(this.regressorBListView, 2, row++);
        regressorsPane.add((Node)buttonBoxA, 1, row);
        regressorsPane.add((Node)buttonBoxB, 2, row);
        Insets insetsLeft = new Insets(5.0, 7.0, 5.0, 5.0);
        Insets insetsRight = new Insets(5.0, 0.0, 5.0, 7.0);
        GridPane.setMargin((Node)exponentLabel, (Insets)insetsLeft);
        GridPane.setMargin((Node)equationLabel, (Insets)insetsLeft);
        GridPane.setMargin((Node)regressandLabel, (Insets)insetsLeft);
        GridPane.setMargin((Node)descriptionLabel, (Insets)insetsLeft);
        GridPane.setMargin((Node)this.exponentTextField, (Insets)insetsRight);
        GridPane.setMargin((Node)this.latexLabel, (Insets)insetsRight);
        GridPane.setMargin(this.regressandComboBox, (Insets)insetsRight);
        GridPane.setMargin((Node)this.descriptionTextField, (Insets)insetsRight);
        GridPane.setMargin((Node)regressorsPane, (Insets)new Insets(10.0, 5.0, 5.0, 5.0));
        row = 0;
        gridPane.add((Node)equationLabel, 0, row);
        gridPane.add((Node)this.latexLabel, 1, row++);
        gridPane.add((Node)descriptionLabel, 0, row);
        gridPane.add((Node)this.descriptionTextField, 1, row++);
        gridPane.add((Node)regressandLabel, 0, row);
        gridPane.add(this.regressandComboBox, 1, row++);
        gridPane.add((Node)exponentLabel, 0, row);
        gridPane.add((Node)this.exponentTextField, 1, row++);
        gridPane.add((Node)regressorsPane, 0, row++, 2, 1);
        return gridPane;
    }

    static StringConverter<ProductSumRestriction.SignType> createSignTypeStringConverter() {
        return new StringConverter<ProductSumRestriction.SignType>(){

            public String toString(ProductSumRestriction.SignType signType) {
                if (signType == null) {
                    return null;
                }
                return signType.toString();
            }

            public ProductSumRestriction.SignType fromString(String string) {
                return string != null && string.equals("-") ? ProductSumRestriction.SignType.MINUS : ProductSumRestriction.SignType.PLUS;
            }
        };
    }

    private class RegressorEventHandler
    implements EventHandler<ActionEvent> {
        private RegressorEventHandler() {
        }

        public void handle(ActionEvent event) {
            int index;
            if (event.getSource() == ProductSumRestrictionDialog.this.addParameterAButtom) {
                UnknownParameter parameter = (UnknownParameter)ProductSumRestrictionDialog.this.regressorAComboBox.getValue();
                if (parameter != null) {
                    ProductSumRestrictionDialog.this.regressorAListView.getItems().add((Object)parameter);
                }
            } else if (event.getSource() == ProductSumRestrictionDialog.this.addParameterBButtom) {
                UnknownParameter parameter = (UnknownParameter)ProductSumRestrictionDialog.this.regressorBComboBox.getValue();
                if (parameter != null) {
                    ProductSumRestrictionDialog.this.regressorBListView.getItems().add((Object)parameter);
                }
            } else if (event.getSource() == ProductSumRestrictionDialog.this.removeParameterAButtom) {
                UnknownParameter parameter = (UnknownParameter)ProductSumRestrictionDialog.this.regressorAListView.getSelectionModel().getSelectedItem();
                if (parameter != null) {
                    ProductSumRestrictionDialog.this.regressorAListView.getItems().remove((Object)parameter);
                }
            } else if (event.getSource() == ProductSumRestrictionDialog.this.removeParameterBButtom) {
                UnknownParameter parameter = (UnknownParameter)ProductSumRestrictionDialog.this.regressorBListView.getSelectionModel().getSelectedItem();
                if (parameter != null) {
                    ProductSumRestrictionDialog.this.regressorBListView.getItems().remove((Object)parameter);
                }
            } else if (event.getSource() == ProductSumRestrictionDialog.this.moveUpParameterAButtom) {
                int index2 = ProductSumRestrictionDialog.this.regressorAListView.getSelectionModel().getSelectedIndex();
                if (index2 > 0) {
                    Collections.swap(ProductSumRestrictionDialog.this.regressorAListView.getItems(), index2, index2 - 1);
                }
            } else if (event.getSource() == ProductSumRestrictionDialog.this.moveDownParameterAButtom) {
                int index3 = ProductSumRestrictionDialog.this.regressorAListView.getSelectionModel().getSelectedIndex();
                if (index3 < ProductSumRestrictionDialog.this.regressorAListView.getItems().size() - 1) {
                    Collections.swap(ProductSumRestrictionDialog.this.regressorAListView.getItems(), index3, index3 + 1);
                }
            } else if (event.getSource() == ProductSumRestrictionDialog.this.moveUpParameterBButtom) {
                int index4 = ProductSumRestrictionDialog.this.regressorBListView.getSelectionModel().getSelectedIndex();
                if (index4 > 0) {
                    Collections.swap(ProductSumRestrictionDialog.this.regressorBListView.getItems(), index4, index4 - 1);
                }
            } else if (event.getSource() == ProductSumRestrictionDialog.this.moveDownParameterBButtom && (index = ProductSumRestrictionDialog.this.regressorBListView.getSelectionModel().getSelectedIndex()) < ProductSumRestrictionDialog.this.regressorBListView.getItems().size() - 1) {
                Collections.swap(ProductSumRestrictionDialog.this.regressorBListView.getItems(), index, index + 1);
            }
            if (ProductSumRestrictionDialog.this.regressorAListView.getItems().size() > ProductSumRestrictionDialog.this.signTypeListView.getItems().size() || ProductSumRestrictionDialog.this.regressorBListView.getItems().size() > ProductSumRestrictionDialog.this.signTypeListView.getItems().size()) {
                ProductSumRestrictionDialog.this.signTypeListView.getItems().add((Object)ProductSumRestriction.SignType.PLUS);
            }
            if (ProductSumRestrictionDialog.this.signTypeListView.getItems().size() > ProductSumRestrictionDialog.this.regressorAListView.getItems().size() && ProductSumRestrictionDialog.this.regressorAListView.getItems().size() > ProductSumRestrictionDialog.this.regressorBListView.getItems().size()) {
                ProductSumRestrictionDialog.this.signTypeListView.getItems().remove(0);
            }
        }
    }
}

