/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.juniform.ui.dialog;

import java.util.Locale;
import java.util.Optional;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.RadioButton;
import javafx.scene.control.TableView;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleGroup;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.util.Callback;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.MatrixEntry;
import no.uib.cipr.matrix.UpperSymmBandMatrix;
import no.uib.cipr.matrix.UpperSymmPackMatrix;
import org.applied_geodesy.adjustment.MathExtension;
import org.applied_geodesy.adjustment.geometry.point.FeaturePoint;
import org.applied_geodesy.juniform.ui.dialog.DialogUtil;
import org.applied_geodesy.juniform.ui.i18n.I18N;
import org.applied_geodesy.ui.dialog.OptionDialog;
import org.applied_geodesy.ui.textfield.DoubleTextField;
import org.applied_geodesy.util.CellValueType;

public class MatrixDialog {
    private I18N i18n = I18N.getInstance();
    private static MatrixDialog matrixDialog = new MatrixDialog();
    private Dialog<Void> dialog = null;
    private DoubleTextField[][] elements;
    private Window window;
    private FeaturePoint currentFeaturePoint;
    private TableView.TableViewSelectionModel<FeaturePoint> tableViewSelectionModel;
    private ToggleGroup matrixTypeToggleGroup;
    private Button previousButton = null;
    private Button nextButton = null;
    private MatrixType matrixType = null;

    private MatrixDialog() {
    }

    public static void setOwner(Window owner) {
        MatrixDialog.matrixDialog.window = owner;
    }

    public static Optional<Void> showAndWait(TableView.TableViewSelectionModel<FeaturePoint> tableViewSelectionModel) {
        MatrixDialog.matrixDialog.tableViewSelectionModel = tableViewSelectionModel;
        matrixDialog.init();
        matrixDialog.setSelectedFeaturePoint();
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    MatrixDialog.matrixDialog.dialog.getDialogPane().requestLayout();
                    Stage stage = (Stage)MatrixDialog.matrixDialog.dialog.getDialogPane().getScene().getWindow();
                    stage.sizeToScene();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        return MatrixDialog.matrixDialog.dialog.showAndWait();
    }

    private void init() {
        if (this.dialog != null) {
            return;
        }
        this.dialog = new Dialog();
        this.dialog.setTitle(this.i18n.getString("MatrixDialog.title", "Dispersion matrix"));
        this.dialog.setHeaderText(String.format(Locale.ENGLISH, this.i18n.getString("MatrixDialog.header", "Dispersion of point %s"), ""));
        this.dialog.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{ButtonType.PREVIOUS, ButtonType.NEXT, ButtonType.OK, ButtonType.CLOSE});
        this.dialog.initModality(Modality.APPLICATION_MODAL);
        this.dialog.initOwner(this.window);
        this.dialog.getDialogPane().setContent(this.createPane());
        this.dialog.setResizable(true);
        Node closeButton = this.dialog.getDialogPane().lookupButton(ButtonType.CLOSE);
        closeButton.managedProperty().bind((ObservableValue)closeButton.visibleProperty());
        closeButton.setVisible(false);
        this.previousButton = (Button)this.dialog.getDialogPane().lookupButton(ButtonType.PREVIOUS);
        this.previousButton.addEventFilter(ActionEvent.ACTION, (EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                event.consume();
                MatrixDialog.this.changeFeaturePoint(false);
            }
        });
        this.nextButton = (Button)this.dialog.getDialogPane().lookupButton(ButtonType.NEXT);
        this.nextButton.addEventFilter(ActionEvent.ACTION, (EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                event.consume();
                MatrixDialog.this.changeFeaturePoint(true);
            }
        });
        this.dialog.setResultConverter((Callback)new Callback<ButtonType, Void>(){

            public Void call(ButtonType buttonType) {
                if (buttonType == ButtonType.OK) {
                    MatrixDialog.this.setMatrix();
                }
                return null;
            }
        });
    }

    private void setSelectedFeaturePoint() {
        int numberOfPointPairs = this.tableViewSelectionModel.getTableView().getItems().size();
        if (numberOfPointPairs <= 0) {
            return;
        }
        FeaturePoint featurePoint = (FeaturePoint)this.tableViewSelectionModel.getSelectedItem();
        if (featurePoint == null) {
            this.tableViewSelectionModel.clearAndSelect(0);
            featurePoint = (FeaturePoint)this.tableViewSelectionModel.getSelectedItem();
        }
        if (featurePoint != null) {
            int index = this.tableViewSelectionModel.getSelectedIndex();
            this.tableViewSelectionModel.clearAndSelect(index);
            this.setFeaturePoint(featurePoint);
            this.previousButton.setDisable(index <= 0);
            this.nextButton.setDisable(index + 1 >= numberOfPointPairs);
        }
    }

    private void changeFeaturePoint(boolean next) {
        this.setMatrix();
        if (next) {
            this.tableViewSelectionModel.selectNext();
        } else {
            this.tableViewSelectionModel.selectPrevious();
        }
        this.setSelectedFeaturePoint();
    }

    private void setFeaturePoint(FeaturePoint featurePoint) {
        this.currentFeaturePoint = featurePoint;
        this.dialog.setHeaderText(String.format(Locale.ENGLISH, this.i18n.getString("MatrixDialog.header", "Dispersion of point %s"), this.currentFeaturePoint.getName()));
        Matrix matrix = this.currentFeaturePoint.getDispersionApriori();
        this.matrixType = matrix instanceof UpperSymmPackMatrix ? MatrixType.DENSE : (matrix instanceof UpperSymmBandMatrix ? MatrixType.DIAGONAL : MatrixType.IDENTITY);
        for (Toggle toggle : this.matrixTypeToggleGroup.getToggles()) {
            if (toggle.getUserData() != this.matrixType) continue;
            toggle.setSelected(true);
            break;
        }
        int i = 0;
        while (i < 3) {
            int j = 0;
            while (j < 3) {
                if (i < matrix.numRows() && j < matrix.numColumns()) {
                    this.elements[i][j].setVisible(true);
                    this.elements[i][j].setManaged(true);
                    if (i <= j) {
                        this.elements[i][j].setValue(matrix.get(i, j));
                    }
                    if (this.matrixType == MatrixType.IDENTITY) {
                        this.elements[i][j].setDisable(true);
                    } else if (this.matrixType == MatrixType.DIAGONAL) {
                        this.elements[i][j].setDisable(i != j);
                    } else {
                        this.elements[i][j].setDisable(i > j);
                    }
                } else {
                    this.elements[i][j].setVisible(false);
                    this.elements[i][j].setManaged(false);
                }
                ++j;
            }
            ++i;
        }
    }

    private Node createPane() {
        GridPane gridPane = DialogUtil.createGridPane();
        this.matrixTypeToggleGroup = new ToggleGroup();
        RadioButton identityRadioButton = DialogUtil.createRadioButton(this.i18n.getString("MatrixDialog.matrix.type.identity.label", "Identiy matrix"), this.i18n.getString("MatrixDialog.matrix.type.identity.tooltip", "If selected, the matrix type is set to the identity type"), this.matrixTypeToggleGroup);
        RadioButton diagonalRadioButton = DialogUtil.createRadioButton(this.i18n.getString("MatrixDialog.matrix.type.diagonal.label", "Diagonal matrix"), this.i18n.getString("MatrixDialog.matrix.type.diagonal.tooltip", "If selected, the matrix type is set to the diagonal type"), this.matrixTypeToggleGroup);
        RadioButton denseRadioButton = DialogUtil.createRadioButton(this.i18n.getString("MatrixDialog.matrix.type.dense.label", "Dense matrix"), this.i18n.getString("MatrixDialog.matrix.type.dense.tooltip", "If selected, the matrix type is set to the symmetric dense type"), this.matrixTypeToggleGroup);
        identityRadioButton.setUserData((Object)MatrixType.IDENTITY);
        diagonalRadioButton.setUserData((Object)MatrixType.DIAGONAL);
        denseRadioButton.setUserData((Object)MatrixType.DENSE);
        Region spacer = new Region();
        VBox buttonBox = new VBox(7.0);
        VBox.setVgrow((Node)identityRadioButton, (Priority)Priority.NEVER);
        VBox.setVgrow((Node)diagonalRadioButton, (Priority)Priority.NEVER);
        VBox.setVgrow((Node)denseRadioButton, (Priority)Priority.NEVER);
        VBox.setVgrow((Node)spacer, (Priority)Priority.ALWAYS);
        buttonBox.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        buttonBox.getChildren().addAll((Object[])new Node[]{identityRadioButton, diagonalRadioButton, denseRadioButton, spacer});
        this.matrixTypeToggleGroup.selectedToggleProperty().addListener((ChangeListener)new MatrixTypeChangeListener());
        Insets insetsField = new Insets(5.0, 5.0, 5.0, 5.0);
        this.elements = new DoubleTextField[3][3];
        int i = 0;
        while (i < 3) {
            int j = 0;
            while (j < 3) {
                this.elements[i][j] = DialogUtil.createDoubleTextField(CellValueType.DOUBLE, 0.0, this.i18n.getString("MatrixDialog.matrix.element.tooltip", "Element"));
                if (i > j) {
                    this.elements[i][j].numberProperty().bind(this.elements[j][i].numberProperty());
                }
                GridPane.setMargin((Node)this.elements[i][j], (Insets)insetsField);
                gridPane.add((Node)this.elements[i][j], j, i);
                ++j;
            }
            ++i;
        }
        GridPane.setMargin((Node)buttonBox, (Insets)new Insets(5.0, 5.0, 5.0, 10.0));
        gridPane.add((Node)buttonBox, 4, 0, 1, 3);
        return gridPane;
    }

    private void changeMatrixType(MatrixType matrixType) {
        int dimension = this.currentFeaturePoint.getDimension();
        this.matrixType = matrixType;
        int i = 0;
        while (i < dimension) {
            int j = 0;
            while (j < dimension) {
                if (this.matrixType == MatrixType.IDENTITY) {
                    this.elements[i][j].setDisable(true);
                    if (i == j) {
                        this.elements[i][j].setValue(1.0);
                    } else if (i < j) {
                        this.elements[i][j].setValue(0.0);
                    }
                } else if (this.matrixType == MatrixType.DIAGONAL) {
                    this.elements[i][j].setDisable(i != j);
                    if (i < j) {
                        this.elements[i][j].setValue(0.0);
                    }
                } else {
                    this.elements[i][j].setDisable(i > j);
                }
                ++j;
            }
            ++i;
        }
    }

    private void setMatrix() {
        int dimension = this.currentFeaturePoint.getDimension();
        Matrix matrix = null;
        if (this.matrixType == MatrixType.DENSE) {
            boolean diagonalMatrixType = true;
            int row = 0;
            while (row < dimension) {
                int column = row + 1;
                while (column < dimension) {
                    if (this.elements[row][column].getNumber() != 0.0) {
                        diagonalMatrixType = false;
                        break;
                    }
                    ++column;
                }
                ++row;
            }
            if (diagonalMatrixType) {
                this.matrixType = MatrixType.DIAGONAL;
            }
        }
        if (this.matrixType == MatrixType.DIAGONAL) {
            boolean identityMatrixType = true;
            int idx = 0;
            while (idx < dimension) {
                if (this.elements[idx][idx].getNumber() != 1.0) {
                    identityMatrixType = false;
                    break;
                }
                ++idx;
            }
            if (identityMatrixType) {
                this.matrixType = MatrixType.IDENTITY;
            }
        }
        switch (this.matrixType) {
            case DENSE: {
                matrix = new UpperSymmPackMatrix(dimension);
                break;
            }
            case DIAGONAL: {
                matrix = new UpperSymmBandMatrix(dimension, 0);
                break;
            }
            case IDENTITY: {
                matrix = MathExtension.identity(dimension);
            }
        }
        if (matrix == null) {
            return;
        }
        if (this.matrixType != MatrixType.IDENTITY) {
            for (MatrixEntry entry : matrix) {
                double value = this.elements[entry.row()][entry.column()].getNumber();
                entry.set(value);
            }
        }
        try {
            this.currentFeaturePoint.setDispersionApriori(matrix);
        }
        catch (IllegalArgumentException e) {
            OptionDialog.showThrowableDialog(this.i18n.getString("MatrixDialog.message.error.failed.exception.title", "Invalid Dispersion Matrix"), this.i18n.getString("MatrixDialog.message.error.failed.exception.header", "Error, could not save dispersion matrix."), this.i18n.getString("MatrixDialog.message.error.failed.exception.message", "An exception has occurred when saving dispersion matrix."), e);
            throw e;
        }
    }

    private static enum MatrixType {
        IDENTITY,
        DIAGONAL,
        DENSE;

    }

    private class MatrixTypeChangeListener
    implements ChangeListener<Toggle> {
        private MatrixTypeChangeListener() {
        }

        public void changed(ObservableValue<? extends Toggle> observable, Toggle oldValue, Toggle newValue) {
            if (MatrixDialog.this.matrixTypeToggleGroup.getSelectedToggle() != null && MatrixDialog.this.matrixTypeToggleGroup.getSelectedToggle().getUserData() != null && MatrixDialog.this.matrixTypeToggleGroup.getSelectedToggle().getUserData() instanceof MatrixType) {
                MatrixType matrixType = (MatrixType)((Object)MatrixDialog.this.matrixTypeToggleGroup.getSelectedToggle().getUserData());
                MatrixDialog.this.changeMatrixType(matrixType);
            }
        }
    }
}

