/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.juniform.ui.dialog;

import java.util.Optional;
import javafx.application.Platform;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.control.Spinner;
import javafx.scene.control.SpinnerValueFactory;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.util.Callback;
import javafx.util.StringConverter;
import org.applied_geodesy.adjustment.DefaultValue;
import org.applied_geodesy.adjustment.EstimationType;
import org.applied_geodesy.adjustment.UnscentedTransformationParameter;
import org.applied_geodesy.adjustment.geometry.FeatureAdjustment;
import org.applied_geodesy.juniform.ui.dialog.DialogUtil;
import org.applied_geodesy.juniform.ui.i18n.I18N;
import org.applied_geodesy.ui.spinner.DoubleSpinner;
import org.applied_geodesy.ui.textfield.DoubleTextField;
import org.applied_geodesy.util.CellValueType;
import org.applied_geodesy.util.FormatterChangedListener;
import org.applied_geodesy.util.FormatterEvent;
import org.applied_geodesy.util.FormatterOptions;

public class LeastSquaresSettingDialog
implements FormatterChangedListener {
    private static I18N i18N = I18N.getInstance();
    private static LeastSquaresSettingDialog leastSquaresSettingDialog = new LeastSquaresSettingDialog();
    private Dialog<Void> dialog = null;
    private Window window;
    private ComboBox<EstimationType> estimationTypeComboBox;
    private DoubleTextField utAlphaTextField;
    private DoubleTextField utBetaTextField;
    private DoubleTextField utWeight0TextField;
    private Spinner<Integer> iterationSpinner;
    private DoubleSpinner lmDampingSpinner;
    private CheckBox applyVarianceOfUnitWeightCheckBox;
    private CheckBox adjustModelParametersOnlyCheckBox;
    private CheckBox preconditioningCheckBox;
    private CheckBox estimateCenterOfMassCheckBox;
    private CheckBox estimateInitialGuessCheckBox;
    private FeatureAdjustment adjustment;
    private FormatterOptions options = FormatterOptions.getInstance();
    private boolean enableUnscentedTransformation = false;

    private LeastSquaresSettingDialog() {
    }

    public static void setOwner(Window owner) {
        LeastSquaresSettingDialog.leastSquaresSettingDialog.window = owner;
    }

    public static Optional<Void> showAndWait(FeatureAdjustment adjustment) {
        leastSquaresSettingDialog.init();
        leastSquaresSettingDialog.setFeatureAdjustment(adjustment);
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    LeastSquaresSettingDialog.leastSquaresSettingDialog.dialog.getDialogPane().requestLayout();
                    Stage stage = (Stage)LeastSquaresSettingDialog.leastSquaresSettingDialog.dialog.getDialogPane().getScene().getWindow();
                    stage.sizeToScene();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        return LeastSquaresSettingDialog.leastSquaresSettingDialog.dialog.showAndWait();
    }

    private void setFeatureAdjustment(FeatureAdjustment adjustment) {
        this.adjustment = adjustment;
        this.applyVarianceOfUnitWeightCheckBox.setSelected(this.adjustment.getVarianceComponentOfUnitWeight().isApplyAposterioriVarianceOfUnitWeight());
        this.adjustModelParametersOnlyCheckBox.setSelected(this.adjustment.isAdjustModelParametersOnly());
        this.preconditioningCheckBox.setSelected(this.adjustment.isPreconditioning());
        this.estimateCenterOfMassCheckBox.setDisable(true);
        this.estimateInitialGuessCheckBox.setDisable(true);
        this.estimateCenterOfMassCheckBox.setSelected(false);
        this.estimateInitialGuessCheckBox.setSelected(false);
        double dampingValue = this.adjustment.getLevenbergMarquardtDampingValue();
        SpinnerValueFactory.DoubleSpinnerValueFactory dampingSpinnerFactory = (SpinnerValueFactory.DoubleSpinnerValueFactory)this.lmDampingSpinner.getValueFactory();
        dampingValue = Math.max(Math.min(dampingValue, dampingSpinnerFactory.getMax()), dampingSpinnerFactory.getMin());
        dampingSpinnerFactory.setValue((Object)dampingValue);
        int iteration = this.adjustment.getMaximalNumberOfIterations();
        SpinnerValueFactory.IntegerSpinnerValueFactory iterationSpinnerFactory = (SpinnerValueFactory.IntegerSpinnerValueFactory)this.iterationSpinner.getValueFactory();
        iteration = Math.max(Math.min(iteration, iterationSpinnerFactory.getMax()), iterationSpinnerFactory.getMin());
        iterationSpinnerFactory.setValue((Object)iteration);
        if (this.enableUnscentedTransformation) {
            this.estimationTypeComboBox.setValue((Object)this.adjustment.getEstimationType());
            this.utAlphaTextField.setValue(this.adjustment.getUnscentedTransformationScaling());
            this.utBetaTextField.setValue(this.adjustment.getUnscentedTransformationDamping());
            this.utWeight0TextField.setValue(this.adjustment.getUnscentedTransformationWeightZero());
        }
        if (adjustment.getFeature() != null) {
            if (!adjustment.getFeature().isImmutable()) {
                this.estimateCenterOfMassCheckBox.setDisable(true);
                this.estimateInitialGuessCheckBox.setDisable(true);
            } else {
                this.estimateCenterOfMassCheckBox.setDisable(false);
                this.estimateInitialGuessCheckBox.setDisable(false);
                this.estimateCenterOfMassCheckBox.setSelected(this.adjustment.getFeature().isEstimateCenterOfMass());
                this.estimateInitialGuessCheckBox.setSelected(this.adjustment.getFeature().isEstimateInitialGuess());
            }
        }
    }

    private void init() {
        if (this.dialog != null) {
            return;
        }
        this.dialog = new Dialog();
        this.dialog.setTitle(i18N.getString("LeastSquaresSettingDialog.title", "Least-squares"));
        this.dialog.setHeaderText(i18N.getString("LeastSquaresSettingDialog.header", "Least-squares properties"));
        this.dialog.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{ButtonType.OK});
        this.dialog.initModality(Modality.APPLICATION_MODAL);
        this.dialog.initOwner(this.window);
        this.dialog.getDialogPane().setContent(this.createPane());
        this.dialog.setResizable(true);
        this.dialog.setResultConverter((Callback)new Callback<ButtonType, Void>(){

            public Void call(ButtonType buttonType) {
                if (buttonType == ButtonType.OK) {
                    LeastSquaresSettingDialog.this.adjustment.getVarianceComponentOfUnitWeight().setApplyAposterioriVarianceOfUnitWeight(LeastSquaresSettingDialog.this.applyVarianceOfUnitWeightCheckBox.isSelected());
                    LeastSquaresSettingDialog.this.adjustment.setAdjustModelParametersOnly(LeastSquaresSettingDialog.this.adjustModelParametersOnlyCheckBox.isSelected());
                    LeastSquaresSettingDialog.this.adjustment.setPreconditioning(LeastSquaresSettingDialog.this.preconditioningCheckBox.isSelected());
                    LeastSquaresSettingDialog.this.adjustment.setMaximalNumberOfIterations((Integer)LeastSquaresSettingDialog.this.iterationSpinner.getValue());
                    LeastSquaresSettingDialog.this.adjustment.setLevenbergMarquardtDampingValue((Double)LeastSquaresSettingDialog.this.lmDampingSpinner.getValue());
                    if (LeastSquaresSettingDialog.this.enableUnscentedTransformation) {
                        LeastSquaresSettingDialog.this.adjustment.setEstimationType((EstimationType)((Object)LeastSquaresSettingDialog.this.estimationTypeComboBox.getValue()));
                        LeastSquaresSettingDialog.this.adjustment.setUnscentedTransformationScaling(LeastSquaresSettingDialog.this.utAlphaTextField.getNumber());
                        LeastSquaresSettingDialog.this.adjustment.setUnscentedTransformationDamping(LeastSquaresSettingDialog.this.utBetaTextField.getNumber());
                        LeastSquaresSettingDialog.this.adjustment.setUnscentedTransformationWeightZero(LeastSquaresSettingDialog.this.utWeight0TextField.getNumber());
                    }
                    if (LeastSquaresSettingDialog.this.adjustment.getFeature() != null && LeastSquaresSettingDialog.this.adjustment.getFeature().isImmutable() && LeastSquaresSettingDialog.this.adjustment.getFeature().isImmutable()) {
                        LeastSquaresSettingDialog.this.adjustment.getFeature().setEstimateCenterOfMass(LeastSquaresSettingDialog.this.estimateCenterOfMassCheckBox.isSelected());
                        LeastSquaresSettingDialog.this.adjustment.getFeature().setEstimateInitialGuess(LeastSquaresSettingDialog.this.estimateInitialGuessCheckBox.isSelected());
                    }
                }
                return null;
            }
        });
        this.options.addFormatterChangedListener(this);
    }

    private Node createPane() {
        VBox contentPane = new VBox();
        if (this.enableUnscentedTransformation) {
            this.estimationTypeComboBox = DialogUtil.createEstimationTypeComboBox(LeastSquaresSettingDialog.estimationTypeStringConverter(), i18N.getString("LeastSquaresSettingDialog.estimationtype.tooltip", "Select estimation type"));
            this.estimationTypeComboBox.getItems().setAll((Object[])new EstimationType[]{EstimationType.L2NORM, EstimationType.SPHERICAL_SIMPLEX_UNSCENTED_TRANSFORMATION});
            this.estimationTypeComboBox.setValue((Object)EstimationType.L2NORM);
            VBox.setMargin(this.estimationTypeComboBox, (Insets)new Insets(5.0, 5.0, 5.0, 5.0));
            contentPane.getChildren().add(this.estimationTypeComboBox);
            TabPane tabPane = new TabPane();
            Tab tabGen = new Tab(i18N.getString("LeastSquaresSettingDialog.tab.leastsquares.label", "Least-squares"), this.createGeneralSettingPane());
            tabGen.setTooltip(new Tooltip(i18N.getString("LeastSquaresSettingDialog.tab.leastsquares.tooltip", "Least-squares options")));
            tabGen.setClosable(false);
            tabPane.getTabs().add((Object)tabGen);
            Tab tabUT = new Tab(i18N.getString("LeastSquaresSettingDialog.tab.unscented_transformation.label", "Unscented transformation"), this.createUnscentedTransformationSettingPane());
            tabUT.setTooltip(new Tooltip(i18N.getString("LeastSquaresSettingDialog.tab.unscented_transformation.tooltip", "Unscented transformation parameters")));
            tabUT.setClosable(false);
            tabPane.getTabs().add((Object)tabUT);
            tabPane.setPadding(new Insets(5.0, 0.0, 0.0, 0.0));
            tabPane.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
            tabPane.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
            contentPane.getChildren().add((Object)tabPane);
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    LeastSquaresSettingDialog.this.estimationTypeComboBox.requestFocus();
                }
            });
        } else {
            contentPane.getChildren().add((Object)this.createGeneralSettingPane());
        }
        contentPane.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        contentPane.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        return contentPane;
    }

    private Node createGeneralSettingPane() {
        Label iterationLabel = new Label(i18N.getString("LeastSquaresSettingDialog.iterations.label", "Maximum number of iterations:"));
        Label dampingLabel = new Label(i18N.getString("LeastSquaresSettingDialog.lm.damping.label", "Levenberg-Marquardt damping value \u03bb:"));
        this.iterationSpinner = DialogUtil.createIntegerSpinner(0, DefaultValue.getMaximumNumberOfIterations(), 10, i18N.getString("LeastSquaresSettingDialog.iterations.tooltip", "Set maximum permissible iteration value"));
        this.lmDampingSpinner = DialogUtil.createDoubleSpinner(CellValueType.STATISTIC, 0.0, 100.0, 0.01, i18N.getString("LeastSquaresSettingDialog.lm.damping.tooltip", "Set damping value of Levenberg-Marquardt algorithm. The algorithm will be applied, if \u03bb > 0"));
        iterationLabel.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        iterationLabel.setMaxSize(Double.NEGATIVE_INFINITY, Double.MAX_VALUE);
        dampingLabel.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        dampingLabel.setMaxSize(Double.NEGATIVE_INFINITY, Double.MAX_VALUE);
        iterationLabel.setLabelFor(this.iterationSpinner);
        dampingLabel.setLabelFor((Node)this.lmDampingSpinner);
        this.applyVarianceOfUnitWeightCheckBox = DialogUtil.createCheckBox(i18N.getString("LeastSquaresSettingDialog.applyvarianceofunitweight.label", "Apply variance of the unit weight"), i18N.getString("LeastSquaresSettingDialog.applyvarianceofunitweight.tooltip", "If checked, the estimated variance of the unit weight will be applied to scale the variance-covariance matrix"));
        this.adjustModelParametersOnlyCheckBox = DialogUtil.createCheckBox(i18N.getString("LeastSquaresSettingDialog.adjustperametersonly.label", "Adjust only model parameters"), i18N.getString("LeastSquaresSettingDialog.adjustperametersonly.tooltip", "If checked, the model parameters will be adjusted but no outlier test will be carried out"));
        this.preconditioningCheckBox = DialogUtil.createCheckBox(i18N.getString("LeastSquaresSettingDialog.preconditioning.label", "Preconditioning of normal system"), i18N.getString("LeastSquaresSettingDialog.preconditioning.tooltip", "If checked, a preconditioned iterative adjustment will be used"));
        this.estimateCenterOfMassCheckBox = DialogUtil.createCheckBox(i18N.getString("LeastSquaresSettingDialog.centerofmass.label", "Center of mass reduction"), i18N.getString("LeastSquaresSettingDialog.centerofmass.tooltip", "If checked, points will be reduced by the center of mass. This option is not supported by user-defined features"));
        this.estimateInitialGuessCheckBox = DialogUtil.createCheckBox(i18N.getString("LeastSquaresSettingDialog.initialguess.label", "Derive initial guess"), i18N.getString("LeastSquaresSettingDialog.initialguess.tooltip", "If checked, an initial guess of the parameter to be estimated will be derived. This option is not supported by user-defined features"));
        GridPane gridPane = DialogUtil.createGridPane();
        GridPane.setHgrow((Node)iterationLabel, (Priority)Priority.NEVER);
        GridPane.setHgrow((Node)dampingLabel, (Priority)Priority.NEVER);
        GridPane.setHgrow((Node)this.applyVarianceOfUnitWeightCheckBox, (Priority)Priority.ALWAYS);
        GridPane.setHgrow((Node)this.adjustModelParametersOnlyCheckBox, (Priority)Priority.ALWAYS);
        GridPane.setHgrow((Node)this.preconditioningCheckBox, (Priority)Priority.ALWAYS);
        GridPane.setHgrow((Node)this.estimateCenterOfMassCheckBox, (Priority)Priority.ALWAYS);
        GridPane.setHgrow((Node)this.estimateInitialGuessCheckBox, (Priority)Priority.ALWAYS);
        GridPane.setHgrow(this.iterationSpinner, (Priority)Priority.ALWAYS);
        GridPane.setHgrow((Node)this.lmDampingSpinner, (Priority)Priority.ALWAYS);
        Insets insetsCenter = new Insets(5.0, 2.0, 5.0, 2.0);
        Insets insetsTop = new Insets(10.0, 2.0, 5.0, 2.0);
        Insets insetsLeft = new Insets(5.0, 7.0, 5.0, 2.0);
        Insets insetsRight = new Insets(5.0, 2.0, 5.0, 7.0);
        GridPane.setMargin((Node)this.applyVarianceOfUnitWeightCheckBox, (Insets)insetsTop);
        GridPane.setMargin((Node)this.adjustModelParametersOnlyCheckBox, (Insets)insetsCenter);
        GridPane.setMargin((Node)this.preconditioningCheckBox, (Insets)insetsCenter);
        GridPane.setMargin((Node)this.estimateCenterOfMassCheckBox, (Insets)insetsCenter);
        GridPane.setMargin((Node)this.estimateInitialGuessCheckBox, (Insets)insetsCenter);
        GridPane.setMargin((Node)iterationLabel, (Insets)insetsLeft);
        GridPane.setMargin((Node)dampingLabel, (Insets)insetsLeft);
        GridPane.setMargin(this.iterationSpinner, (Insets)insetsRight);
        GridPane.setMargin((Node)this.lmDampingSpinner, (Insets)insetsRight);
        int row = 0;
        gridPane.add((Node)this.applyVarianceOfUnitWeightCheckBox, 0, row++, 2, 1);
        gridPane.add((Node)this.adjustModelParametersOnlyCheckBox, 0, row++, 2, 1);
        gridPane.add((Node)this.preconditioningCheckBox, 0, row++, 2, 1);
        gridPane.add((Node)this.estimateCenterOfMassCheckBox, 0, row++, 2, 1);
        gridPane.add((Node)this.estimateInitialGuessCheckBox, 0, row++, 2, 1);
        gridPane.add((Node)iterationLabel, 0, row);
        gridPane.add(this.iterationSpinner, 1, row++);
        gridPane.add((Node)dampingLabel, 0, row);
        gridPane.add((Node)this.lmDampingSpinner, 1, row++);
        gridPane.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        gridPane.setMaxSize(Double.MAX_VALUE, Double.NEGATIVE_INFINITY);
        return gridPane;
    }

    private Node createUnscentedTransformationSettingPane() {
        GridPane gridPane = DialogUtil.createGridPane();
        Label alphaLabel = new Label(i18N.getString("LeastSquaresSettingDialog.ut.scaling.label", "Scaling \u03b1:"));
        Label betaLabel = new Label(i18N.getString("LeastSquaresSettingDialog.ut.damping.label", "Damping \u03b2:"));
        Label utWeight0Label = new Label(i18N.getString("LeastSquaresSettingDialog.ut.weight0.label", "Weight w0:"));
        this.utAlphaTextField = DialogUtil.createDoubleTextField(CellValueType.STATISTIC, UnscentedTransformationParameter.getAlpha(), Boolean.FALSE, DoubleTextField.ValueSupport.EXCLUDING_INCLUDING_INTERVAL, 0.0, 1.0, i18N.getString("LeastSquaresSettingDialog.ut.scaling.tooltip", "Defines spread of sigma points around the mean value, if \u03b1 \u2260 1"));
        this.utBetaTextField = DialogUtil.createDoubleTextField(CellValueType.STATISTIC, UnscentedTransformationParameter.getBeta(), Boolean.FALSE, DoubleTextField.ValueSupport.NON_NULL_VALUE_SUPPORT, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, i18N.getString("LeastSquaresSettingDialog.ut.damping.tooltip", "Considers prior knowledge of the distribution, if \u03b2 \u2260 0"));
        this.utWeight0TextField = DialogUtil.createDoubleTextField(CellValueType.STATISTIC, UnscentedTransformationParameter.getWeightZero(), Boolean.FALSE, DoubleTextField.ValueSupport.INCLUDING_EXCLUDING_INTERVAL, Double.NEGATIVE_INFINITY, 1.0, i18N.getString("LeastSquaresSettingDialog.ut.weight0.tooltip", "Set the weight related to the zero sigma point (SUT: 0 \u2264 w0 < 1)"));
        alphaLabel.setLabelFor((Node)this.utAlphaTextField);
        betaLabel.setLabelFor((Node)this.utBetaTextField);
        utWeight0Label.setLabelFor((Node)this.utWeight0TextField);
        GridPane.setHgrow((Node)alphaLabel, (Priority)Priority.NEVER);
        GridPane.setHgrow((Node)betaLabel, (Priority)Priority.NEVER);
        GridPane.setHgrow((Node)utWeight0Label, (Priority)Priority.NEVER);
        GridPane.setHgrow((Node)this.utAlphaTextField, (Priority)Priority.ALWAYS);
        GridPane.setHgrow((Node)this.utBetaTextField, (Priority)Priority.ALWAYS);
        GridPane.setHgrow((Node)this.utWeight0TextField, (Priority)Priority.ALWAYS);
        Insets insetsLeft = new Insets(5.0, 7.0, 5.0, 2.0);
        Insets insetsRight = new Insets(5.0, 2.0, 5.0, 7.0);
        GridPane.setMargin((Node)alphaLabel, (Insets)insetsLeft);
        GridPane.setMargin((Node)this.utAlphaTextField, (Insets)insetsRight);
        GridPane.setMargin((Node)betaLabel, (Insets)insetsLeft);
        GridPane.setMargin((Node)this.utBetaTextField, (Insets)insetsRight);
        GridPane.setMargin((Node)utWeight0Label, (Insets)insetsLeft);
        GridPane.setMargin((Node)this.utWeight0TextField, (Insets)insetsRight);
        int row = 0;
        gridPane.add((Node)utWeight0Label, 0, row);
        gridPane.add((Node)this.utWeight0TextField, 1, row++);
        gridPane.add((Node)alphaLabel, 0, row);
        gridPane.add((Node)this.utAlphaTextField, 1, row++, 2, 1);
        gridPane.add((Node)betaLabel, 0, row);
        gridPane.add((Node)this.utBetaTextField, 1, row++, 2, 1);
        return gridPane;
    }

    static StringConverter<EstimationType> estimationTypeStringConverter() {
        return new StringConverter<EstimationType>(){

            public String toString(EstimationType type) {
                if (type == null) {
                    return null;
                }
                switch (type) {
                    case L2NORM: {
                        return i18N.getString("LeastSquaresSettingDialog.estimationtype.l2norm.label", "Least-squares adjustment (L2-Norm)");
                    }
                    case SPHERICAL_SIMPLEX_UNSCENTED_TRANSFORMATION: {
                        return i18N.getString("LeastSquaresSettingDialog.estimationtype.sut.label", "Spherical simplex unscented transformation (SUT)");
                    }
                }
                throw new IllegalArgumentException("Error, unsupported estimation type " + String.valueOf((Object)type) + "!");
            }

            public EstimationType fromString(String string) {
                return EstimationType.valueOf(string);
            }
        };
    }

    @Override
    public void formatterChanged(FormatterEvent evt) {
        this.lmDampingSpinner.getEditor().setText(this.options.toStatisticFormat((Double)this.lmDampingSpinner.getValueFactory().getValue()));
    }

    public static void setEnableUnscentedTransformation(boolean enable) {
        LeastSquaresSettingDialog.leastSquaresSettingDialog.enableUnscentedTransformation = enable;
    }
}

