/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.juniform.ui.dialog;

import java.util.Locale;
import java.util.Optional;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.util.Callback;
import javafx.util.StringConverter;
import org.applied_geodesy.adjustment.geometry.FeatureType;
import org.applied_geodesy.adjustment.geometry.GeometricPrimitive;
import org.applied_geodesy.adjustment.geometry.PrimitiveType;
import org.applied_geodesy.adjustment.geometry.curve.primitive.Circle;
import org.applied_geodesy.adjustment.geometry.curve.primitive.Ellipse;
import org.applied_geodesy.adjustment.geometry.curve.primitive.Line;
import org.applied_geodesy.adjustment.geometry.curve.primitive.QuadraticCurve;
import org.applied_geodesy.adjustment.geometry.surface.primitive.Cone;
import org.applied_geodesy.adjustment.geometry.surface.primitive.Cylinder;
import org.applied_geodesy.adjustment.geometry.surface.primitive.Ellipsoid;
import org.applied_geodesy.adjustment.geometry.surface.primitive.Paraboloid;
import org.applied_geodesy.adjustment.geometry.surface.primitive.Plane;
import org.applied_geodesy.adjustment.geometry.surface.primitive.QuadraticSurface;
import org.applied_geodesy.adjustment.geometry.surface.primitive.Sphere;
import org.applied_geodesy.adjustment.geometry.surface.primitive.Torus;
import org.applied_geodesy.juniform.ui.dialog.DialogUtil;
import org.applied_geodesy.juniform.ui.i18n.I18N;

public class GeometricPrimitiveDialog {
    private static I18N i18N = I18N.getInstance();
    private static GeometricPrimitiveDialog geometricPrimitiveDialog = new GeometricPrimitiveDialog();
    private Dialog<GeometricPrimitive> dialog = null;
    private ComboBox<PrimitiveType> primitiveTypeComboBox;
    private TextField nameTextField;
    private Window window;

    private GeometricPrimitiveDialog() {
    }

    public static void setOwner(Window owner) {
        GeometricPrimitiveDialog.geometricPrimitiveDialog.window = owner;
    }

    public static Optional<GeometricPrimitive> showAndWait(FeatureType featureType) {
        geometricPrimitiveDialog.init();
        geometricPrimitiveDialog.setFeatureType(featureType);
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    GeometricPrimitiveDialog.geometricPrimitiveDialog.dialog.getDialogPane().requestLayout();
                    Stage stage = (Stage)GeometricPrimitiveDialog.geometricPrimitiveDialog.dialog.getDialogPane().getScene().getWindow();
                    stage.sizeToScene();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        return GeometricPrimitiveDialog.geometricPrimitiveDialog.dialog.showAndWait();
    }

    private void init() {
        if (this.dialog != null) {
            return;
        }
        this.dialog = new Dialog();
        this.dialog.setTitle(i18N.getString("GeometricPrimitiveDialog.title", "Geometry"));
        this.dialog.setHeaderText(i18N.getString("GeometricPrimitiveDialog.header", "Geometric primitives"));
        this.dialog.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{ButtonType.OK, ButtonType.CANCEL});
        this.dialog.initModality(Modality.APPLICATION_MODAL);
        this.dialog.initOwner(this.window);
        this.dialog.getDialogPane().setContent(this.createPane());
        this.dialog.setResizable(true);
        this.dialog.setResultConverter((Callback)new Callback<ButtonType, GeometricPrimitive>(){

            public GeometricPrimitive call(ButtonType buttonType) {
                PrimitiveType primitiveType;
                if (buttonType == ButtonType.OK && (primitiveType = (PrimitiveType)((Object)GeometricPrimitiveDialog.this.primitiveTypeComboBox.getValue())) != null) {
                    GeometricPrimitive geometricPrimitive = GeometricPrimitiveDialog.this.getGeometricPrimitive(primitiveType);
                    GeometricPrimitiveDialog.setDefaultName(geometricPrimitive);
                    if (GeometricPrimitiveDialog.this.nameTextField.getText() != null && !GeometricPrimitiveDialog.this.nameTextField.getText().isBlank()) {
                        geometricPrimitive.setName(GeometricPrimitiveDialog.this.nameTextField.getText().trim());
                    }
                    return geometricPrimitive;
                }
                return null;
            }
        });
    }

    private GeometricPrimitive getGeometricPrimitive(PrimitiveType primitiveType) {
        switch (primitiveType) {
            case LINE: {
                return new Line();
            }
            case CIRCLE: {
                return new Circle();
            }
            case ELLIPSE: {
                return new Ellipse();
            }
            case QUADRATIC_CURVE: {
                return new QuadraticCurve();
            }
            case PLANE: {
                return new Plane();
            }
            case SPHERE: {
                return new Sphere();
            }
            case ELLIPSOID: {
                return new Ellipsoid();
            }
            case CYLINDER: {
                return new Cylinder();
            }
            case CONE: {
                return new Cone();
            }
            case PARABOLOID: {
                return new Paraboloid();
            }
            case TORUS: {
                return new Torus();
            }
            case QUADRATIC_SURFACE: {
                return new QuadraticSurface();
            }
        }
        throw new IllegalArgumentException("Error, unknown type of geometric primitive " + String.valueOf((Object)primitiveType));
    }

    private void setFeatureType(FeatureType featureType) {
        this.primitiveTypeComboBox.setItems(FXCollections.observableArrayList((Object[])PrimitiveType.values(featureType)));
        this.primitiveTypeComboBox.getSelectionModel().clearAndSelect(0);
    }

    private Node createPane() {
        GridPane gridPane = DialogUtil.createGridPane();
        Label nameLabel = new Label(i18N.getString("GeometricPrimitiveDialog.primitive.name.label", "Name:"));
        Label typeLabel = new Label(i18N.getString("GeometricPrimitiveDialog.primitive.type.label", "Type:"));
        this.nameTextField = DialogUtil.createTextField(i18N.getString("GeometricPrimitiveDialog.primitive.name.tooltip", "Name of geometric primitive"), i18N.getString("GeometricPrimitiveDialog.primitive.name.prompt", "Name of geometry"));
        this.primitiveTypeComboBox = DialogUtil.createPrimitiveTypeComboBox(GeometricPrimitiveDialog.createPrimitiveTypeStringConverter(), i18N.getString("GeometricPrimitiveDialog.primitive.type.tooltip", "Select geometric primitive type"));
        nameLabel.setLabelFor((Node)this.nameTextField);
        typeLabel.setLabelFor(this.primitiveTypeComboBox);
        nameLabel.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        typeLabel.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        nameLabel.setMaxWidth(Double.MAX_VALUE);
        typeLabel.setMaxWidth(Double.MAX_VALUE);
        GridPane.setHgrow((Node)nameLabel, (Priority)Priority.NEVER);
        GridPane.setHgrow((Node)typeLabel, (Priority)Priority.NEVER);
        GridPane.setHgrow((Node)this.nameTextField, (Priority)Priority.ALWAYS);
        GridPane.setHgrow(this.primitiveTypeComboBox, (Priority)Priority.ALWAYS);
        Insets insetsLeft = new Insets(5.0, 7.0, 5.0, 5.0);
        Insets insetsRight = new Insets(5.0, 0.0, 5.0, 7.0);
        GridPane.setMargin((Node)nameLabel, (Insets)insetsLeft);
        GridPane.setMargin((Node)typeLabel, (Insets)insetsLeft);
        GridPane.setMargin((Node)this.nameTextField, (Insets)insetsRight);
        GridPane.setMargin(this.primitiveTypeComboBox, (Insets)insetsRight);
        gridPane.add((Node)typeLabel, 0, 0);
        gridPane.add(this.primitiveTypeComboBox, 1, 0);
        gridPane.add((Node)nameLabel, 0, 1);
        gridPane.add((Node)this.nameTextField, 1, 1);
        return gridPane;
    }

    static StringConverter<PrimitiveType> createPrimitiveTypeStringConverter() {
        return new StringConverter<PrimitiveType>(){

            public String toString(PrimitiveType primitiveType) {
                return GeometricPrimitiveDialog.getPrimitiveTypeLabel(primitiveType);
            }

            public PrimitiveType fromString(String string) {
                return PrimitiveType.valueOf(string);
            }
        };
    }

    public static String getPrimitiveTypeLabel(PrimitiveType primitiveType) throws IllegalArgumentException {
        if (primitiveType == null) {
            return null;
        }
        switch (primitiveType) {
            case LINE: {
                return i18N.getString("GeometricPrimitiveDialog.primitive.type.curve.line.label", "Line");
            }
            case CIRCLE: {
                return i18N.getString("GeometricPrimitiveDialog.primitive.type.curve.circle.label", "Circle");
            }
            case ELLIPSE: {
                return i18N.getString("GeometricPrimitiveDialog.primitive.type.curve.ellipse.label", "Ellipse");
            }
            case QUADRATIC_CURVE: {
                return i18N.getString("GeometricPrimitiveDialog.primitive.type.curve.quadratic.label", "Quadratic curve");
            }
            case PLANE: {
                return i18N.getString("GeometricPrimitiveDialog.primitive.type.surface.plane.label", "Plane");
            }
            case SPHERE: {
                return i18N.getString("GeometricPrimitiveDialog.primitive.type.surface.sphere.label", "Sphere");
            }
            case ELLIPSOID: {
                return i18N.getString("GeometricPrimitiveDialog.primitive.type.surface.ellipsoid.label", "Ellipsoid");
            }
            case CYLINDER: {
                return i18N.getString("GeometricPrimitiveDialog.primitive.type.surface.cylinder.label", "Cylinder");
            }
            case CONE: {
                return i18N.getString("GeometricPrimitiveDialog.primitive.type.surface.cone.label", "Cone");
            }
            case PARABOLOID: {
                return i18N.getString("GeometricPrimitiveDialog.primitive.type.surface.paraboloid.label", "Paraboloid");
            }
            case TORUS: {
                return i18N.getString("GeometricPrimitiveDialog.primitive.type.surface.torus.label", "Torus");
            }
            case QUADRATIC_SURFACE: {
                return i18N.getString("GeometricPrimitiveDialog.primitive.type.surface.quadratic.label", "Quadratic surface");
            }
        }
        throw new IllegalArgumentException("Error, unknown type of geometric primitive " + String.valueOf((Object)primitiveType));
    }

    public static void setDefaultName(GeometricPrimitive geometricPrimitive) throws IllegalArgumentException {
        String name = GeometricPrimitiveDialog.getPrimitiveTypeLabel(geometricPrimitive.getPrimitiveType());
        if (name == null) {
            throw new NullPointerException("Error, name of geometric primitive cannot be null!");
        }
        name = String.format(Locale.ENGLISH, name + " (id: %d)", geometricPrimitive.getId());
        geometricPrimitive.setName(name);
    }
}

