/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.juniform.ui.dialog;

import java.util.Optional;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.util.Callback;
import org.applied_geodesy.adjustment.geometry.GeometricPrimitive;
import org.applied_geodesy.adjustment.geometry.point.FeaturePoint;
import org.applied_geodesy.adjustment.geometry.restriction.FeaturePointRestriction;
import org.applied_geodesy.juniform.ui.dialog.DialogUtil;
import org.applied_geodesy.juniform.ui.dialog.FeatureDialog;
import org.applied_geodesy.juniform.ui.i18n.I18N;
import org.applied_geodesy.juniform.ui.propertiespane.UIPointSelectionPaneBuilder;
import org.applied_geodesy.ui.tex.LaTexLabel;

public class FeaturePointRestrictionDialog {
    private static I18N i18N = I18N.getInstance();
    private static FeaturePointRestrictionDialog restrictionTypeDialog = new FeaturePointRestrictionDialog();
    private Dialog<FeaturePointRestriction> dialog = null;
    private LaTexLabel latexLabel;
    private ComboBox<GeometricPrimitive> geometricPrimitiveComboBox;
    private ComboBox<FeaturePoint> featurePointComboBox;
    private TextField descriptionTextField;
    private Window window;
    private FeaturePointRestriction restriction;

    private FeaturePointRestrictionDialog() {
    }

    public static void setOwner(Window owner) {
        FeaturePointRestrictionDialog.restrictionTypeDialog.window = owner;
    }

    public static Optional<FeaturePointRestriction> showAndWait(ObservableList<GeometricPrimitive> geometricPrimitives, ObservableList<FeaturePoint> featurePoints, FeaturePointRestriction featurePointRestriction) {
        restrictionTypeDialog.init();
        restrictionTypeDialog.setGeometricPrimitives(geometricPrimitives);
        restrictionTypeDialog.setFeaturePoints(featurePoints);
        restrictionTypeDialog.setRestriction(featurePointRestriction);
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    FeaturePointRestrictionDialog.restrictionTypeDialog.dialog.getDialogPane().requestLayout();
                    Stage stage = (Stage)FeaturePointRestrictionDialog.restrictionTypeDialog.dialog.getDialogPane().getScene().getWindow();
                    stage.sizeToScene();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        return FeaturePointRestrictionDialog.restrictionTypeDialog.dialog.showAndWait();
    }

    private void setRestriction(FeaturePointRestriction restriction) {
        if (this.restriction != null) {
            this.geometricPrimitiveComboBox.valueProperty().unbindBidirectional(this.restriction.geometricPrimitiveProperty());
            this.featurePointComboBox.valueProperty().unbindBidirectional(this.restriction.featurePointProperty());
            this.descriptionTextField.textProperty().unbindBidirectional(this.restriction.descriptionProperty());
        }
        this.restriction = restriction;
        this.geometricPrimitiveComboBox.valueProperty().bindBidirectional(this.restriction.geometricPrimitiveProperty());
        this.featurePointComboBox.valueProperty().bindBidirectional(this.restriction.featurePointProperty());
        this.descriptionTextField.textProperty().bindBidirectional(this.restriction.descriptionProperty());
        this.latexLabel.setTex(this.restriction.toLaTex());
        this.geometricPrimitiveComboBox.setDisable(restriction.isIndispensable());
        this.featurePointComboBox.setDisable(restriction.isIndispensable());
        if (!restriction.isIndispensable()) {
            if (restriction.getGeometricPrimitive() != null) {
                this.geometricPrimitiveComboBox.getSelectionModel().select((Object)restriction.getGeometricPrimitive());
            } else {
                this.geometricPrimitiveComboBox.getSelectionModel().clearAndSelect(0);
            }
            if (restriction.getFeaturePoint() != null) {
                this.featurePointComboBox.getSelectionModel().select((Object)restriction.getFeaturePoint());
            } else {
                this.featurePointComboBox.getSelectionModel().clearAndSelect(0);
            }
        }
    }

    private void setFeaturePoints(ObservableList<FeaturePoint> featurePoints) {
        ObservableList featurePointList = FXCollections.observableArrayList(featurePoints);
        this.featurePointComboBox.setItems(featurePointList);
    }

    private void setGeometricPrimitives(ObservableList<GeometricPrimitive> geometricPrimitives) {
        ObservableList geometricPrimitiveList = FXCollections.observableArrayList(geometricPrimitives);
        this.geometricPrimitiveComboBox.setItems(geometricPrimitiveList);
    }

    private void init() {
        if (this.dialog != null) {
            return;
        }
        this.dialog = new Dialog();
        this.dialog.setTitle(i18N.getString("FeaturePointRestrictionDialog.title", "Feature point restriction"));
        this.dialog.setHeaderText(i18N.getString("FeaturePointRestrictionDialog.header", "Feature point restriction"));
        this.dialog.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{ButtonType.OK});
        this.dialog.initModality(Modality.APPLICATION_MODAL);
        this.dialog.initOwner(this.window);
        this.dialog.getDialogPane().setContent(this.createPane());
        this.dialog.setResizable(true);
        this.dialog.setResultConverter((Callback)new Callback<ButtonType, FeaturePointRestriction>(){

            public FeaturePointRestriction call(ButtonType buttonType) {
                if (buttonType == ButtonType.OK) {
                    return FeaturePointRestrictionDialog.this.restriction;
                }
                return null;
            }
        });
    }

    private Node createPane() {
        GridPane gridPane = DialogUtil.createGridPane();
        Label equationLabel = new Label(i18N.getString("FeaturePointRestrictionDialog.equation.label", "Equation:"));
        Label descriptionLabel = new Label(i18N.getString("FeaturePointRestrictionDialog.description.label", "Description:"));
        Label geometryLabel = new Label(i18N.getString("FeaturePointRestrictionDialog.primitive.label", "Geometric primitive:"));
        Label pointLabel = new Label(i18N.getString("FeaturePointRestrictionDialog.featurepoint.label", "Feature point:"));
        equationLabel.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        descriptionLabel.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        geometryLabel.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        pointLabel.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        this.descriptionTextField = DialogUtil.createTextField(i18N.getString("FeaturePointRestrictionDialog.description.tooltip", "Description of parameter restriction"), i18N.getString("FeaturePointRestrictionDialog.description.prompt", "Restriction description"));
        this.geometricPrimitiveComboBox = DialogUtil.createGeometricPrimitiveComboBox(FeatureDialog.createGeometricPrimitiveCellFactory(), i18N.getString("FeaturePointRestrictionDialog.primitive.tooltip", "Select geometric primitive"));
        this.featurePointComboBox = DialogUtil.createFeaturePointComboBox(UIPointSelectionPaneBuilder.createFeaturePointCellFactory(), i18N.getString("FeaturePointRestrictionDialog.featurepoint.tooltip", "Select feature point"));
        this.latexLabel = new LaTexLabel();
        this.latexLabel.setPrefSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        this.latexLabel.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        equationLabel.setLabelFor((Node)this.latexLabel);
        descriptionLabel.setLabelFor((Node)this.descriptionTextField);
        geometryLabel.setLabelFor(this.geometricPrimitiveComboBox);
        pointLabel.setLabelFor(this.featurePointComboBox);
        GridPane.setHgrow((Node)equationLabel, (Priority)Priority.NEVER);
        GridPane.setHgrow((Node)descriptionLabel, (Priority)Priority.NEVER);
        GridPane.setHgrow((Node)geometryLabel, (Priority)Priority.NEVER);
        GridPane.setHgrow((Node)pointLabel, (Priority)Priority.NEVER);
        GridPane.setHgrow((Node)this.latexLabel, (Priority)Priority.ALWAYS);
        GridPane.setHgrow((Node)this.descriptionTextField, (Priority)Priority.ALWAYS);
        GridPane.setHgrow(this.geometricPrimitiveComboBox, (Priority)Priority.ALWAYS);
        GridPane.setHgrow(this.featurePointComboBox, (Priority)Priority.ALWAYS);
        Insets insetsLeft = new Insets(5.0, 7.0, 5.0, 5.0);
        Insets insetsRight = new Insets(5.0, 0.0, 5.0, 7.0);
        GridPane.setMargin((Node)equationLabel, (Insets)insetsLeft);
        GridPane.setMargin((Node)descriptionLabel, (Insets)insetsLeft);
        GridPane.setMargin((Node)geometryLabel, (Insets)insetsLeft);
        GridPane.setMargin((Node)pointLabel, (Insets)insetsLeft);
        GridPane.setMargin((Node)this.latexLabel, (Insets)insetsRight);
        GridPane.setMargin(this.geometricPrimitiveComboBox, (Insets)insetsRight);
        GridPane.setMargin(this.featurePointComboBox, (Insets)insetsRight);
        GridPane.setMargin((Node)this.descriptionTextField, (Insets)insetsRight);
        int row = 0;
        gridPane.add((Node)equationLabel, 0, row);
        gridPane.add((Node)this.latexLabel, 1, row++);
        gridPane.add((Node)descriptionLabel, 0, row);
        gridPane.add((Node)this.descriptionTextField, 1, row++);
        gridPane.add((Node)geometryLabel, 0, row);
        gridPane.add(this.geometricPrimitiveComboBox, 1, row++);
        gridPane.add((Node)pointLabel, 0, row);
        gridPane.add(this.featurePointComboBox, 1, row++);
        return gridPane;
    }
}

