/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.juniform.ui.dialog;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Optional;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.TextField;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.util.Callback;
import javafx.util.StringConverter;
import org.applied_geodesy.adjustment.geometry.Feature;
import org.applied_geodesy.adjustment.geometry.GeometricPrimitive;
import org.applied_geodesy.adjustment.geometry.PrimitiveType;
import org.applied_geodesy.adjustment.geometry.parameter.UnknownParameter;
import org.applied_geodesy.adjustment.geometry.restriction.Restriction;
import org.applied_geodesy.juniform.ui.dialog.DialogUtil;
import org.applied_geodesy.juniform.ui.dialog.GeometricPrimitiveDialog;
import org.applied_geodesy.juniform.ui.i18n.I18N;
import org.applied_geodesy.juniform.ui.tree.UITreeBuilder;
import org.applied_geodesy.ui.tex.LaTexLabel;

public class FeatureDialog {
    private static I18N i18N = I18N.getInstance();
    private static FeatureDialog featureDialog = new FeatureDialog();
    private Dialog<Feature> dialog = null;
    private TextField nameTextField;
    private ListView<GeometricPrimitive> geometricPrimitiveList;
    private Label primitiveTypeLabel;
    private Button addPrimitiveButton;
    private Button removePrimitiveButton;
    private LaTexLabel latexLabel;
    private Window window;
    private Feature feature;
    private GeometricPrimitive geometricPrimitive;

    private FeatureDialog() {
    }

    public static void setOwner(Window owner) {
        FeatureDialog.featureDialog.window = owner;
    }

    public static Optional<Feature> showAndWait(Feature feature) {
        featureDialog.init();
        featureDialog.setFeature(feature);
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    FeatureDialog.featureDialog.dialog.getDialogPane().requestLayout();
                    Stage stage = (Stage)FeatureDialog.featureDialog.dialog.getDialogPane().getScene().getWindow();
                    stage.sizeToScene();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        return FeatureDialog.featureDialog.dialog.showAndWait();
    }

    private void setFeature(Feature feature) {
        this.feature = feature;
        if (feature != null) {
            this.geometricPrimitiveList.getSelectionModel().clearSelection();
            this.geometricPrimitiveList.setItems(this.feature.getGeometricPrimitives());
            this.addPrimitiveButton.setDisable(this.feature.isImmutable());
            this.geometricPrimitiveList.requestFocus();
            if (this.geometricPrimitiveList.getItems().size() > 0) {
                this.setGeometricPrimitive((GeometricPrimitive)this.geometricPrimitiveList.getItems().get(0));
                this.geometricPrimitiveList.getSelectionModel().clearAndSelect(0);
            }
        }
    }

    private void setGeometricPrimitive(GeometricPrimitive geometricPrimitive) {
        if (this.geometricPrimitive != null) {
            this.nameTextField.textProperty().unbindBidirectional(this.geometricPrimitive.nameProperty());
            this.primitiveTypeLabel.setText(null);
        }
        this.geometricPrimitive = geometricPrimitive;
        if (this.geometricPrimitive == null) {
            this.latexLabel.setTex("");
            this.nameTextField.setDisable(true);
            this.primitiveTypeLabel.setText(null);
            this.removePrimitiveButton.setDisable(true);
        } else {
            this.nameTextField.setDisable(false);
            this.removePrimitiveButton.setDisable(false);
            this.latexLabel.setTex(geometricPrimitive.toLaTex());
            if (this.feature.isImmutable()) {
                this.removePrimitiveButton.setDisable(true);
                this.addPrimitiveButton.setDisable(true);
            } else {
                Restriction restriction;
                HashSet<Restriction> equations = new HashSet<Restriction>(geometricPrimitive.getRestrictions());
                Iterator<Restriction> iterator = this.feature.getRestrictions().iterator();
                block0: while (iterator.hasNext()) {
                    restriction = iterator.next();
                    if (equations.contains(restriction)) continue;
                    for (UnknownParameter unknownParameter : geometricPrimitive.getUnknownParameters()) {
                        if (!restriction.contains(unknownParameter) && !restriction.contains(geometricPrimitive)) continue;
                        this.removePrimitiveButton.setDisable(true);
                        continue block0;
                    }
                }
                iterator = this.feature.getPostProcessingCalculations().iterator();
                block2: while (iterator.hasNext()) {
                    restriction = iterator.next();
                    if (equations.contains(restriction)) continue;
                    for (UnknownParameter unknownParameter : geometricPrimitive.getUnknownParameters()) {
                        if (!restriction.contains(unknownParameter) && !restriction.contains(geometricPrimitive)) continue;
                        this.removePrimitiveButton.setDisable(true);
                        continue block2;
                    }
                }
            }
            this.primitiveTypeLabel.setText(GeometricPrimitiveDialog.getPrimitiveTypeLabel(this.geometricPrimitive.getPrimitiveType()));
            this.nameTextField.textProperty().bindBidirectional(this.geometricPrimitive.nameProperty());
        }
    }

    private void init() {
        if (this.dialog != null) {
            return;
        }
        this.dialog = new Dialog();
        this.dialog.setTitle(i18N.getString("FeatureDialog.title", "Feature"));
        this.dialog.setHeaderText(i18N.getString("FeatureDialog.header", "Feature properties"));
        this.dialog.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{ButtonType.OK});
        this.dialog.initModality(Modality.APPLICATION_MODAL);
        this.dialog.initOwner(this.window);
        this.dialog.getDialogPane().setContent(this.createPane());
        this.dialog.setResizable(true);
        this.dialog.setResultConverter((Callback)new Callback<ButtonType, Feature>(){

            public Feature call(ButtonType buttonType) {
                if (buttonType == ButtonType.OK) {
                    return FeatureDialog.this.feature;
                }
                return null;
            }
        });
    }

    private Node createPane() {
        GridPane gridPane = DialogUtil.createGridPane();
        Label nameLabel = new Label(i18N.getString("FeatureDialog.primitive.name.label", "Name:"));
        Label typeLabel = new Label(i18N.getString("FeatureDialog.primitive.type.label", "Type:"));
        Label equationLabel = new Label(i18N.getString("FeatureDialog.equation.label", "Equation:"));
        this.nameTextField = DialogUtil.createTextField(i18N.getString("FeatureDialog.primitive.name.tooltip", "Name of geometric primitive"), i18N.getString("FeatureDialog.primitive.name.prompt", "Geometric primitive name"));
        this.nameTextField.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                UITreeBuilder.getInstance().getTree().refresh();
            }
        });
        this.latexLabel = new LaTexLabel();
        this.latexLabel.setMinSize(225.0, Double.NEGATIVE_INFINITY);
        this.latexLabel.setMaxSize(Double.MAX_VALUE, Double.NEGATIVE_INFINITY);
        this.primitiveTypeLabel = new Label();
        this.geometricPrimitiveList = DialogUtil.createGeometricPrimitiveListView(FeatureDialog.createGeometricPrimitiveCellFactory());
        this.geometricPrimitiveList.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new GeometricPrimitiveSelectionChangeListener());
        ManageGeometricPrimitiveEventHandler manageGeometricPrimitiveEventHandler = new ManageGeometricPrimitiveEventHandler();
        VBox buttonBox = new VBox(3.0);
        this.addPrimitiveButton = DialogUtil.createButton(i18N.getString("FeatureDialog.button.add.label", "Add"), i18N.getString("FeatureDialog.button.add.tooltip", "Add further geometric primitve"));
        this.removePrimitiveButton = DialogUtil.createButton(i18N.getString("FeatureDialog.button.remove.label", "Remove"), i18N.getString("FeatureDialog.button.remove.tooltip", "Remove selected geometric primitve"));
        this.addPrimitiveButton.setOnAction((EventHandler)manageGeometricPrimitiveEventHandler);
        this.removePrimitiveButton.setOnAction((EventHandler)manageGeometricPrimitiveEventHandler);
        this.addPrimitiveButton.setDisable(true);
        this.removePrimitiveButton.setDisable(true);
        VBox.setVgrow((Node)this.addPrimitiveButton, (Priority)Priority.ALWAYS);
        VBox.setVgrow((Node)this.removePrimitiveButton, (Priority)Priority.ALWAYS);
        buttonBox.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        buttonBox.getChildren().addAll((Object[])new Node[]{this.addPrimitiveButton, this.removePrimitiveButton});
        Region spacer = new Region();
        nameLabel.setLabelFor((Node)this.nameTextField);
        typeLabel.setLabelFor((Node)this.primitiveTypeLabel);
        equationLabel.setLabelFor((Node)this.latexLabel);
        nameLabel.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        typeLabel.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        equationLabel.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        nameLabel.setMaxWidth(Double.MAX_VALUE);
        typeLabel.setMaxWidth(Double.MAX_VALUE);
        equationLabel.setMaxWidth(Double.MAX_VALUE);
        GridPane.setHgrow((Node)nameLabel, (Priority)Priority.NEVER);
        GridPane.setHgrow((Node)typeLabel, (Priority)Priority.NEVER);
        GridPane.setHgrow((Node)buttonBox, (Priority)Priority.NEVER);
        GridPane.setHgrow((Node)equationLabel, (Priority)Priority.NEVER);
        GridPane.setHgrow((Node)this.nameTextField, (Priority)Priority.ALWAYS);
        GridPane.setHgrow((Node)this.primitiveTypeLabel, (Priority)Priority.ALWAYS);
        GridPane.setHgrow((Node)this.latexLabel, (Priority)Priority.ALWAYS);
        GridPane.setHgrow(this.geometricPrimitiveList, (Priority)Priority.NEVER);
        GridPane.setVgrow(this.geometricPrimitiveList, (Priority)Priority.ALWAYS);
        GridPane.setVgrow((Node)buttonBox, (Priority)Priority.NEVER);
        GridPane.setHgrow((Node)spacer, (Priority)Priority.ALWAYS);
        GridPane.setVgrow((Node)spacer, (Priority)Priority.ALWAYS);
        Insets insetsLeft = new Insets(5.0, 7.0, 5.0, 5.0);
        Insets insetsRight = new Insets(5.0, 0.0, 5.0, 7.0);
        GridPane.setMargin(this.geometricPrimitiveList, (Insets)new Insets(5.0, 10.0, 5.0, 0.0));
        GridPane.setMargin((Node)nameLabel, (Insets)insetsLeft);
        GridPane.setMargin((Node)typeLabel, (Insets)insetsLeft);
        GridPane.setMargin((Node)equationLabel, (Insets)insetsLeft);
        GridPane.setMargin((Node)buttonBox, (Insets)insetsLeft);
        GridPane.setMargin((Node)this.nameTextField, (Insets)insetsRight);
        GridPane.setMargin((Node)this.primitiveTypeLabel, (Insets)insetsRight);
        GridPane.setMargin((Node)this.latexLabel, (Insets)insetsRight);
        GridPane.setValignment((Node)equationLabel, (VPos)VPos.TOP);
        int row = 0;
        gridPane.add((Node)nameLabel, 1, row);
        gridPane.add((Node)this.nameTextField, 2, row++);
        gridPane.add((Node)typeLabel, 1, row);
        gridPane.add((Node)this.primitiveTypeLabel, 2, row++);
        gridPane.add((Node)equationLabel, 1, row);
        gridPane.add((Node)this.latexLabel, 2, row++);
        gridPane.add((Node)spacer, 1, row++, 2, 1);
        gridPane.add((Node)buttonBox, 1, row++);
        gridPane.add(this.geometricPrimitiveList, 0, 0, 1, row);
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                FeatureDialog.this.geometricPrimitiveList.requestFocus();
                if (FeatureDialog.this.geometricPrimitiveList.getItems().size() > 0) {
                    FeatureDialog.this.geometricPrimitiveList.getSelectionModel().clearAndSelect(0);
                    FeatureDialog.this.setGeometricPrimitive((GeometricPrimitive)FeatureDialog.this.geometricPrimitiveList.getItems().get(0));
                }
            }
        });
        return gridPane;
    }

    static StringConverter<PrimitiveType> createPrimitiveTypeStringConverter() {
        return new StringConverter<PrimitiveType>(){

            public String toString(PrimitiveType primitiveType) {
                return GeometricPrimitiveDialog.getPrimitiveTypeLabel(primitiveType);
            }

            public PrimitiveType fromString(String string) {
                return PrimitiveType.valueOf(string);
            }
        };
    }

    static Callback<ListView<GeometricPrimitive>, ListCell<GeometricPrimitive>> createGeometricPrimitiveCellFactory() {
        return new Callback<ListView<GeometricPrimitive>, ListCell<GeometricPrimitive>>(){

            public ListCell<GeometricPrimitive> call(ListView<GeometricPrimitive> listView) {
                return new ListCell<GeometricPrimitive>(){

                    protected void updateItem(GeometricPrimitive geometricPrimitive, boolean empty) {
                        super.updateItem((Object)geometricPrimitive, empty);
                        this.textProperty().unbind();
                        if (empty || geometricPrimitive == null) {
                            this.setText(null);
                            this.setTooltip(null);
                            this.setGraphic(null);
                        } else {
                            this.textProperty().bind(geometricPrimitive.nameProperty());
                        }
                    }
                };
            }
        };
    }

    private void addGeometricPrimitive(GeometricPrimitive geometricPrimitive) {
        if (geometricPrimitive != null) {
            this.feature.getGeometricPrimitives().add(geometricPrimitive);
        }
    }

    private void removeGeometricPrimitive() {
        if (this.feature != null && this.geometricPrimitive != null) {
            this.feature.getGeometricPrimitives().remove(this.geometricPrimitive);
        }
    }

    private class GeometricPrimitiveSelectionChangeListener
    implements ChangeListener<GeometricPrimitive> {
        private GeometricPrimitiveSelectionChangeListener() {
        }

        public void changed(ObservableValue<? extends GeometricPrimitive> observable, GeometricPrimitive oldValue, GeometricPrimitive newValue) {
            FeatureDialog.this.setGeometricPrimitive(newValue);
        }
    }

    private class ManageGeometricPrimitiveEventHandler
    implements EventHandler<ActionEvent> {
        private ManageGeometricPrimitiveEventHandler() {
        }

        public void handle(ActionEvent event) {
            if (event.getSource() == FeatureDialog.this.addPrimitiveButton && FeatureDialog.this.feature != null) {
                Optional<GeometricPrimitive> optional = GeometricPrimitiveDialog.showAndWait(FeatureDialog.this.feature.getFeatureType());
                if (optional.isPresent()) {
                    GeometricPrimitive result = optional.get();
                    FeatureDialog.this.addGeometricPrimitive(result);
                }
            } else if (event.getSource() == FeatureDialog.this.removePrimitiveButton) {
                FeatureDialog.this.removeGeometricPrimitive();
            }
        }
    }
}

