/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.juniform.ui.dialog;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Locale;
import javafx.application.Platform;
import javafx.concurrent.Task;
import javafx.concurrent.WorkerStateEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.DialogEvent;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.VBox;
import javafx.scene.text.Text;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.stage.WindowEvent;
import javafx.util.Callback;
import no.uib.cipr.matrix.MatrixSingularException;
import no.uib.cipr.matrix.NotConvergedException;
import org.applied_geodesy.adjustment.EstimationStateType;
import org.applied_geodesy.adjustment.EstimationType;
import org.applied_geodesy.adjustment.geometry.Feature;
import org.applied_geodesy.adjustment.geometry.FeatureAdjustment;
import org.applied_geodesy.juniform.ui.i18n.I18N;
import org.applied_geodesy.juniform.ui.menu.UIMenuBuilder;
import org.applied_geodesy.juniform.ui.table.UIParameterTableBuilder;
import org.applied_geodesy.juniform.ui.table.UIPointTableBuilder;
import org.applied_geodesy.juniform.ui.tree.UITreeBuilder;
import org.applied_geodesy.ui.dialog.OptionDialog;

public class FeatureAdjustmentDialog {
    private static FeatureAdjustmentDialog adjustmentDialog = new FeatureAdjustmentDialog();
    private Window window;
    private AdjustmentTask adjustmentTask;
    private boolean preventClosing = false;
    private I18N i18n = I18N.getInstance();
    private Dialog<EstimationStateType> dialog = null;
    private ProgressIndicator progressIndicator = new ProgressIndicator(-1.0);
    private Label iterationLabel = new Label();
    private Label progressLabel = new Label();
    private EstimationStateType result;

    private FeatureAdjustmentDialog() {
    }

    public static void show() {
        adjustmentDialog.init();
        adjustmentDialog.reset();
        FeatureAdjustmentDialog.adjustmentDialog.dialog.show();
        adjustmentDialog.process();
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    FeatureAdjustmentDialog.adjustmentDialog.dialog.getDialogPane().requestLayout();
                    Stage stage = (Stage)FeatureAdjustmentDialog.adjustmentDialog.dialog.getDialogPane().getScene().getWindow();
                    stage.sizeToScene();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public static void setOwner(Window owner) {
        FeatureAdjustmentDialog.adjustmentDialog.window = owner;
    }

    private void init() {
        if (this.dialog != null) {
            return;
        }
        this.dialog = new Dialog();
        this.dialog.initOwner(this.window);
        this.dialog.setTitle(this.i18n.getString("FeatureAdjustmentDialog.title", "Feature adjustment"));
        this.dialog.setHeaderText(this.i18n.getString("FeatureAdjustmentDialog.header", "Feature adjustment is processing\u2026"));
        this.dialog.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{ButtonType.CANCEL});
        this.dialog.initModality(Modality.APPLICATION_MODAL);
        VBox vbox = new VBox();
        vbox.getChildren().addAll((Object[])new Node[]{this.createProgressPane()});
        this.dialog.getDialogPane().getScene().getWindow().setOnCloseRequest((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent event) {
                if (FeatureAdjustmentDialog.this.preventClosing) {
                    event.consume();
                    if (FeatureAdjustmentDialog.this.adjustmentTask != null) {
                        FeatureAdjustmentDialog.this.adjustmentTask.cancelled();
                    }
                }
            }
        });
        this.dialog.setOnCloseRequest((EventHandler)new EventHandler<DialogEvent>(){

            public void handle(DialogEvent event) {
                if (FeatureAdjustmentDialog.this.preventClosing) {
                    event.consume();
                    if (FeatureAdjustmentDialog.this.adjustmentTask != null) {
                        FeatureAdjustmentDialog.this.adjustmentTask.cancelled();
                    }
                }
            }
        });
        this.dialog.setResultConverter((Callback)new Callback<ButtonType, EstimationStateType>(){

            public EstimationStateType call(ButtonType buttonType) {
                return FeatureAdjustmentDialog.this.result;
            }
        });
        this.dialog.getDialogPane().setContent((Node)vbox);
    }

    private void reset() {
        this.progressIndicator.setProgress(-1.0);
        this.iterationLabel.setText(null);
        this.progressLabel.setText(null);
        this.preventClosing = false;
        this.result = EstimationStateType.NOT_INITIALISED;
    }

    private Node createProgressPane() {
        GridPane gridPane = new GridPane();
        gridPane.setMinWidth(400.0);
        gridPane.setHgap(20.0);
        gridPane.setVgap(15.0);
        gridPane.setPadding(new Insets(5.0, 10.0, 5.0, 10.0));
        this.progressIndicator.setMinWidth(50.0);
        this.progressIndicator.setMinHeight(50.0);
        gridPane.add((Node)this.progressIndicator, 0, 0, 1, 3);
        gridPane.add((Node)this.iterationLabel, 1, 0);
        gridPane.add((Node)this.progressLabel, 1, 1);
        return gridPane;
    }

    private void process() {
        this.reset();
        FeatureAdjustment adjustment = UITreeBuilder.getInstance().getFeatureAdjustment();
        this.adjustmentTask = new AdjustmentTask(adjustment);
        this.adjustmentTask.setOnSucceeded((EventHandler)new EventHandler<WorkerStateEvent>(){

            public void handle(WorkerStateEvent event) {
                FeatureAdjustmentDialog.this.result = (EstimationStateType)((Object)FeatureAdjustmentDialog.this.adjustmentTask.getValue());
                UIMenuBuilder.getInstance().setReportMenuDisable(false);
                UITreeBuilder.getInstance().handleTreeSelections();
            }
        });
        this.adjustmentTask.setOnFailed((EventHandler)new EventHandler<WorkerStateEvent>(){

            public void handle(WorkerStateEvent event) {
                FeatureAdjustmentDialog.this.preventClosing = false;
                FeatureAdjustmentDialog.this.dialog.hide();
                final Throwable throwable = FeatureAdjustmentDialog.this.adjustmentTask.getException();
                if (throwable != null) {
                    if (throwable instanceof NotConvergedException) {
                        Platform.runLater((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                OptionDialog.showThrowableDialog((this).FeatureAdjustmentDialog.this.i18n.getString("FeatureAdjustmentDialog.message.error.failed.noconvergence.title", "Feature adjustment failed"), (this).FeatureAdjustmentDialog.this.i18n.getString("FeatureAdjustmentDialog.message.error.failed.noconvergence.header", "Iteration process diverges"), (this).FeatureAdjustmentDialog.this.i18n.getString("FeatureAdjustmentDialog.message.error.failed.noconvergence.message", "Error, iteration limit of adjustment process reached but without satisfactory convergence."), throwable);
                            }
                        });
                    } else if (throwable instanceof MatrixSingularException) {
                        Platform.runLater((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                OptionDialog.showThrowableDialog((this).FeatureAdjustmentDialog.this.i18n.getString("FeatureAdjustmentDialog.message.error.failed.singularmatrix.title", "Feature adjustment failed"), (this).FeatureAdjustmentDialog.this.i18n.getString("FeatureAdjustmentDialog.message.error.failed.singularmatrix.header", "Singular normal euqation matrix"), (this).FeatureAdjustmentDialog.this.i18n.getString("FeatureAdjustmentDialog.message.error.failed.singularmatrix.message", "Error, could not invert normal equation matrix."), throwable);
                            }
                        });
                    } else if (throwable instanceof OutOfMemoryError) {
                        Platform.runLater((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                OptionDialog.showThrowableDialog((this).FeatureAdjustmentDialog.this.i18n.getString("FeatureAdjustmentDialog.message.error.failed.outofmemory.title", "Feature adjustment failed"), (this).FeatureAdjustmentDialog.this.i18n.getString("FeatureAdjustmentDialog.message.error.failed.outofmemory.header", "Out of memory"), (this).FeatureAdjustmentDialog.this.i18n.getString("FeatureAdjustmentDialog.message.error.failed.outofmemory.message", "Error, not enough memory to adjust feature. Please allocate more memory."), throwable);
                            }
                        });
                    } else {
                        Platform.runLater((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                OptionDialog.showThrowableDialog((this).FeatureAdjustmentDialog.this.i18n.getString("FeatureAdjustmentDialog.message.error.failed.exception.title", "Feature adjustment failed"), (this).FeatureAdjustmentDialog.this.i18n.getString("FeatureAdjustmentDialog.message.error.failed.exception.header", "Error, could not adjust feature."), (this).FeatureAdjustmentDialog.this.i18n.getString("FeatureAdjustmentDialog.message.error.failed.exception.message", "An exception has occurred during feature adjustment."), throwable);
                            }
                        });
                    }
                    throwable.printStackTrace();
                }
                try {
                    FeatureAdjustmentDialog.this.refreshTables();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        Thread th = new Thread((Runnable)((Object)this.adjustmentTask));
        th.setDaemon(true);
        th.start();
    }

    private void refreshTables() {
        UIPointTableBuilder.getInstance().getTable().getSelectionModel().clearSelection();
        UIPointTableBuilder.getInstance().getTable().refresh();
        UIPointTableBuilder.getInstance().getTable().sort();
        UIParameterTableBuilder.getInstance().getTable().getSelectionModel().clearSelection();
        UIParameterTableBuilder.getInstance().getTable().refresh();
        UIParameterTableBuilder.getInstance().getTable().sort();
    }

    private class AdjustmentTask
    extends Task<EstimationStateType>
    implements PropertyChangeListener {
        private final String iterationTextTemplate;
        private final String convergenceTextTemplate;
        private final String unscentedTransformationTextTemplate;
        private final String dampingValueTextTemplate;
        private FeatureAdjustment adjustment;
        private double processState = 0.0;
        private double finalStepProcesses = 0.0;
        private boolean updateProgressOnIterate = true;

        private AdjustmentTask(FeatureAdjustment adjustment) {
            this.adjustment = adjustment;
            this.unscentedTransformationTextTemplate = FeatureAdjustmentDialog.this.i18n.getString("FeatureAdjustmentDialog.unscentedtransformation.label", "%d. unscented transformation step of %d \u2026");
            this.iterationTextTemplate = FeatureAdjustmentDialog.this.i18n.getString("FeatureAdjustmentDialog.iteration.label", "%d. iteration step of maximal %d \u2026");
            this.convergenceTextTemplate = FeatureAdjustmentDialog.this.i18n.getString("FeatureAdjustmentDialog.convergence.label", "Convergence max|dx| = %.2e");
            this.dampingValueTextTemplate = FeatureAdjustmentDialog.this.i18n.getString("FeatureAdjustmentDialog.damping.label", "Damping value \u03bb = %.2e");
        }

        protected EstimationStateType call() throws Exception {
            try {
                FeatureAdjustmentDialog.this.preventClosing = true;
                UIMenuBuilder.getInstance().setReportMenuDisable(true);
                this.updateProgress(-1.0, -1.0);
                this.updateMessage(FeatureAdjustmentDialog.this.i18n.getString("FeatureAdjustmentDialog.initialize.label", "Initialize process\u2026"));
                this.updateIterationProgressMessage(FeatureAdjustmentDialog.this.i18n.getString("FeatureAdjustmentDialog.pleasewait.label", "Please wait\u2026"));
                this.updateConvergenceProgressMessage(null);
                this.updateProgressOnIterate = this.adjustment.getEstimationType() != EstimationType.SPHERICAL_SIMPLEX_UNSCENTED_TRANSFORMATION && this.adjustment.getEstimationType() != EstimationType.MODIFIED_UNSCENTED_TRANSFORMATION;
                this.finalStepProcesses = 0.08333333333333333;
                this.adjustment.addPropertyChangeListener(this);
                this.processState = 0.0;
                this.updateProgress(this.processState, 1.0);
                if (this.isCancelled()) {
                    EstimationStateType estimationStateType = EstimationStateType.INTERRUPT;
                    return estimationStateType;
                }
                Feature feature = this.adjustment.getFeature();
                if (feature.isEstimateInitialGuess()) {
                    feature.deriveInitialGuess();
                }
                this.adjustment.init();
                EstimationStateType returnType = this.adjustment.estimateModel();
                if (this.isCancelled()) {
                    EstimationStateType estimationStateType = EstimationStateType.INTERRUPT;
                    return estimationStateType;
                }
                this.updateProgress(-1.0, -1.0);
                this.updateMessage(FeatureAdjustmentDialog.this.i18n.getString("FeatureAdjustmentDialog.save.label", "Save results\u2026"));
                this.updateIterationProgressMessage(FeatureAdjustmentDialog.this.i18n.getString("FeatureAdjustmentDialog.pleasewait.label", "Please wait\u2026"));
                this.updateConvergenceProgressMessage(null);
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        try {
                            FeatureAdjustmentDialog.this.refreshTables();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                });
                EstimationStateType estimationStateType = returnType;
                return estimationStateType;
            }
            finally {
                this.destroyFeatureAdjustment();
                this.updateIterationProgressMessage(null);
                this.updateConvergenceProgressMessage(null);
                FeatureAdjustmentDialog.this.preventClosing = false;
            }
        }

        protected void succeeded() {
            FeatureAdjustmentDialog.this.preventClosing = false;
            super.succeeded();
            this.hideDialog();
        }

        protected void failed() {
            FeatureAdjustmentDialog.this.preventClosing = false;
            super.failed();
            this.hideDialog();
        }

        protected void cancelled() {
            super.cancelled();
            if (this.adjustment != null) {
                this.adjustment.interrupt();
            }
        }

        private void hideDialog() {
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (!((AdjustmentTask)AdjustmentTask.this).FeatureAdjustmentDialog.this.preventClosing) {
                        ((AdjustmentTask)AdjustmentTask.this).FeatureAdjustmentDialog.this.dialog.hide();
                    }
                }
            });
        }

        private void updateIterationProgressMessage(final String message) {
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    ((AdjustmentTask)AdjustmentTask.this).FeatureAdjustmentDialog.this.iterationLabel.setText(message);
                }
            });
        }

        private void updateConvergenceProgressMessage(final String message) {
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    ((AdjustmentTask)AdjustmentTask.this).FeatureAdjustmentDialog.this.progressLabel.setText(message);
                }
            });
        }

        protected void updateMessage(final String message) {
            super.updateMessage(message);
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    ((AdjustmentTask)AdjustmentTask.this).FeatureAdjustmentDialog.this.dialog.setHeaderText(message);
                }
            });
        }

        protected void updateProgress(final double workDone, double max) {
            super.updateProgress(workDone, max);
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    Node node;
                    ((AdjustmentTask)AdjustmentTask.this).FeatureAdjustmentDialog.this.progressIndicator.setProgress(workDone);
                    if (workDone >= 1.0 && (node = ((AdjustmentTask)AdjustmentTask.this).FeatureAdjustmentDialog.this.progressIndicator.lookup(".percentage")) != null && node instanceof Text) {
                        Text text = (Text)node;
                        text.setText(((AdjustmentTask)AdjustmentTask.this).FeatureAdjustmentDialog.this.i18n.getString("FeatureAdjustmentDialog.done.label", "Done"));
                        ((AdjustmentTask)AdjustmentTask.this).FeatureAdjustmentDialog.this.progressIndicator.setPrefWidth(text.getLayoutBounds().getWidth());
                    }
                }
            });
        }

        private void destroyFeatureAdjustment() {
            if (this.adjustment != null) {
                this.adjustment.removePropertyChangeListener(this);
                this.adjustment = null;
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String name = evt.getPropertyName();
            EstimationStateType state = EstimationStateType.valueOf(name);
            if (state == null) {
                return;
            }
            Object oldValue = evt.getOldValue();
            Object newValue = evt.getNewValue();
            switch (state) {
                case BUSY: {
                    this.updateMessage(FeatureAdjustmentDialog.this.i18n.getString("FeatureAdjustmentDialog.busy.label", "Feature adjustment in process\u2026"));
                    this.updateIterationProgressMessage(null);
                    this.updateConvergenceProgressMessage(null);
                    break;
                }
                case CONVERGENCE: {
                    if (oldValue == null || newValue == null || !(oldValue instanceof Double) || !(newValue instanceof Double)) break;
                    double current = (Double)newValue;
                    double minimal = (Double)oldValue;
                    if (this.updateProgressOnIterate) {
                        double frac = 0.75 * Math.min(minimal / current, 1.0);
                        this.processState = Math.max(this.processState, frac);
                        this.updateProgress(this.processState, 1.0);
                    }
                    this.updateConvergenceProgressMessage(String.format(Locale.ENGLISH, this.convergenceTextTemplate, current, minimal));
                    break;
                }
                case ITERATE: {
                    if (oldValue == null || newValue == null || !(oldValue instanceof Integer) || !(newValue instanceof Integer)) break;
                    int current = (Integer)newValue;
                    int maximal = (Integer)oldValue;
                    if (this.updateProgressOnIterate) {
                        double frac = 0.75 * Math.min((double)current / (double)maximal, 1.0);
                        this.processState = Math.max(this.processState, frac);
                        this.updateProgress(this.processState, 1.0);
                    }
                    this.updateIterationProgressMessage(String.format(Locale.ENGLISH, this.iterationTextTemplate, current, maximal));
                    break;
                }
                case UNSCENTED_TRANSFORMATION_STEP: {
                    if (oldValue == null || newValue == null || !(oldValue instanceof Integer) || !(newValue instanceof Integer)) break;
                    int current = (Integer)newValue;
                    int maximal = (Integer)oldValue;
                    double frac = 0.75 * Math.min((double)current / (double)maximal, 1.0);
                    this.processState = Math.max(this.processState, frac);
                    this.updateMessage(String.format(Locale.ENGLISH, this.unscentedTransformationTextTemplate, current, maximal));
                    this.updateProgress(this.processState, 1.0);
                    break;
                }
                case INVERT_NORMAL_EQUATION_MATRIX: {
                    this.processState += this.finalStepProcesses;
                    this.updateProgress(this.processState, 1.0);
                    this.updateMessage(FeatureAdjustmentDialog.this.i18n.getString("FeatureAdjustmentDialog.invert_normal_equation_matrix.label", "Invert normal equation matrix\u2026"));
                    break;
                }
                case ESTIAMTE_STOCHASTIC_PARAMETERS: {
                    this.processState += this.finalStepProcesses;
                    this.updateProgress(this.processState, 1.0);
                    this.updateMessage(FeatureAdjustmentDialog.this.i18n.getString("FeatureAdjustmentDialog.estimate_stochastic_parameters.label", "Estimate stochastic parameters\u2026"));
                    break;
                }
                case ERROR_FREE_ESTIMATION: {
                    this.updateProgress(-1.0, -1.0);
                    this.updateMessage(FeatureAdjustmentDialog.this.i18n.getString("FeatureAdjustmentDialog.error_free_estimation.label", "Feature adjustment finished\u2026"));
                    break;
                }
                case INTERRUPT: {
                    this.updateMessage(FeatureAdjustmentDialog.this.i18n.getString("FeatureAdjustmentDialog.interrupt.label", "Terminate adjustment process\u2026"));
                    this.updateIterationProgressMessage(FeatureAdjustmentDialog.this.i18n.getString("FeatureAdjustmentDialog.pleasewait.label", "Please wait\u2026"));
                    this.updateConvergenceProgressMessage(null);
                    break;
                }
                case LEVENBERG_MARQUARDT_STEP: {
                    if (oldValue == null || newValue == null || !(oldValue instanceof Double) || !(newValue instanceof Double)) break;
                    double lambdaNew = (Double)newValue;
                    double lambdaOld = (Double)oldValue;
                    this.updateConvergenceProgressMessage(String.format(Locale.ENGLISH, this.dampingValueTextTemplate, lambdaNew, lambdaOld));
                    break;
                }
                case PRINCIPAL_COMPONENT_ANALYSIS: 
                case EXPORT_ADJUSTMENT_RESULTS: {
                    break;
                }
            }
        }
    }
}

