/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.juniform.ui.dialog;

import java.text.NumberFormat;
import java.util.List;
import java.util.Locale;
import javafx.beans.property.Property;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.RadioButton;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.Spinner;
import javafx.scene.control.SpinnerValueFactory;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.scene.control.TitledPane;
import javafx.scene.control.ToggleGroup;
import javafx.scene.control.Tooltip;
import javafx.scene.control.cell.ComboBoxListCell;
import javafx.scene.layout.GridPane;
import javafx.util.Callback;
import javafx.util.StringConverter;
import org.applied_geodesy.adjustment.EstimationType;
import org.applied_geodesy.adjustment.geometry.GeometricPrimitive;
import org.applied_geodesy.adjustment.geometry.PrimitiveType;
import org.applied_geodesy.adjustment.geometry.parameter.ParameterType;
import org.applied_geodesy.adjustment.geometry.parameter.ProcessingType;
import org.applied_geodesy.adjustment.geometry.parameter.UnknownParameter;
import org.applied_geodesy.adjustment.geometry.point.FeaturePoint;
import org.applied_geodesy.adjustment.geometry.restriction.ProductSumRestriction;
import org.applied_geodesy.adjustment.geometry.restriction.RestrictionType;
import org.applied_geodesy.adjustment.geometry.restriction.TrigonometricRestriction;
import org.applied_geodesy.adjustment.statistic.TestStatisticType;
import org.applied_geodesy.ui.spinner.DoubleSpinner;
import org.applied_geodesy.ui.textfield.DoubleTextField;
import org.applied_geodesy.util.CellValueType;

class DialogUtil {
    private DialogUtil() {
    }

    static ComboBox<EstimationType> createEstimationTypeComboBox(StringConverter<EstimationType> estimationTypeStringConverter, String tooltip) {
        ComboBox typeComboBox = new ComboBox();
        typeComboBox.getItems().setAll((Object[])EstimationType.values());
        typeComboBox.setConverter(estimationTypeStringConverter);
        typeComboBox.setTooltip(new Tooltip(tooltip));
        typeComboBox.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        typeComboBox.setMaxSize(Double.MAX_VALUE, Double.NEGATIVE_INFINITY);
        return typeComboBox;
    }

    static ComboBox<GeometricPrimitive> createGeometricPrimitiveComboBox(Callback<ListView<GeometricPrimitive>, ListCell<GeometricPrimitive>> geometricPrimitiveCellFactory, String tooltip) {
        ComboBox comboBox = new ComboBox();
        comboBox.setCellFactory(geometricPrimitiveCellFactory);
        comboBox.setButtonCell((ListCell)geometricPrimitiveCellFactory.call(null));
        comboBox.setTooltip(new Tooltip(tooltip));
        comboBox.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        comboBox.setMaxSize(Double.MAX_VALUE, Double.NEGATIVE_INFINITY);
        return comboBox;
    }

    static ComboBox<FeaturePoint> createFeaturePointComboBox(Callback<ListView<FeaturePoint>, ListCell<FeaturePoint>> featurePointCellFactory, String tooltip) {
        ComboBox comboBox = new ComboBox();
        comboBox.setCellFactory(featurePointCellFactory);
        comboBox.setButtonCell((ListCell)featurePointCellFactory.call(null));
        comboBox.setTooltip(new Tooltip(tooltip));
        comboBox.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        comboBox.setMaxSize(Double.MAX_VALUE, Double.NEGATIVE_INFINITY);
        return comboBox;
    }

    static ComboBox<PrimitiveType> createPrimitiveTypeComboBox(StringConverter<PrimitiveType> primitiveTypeStringConverter, String tooltip) {
        ComboBox typeComboBox = new ComboBox();
        typeComboBox.getItems().setAll((Object[])PrimitiveType.values());
        typeComboBox.setConverter(primitiveTypeStringConverter);
        typeComboBox.setTooltip(new Tooltip(tooltip));
        typeComboBox.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        typeComboBox.setMaxSize(Double.MAX_VALUE, Double.NEGATIVE_INFINITY);
        return typeComboBox;
    }

    static ComboBox<RestrictionType> createRestrictionTypeComboBox(StringConverter<RestrictionType> restrictionTypeStringConverter, String tooltip) {
        ComboBox typeComboBox = new ComboBox();
        typeComboBox.getItems().setAll((Object[])RestrictionType.values());
        typeComboBox.setConverter(restrictionTypeStringConverter);
        typeComboBox.setTooltip(new Tooltip(tooltip));
        typeComboBox.getSelectionModel().select((Object)RestrictionType.AVERAGE);
        typeComboBox.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        typeComboBox.setMaxSize(Double.MAX_VALUE, Double.NEGATIVE_INFINITY);
        return typeComboBox;
    }

    static ComboBox<UnknownParameter> createUnknownParameterComboBox(Callback<ListView<UnknownParameter>, ListCell<UnknownParameter>> unknownParameterCellFactory, String tooltip) {
        ComboBox comboBox = new ComboBox();
        comboBox.setCellFactory(unknownParameterCellFactory);
        comboBox.setButtonCell((ListCell)unknownParameterCellFactory.call(null));
        comboBox.setTooltip(new Tooltip(tooltip));
        comboBox.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        comboBox.setMaxSize(Double.MAX_VALUE, Double.NEGATIVE_INFINITY);
        return comboBox;
    }

    static ComboBox<TrigonometricRestriction.TrigonometricFunctionType> createTrigonometricFunctionTypeComboBox(StringConverter<TrigonometricRestriction.TrigonometricFunctionType> trigonometricFunctionTypeStringConverter, String tooltip) {
        ComboBox typeComboBox = new ComboBox();
        typeComboBox.getItems().setAll((Object[])TrigonometricRestriction.TrigonometricFunctionType.values());
        typeComboBox.setConverter(trigonometricFunctionTypeStringConverter);
        typeComboBox.setTooltip(new Tooltip(tooltip));
        typeComboBox.getSelectionModel().select((Object)TrigonometricRestriction.TrigonometricFunctionType.TANGENT);
        typeComboBox.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        typeComboBox.setMaxSize(Double.MAX_VALUE, Double.NEGATIVE_INFINITY);
        return typeComboBox;
    }

    static GridPane createGridPane() {
        GridPane gridPane = new GridPane();
        gridPane.setMaxWidth(Double.MAX_VALUE);
        gridPane.setMinWidth(Double.NEGATIVE_INFINITY);
        gridPane.setAlignment(Pos.TOP_CENTER);
        gridPane.setPadding(new Insets(5.0, 15.0, 5.0, 15.0));
        return gridPane;
    }

    static Button createButton(String title, String tooltip) {
        Label label = new Label(title);
        label.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        label.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        label.setPadding(new Insets(0.0, 0.0, 0.0, 0.0));
        Button button = new Button();
        button.setGraphic((Node)label);
        button.setTooltip(new Tooltip(tooltip));
        button.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        button.setMaxSize(Double.MAX_VALUE, Double.NEGATIVE_INFINITY);
        return button;
    }

    static ListView<UnknownParameter> createParameterListView(Callback<ListView<UnknownParameter>, ListCell<UnknownParameter>> unknownParameterCellFactory) {
        ListView list = new ListView();
        list.setCellFactory(unknownParameterCellFactory);
        list.getSelectionModel().setSelectionMode(SelectionMode.SINGLE);
        ListView placeholderList = new ListView();
        placeholderList.getItems().add((Object)new String());
        placeholderList.setDisable(true);
        list.setPlaceholder((Node)placeholderList);
        return list;
    }

    static ListView<GeometricPrimitive> createGeometricPrimitiveListView(Callback<ListView<GeometricPrimitive>, ListCell<GeometricPrimitive>> geometricPrimitiveCellFactory) {
        ListView list = new ListView();
        list.setCellFactory(geometricPrimitiveCellFactory);
        list.getSelectionModel().setSelectionMode(SelectionMode.SINGLE);
        ListView placeholderList = new ListView();
        placeholderList.getItems().add((Object)new String());
        placeholderList.setDisable(true);
        list.setPlaceholder((Node)placeholderList);
        return list;
    }

    static ListView<ProductSumRestriction.SignType> createSignTypeListView(StringConverter<ProductSumRestriction.SignType> signTypeStringConverter) {
        ListView list = new ListView();
        list.setCellFactory(ComboBoxListCell.forListView(signTypeStringConverter, (Object[])ProductSumRestriction.SignType.values()));
        list.getSelectionModel().setSelectionMode(SelectionMode.SINGLE);
        list.setEditable(true);
        ListView placeholderList = new ListView();
        placeholderList.getItems().add((Object)new String());
        placeholderList.setDisable(true);
        list.setPlaceholder((Node)placeholderList);
        return list;
    }

    static TextField createTextField(String tooltip, String prompt) {
        TextField textField = new TextField();
        textField.setTooltip(new Tooltip(tooltip));
        textField.setPromptText(prompt);
        textField.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        textField.setMaxSize(Double.MAX_VALUE, Double.NEGATIVE_INFINITY);
        return textField;
    }

    static DoubleTextField createDoubleTextField(CellValueType cellValueType, double value, String tooltip) {
        DoubleTextField textField = new DoubleTextField(value, cellValueType, true, DoubleTextField.ValueSupport.NON_NULL_VALUE_SUPPORT);
        textField.setTooltip(new Tooltip(tooltip));
        textField.setAlignment(Pos.CENTER_RIGHT);
        textField.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        textField.setMaxSize(Double.MAX_VALUE, Double.NEGATIVE_INFINITY);
        return textField;
    }

    static DoubleTextField createDoubleTextField(CellValueType cellValueType, double value, boolean displayUnit, DoubleTextField.ValueSupport valueSupport, double lowerBoundary, double upperBoundary, String tooltip) {
        DoubleTextField textField = new DoubleTextField(value, cellValueType, displayUnit, valueSupport, lowerBoundary, upperBoundary);
        textField.setTooltip(new Tooltip(tooltip));
        textField.setAlignment(Pos.CENTER_RIGHT);
        textField.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        textField.setMaxSize(Double.MAX_VALUE, Double.NEGATIVE_INFINITY);
        return textField;
    }

    static ComboBox<ParameterType> createParameterTypeComboBox(StringConverter<ParameterType> parameterTypeStringConverter, String tooltip) {
        ComboBox typeComboBox = new ComboBox();
        typeComboBox.getItems().setAll((Object[])ParameterType.values());
        typeComboBox.setConverter(parameterTypeStringConverter);
        typeComboBox.setTooltip(new Tooltip(tooltip));
        typeComboBox.getSelectionModel().select((Object)ParameterType.LENGTH);
        typeComboBox.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        typeComboBox.setMaxSize(Double.MAX_VALUE, Double.NEGATIVE_INFINITY);
        return typeComboBox;
    }

    static ComboBox<Boolean> createBooleanComboBox(StringConverter<Boolean> booleanTypeStringConverter, String tooltip) {
        ComboBox typeComboBox = new ComboBox();
        typeComboBox.getItems().setAll(List.of(Boolean.TRUE, Boolean.FALSE));
        typeComboBox.setConverter(booleanTypeStringConverter);
        typeComboBox.setTooltip(new Tooltip(tooltip));
        typeComboBox.getSelectionModel().select((Object)Boolean.TRUE);
        typeComboBox.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        typeComboBox.setMaxSize(Double.MAX_VALUE, Double.NEGATIVE_INFINITY);
        return typeComboBox;
    }

    static CheckBox createCheckBox(String title, String tooltip) {
        Label label = new Label(title);
        label.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        label.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        label.setPadding(new Insets(0.0, 0.0, 0.0, 3.0));
        CheckBox checkBox = new CheckBox();
        checkBox.setGraphic((Node)label);
        checkBox.setTooltip(new Tooltip(tooltip));
        checkBox.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        checkBox.setMaxSize(Double.MAX_VALUE, Double.NEGATIVE_INFINITY);
        return checkBox;
    }

    static RadioButton createRadioButton(String title, String tooltip, ToggleGroup toggleGroup) {
        Label label = new Label(title);
        label.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        label.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        label.setPadding(new Insets(0.0, 0.0, 0.0, 3.0));
        RadioButton radioButton = new RadioButton();
        radioButton.setGraphic((Node)label);
        radioButton.setTooltip(new Tooltip(tooltip));
        radioButton.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        radioButton.setMaxSize(Double.MAX_VALUE, Double.NEGATIVE_INFINITY);
        if (toggleGroup != null) {
            radioButton.setToggleGroup(toggleGroup);
        }
        return radioButton;
    }

    static ComboBox<TestStatisticType> createTestStatisticTypeComboBox(StringConverter<TestStatisticType> testStatisticTypeStringConverter, String tooltip) {
        ComboBox typeComboBox = new ComboBox();
        typeComboBox.getItems().setAll((Object[])TestStatisticType.values());
        typeComboBox.setConverter(testStatisticTypeStringConverter);
        typeComboBox.setTooltip(new Tooltip(tooltip));
        typeComboBox.getSelectionModel().select((Object)TestStatisticType.NONE);
        typeComboBox.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        typeComboBox.setMaxSize(Double.MAX_VALUE, Double.NEGATIVE_INFINITY);
        typeComboBox.setMaxWidth(Double.MAX_VALUE);
        return typeComboBox;
    }

    static DoubleSpinner createDoubleSpinner(CellValueType cellValueType, double min, double max, double amountToStepBy, String tooltip) {
        DoubleSpinner doubleSpinner = new DoubleSpinner(cellValueType, min, max, amountToStepBy);
        doubleSpinner.setMinWidth(75.0);
        doubleSpinner.setPrefWidth(100.0);
        doubleSpinner.setMaxWidth(Double.MAX_VALUE);
        doubleSpinner.setTooltip(new Tooltip(tooltip));
        return doubleSpinner;
    }

    static Spinner<Integer> createIntegerSpinner(int min, int max, int amountToStepBy, String tooltip) {
        final NumberFormat numberFormat = NumberFormat.getInstance(Locale.ENGLISH);
        numberFormat.setMaximumFractionDigits(0);
        numberFormat.setMinimumFractionDigits(0);
        numberFormat.setGroupingUsed(false);
        StringConverter<Integer> converter = new StringConverter<Integer>(){

            public Integer fromString(String s) {
                if (s == null || s.trim().isEmpty()) {
                    return null;
                }
                try {
                    return numberFormat.parse(s).intValue();
                }
                catch (Exception nfe) {
                    nfe.printStackTrace();
                    return null;
                }
            }

            public String toString(Integer d) {
                return d == null ? "" : numberFormat.format(d);
            }
        };
        final SpinnerValueFactory.IntegerSpinnerValueFactory integerFactory = new SpinnerValueFactory.IntegerSpinnerValueFactory(min, max);
        Spinner integerSpinner = new Spinner();
        integerSpinner.setEditable(true);
        integerSpinner.setValueFactory((SpinnerValueFactory)integerFactory);
        integerFactory.setConverter((StringConverter)converter);
        integerFactory.setAmountToStepBy(amountToStepBy);
        TextFormatter formatter = new TextFormatter(integerFactory.getConverter(), (Object)((Integer)integerFactory.getValue()));
        integerSpinner.getEditor().setTextFormatter(formatter);
        integerSpinner.getEditor().setAlignment(Pos.BOTTOM_RIGHT);
        integerFactory.valueProperty().bindBidirectional((Property)formatter.valueProperty());
        integerSpinner.setMinWidth(75.0);
        integerSpinner.setPrefWidth(100.0);
        integerSpinner.setMaxWidth(Double.MAX_VALUE);
        integerSpinner.setTooltip(new Tooltip(tooltip));
        integerFactory.valueProperty().addListener((ChangeListener)new ChangeListener<Integer>(){

            public void changed(ObservableValue<? extends Integer> observable, Integer oldValue, Integer newValue) {
                if (newValue == null) {
                    integerFactory.setValue((Object)oldValue);
                }
            }
        });
        return integerSpinner;
    }

    static ComboBox<ProcessingType> createProcessingTypeComboBox(StringConverter<ProcessingType> processingTypeStringConverter, String tooltip) {
        ComboBox typeComboBox = new ComboBox();
        typeComboBox.setConverter(processingTypeStringConverter);
        typeComboBox.setTooltip(new Tooltip(tooltip));
        typeComboBox.getSelectionModel().select((Object)ProcessingType.ADJUSTMENT);
        typeComboBox.setMinWidth(150.0);
        typeComboBox.setPrefWidth(200.0);
        typeComboBox.setMaxWidth(Double.MAX_VALUE);
        return typeComboBox;
    }

    static TitledPane createTitledPane(String title, String tooltip, Node content) {
        Label label = new Label(title);
        label.setTooltip(new Tooltip(tooltip));
        TitledPane titledPane = new TitledPane();
        titledPane.setGraphic((Node)label);
        titledPane.setCollapsible(true);
        titledPane.setAnimated(true);
        titledPane.setContent(content);
        titledPane.setPadding(new Insets(0.0, 10.0, 5.0, 10.0));
        return titledPane;
    }
}

