/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.juniform.ui.dialog;

import java.util.Optional;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.control.ListView;
import javafx.scene.control.TextField;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.util.Callback;
import org.applied_geodesy.adjustment.geometry.parameter.UnknownParameter;
import org.applied_geodesy.adjustment.geometry.restriction.AverageRestriction;
import org.applied_geodesy.juniform.ui.dialog.DialogUtil;
import org.applied_geodesy.juniform.ui.dialog.UnknownParameterDialog;
import org.applied_geodesy.juniform.ui.i18n.I18N;
import org.applied_geodesy.ui.tex.LaTexLabel;

public class AverageRestrictionDialog {
    private static I18N i18N = I18N.getInstance();
    private static AverageRestrictionDialog restrictionTypeDialog = new AverageRestrictionDialog();
    private Dialog<AverageRestriction> dialog = null;
    private LaTexLabel latexLabel;
    private ComboBox<UnknownParameter> regressorComboBox;
    private ListView<UnknownParameter> regressorListView;
    private Button addParameterButtom;
    private Button removeParameterButtom;
    private ComboBox<UnknownParameter> regressandComboBox;
    private TextField descriptionTextField;
    private Window window;
    private AverageRestriction restriction;

    private AverageRestrictionDialog() {
    }

    public static void setOwner(Window owner) {
        AverageRestrictionDialog.restrictionTypeDialog.window = owner;
    }

    public static Optional<AverageRestriction> showAndWait(ObservableList<UnknownParameter> unknownParameters, AverageRestriction averageRestriction) {
        restrictionTypeDialog.init();
        restrictionTypeDialog.setUnknownParameters(unknownParameters);
        restrictionTypeDialog.setRestriction(averageRestriction);
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    AverageRestrictionDialog.restrictionTypeDialog.dialog.getDialogPane().requestLayout();
                    Stage stage = (Stage)AverageRestrictionDialog.restrictionTypeDialog.dialog.getDialogPane().getScene().getWindow();
                    stage.sizeToScene();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        return AverageRestrictionDialog.restrictionTypeDialog.dialog.showAndWait();
    }

    private void setUnknownParameters(ObservableList<UnknownParameter> unknownParameters) {
        ObservableList unknownParameterList = FXCollections.observableArrayList(unknownParameters);
        this.regressorComboBox.setItems(unknownParameterList);
        this.regressandComboBox.setItems(unknownParameterList);
    }

    private void setRestriction(AverageRestriction restriction) {
        if (this.restriction != null) {
            this.descriptionTextField.textProperty().unbindBidirectional(this.restriction.descriptionProperty());
            this.regressandComboBox.valueProperty().unbindBidirectional(this.restriction.regressandProperty());
            this.regressorListView.setItems(FXCollections.emptyObservableList());
        }
        this.restriction = restriction;
        this.descriptionTextField.textProperty().bindBidirectional(this.restriction.descriptionProperty());
        this.regressandComboBox.valueProperty().bindBidirectional(this.restriction.regressandProperty());
        this.regressorListView.setItems(this.restriction.getRegressors());
        this.latexLabel.setTex(this.restriction.toLaTex());
        this.regressorListView.setDisable(restriction.isIndispensable());
        this.regressorComboBox.setDisable(restriction.isIndispensable());
        this.regressandComboBox.setDisable(restriction.isIndispensable());
        this.addParameterButtom.setDisable(restriction.isIndispensable());
        this.removeParameterButtom.setDisable(restriction.isIndispensable());
        if (!restriction.isIndispensable()) {
            UnknownParameter regressand = this.restriction.getRegressand();
            if (regressand == null) {
                this.regressandComboBox.getSelectionModel().clearAndSelect(0);
            }
            this.regressorComboBox.getSelectionModel().clearAndSelect(0);
        } else {
            this.regressorComboBox.getSelectionModel().clearSelection();
        }
    }

    private void init() {
        if (this.dialog != null) {
            return;
        }
        this.dialog = new Dialog();
        this.dialog.setTitle(i18N.getString("AverageRestrictionDialog.title", "Average restriction"));
        this.dialog.setHeaderText(i18N.getString("AverageRestrictionDialog.header", "Average value restriction"));
        this.dialog.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{ButtonType.OK});
        this.dialog.initModality(Modality.APPLICATION_MODAL);
        this.dialog.initOwner(this.window);
        this.dialog.getDialogPane().setContent(this.createPane());
        this.dialog.setResizable(true);
        this.dialog.setResultConverter((Callback)new Callback<ButtonType, AverageRestriction>(){

            public AverageRestriction call(ButtonType buttonType) {
                if (buttonType == ButtonType.OK) {
                    return AverageRestrictionDialog.this.restriction;
                }
                return null;
            }
        });
    }

    private Node createPane() {
        GridPane gridPane = DialogUtil.createGridPane();
        Label equationLabel = new Label(i18N.getString("AverageRestrictionDialog.equation.label", "Equation:"));
        Label descriptionLabel = new Label(i18N.getString("AverageRestrictionDialog.description.label", "Description:"));
        Label regressandLabel = new Label(i18N.getString("AverageRestrictionDialog.regressand.label", "Regressand c:"));
        Label regressorLabel = new Label(i18N.getString("AverageRestrictionDialog.regressor.label", "Regressor a:"));
        regressorLabel.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        regressorLabel.setMaxWidth(Double.MAX_VALUE);
        this.descriptionTextField = DialogUtil.createTextField(i18N.getString("AverageRestrictionDialog.description.tooltip", "Description of parameter restriction"), i18N.getString("AverageRestrictionDialog.description.prompt", "Restriction description"));
        this.regressorComboBox = DialogUtil.createUnknownParameterComboBox(UnknownParameterDialog.createUnknownParameterCellFactory(), i18N.getString("AverageRestrictionDialog.regressor.tooltip", "Select regressor a"));
        this.regressandComboBox = DialogUtil.createUnknownParameterComboBox(UnknownParameterDialog.createUnknownParameterCellFactory(), i18N.getString("AverageRestrictionDialog.regressand.tooltip", "Select regressand c"));
        this.latexLabel = new LaTexLabel();
        this.latexLabel.setPrefSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        this.latexLabel.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        this.regressorListView = DialogUtil.createParameterListView(UnknownParameterDialog.createUnknownParameterCellFactory());
        RegressorEventHandler regressorEventHandler = new RegressorEventHandler();
        this.addParameterButtom = DialogUtil.createButton(i18N.getString("AverageRestrictionDialog.regressor.add.label", "+"), i18N.getString("AverageRestrictionDialog.regressor.add.tooltip", "Add parameter to regressor list"));
        this.removeParameterButtom = DialogUtil.createButton(i18N.getString("AverageRestrictionDialog.regressor.remove.label", "-"), i18N.getString("AverageRestrictionDialog.regressor.remove.tooltip", "Remove regressor"));
        this.addParameterButtom.setOnAction((EventHandler)regressorEventHandler);
        this.removeParameterButtom.setOnAction((EventHandler)regressorEventHandler);
        HBox buttonBoxA = new HBox(5.0);
        HBox.setHgrow((Node)this.addParameterButtom, (Priority)Priority.NEVER);
        HBox.setHgrow((Node)this.removeParameterButtom, (Priority)Priority.NEVER);
        buttonBoxA.getChildren().addAll((Object[])new Node[]{this.addParameterButtom, this.removeParameterButtom});
        equationLabel.setLabelFor((Node)this.latexLabel);
        descriptionLabel.setLabelFor((Node)this.descriptionTextField);
        regressandLabel.setLabelFor(this.regressandComboBox);
        regressorLabel.setLabelFor(this.regressorComboBox);
        regressorLabel.setAlignment(Pos.TOP_CENTER);
        HBox regressorsBox = new HBox(10.0);
        VBox regressorABox = new VBox(5.0);
        regressorsBox.setPrefHeight(200.0);
        HBox.setHgrow((Node)regressorABox, (Priority)Priority.ALWAYS);
        VBox.setVgrow((Node)regressorLabel, (Priority)Priority.NEVER);
        VBox.setVgrow(this.regressorComboBox, (Priority)Priority.NEVER);
        VBox.setVgrow(this.regressorListView, (Priority)Priority.ALWAYS);
        regressorABox.getChildren().addAll((Object[])new Node[]{regressorLabel, this.regressorComboBox, this.regressorListView, buttonBoxA});
        regressorsBox.getChildren().addAll((Object[])new Node[]{regressorABox});
        GridPane.setHgrow((Node)equationLabel, (Priority)Priority.NEVER);
        GridPane.setHgrow((Node)descriptionLabel, (Priority)Priority.NEVER);
        GridPane.setHgrow((Node)regressandLabel, (Priority)Priority.NEVER);
        GridPane.setHgrow((Node)this.latexLabel, (Priority)Priority.ALWAYS);
        GridPane.setHgrow((Node)this.descriptionTextField, (Priority)Priority.ALWAYS);
        GridPane.setHgrow(this.regressandComboBox, (Priority)Priority.ALWAYS);
        GridPane.setHgrow((Node)regressorsBox, (Priority)Priority.ALWAYS);
        GridPane.setVgrow((Node)regressorsBox, (Priority)Priority.ALWAYS);
        Insets insetsLeft = new Insets(5.0, 7.0, 5.0, 5.0);
        Insets insetsRight = new Insets(5.0, 0.0, 5.0, 7.0);
        GridPane.setMargin((Node)equationLabel, (Insets)insetsLeft);
        GridPane.setMargin((Node)regressandLabel, (Insets)insetsLeft);
        GridPane.setMargin((Node)descriptionLabel, (Insets)insetsLeft);
        GridPane.setMargin((Node)this.latexLabel, (Insets)insetsRight);
        GridPane.setMargin(this.regressandComboBox, (Insets)insetsRight);
        GridPane.setMargin((Node)this.descriptionTextField, (Insets)insetsRight);
        GridPane.setMargin((Node)regressorsBox, (Insets)new Insets(10.0, 5.0, 5.0, 5.0));
        int row = 0;
        gridPane.add((Node)equationLabel, 0, row);
        gridPane.add((Node)this.latexLabel, 1, row++);
        gridPane.add((Node)descriptionLabel, 0, row);
        gridPane.add((Node)this.descriptionTextField, 1, row++);
        gridPane.add((Node)regressandLabel, 0, row);
        gridPane.add(this.regressandComboBox, 1, row++);
        gridPane.add((Node)regressorsBox, 0, row++, 2, 1);
        return gridPane;
    }

    private class RegressorEventHandler
    implements EventHandler<ActionEvent> {
        private RegressorEventHandler() {
        }

        public void handle(ActionEvent event) {
            UnknownParameter parameter;
            if (event.getSource() == AverageRestrictionDialog.this.addParameterButtom) {
                UnknownParameter parameter2 = (UnknownParameter)AverageRestrictionDialog.this.regressorComboBox.getValue();
                if (parameter2 != null) {
                    AverageRestrictionDialog.this.regressorListView.getItems().add((Object)parameter2);
                }
            } else if (event.getSource() == AverageRestrictionDialog.this.removeParameterButtom && (parameter = (UnknownParameter)AverageRestrictionDialog.this.regressorListView.getSelectionModel().getSelectedItem()) != null) {
                AverageRestrictionDialog.this.regressorListView.getItems().remove((Object)parameter);
            }
        }
    }
}

