/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.juniform.ui;

import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Application;
import javafx.application.HostServices;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.SplitPane;
import javafx.scene.control.TabPane;
import javafx.scene.control.Tooltip;
import javafx.scene.control.TreeView;
import javafx.scene.effect.DropShadow;
import javafx.scene.effect.Effect;
import javafx.scene.image.Image;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.scene.text.Text;
import javafx.stage.Stage;
import javafx.stage.Window;
import org.applied_geodesy.adjustment.geometry.FeatureAdjustment;
import org.applied_geodesy.adjustment.geometry.FeatureChangeListener;
import org.applied_geodesy.adjustment.geometry.FeatureEvent;
import org.applied_geodesy.jag3d.ui.JAG3D;
import org.applied_geodesy.juniform.io.writer.FTLReport;
import org.applied_geodesy.juniform.ui.dialog.AboutDialog;
import org.applied_geodesy.juniform.ui.dialog.AverageRestrictionDialog;
import org.applied_geodesy.juniform.ui.dialog.FeatureAdjustmentDialog;
import org.applied_geodesy.juniform.ui.dialog.FeatureDialog;
import org.applied_geodesy.juniform.ui.dialog.FeaturePointRestrictionDialog;
import org.applied_geodesy.juniform.ui.dialog.FormatterOptionDialog;
import org.applied_geodesy.juniform.ui.dialog.GeometricPrimitiveDialog;
import org.applied_geodesy.juniform.ui.dialog.LeastSquaresSettingDialog;
import org.applied_geodesy.juniform.ui.dialog.MatrixDialog;
import org.applied_geodesy.juniform.ui.dialog.ProductSumRestrictionDialog;
import org.applied_geodesy.juniform.ui.dialog.QuantilesDialog;
import org.applied_geodesy.juniform.ui.dialog.ReadFileProgressDialog;
import org.applied_geodesy.juniform.ui.dialog.RestrictionDialog;
import org.applied_geodesy.juniform.ui.dialog.RestrictionTypeDialog;
import org.applied_geodesy.juniform.ui.dialog.TestStatisticDialog;
import org.applied_geodesy.juniform.ui.dialog.TrigonometricRestrictionDialog;
import org.applied_geodesy.juniform.ui.dialog.UnknownParameterDialog;
import org.applied_geodesy.juniform.ui.dialog.UnknownParameterTypeDialog;
import org.applied_geodesy.juniform.ui.dialog.VarianceComponentsDialog;
import org.applied_geodesy.juniform.ui.dialog.VectorAngleRestrictionDialog;
import org.applied_geodesy.juniform.ui.i18n.I18N;
import org.applied_geodesy.juniform.ui.menu.UIMenuBuilder;
import org.applied_geodesy.juniform.ui.table.UIParameterTableBuilder;
import org.applied_geodesy.juniform.ui.table.UIPointTableBuilder;
import org.applied_geodesy.juniform.ui.tabpane.UITabPaneBuilder;
import org.applied_geodesy.juniform.ui.tree.TreeItemValue;
import org.applied_geodesy.juniform.ui.tree.UITreeBuilder;
import org.applied_geodesy.ui.dialog.OptionDialog;
import org.applied_geodesy.util.ImageUtils;
import org.applied_geodesy.version.juniform.Version;

public class JUniForm
extends Application {
    private static final String TITLE_TEMPLATE = "%s%sJUniForm%s \u00b7 Curves and Surfaces Fitting \u00b7";
    private static Stage primaryStage;
    private Button adjustmentButton;

    public static void setTitle(String title) {
        if (primaryStage != null && title != null && !title.trim().isEmpty()) {
            primaryStage.setTitle(String.format(Locale.ENGLISH, TITLE_TEMPLATE, title, " \u2014 ", Version.isReleaseCandidate() ? " (RC)" : ""));
        } else if (primaryStage != null) {
            primaryStage.setTitle(String.format(Locale.ENGLISH, TITLE_TEMPLATE, "", "", Version.isReleaseCandidate() ? " (RC)" : ""));
        }
    }

    public static void close() {
        primaryStage.close();
    }

    public static Stage getStage() {
        return primaryStage;
    }

    private void setHostServices() {
        HostServices hostServices = this.getHostServices();
        FTLReport.setHostServices(hostServices);
        AboutDialog.setHostServices(hostServices);
    }

    private void setStageToDialogs(Stage primaryStage) {
        OptionDialog.setOwner((Window)primaryStage);
        TestStatisticDialog.setOwner((Window)primaryStage);
        UnknownParameterDialog.setOwner((Window)primaryStage);
        UnknownParameterTypeDialog.setOwner((Window)primaryStage);
        RestrictionDialog.setOwner((Window)primaryStage);
        RestrictionTypeDialog.setOwner((Window)primaryStage);
        AverageRestrictionDialog.setOwner((Window)primaryStage);
        ProductSumRestrictionDialog.setOwner((Window)primaryStage);
        FeatureDialog.setOwner((Window)primaryStage);
        GeometricPrimitiveDialog.setOwner((Window)primaryStage);
        MatrixDialog.setOwner((Window)primaryStage);
        FeatureAdjustmentDialog.setOwner((Window)primaryStage);
        LeastSquaresSettingDialog.setOwner((Window)primaryStage);
        ReadFileProgressDialog.setOwner((Window)primaryStage);
        FormatterOptionDialog.setOwner((Window)primaryStage);
        AboutDialog.setOwner((Window)primaryStage);
        FeaturePointRestrictionDialog.setOwner((Window)primaryStage);
        VectorAngleRestrictionDialog.setOwner((Window)primaryStage);
        TrigonometricRestrictionDialog.setOwner((Window)primaryStage);
        QuantilesDialog.setOwner((Window)primaryStage);
        VarianceComponentsDialog.setOwner((Window)primaryStage);
    }

    public void start(Stage primaryStage) throws Exception {
        if (JUniForm.primaryStage != primaryStage) {
            I18N i18n = I18N.getInstance();
            JUniForm.primaryStage = primaryStage;
            UITabPaneBuilder tabPaneBuilder = UITabPaneBuilder.getInstance();
            UIMenuBuilder menuBuilder = UIMenuBuilder.getInstance();
            UITreeBuilder treeBuilder = UITreeBuilder.getInstance();
            this.adjustmentButton = new Button(i18n.getString("JUniForm.button.adjust.label", "Adjust feature"));
            this.adjustmentButton.setTooltip(new Tooltip(i18n.getString("JUniForm.button.adjust.tooltip", "Start feature adjustment process")));
            this.adjustmentButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent event) {
                    FeatureAdjustmentDialog.show();
                }
            });
            this.adjustmentButton.setDisable(true);
            final TabPane tabPane = tabPaneBuilder.getTabPane();
            TreeView<TreeItemValue<?>> tree = treeBuilder.getTree();
            SplitPane splitPane = new SplitPane();
            splitPane.setOrientation(Orientation.HORIZONTAL);
            splitPane.getItems().addAll((Object[])new Node[]{tree, tabPane});
            splitPane.setDividerPositions(new double[]{0.3});
            SplitPane.setResizableWithParent(tree, (Boolean)false);
            DropShadow ds = new DropShadow();
            ds.setOffsetY(0.5);
            ds.setColor(Color.gray((double)0.8));
            Text applicationName = new Text();
            applicationName.setEffect((Effect)ds);
            applicationName.setCache(true);
            applicationName.setFill((Paint)Color.GREY);
            applicationName.setText("Java\u00b7Unified\u00b7Form\u00b7Fitting");
            applicationName.setFont(Font.font((String)"SansSerif", (FontWeight)FontWeight.NORMAL, (double)17.0));
            Region spacer = new Region();
            HBox hbox = new HBox(10.0);
            hbox.setPadding(new Insets(5.0, 10.0, 5.0, 15.0));
            HBox.setHgrow((Node)spacer, (Priority)Priority.ALWAYS);
            hbox.getChildren().addAll((Object[])new Node[]{applicationName, spacer, this.adjustmentButton});
            BorderPane border = new BorderPane();
            border.setPrefSize(900.0, 650.0);
            border.setTop((Node)menuBuilder.getMenuBar());
            border.setCenter((Node)splitPane);
            border.setBottom((Node)hbox);
            Scene scene = new Scene((Parent)border);
            scene.addEventFilter(KeyEvent.KEY_PRESSED, (EventHandler)new EventHandler<KeyEvent>(){
                final KeyCombination adjustKeyComb = new KeyCodeCombination(KeyCode.F5, new KeyCombination.Modifier[0]);
                final KeyCombination tabOneKeyComb = new KeyCodeCombination(KeyCode.DIGIT1, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN});
                final KeyCombination tabTwoKeyComb = new KeyCodeCombination(KeyCode.DIGIT2, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN});
                final KeyCombination tabThreeKeyComb = new KeyCodeCombination(KeyCode.DIGIT3, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN});
                final KeyCombination tabFourKeyComb = new KeyCodeCombination(KeyCode.DIGIT4, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN});
                final KeyCombination tabFiveKeyComb = new KeyCodeCombination(KeyCode.DIGIT5, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN});
                final KeyCombination tabSixKeyComb = new KeyCodeCombination(KeyCode.DIGIT6, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN});
                final KeyCombination tabSevenKeyComb = new KeyCodeCombination(KeyCode.DIGIT7, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN});
                final KeyCombination tabEightKeyComb = new KeyCodeCombination(KeyCode.DIGIT8, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN});
                final KeyCombination tabNineKeyComb = new KeyCodeCombination(KeyCode.DIGIT9, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN});
                final KeyCombination tabOneKeyCombNum = new KeyCodeCombination(KeyCode.NUMPAD1, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN});
                final KeyCombination tabTwoKeyCombNum = new KeyCodeCombination(KeyCode.NUMPAD2, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN});
                final KeyCombination tabThreeKeyCombNum = new KeyCodeCombination(KeyCode.NUMPAD3, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN});
                final KeyCombination tabFourKeyCombNum = new KeyCodeCombination(KeyCode.NUMPAD4, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN});
                final KeyCombination tabFiveKeyCombNum = new KeyCodeCombination(KeyCode.NUMPAD5, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN});
                final KeyCombination tabSixKeyCombNum = new KeyCodeCombination(KeyCode.NUMPAD6, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN});
                final KeyCombination tabSevenKeyCombNum = new KeyCodeCombination(KeyCode.NUMPAD7, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN});
                final KeyCombination tabEightKeyCombNum = new KeyCodeCombination(KeyCode.NUMPAD8, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN});
                final KeyCombination tabNineKeyCombNum = new KeyCodeCombination(KeyCode.NUMPAD9, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN});

                public void handle(KeyEvent keyEvent) {
                    if (this.adjustKeyComb.match(keyEvent) && !JUniForm.this.adjustmentButton.isDisabled()) {
                        JUniForm.this.adjustmentButton.fire();
                        keyEvent.consume();
                    } else if (tabPane.getSelectionModel().getSelectedItem() != null && (this.tabOneKeyComb.match(keyEvent) || this.tabTwoKeyComb.match(keyEvent) || this.tabThreeKeyComb.match(keyEvent) || this.tabFourKeyComb.match(keyEvent) || this.tabFiveKeyComb.match(keyEvent) || this.tabSixKeyComb.match(keyEvent) || this.tabSevenKeyComb.match(keyEvent) || this.tabEightKeyComb.match(keyEvent) || this.tabNineKeyComb.match(keyEvent) || this.tabOneKeyCombNum.match(keyEvent) || this.tabTwoKeyCombNum.match(keyEvent) || this.tabThreeKeyCombNum.match(keyEvent) || this.tabFourKeyCombNum.match(keyEvent) || this.tabFiveKeyCombNum.match(keyEvent) || this.tabSixKeyCombNum.match(keyEvent) || this.tabSevenKeyCombNum.match(keyEvent) || this.tabEightKeyCombNum.match(keyEvent) || this.tabNineKeyCombNum.match(keyEvent))) {
                        int size = tabPane.getTabs().size();
                        if ((this.tabOneKeyComb.match(keyEvent) || this.tabOneKeyCombNum.match(keyEvent)) && size > 0) {
                            tabPane.getSelectionModel().clearAndSelect(0);
                        } else if ((this.tabTwoKeyComb.match(keyEvent) || this.tabTwoKeyCombNum.match(keyEvent)) && size > 1) {
                            tabPane.getSelectionModel().clearAndSelect(1);
                        } else if ((this.tabThreeKeyComb.match(keyEvent) || this.tabThreeKeyCombNum.match(keyEvent)) && size > 2) {
                            tabPane.getSelectionModel().clearAndSelect(2);
                        } else if ((this.tabFourKeyComb.match(keyEvent) || this.tabFourKeyCombNum.match(keyEvent)) && size > 3) {
                            tabPane.getSelectionModel().clearAndSelect(3);
                        } else if ((this.tabFiveKeyComb.match(keyEvent) || this.tabFiveKeyCombNum.match(keyEvent)) && size > 4) {
                            tabPane.getSelectionModel().clearAndSelect(4);
                        } else if ((this.tabSixKeyComb.match(keyEvent) || this.tabSixKeyCombNum.match(keyEvent)) && size > 5) {
                            tabPane.getSelectionModel().clearAndSelect(5);
                        } else if ((this.tabSevenKeyComb.match(keyEvent) || this.tabSevenKeyCombNum.match(keyEvent)) && size > 6) {
                            tabPane.getSelectionModel().clearAndSelect(6);
                        } else if ((this.tabEightKeyComb.match(keyEvent) || this.tabEightKeyCombNum.match(keyEvent)) && size > 7) {
                            tabPane.getSelectionModel().clearAndSelect(7);
                        } else if ((this.tabNineKeyComb.match(keyEvent) || this.tabNineKeyCombNum.match(keyEvent)) && size > 8) {
                            tabPane.getSelectionModel().clearAndSelect(8);
                        }
                        keyEvent.consume();
                    }
                }
            });
            try {
                URL cssURL = null;
                cssURL = JAG3D.class.getClassLoader().getResource("css/");
                if (cssURL != null && Files.exists(Paths.get((cssURL = cssURL.toURI().resolve("juniform.css").toURL()).toURI()), new LinkOption[0])) {
                    scene.getStylesheets().add((Object)cssURL.toExternalForm());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                primaryStage.getIcons().addAll((Object[])new Image[]{ImageUtils.getImage("JUniForm_16x16.png"), ImageUtils.getImage("JUniForm_32x32.png"), ImageUtils.getImage("JUniForm_64x64.png")});
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            primaryStage.setScene(scene);
            JUniForm.setTitle(null);
            primaryStage.show();
            primaryStage.toFront();
            this.setHostServices();
            this.setStageToDialogs(primaryStage);
            FeatureAdjustment adjustment = treeBuilder.getFeatureAdjustment();
            adjustment.addFeatureChangeListener(treeBuilder);
            adjustment.addFeatureChangeListener(UIMenuBuilder.getInstance());
            adjustment.addFeatureChangeListener(UIParameterTableBuilder.getInstance());
            adjustment.addFeatureChangeListener(UIPointTableBuilder.getInstance());
            adjustment.addFeatureChangeListener(new AdjustmentFeatureChangedListener());
        } else {
            primaryStage.show();
            primaryStage.toFront();
        }
    }

    public static void main(String[] args) {
        try {
            Logger[] loggers;
            Logger[] loggerArray = loggers = new Logger[]{Logger.getLogger("hsqldb.db"), Logger.getLogger("com.github.fommil.netlib.LAPACK"), Logger.getLogger("com.github.fommil.netlib.BLAS")};
            int n = loggers.length;
            int n2 = 0;
            while (n2 < n) {
                Logger logger = loggerArray[n2];
                logger.setUseParentHandlers(false);
                logger.setLevel(Level.OFF);
                ++n2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Application.launch(JUniForm.class, (String[])args);
    }

    private class AdjustmentFeatureChangedListener
    implements FeatureChangeListener {
        private AdjustmentFeatureChangedListener() {
        }

        @Override
        public void featureChanged(FeatureEvent evt) {
            JUniForm.this.adjustmentButton.setDisable(evt.getEventType() == FeatureEvent.FeatureEventType.FEATURE_REMOVED);
        }
    }
}

