/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.juniform.test.tracim;

import java.util.List;
import no.uib.cipr.matrix.MatrixSingularException;
import no.uib.cipr.matrix.NotConvergedException;
import org.applied_geodesy.adjustment.EstimationStateType;
import org.applied_geodesy.adjustment.geometry.Feature;
import org.applied_geodesy.adjustment.geometry.FeatureAdjustment;
import org.applied_geodesy.adjustment.geometry.GeometricPrimitive;
import org.applied_geodesy.adjustment.geometry.point.FeaturePoint;

class TraCIMTest {
    TraCIMTest() {
    }

    public Feature adjust(Feature feature, List<FeaturePoint> points) {
        return this.adjust(feature, points, 0.0);
    }

    public Feature adjust(Feature feature, List<FeaturePoint> points, double lambda) {
        FeatureAdjustment adjustment = new FeatureAdjustment();
        for (GeometricPrimitive geometricPrimitive : feature) {
            geometricPrimitive.getFeaturePoints().addAll(points);
        }
        try {
            if (feature.isEstimateInitialGuess()) {
                feature.deriveInitialGuess();
            }
            adjustment.setLevenbergMarquardtDampingValue(Math.max(lambda, 0.0));
            adjustment.setFeature(feature);
            adjustment.init();
            EstimationStateType type = adjustment.estimateModel();
            if (type == EstimationStateType.ERROR_FREE_ESTIMATION) {
                return feature;
            }
        }
        catch (IllegalArgumentException | UnsupportedOperationException | MatrixSingularException | NotConvergedException e) {
            e.printStackTrace();
        }
        return null;
    }
}

