/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.juniform.test.tracim;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringReader;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathConstants;
import org.applied_geodesy.adjustment.geometry.Feature;
import org.applied_geodesy.adjustment.geometry.parameter.ParameterType;
import org.applied_geodesy.adjustment.geometry.parameter.UnknownParameter;
import org.applied_geodesy.adjustment.geometry.point.FeaturePoint;
import org.applied_geodesy.adjustment.geometry.surface.CircularConeFeature;
import org.applied_geodesy.adjustment.geometry.surface.CircularCylinderFeature;
import org.applied_geodesy.adjustment.geometry.surface.PlaneFeature;
import org.applied_geodesy.adjustment.geometry.surface.SpatialCircleFeature;
import org.applied_geodesy.adjustment.geometry.surface.SpatialLineFeature;
import org.applied_geodesy.adjustment.geometry.surface.SphereFeature;
import org.applied_geodesy.juniform.test.tracim.TraCIMTest;
import org.applied_geodesy.util.XMLUtilities;
import org.applied_geodesy.version.coordtrans.Version;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class TraCIM {
    private final String orderId;
    private final String baseURI = "https://tracim.ptb.de/tracim/api";
    private final String customer = "Steinbeis Transfer Centre Applied Geodesy";
    private final String vendor = "Dr.-Ing. Michael L\u00f6sler";
    private final String software = "Java\u00b7Applied\u00b7Geodesy\u00b73D";
    private final String version = String.valueOf(Version.get()).substring(0, 4);
    private final String revision = String.valueOf(Version.get()).substring(4);
    private String processId;
    public static final boolean READ_DATA_FROM_LOCAL_FILE = false;
    public static final String NUMBER_TEMPLATE = "%+.20f";
    public static final String BASE_PATH = "./tracim";
    public static final boolean STORE_COMPLETE_TRANSACTION = true;

    public TraCIM(String orderId) {
        this.orderId = orderId;
    }

    public Document getTestData() throws IOException, ParserConfigurationException, SAXException, URISyntaxException {
        String xmlString = "";
        String address = "https://tracim.ptb.de/tracim/api" + "/order/" + this.orderId + "/test";
        xmlString = this.sendRequest(address, null);
        String txtFile = "./tracim/gauss_data_sets_" + this.orderId + ".xml";
        this.toFile(new File(txtFile), xmlString);
        return this.convertStringToXMLDocument(xmlString);
    }

    public void saveReport(File file, String xmlResult) throws ParserConfigurationException, SAXException, IOException, URISyntaxException {
        String xmlString = this.submitResult(xmlResult);
        String txtFile = "./tracim/gauss_test_report_" + this.orderId + ".xml";
        this.toFile(new File(txtFile), xmlString);
        Document document = this.convertStringToXMLDocument(xmlString);
        String xpathPattern = "//tracim/validation";
        Node validationElement = (Node)XMLUtilities.xpathSearch(document, xpathPattern, null, XPathConstants.NODE);
        String reportPDF = (String)XMLUtilities.xpathSearch(validationElement, "./reportPDF", null, XPathConstants.STRING);
        try (FileOutputStream fos = null;){
            fos = new FileOutputStream(file);
            byte[] decoder = Base64.getDecoder().decode(reportPDF);
            fos.write(decoder);
            fos.flush();
        }
    }

    public String getResultAsXMLString(Document document) throws IOException {
        String xpathPattern = "//tracim//process/key";
        this.processId = (String)XMLUtilities.xpathSearch(document, xpathPattern, null, XPathConstants.STRING);
        StringBuffer xmlStringBuffer = new StringBuffer();
        xmlStringBuffer.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n");
        xmlStringBuffer.append("<gaussResultPackage xmlns:tracim=\"http://tracim.ptb.de/tracim\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns=\"http://tracim.ptb.de/gauss/test\">\r\n");
        xmlStringBuffer.append("<processKey>").append(this.processId).append("</processKey>\r\n");
        xmlStringBuffer.append("<customer>").append("Steinbeis Transfer Centre Applied Geodesy").append("</customer>\r\n");
        xmlStringBuffer.append("<softwareVendor>").append("Dr.-Ing. Michael L\u00f6sler").append("</softwareVendor>\r\n");
        xmlStringBuffer.append("<softwareName>").append("Java\u00b7Applied\u00b7Geodesy\u00b73D").append("</softwareName>\r\n");
        xmlStringBuffer.append("<softwareVersion>").append(this.version).append("</softwareVersion>\r\n");
        xmlStringBuffer.append("<softwareRev>").append(this.revision).append("</softwareRev>\r\n");
        xmlStringBuffer.append("<resultPackage>\r\n").append(this.performTests(document)).append("</resultPackage>\r\n");
        xmlStringBuffer.append("<mpe_size>0.0001</mpe_size>\r\n");
        xmlStringBuffer.append("<mpe_angle>0.0000001</mpe_angle>\r\n");
        xmlStringBuffer.append("<mpe_position>0.0001</mpe_position>\r\n");
        xmlStringBuffer.append("<mpe_orientation>0.0000001</mpe_orientation>\r\n");
        xmlStringBuffer.append("</gaussResultPackage>\r\n");
        String xmlString = xmlStringBuffer.toString();
        String txtFile = "./tracim/gauss_adjustment_results_" + this.orderId + ".xml";
        this.toFile(new File(txtFile), xmlString);
        return xmlString;
    }

    private Document convertStringToXMLDocument(String xmlString) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = builder.parse(new InputSource(new StringReader(xmlString)));
        return doc;
    }

    private String submitResult(String xmlResult) throws IOException, URISyntaxException {
        String address = "https://tracim.ptb.de/tracim/api" + "/test/" + this.processId;
        String response = this.sendRequest(address, xmlResult);
        return response;
    }

    private String getFileContent(String fileName) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        BufferedReader reader = null;
        try {
            String str;
            reader = new BufferedReader(new FileReader(fileName));
            while ((str = reader.readLine()) != null) {
                stringBuffer.append(str);
            }
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return stringBuffer.toString();
    }

    private String sendRequest(String address, String data) throws IOException, URISyntaxException {
        String response;
        block6: {
            response = null;
            try (BufferedReader in = null;){
                data = data == null ? "" : data;
                URL url = new URI(address).toURL();
                StringBuilder postData = new StringBuilder();
                postData.append(URLEncoder.encode(String.valueOf(data), "UTF-8"));
                byte[] postDataBytes = data.getBytes("UTF-8");
                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                conn.setReadTimeout(10000);
                conn.setConnectTimeout(15000);
                conn.setRequestMethod("POST");
                conn.setRequestProperty("Accept-Charset", "UTF-8");
                conn.setRequestProperty("Content-Type", "application/xml");
                conn.setRequestProperty("accept", "application/xml");
                conn.setRequestProperty("Content-Length", String.valueOf(postDataBytes.length));
                conn.setInstanceFollowRedirects(true);
                conn.setDoOutput(true);
                conn.setDoInput(true);
                conn.getOutputStream().write(postDataBytes);
                int responseCode = conn.getResponseCode();
                if (responseCode == 200) {
                    int c;
                    in = new BufferedReader(new InputStreamReader(conn.getInputStream(), Charset.forName("UTF-8")));
                    StringBuilder sb = new StringBuilder();
                    while ((c = in.read()) >= 0) {
                        sb.append((char)c);
                    }
                    response = sb.toString();
                    break block6;
                }
                Map<Integer, String> errors = Map.of(403, "No more tests left for this test process.\r\nTest process already closed.\r\nTest Data already used.", 404, "Unknown order number.", 422, "Unknown request type. Consult specific message.\r\nProcess key does not match!\r\nCustomer element is blank!\r\nSoftware vendor element is blank!\r\nSoftware name element is blank!\r\nSoftware version element is blank!\r\nMPE-elements not present. You are allowed to set MPE\u2019s to zero but the elements have to be present!\r\nCheck your MPEs! If you set one MPE you have to set it all!\r\nCheck your MPEs! Negative MPE\u2019s are not allowed.", 500, "Internal Server error.");
                throw new IOException("Error, server response code is " + responseCode + "\r\n" + errors.get(responseCode));
            }
        }
        return response;
    }

    /*
     * Unable to fully structure code
     */
    private String performTests(Document document) throws IOException {
        xmlResults = new StringBuffer();
        xpathPattern = "//tracim//testElement";
        testElementList = (NodeList)XMLUtilities.xpathSearch(document, xpathPattern, null, XPathConstants.NODESET);
        i = 0;
        while (i < testElementList.getLength()) {
            testElement = testElementList.item(i);
            xpath = "./basicID";
            bId = (String)XMLUtilities.xpathSearch(testElement, xpath, null, XPathConstants.STRING);
            xpath = "./computationObject";
            object = (String)XMLUtilities.xpathSearch(testElement, xpath, null, XPathConstants.STRING);
            xpath = "./pointCloud/vectors";
            vectorsList = (NodeList)XMLUtilities.xpathSearch(testElement, xpath, null, XPathConstants.NODESET);
            cnt = 0;
            points = new ArrayList<FeaturePoint>(vectorsList.getLength());
            j = 0;
            while (j < vectorsList.getLength()) {
                vector = vectorsList.item(j);
                x = (Number)XMLUtilities.xpathSearch(vector, "./x", null, XPathConstants.NUMBER);
                y = (Number)XMLUtilities.xpathSearch(vector, "./y", null, XPathConstants.NUMBER);
                z = (Number)XMLUtilities.xpathSearch(vector, "./z", null, XPathConstants.NUMBER);
                if ((point = new FeaturePoint(String.valueOf(++cnt), x.doubleValue(), y.doubleValue(), z.doubleValue())) != null) {
                    points.add(point);
                }
                ++j;
            }
            txtFile = "./tracim/" + bId + "_" + object + "_" + this.orderId + ".txt";
            this.toFile(new File(txtFile), points);
            xmlResults.append("<results>\r\n");
            xmlResults.append("<basicID>").append(bId).append("</basicID>\r\n");
            xmlResults.append("<computationObject>").append(object).append("</computationObject>\r\n");
            xmlResults.append("<refParameter>\r\n");
            traCIMTest = new TraCIMTest();
            feature = null;
            unknownParameters = null;
            var34_47 = object;
            tmp = -1;
            switch (var34_47.hashCode()) {
                case -1842652211: {
                    if (var34_47.equals("SPHERE")) {
                        tmp = 1;
                    }
                    break;
                }
                case 2074403: {
                    if (var34_47.equals("CONE")) {
                        tmp = 2;
                    }
                    break;
                }
                case 76210748: {
                    if (var34_47.equals("PLANE")) {
                        tmp = 3;
                    }
                    break;
                }
                case 433248214: {
                    if (var34_47.equals("CYLINDER")) {
                        tmp = 4;
                    }
                    break;
                }
                case 894914204: {
                    if (var34_47.equals("LINE_3D")) {
                        tmp = 5;
                    }
                    break;
                }
                case 1988079824: {
                    if (var34_47.equals("CIRCLE")) {
                        tmp = 6;
                    }
                    break;
                }
            }
            switch (tmp) {
                case 5: {
                    feature = traCIMTest.adjust(new SpatialLineFeature(), points);
                    if (feature == null) {
                        System.err.println("Error, least-squares failed for " + object + ", " + bId);
                        break;
                    }
                    unknownParameters = this.convertParameterListToMap((List<UnknownParameter>)feature.getUnknownParameters());
                    x0 = unknownParameters.get((Object)ParameterType.ORIGIN_COORDINATE_X).getValue();
                    y0 = unknownParameters.get((Object)ParameterType.ORIGIN_COORDINATE_Y).getValue();
                    z0 = unknownParameters.get((Object)ParameterType.ORIGIN_COORDINATE_Z).getValue();
                    nx = unknownParameters.get((Object)ParameterType.VECTOR_X).getValue();
                    ny = unknownParameters.get((Object)ParameterType.VECTOR_Y).getValue();
                    nz = unknownParameters.get((Object)ParameterType.VECTOR_Z).getValue();
                    this.addPosition(xmlResults, x0, y0, z0);
                    this.addNormalVector(xmlResults, nx, ny, nz);
                    txtFile = "./tracim/" + bId + "_" + object + "_" + this.orderId + ".sol";
                    this.toFile(new File(txtFile), new double[]{x0, y0, z0, nx, ny, nz});
                    ** GOTO lbl202
                }
                case 3: {
                    feature = traCIMTest.adjust(new PlaneFeature(), points);
                    if (feature == null) {
                        System.err.println("Error, least-squares failed for " + object + ", " + bId);
                        break;
                    }
                    unknownParameters = this.convertParameterListToMap((List<UnknownParameter>)feature.getUnknownParameters());
                    nx = unknownParameters.get((Object)ParameterType.VECTOR_X).getValue();
                    ny = unknownParameters.get((Object)ParameterType.VECTOR_Y).getValue();
                    nz = unknownParameters.get((Object)ParameterType.VECTOR_Z).getValue();
                    d = unknownParameters.get((Object)ParameterType.LENGTH).getValue();
                    if (nx > ny && nx > nz) {
                        x0 = d / nx;
                        y0 = 0.0;
                        z0 = 0.0;
                    } else if (ny > nx && ny > nz) {
                        x0 = 0.0;
                        y0 = d / ny;
                        z0 = 0.0;
                    } else {
                        x0 = 0.0;
                        y0 = 0.0;
                        z0 = d / nz;
                    }
                    this.addPosition(xmlResults, x0, y0, z0);
                    this.addNormalVector(xmlResults, nx, ny, nz);
                    txtFile = "./tracim/" + bId + "_" + object + "_" + this.orderId + ".sol";
                    this.toFile(new File(txtFile), new double[]{x0, y0, z0, nx, ny, nz});
                    ** GOTO lbl202
                }
                case 6: {
                    feature = traCIMTest.adjust(new SpatialCircleFeature(), points);
                    if (feature == null) {
                        System.err.println("Error, least-squares failed for " + object + ", " + bId);
                        break;
                    }
                    unknownParameters = this.convertParameterListToMap((List<UnknownParameter>)feature.getUnknownParameters());
                    x0 = unknownParameters.get((Object)ParameterType.ORIGIN_COORDINATE_X).getValue();
                    y0 = unknownParameters.get((Object)ParameterType.ORIGIN_COORDINATE_Y).getValue();
                    z0 = unknownParameters.get((Object)ParameterType.ORIGIN_COORDINATE_Z).getValue();
                    nx = unknownParameters.get((Object)ParameterType.VECTOR_X).getValue();
                    ny = unknownParameters.get((Object)ParameterType.VECTOR_Y).getValue();
                    nz = unknownParameters.get((Object)ParameterType.VECTOR_Z).getValue();
                    r = unknownParameters.get((Object)ParameterType.RADIUS).getValue();
                    this.addPosition(xmlResults, x0, y0, z0);
                    this.addNormalVector(xmlResults, nx, ny, nz);
                    this.addRadius(xmlResults, r);
                    txtFile = "./tracim/" + bId + "_" + object + "_" + this.orderId + ".sol";
                    this.toFile(new File(txtFile), new double[]{x0, y0, z0, nx, ny, nz, r});
                    ** GOTO lbl202
                }
                case 4: {
                    feature = traCIMTest.adjust(new CircularCylinderFeature(), points);
                    if (feature == null) {
                        System.err.println("Error, least-squares failed for " + object + ", " + bId);
                        break;
                    }
                    unknownParameters = this.convertParameterListToMap((List<UnknownParameter>)feature.getUnknownParameters());
                    x0 = unknownParameters.get((Object)ParameterType.ORIGIN_COORDINATE_X).getValue();
                    y0 = unknownParameters.get((Object)ParameterType.ORIGIN_COORDINATE_Y).getValue();
                    z0 = unknownParameters.get((Object)ParameterType.ORIGIN_COORDINATE_Z).getValue();
                    nx = unknownParameters.get((Object)ParameterType.VECTOR_X).getValue();
                    ny = unknownParameters.get((Object)ParameterType.VECTOR_Y).getValue();
                    nz = unknownParameters.get((Object)ParameterType.VECTOR_Z).getValue();
                    r = unknownParameters.get((Object)ParameterType.RADIUS).getValue();
                    this.addPosition(xmlResults, x0, y0, z0);
                    this.addNormalVector(xmlResults, nx, ny, nz);
                    this.addRadius(xmlResults, r);
                    txtFile = "./tracim/" + bId + "_" + object + "_" + this.orderId + ".sol";
                    this.toFile(new File(txtFile), new double[]{x0, y0, z0, nx, ny, nz, r});
                    ** GOTO lbl202
                }
                case 2: {
                    feature = traCIMTest.adjust(new CircularConeFeature(), points, 1.0E-4);
                    if (feature == null) {
                        System.err.println("Error, least-squares failed for " + object + ", " + bId);
                        break;
                    }
                    unknownParameters = this.convertParameterListToMap((List<UnknownParameter>)feature.getUnknownParameters());
                    x0 = unknownParameters.get((Object)ParameterType.ORIGIN_COORDINATE_X).getValue();
                    y0 = unknownParameters.get((Object)ParameterType.ORIGIN_COORDINATE_Y).getValue();
                    z0 = unknownParameters.get((Object)ParameterType.ORIGIN_COORDINATE_Z).getValue();
                    nx = unknownParameters.get((Object)ParameterType.ROTATION_COMPONENT_R31).getValue();
                    ny = unknownParameters.get((Object)ParameterType.ROTATION_COMPONENT_R32).getValue();
                    nz = unknownParameters.get((Object)ParameterType.ROTATION_COMPONENT_R33).getValue();
                    alpha = Math.abs(unknownParameters.get((Object)ParameterType.ANGLE).getValue());
                    r = 0.0;
                    point = Feature.deriveCenterOfMass(points);
                    mx = point.getX0() - x0;
                    my = point.getY0() - y0;
                    mz = point.getZ0() - z0;
                    if ((phi = Math.acos(nx * (mx /= (len = Math.sqrt(mx * mx + my * my + mz * mz))) + ny * (my /= len) + nz * (mz /= len))) < alpha) {
                        nx = -nx;
                        ny = -ny;
                        nz = -nz;
                    }
                    alpha = 2.0 * alpha * 57.29577951308232;
                    this.addPosition(xmlResults, x0, y0, z0);
                    this.addNormalVector(xmlResults, nx, ny, nz);
                    this.addRadius(xmlResults, r);
                    this.addAngle(xmlResults, alpha);
                    txtFile = "./tracim/" + bId + "_" + object + "_" + this.orderId + ".sol";
                    this.toFile(new File(txtFile), new double[]{x0, y0, z0, nx, ny, nz, alpha, r});
                    ** GOTO lbl202
                }
                case 1: {
                    feature = traCIMTest.adjust(new SphereFeature(), points);
                    if (feature == null) {
                        System.err.println("Error, least-squares failed for " + object + ", " + bId);
                        break;
                    }
                    unknownParameters = this.convertParameterListToMap((List<UnknownParameter>)feature.getUnknownParameters());
                    x0 = unknownParameters.get((Object)ParameterType.ORIGIN_COORDINATE_X).getValue();
                    y0 = unknownParameters.get((Object)ParameterType.ORIGIN_COORDINATE_Y).getValue();
                    z0 = unknownParameters.get((Object)ParameterType.ORIGIN_COORDINATE_Z).getValue();
                    r = unknownParameters.get((Object)ParameterType.RADIUS).getValue();
                    this.addPosition(xmlResults, x0, y0, z0);
                    this.addRadius(xmlResults, r);
                    txtFile = "./tracim/" + bId + "_" + object + "_" + this.orderId + ".sol";
                    this.toFile(new File(txtFile), new double[]{x0, y0, z0, r});
                }
lbl202:
                // 7 sources

                default: {
                    xmlResults.append("</refParameter>\r\n");
                    xmlResults.append("</results>\r\n");
                }
            }
            ++i;
        }
        return xmlResults.toString();
    }

    private Map<ParameterType, UnknownParameter> convertParameterListToMap(List<UnknownParameter> unknownParameters) {
        HashMap<ParameterType, UnknownParameter> unknownParameterMap = new HashMap<ParameterType, UnknownParameter>(unknownParameters.size());
        for (UnknownParameter unknownParameter : unknownParameters) {
            if (!unknownParameter.isVisible()) continue;
            unknownParameterMap.put(unknownParameter.getParameterType(), unknownParameter);
        }
        return unknownParameterMap;
    }

    private void addPosition(StringBuffer sb, double x, double y, double z) {
        sb.append("<positionX>").append(String.format(Locale.ENGLISH, NUMBER_TEMPLATE, x)).append("</positionX>\r\n");
        sb.append("<positionY>").append(String.format(Locale.ENGLISH, NUMBER_TEMPLATE, y)).append("</positionY>\r\n");
        sb.append("<positionZ>").append(String.format(Locale.ENGLISH, NUMBER_TEMPLATE, z)).append("</positionZ>\r\n");
    }

    private void addNormalVector(StringBuffer sb, double nx, double ny, double nz) {
        sb.append("<orientationX>").append(String.format(Locale.ENGLISH, NUMBER_TEMPLATE, nx)).append("</orientationX>\r\n");
        sb.append("<orientationY>").append(String.format(Locale.ENGLISH, NUMBER_TEMPLATE, ny)).append("</orientationY>\r\n");
        sb.append("<orientationZ>").append(String.format(Locale.ENGLISH, NUMBER_TEMPLATE, nz)).append("</orientationZ>\r\n");
    }

    private void addRadius(StringBuffer sb, double radius) {
        sb.append("<radius>").append(String.format(Locale.ENGLISH, NUMBER_TEMPLATE, radius)).append("</radius>\r\n");
    }

    private void addAngle(StringBuffer sb, double alpha) {
        sb.append("<angle>").append(String.format(Locale.ENGLISH, NUMBER_TEMPLATE, alpha)).append("</angle>\r\n");
    }

    private void toFile(File file, double[] array) throws IOException {
        StringBuffer sb = new StringBuffer();
        double[] dArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            double d = dArray[n2];
            sb.append(String.format(Locale.ENGLISH, NUMBER_TEMPLATE, d)).append("\r\n");
            ++n2;
        }
        this.toFile(file, sb.toString());
    }

    private void toFile(File file, String string) throws IOException {
        try (PrintWriter pw = null;){
            pw = new PrintWriter(new BufferedWriter(new FileWriter(file)));
            pw.println(string);
        }
    }

    private void toFile(File file, List<FeaturePoint> points) throws IOException {
        try (PrintWriter pw = null;){
            pw = new PrintWriter(new BufferedWriter(new FileWriter(file)));
            String format = "%25s\t%35.15f\t%35.15f\t%35.15f%n";
            for (FeaturePoint point : points) {
                pw.printf(Locale.ENGLISH, format, point.getName(), point.getX(), point.getY(), point.getZ());
            }
        }
    }

    public static void main(String[] args) {
        System.setProperty("com.github.fommil.netlib.BLAS", "com.github.fommil.netlib.F2jBLAS");
        System.setProperty("com.github.fommil.netlib.LAPACK", "com.github.fommil.netlib.F2jLAPACK");
        System.setProperty("com.github.fommil.netlib.ARPACK", "com.github.fommil.netlib.F2jARPACK");
        String processKey = "";
        try {
            TraCIM traCIM = new TraCIM("");
            Document document = traCIM.getTestData();
            String xmlResult = traCIM.getResultAsXMLString(document);
            traCIM.saveReport(new File("./tracim/gauss_test_report_.pdf"), xmlResult);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

