/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.juniform.test.nist;

import java.util.List;
import java.util.Locale;
import org.applied_geodesy.adjustment.geometry.Feature;
import org.applied_geodesy.adjustment.geometry.parameter.ParameterType;
import org.applied_geodesy.adjustment.geometry.parameter.UnknownParameter;
import org.applied_geodesy.adjustment.geometry.surface.SpatialLineFeature;
import org.applied_geodesy.juniform.test.nist.NISTTest;

public class SpatialLineTest
extends NISTTest {
    private SpatialLineTest() {
    }

    @Override
    void compare(List<Double> referenceResults, List<UnknownParameter> unknownParameters) {
        double x0Ref = referenceResults.get(0);
        double y0Ref = referenceResults.get(1);
        double z0Ref = referenceResults.get(2);
        double nxRef = referenceResults.get(3);
        double nyRef = referenceResults.get(4);
        double nzRef = referenceResults.get(5);
        double d = nxRef * x0Ref + nyRef * y0Ref + nzRef * z0Ref;
        double[] references = new double[]{x0Ref -= d * nxRef, y0Ref -= d * nyRef, z0Ref -= d * nzRef, nxRef, nyRef, nzRef};
        List<ParameterType> types = List.of(ParameterType.ORIGIN_COORDINATE_X, ParameterType.ORIGIN_COORDINATE_Y, ParameterType.ORIGIN_COORDINATE_Z, ParameterType.VECTOR_X, ParameterType.VECTOR_Y, ParameterType.VECTOR_Z);
        int i = 0;
        while (i < types.size()) {
            for (UnknownParameter unknownParameter : unknownParameters) {
                if (unknownParameter.getParameterType() != types.get(i)) continue;
                double diff = Math.abs(unknownParameter.getValue()) - Math.abs(references[i]);
                System.out.println(String.format(Locale.ENGLISH, "%30s EST = %+25.16f REF = %+25.16f  DIFF = %+6.3e %s", new Object[]{unknownParameter.getParameterType(), unknownParameter.getValue(), references[i], diff, Math.abs(diff) > EPS ? "***" : ""}));
                break;
            }
            ++i;
        }
    }

    @Override
    Feature getFeature() {
        return new SpatialLineFeature();
    }

    @Override
    int getDimension() {
        return 3;
    }

    public static void main(String[] args) throws Exception {
        System.setProperty("com.github.fommil.netlib.BLAS", "com.github.fommil.netlib.F2jBLAS");
        System.setProperty("com.github.fommil.netlib.LAPACK", "com.github.fommil.netlib.F2jLAPACK");
        System.setProperty("com.github.fommil.netlib.ARPACK", "com.github.fommil.netlib.F2jARPACK");
        SpatialLineTest test2d = new SpatialLineTest();
        test2d.start("./nist/Line2d/");
        SpatialLineTest test3d = new SpatialLineTest();
        test3d.start("./nist/Line3d/");
    }
}

