/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.juniform.test.nist;

import java.io.BufferedReader;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import no.uib.cipr.matrix.MatrixSingularException;
import no.uib.cipr.matrix.NotConvergedException;
import org.applied_geodesy.adjustment.Constant;
import org.applied_geodesy.adjustment.EstimationStateType;
import org.applied_geodesy.adjustment.geometry.Feature;
import org.applied_geodesy.adjustment.geometry.FeatureAdjustment;
import org.applied_geodesy.adjustment.geometry.GeometricPrimitive;
import org.applied_geodesy.adjustment.geometry.parameter.UnknownParameter;
import org.applied_geodesy.adjustment.geometry.point.FeaturePoint;
import org.applied_geodesy.util.ObservableUniqueList;

public abstract class NISTTest {
    static final double EPS = Math.sqrt(Constant.EPS);
    static final String TEMPLATE = "%30s EST = %+25.16f REF = %+25.16f  DIFF = %+6.3e %s";
    static ComponentOrderType CMP_TYPE = ComponentOrderType.XYZ;

    public static List<Double> readFittingResults(Path path) throws IOException, NullPointerException, NumberFormatException {
        ArrayList<Double> values = new ArrayList<Double>();
        Throwable throwable = null;
        Object var3_4 = null;
        try (BufferedReader reader = Files.newBufferedReader(path, Charset.forName("UTF-8"));){
            String currentLine = null;
            while ((currentLine = reader.readLine()) != null) {
                double value = Double.parseDouble(currentLine.trim());
                values.add(value);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return values;
    }

    public static List<FeaturePoint> readCoordinates(Path path, int dim) throws IOException, NullPointerException, NumberFormatException {
        ArrayList<FeaturePoint> points = new ArrayList<FeaturePoint>();
        if (dim == 3) {
            CMP_TYPE = ComponentOrderType.XYZ;
        }
        int cnt = 1;
        Throwable throwable = null;
        Object var5_6 = null;
        try (BufferedReader reader = Files.newBufferedReader(path, Charset.forName("UTF-8"));){
            String currentLine = null;
            while ((currentLine = reader.readLine()) != null) {
                String[] data = currentLine.split("\\s+");
                if (data.length < dim) continue;
                double x = Double.parseDouble(data[0]);
                double y = Double.parseDouble(data[1]);
                double z = Double.parseDouble(data[2]);
                FeaturePoint point = new FeaturePoint(String.valueOf(cnt), x, y, z);
                if (point == null) continue;
                points.add(point);
            }
            if (dim == 2) {
                ArrayList<FeaturePoint> points2d = new ArrayList<FeaturePoint>(points.size());
                FeaturePoint firstPoint = (FeaturePoint)points.get(0);
                FeaturePoint lastPoint = (FeaturePoint)points.get(points.size() - 1);
                if (Math.abs(firstPoint.getX0() - lastPoint.getX0()) < Math.abs(firstPoint.getY0() - lastPoint.getY0()) && Math.abs(firstPoint.getX0() - lastPoint.getX0()) < Math.abs(firstPoint.getZ0() - lastPoint.getZ0())) {
                    CMP_TYPE = ComponentOrderType.YZ;
                }
                if (Math.abs(firstPoint.getY0() - lastPoint.getY0()) < Math.abs(firstPoint.getX0() - lastPoint.getX0()) && Math.abs(firstPoint.getY0() - lastPoint.getY0()) < Math.abs(firstPoint.getZ0() - lastPoint.getZ0())) {
                    CMP_TYPE = ComponentOrderType.XZ;
                }
                if (Math.abs(firstPoint.getZ0() - lastPoint.getZ0()) < Math.abs(firstPoint.getX0() - lastPoint.getX0()) && Math.abs(firstPoint.getZ0() - lastPoint.getZ0()) < Math.abs(firstPoint.getY0() - lastPoint.getY0())) {
                    CMP_TYPE = ComponentOrderType.XY;
                }
                for (FeaturePoint point3d : points) {
                    if (CMP_TYPE == ComponentOrderType.YZ) {
                        points2d.add(new FeaturePoint(point3d.getName(), point3d.getY0(), point3d.getZ0()));
                        continue;
                    }
                    if (CMP_TYPE == ComponentOrderType.XZ) {
                        points2d.add(new FeaturePoint(point3d.getName(), point3d.getX0(), point3d.getZ0()));
                        continue;
                    }
                    if (CMP_TYPE != ComponentOrderType.XY) continue;
                    points2d.add(new FeaturePoint(point3d.getName(), point3d.getX0(), point3d.getY0()));
                }
                points = points2d;
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return points;
    }

    public void start(String directory) throws Exception {
        Throwable throwable = null;
        Object var3_4 = null;
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(Paths.get(directory, new String[0]), "*.ds");){
            for (Path pointPath : directoryStream) {
                String pathName = pointPath.toString();
                int pos = pathName.lastIndexOf(".");
                if (pos > 0 && pos < pathName.length() - 1) {
                    pathName = pathName.substring(0, pos);
                }
                Path resultPath = Paths.get(pathName + ".fit", new String[0]);
                System.out.println("\n==========================\n");
                System.out.println(pointPath.getFileName());
                List<FeaturePoint> featurePoints = NISTTest.readCoordinates(pointPath, this.getDimension());
                List<Double> referenceResults = NISTTest.readFittingResults(resultPath);
                Feature feature = this.adjust(featurePoints);
                if (feature == null) {
                    System.err.println("Adjustment failed!");
                    continue;
                }
                ObservableUniqueList<UnknownParameter> unknownParameters = feature.getUnknownParameters();
                this.compare(referenceResults, (List<UnknownParameter>)((Object)unknownParameters));
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public Feature adjust(List<FeaturePoint> points) {
        FeatureAdjustment adjustment = new FeatureAdjustment();
        Feature feature = this.getFeature();
        for (GeometricPrimitive geometricPrimitive : feature) {
            geometricPrimitive.getFeaturePoints().addAll(points);
        }
        try {
            if (feature.isEstimateInitialGuess()) {
                feature.deriveInitialGuess();
            }
            adjustment.setLevenbergMarquardtDampingValue(this.getLambda());
            adjustment.setFeature(feature);
            adjustment.init();
            EstimationStateType type = adjustment.estimateModel();
            if (type == EstimationStateType.ERROR_FREE_ESTIMATION) {
                return feature;
            }
        }
        catch (IllegalArgumentException | UnsupportedOperationException | MatrixSingularException | NotConvergedException e) {
            e.printStackTrace();
        }
        return null;
    }

    double getLambda() {
        return 0.0;
    }

    abstract int getDimension();

    abstract Feature getFeature();

    abstract void compare(List<Double> var1, List<UnknownParameter> var2);

    public static enum ComponentOrderType {
        XY,
        XZ,
        YZ,
        XYZ;

    }
}

