/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.juniform.test.nist;

import java.util.List;
import java.util.Locale;
import org.applied_geodesy.adjustment.geometry.Feature;
import org.applied_geodesy.adjustment.geometry.curve.LineFeature;
import org.applied_geodesy.adjustment.geometry.parameter.ParameterType;
import org.applied_geodesy.adjustment.geometry.parameter.UnknownParameter;
import org.applied_geodesy.juniform.test.nist.NISTTest;

public class LineTest
extends NISTTest {
    private LineTest() {
    }

    @Override
    void compare(List<Double> referenceResults, List<UnknownParameter> unknownParameters) {
        int idxX = 0;
        int idxY = 1;
        if (CMP_TYPE == NISTTest.ComponentOrderType.XZ) {
            idxX = 0;
            idxY = 2;
        } else if (CMP_TYPE == NISTTest.ComponentOrderType.YZ) {
            idxX = 1;
            idxY = 2;
        }
        double x0Ref = referenceResults.get(idxX);
        double y0Ref = referenceResults.get(idxY);
        double nxRef = referenceResults.get(idxX + 3);
        double nyRef = referenceResults.get(idxY + 3);
        double d = nxRef * x0Ref + nyRef * y0Ref;
        double[] references = new double[]{x0Ref -= d * nxRef, y0Ref -= d * nyRef, nxRef, nyRef};
        List<ParameterType> types = List.of(ParameterType.ORIGIN_COORDINATE_X, ParameterType.ORIGIN_COORDINATE_Y, ParameterType.VECTOR_X, ParameterType.VECTOR_Y);
        int i = 0;
        while (i < types.size()) {
            for (UnknownParameter unknownParameter : unknownParameters) {
                if (unknownParameter.getParameterType() != types.get(i)) continue;
                double diff = Math.abs(unknownParameter.getValue()) - Math.abs(references[i]);
                System.out.println(String.format(Locale.ENGLISH, "%30s EST = %+25.16f REF = %+25.16f  DIFF = %+6.3e %s", new Object[]{unknownParameter.getParameterType(), unknownParameter.getValue(), references[i], diff, Math.abs(diff) > EPS ? "***" : ""}));
                break;
            }
            ++i;
        }
    }

    @Override
    Feature getFeature() {
        return new LineFeature();
    }

    @Override
    int getDimension() {
        return 2;
    }

    public static void main(String[] args) throws Exception {
        System.setProperty("com.github.fommil.netlib.BLAS", "com.github.fommil.netlib.F2jBLAS");
        System.setProperty("com.github.fommil.netlib.LAPACK", "com.github.fommil.netlib.F2jLAPACK");
        System.setProperty("com.github.fommil.netlib.ARPACK", "com.github.fommil.netlib.F2jARPACK");
        LineTest test = new LineTest();
        test.start("./nist/Line2d/");
    }
}

