/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.juniform.test.nist;

import java.util.List;
import java.util.Locale;
import org.applied_geodesy.adjustment.geometry.Feature;
import org.applied_geodesy.adjustment.geometry.curve.EllipseFeature;
import org.applied_geodesy.adjustment.geometry.parameter.ParameterType;
import org.applied_geodesy.adjustment.geometry.parameter.UnknownParameter;
import org.applied_geodesy.juniform.test.nist.NISTTest;

public class EllipseTest
extends NISTTest {
    private EllipseTest() {
    }

    @Override
    Feature getFeature() {
        return new EllipseFeature();
    }

    @Override
    void compare(List<Double> referenceResults, List<UnknownParameter> unknownParameters) {
        int idxX = 0;
        int idxY = 1;
        if (CMP_TYPE == NISTTest.ComponentOrderType.XZ) {
            idxX = 0;
            idxY = 2;
        } else if (CMP_TYPE == NISTTest.ComponentOrderType.YZ) {
            idxX = 1;
            idxY = 2;
        }
        double x0Ref = referenceResults.get(idxX);
        double y0Ref = referenceResults.get(idxY);
        double rRef = 0.5 * referenceResults.get(6);
        double[] references = new double[]{x0Ref, y0Ref, rRef, rRef};
        List<ParameterType> types = List.of(ParameterType.ORIGIN_COORDINATE_X, ParameterType.ORIGIN_COORDINATE_Y, ParameterType.MAJOR_AXIS_COEFFICIENT, ParameterType.MINOR_AXIS_COEFFICIENT);
        int i = 0;
        while (i < types.size()) {
            for (UnknownParameter unknownParameter : unknownParameters) {
                if (unknownParameter.getParameterType() != types.get(i)) continue;
                double diff = Math.abs(unknownParameter.getValue()) - Math.abs(references[i]);
                System.out.println(String.format(Locale.ENGLISH, "%30s EST = %+25.16f REF = %+25.16f  DIFF = %+6.3e %s", new Object[]{unknownParameter.getParameterType(), unknownParameter.getValue(), references[i], diff, Math.abs(diff) > EPS ? "***" : ""}));
                break;
            }
            ++i;
        }
    }

    @Override
    int getDimension() {
        return 2;
    }

    public static void main(String[] args) throws Exception {
        System.setProperty("com.github.fommil.netlib.BLAS", "com.github.fommil.netlib.F2jBLAS");
        System.setProperty("com.github.fommil.netlib.LAPACK", "com.github.fommil.netlib.F2jLAPACK");
        System.setProperty("com.github.fommil.netlib.ARPACK", "com.github.fommil.netlib.F2jARPACK");
        EllipseTest test = new EllipseTest();
        test.start("./nist/Circle2d/");
    }
}

