/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.juniform.test.nist;

import java.util.List;
import java.util.Locale;
import org.applied_geodesy.adjustment.geometry.Feature;
import org.applied_geodesy.adjustment.geometry.parameter.ParameterType;
import org.applied_geodesy.adjustment.geometry.parameter.UnknownParameter;
import org.applied_geodesy.adjustment.geometry.surface.CylinderFeature;
import org.applied_geodesy.juniform.test.nist.NISTTest;

public class CylinderTest
extends NISTTest {
    private CylinderTest() {
    }

    @Override
    void compare(List<Double> referenceResults, List<UnknownParameter> unknownParameters) {
        double x0Ref = referenceResults.get(0);
        double y0Ref = referenceResults.get(1);
        double z0Ref = referenceResults.get(2);
        double nxRef = referenceResults.get(3);
        double nyRef = referenceResults.get(4);
        double nzRef = referenceResults.get(5);
        double rRef = 0.5 * referenceResults.get(6);
        double dRef = nxRef * x0Ref + nyRef * y0Ref + nzRef * z0Ref;
        double[] references = new double[]{x0Ref -= dRef * nxRef, y0Ref -= dRef * nyRef, z0Ref -= dRef * nzRef, nxRef, nyRef, nzRef, rRef, rRef};
        List<ParameterType> types = List.of(ParameterType.ORIGIN_COORDINATE_X, ParameterType.ORIGIN_COORDINATE_Y, ParameterType.ORIGIN_COORDINATE_Z, ParameterType.VECTOR_X, ParameterType.VECTOR_Y, ParameterType.VECTOR_Z, ParameterType.MAJOR_AXIS_COEFFICIENT, ParameterType.MINOR_AXIS_COEFFICIENT);
        int i = 0;
        while (i < types.size()) {
            for (UnknownParameter unknownParameter : unknownParameters) {
                if (unknownParameter.getParameterType() != types.get(i)) continue;
                double diff = Math.abs(unknownParameter.getValue()) - Math.abs(references[i]);
                System.out.println(String.format(Locale.ENGLISH, "%30s EST = %+25.16f REF = %+25.16f  DIFF = %+6.3e %s", new Object[]{unknownParameter.getParameterType(), unknownParameter.getValue(), references[i], diff, Math.abs(diff) > EPS ? "***" : ""}));
                break;
            }
            ++i;
        }
    }

    @Override
    Feature getFeature() {
        return new CylinderFeature();
    }

    @Override
    int getDimension() {
        return 3;
    }

    @Override
    double getLambda() {
        return 0.0;
    }

    public static void main(String[] args) throws Exception {
        System.setProperty("com.github.fommil.netlib.BLAS", "com.github.fommil.netlib.F2jBLAS");
        System.setProperty("com.github.fommil.netlib.LAPACK", "com.github.fommil.netlib.F2jLAPACK");
        System.setProperty("com.github.fommil.netlib.ARPACK", "com.github.fommil.netlib.F2jARPACK");
        CylinderTest test = new CylinderTest();
        test.start("./nist/Cylinder/");
    }
}

