/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.juniform.test.nist;

import java.util.List;
import java.util.Locale;
import org.applied_geodesy.adjustment.geometry.Feature;
import org.applied_geodesy.adjustment.geometry.parameter.ParameterType;
import org.applied_geodesy.adjustment.geometry.parameter.UnknownParameter;
import org.applied_geodesy.adjustment.geometry.surface.CircularConeFeature;
import org.applied_geodesy.juniform.test.nist.NISTTest;

public class CircularConeTest
extends NISTTest {
    private CircularConeTest() {
    }

    @Override
    void compare(List<Double> referenceResults, List<UnknownParameter> unknownParameters) {
        double x0Ref = referenceResults.get(0);
        double y0Ref = referenceResults.get(1);
        double z0Ref = referenceResults.get(2);
        double nxRef = referenceResults.get(3);
        double nyRef = referenceResults.get(4);
        double nzRef = referenceResults.get(5);
        double rRef = referenceResults.get(6);
        double phiRef = 0.5 * referenceResults.get(7) * (Math.PI / 180);
        double s = -rRef / Math.sin(phiRef);
        double xApexRef = x0Ref + s * nxRef;
        double yApexRef = y0Ref + s * nyRef;
        double zApexRef = z0Ref + s * nzRef;
        double dRef = nxRef * x0Ref + nyRef * y0Ref + nzRef * z0Ref;
        double[] references = new double[]{x0Ref -= dRef * nxRef, y0Ref -= dRef * nyRef, z0Ref -= dRef * nzRef, xApexRef, yApexRef, zApexRef, nxRef, nyRef, nzRef, phiRef, 1.0 / Math.tan(phiRef)};
        double xApex = 0.0;
        double yApex = 0.0;
        double zApex = 0.0;
        double x0 = 0.0;
        double y0 = 0.0;
        double z0 = 0.0;
        double nx = 0.0;
        double ny = 0.0;
        double nz = 0.0;
        double phi = 0.0;
        double b = 0.0;
        for (UnknownParameter unknownParameter : unknownParameters) {
            if (unknownParameter.getParameterType() == ParameterType.ORIGIN_COORDINATE_X) {
                xApex = unknownParameter.getValue();
                continue;
            }
            if (unknownParameter.getParameterType() == ParameterType.ORIGIN_COORDINATE_Y) {
                yApex = unknownParameter.getValue();
                continue;
            }
            if (unknownParameter.getParameterType() == ParameterType.ORIGIN_COORDINATE_Z) {
                zApex = unknownParameter.getValue();
                continue;
            }
            if (unknownParameter.getParameterType() == ParameterType.ROTATION_COMPONENT_R31) {
                nx = unknownParameter.getValue();
                continue;
            }
            if (unknownParameter.getParameterType() == ParameterType.ROTATION_COMPONENT_R32) {
                ny = unknownParameter.getValue();
                continue;
            }
            if (unknownParameter.getParameterType() == ParameterType.ROTATION_COMPONENT_R33) {
                nz = unknownParameter.getValue();
                continue;
            }
            if (unknownParameter.getParameterType() == ParameterType.ANGLE) {
                phi = unknownParameter.getValue();
                continue;
            }
            if (unknownParameter.getParameterType() != ParameterType.MAJOR_AXIS_COEFFICIENT) continue;
            b = unknownParameter.getValue();
        }
        double d = nx * xApex + ny * yApex + nz * zApex;
        x0 = xApex - d * nx;
        y0 = yApex - d * ny;
        z0 = zApex - d * nz;
        double[] solution = new double[]{x0, y0, z0, xApex, yApex, zApex, nx, ny, nz, phi, b};
        List<ParameterType> types = List.of(ParameterType.COORDINATE_X, ParameterType.COORDINATE_Y, ParameterType.COORDINATE_Z, ParameterType.ORIGIN_COORDINATE_X, ParameterType.ORIGIN_COORDINATE_Y, ParameterType.ORIGIN_COORDINATE_Z, ParameterType.ROTATION_COMPONENT_R31, ParameterType.ROTATION_COMPONENT_R32, ParameterType.ROTATION_COMPONENT_R33, ParameterType.ANGLE, ParameterType.MAJOR_AXIS_COEFFICIENT);
        int i = 0;
        while (i < types.size()) {
            double diff = Math.abs(solution[i]) - Math.abs(references[i]);
            System.out.println(String.format(Locale.ENGLISH, "%30s EST = %+25.16f REF = %+25.16f  DIFF = %+6.3e %s", new Object[]{types.get(i), solution[i], references[i], diff, Math.abs(diff) > EPS ? "***" : ""}));
            ++i;
        }
    }

    @Override
    Feature getFeature() {
        return new CircularConeFeature();
    }

    @Override
    int getDimension() {
        return 3;
    }

    @Override
    double getLambda() {
        return 0.001;
    }

    public static void main(String[] args) throws Exception {
        System.setProperty("com.github.fommil.netlib.BLAS", "com.github.fommil.netlib.F2jBLAS");
        System.setProperty("com.github.fommil.netlib.LAPACK", "com.github.fommil.netlib.F2jLAPACK");
        System.setProperty("com.github.fommil.netlib.ARPACK", "com.github.fommil.netlib.F2jARPACK");
        CircularConeTest test = new CircularConeTest();
        test.start("./nist/Cone/");
    }
}

