/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.juniform.io.writer;

import freemarker.ext.beans.BeansWrapper;
import freemarker.ext.beans.BeansWrapperBuilder;
import freemarker.template.Configuration;
import freemarker.template.MalformedTemplateNameException;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateExceptionHandler;
import freemarker.template.TemplateHashModel;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateNotFoundException;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javafx.application.HostServices;
import no.uib.cipr.matrix.UpperSymmPackMatrix;
import org.applied_geodesy.adjustment.geometry.Feature;
import org.applied_geodesy.adjustment.geometry.FeatureAdjustment;
import org.applied_geodesy.adjustment.geometry.GeometricPrimitive;
import org.applied_geodesy.adjustment.geometry.VarianceComponent;
import org.applied_geodesy.adjustment.geometry.VarianceComponentType;
import org.applied_geodesy.adjustment.geometry.parameter.ParameterType;
import org.applied_geodesy.adjustment.geometry.parameter.UnknownParameter;
import org.applied_geodesy.adjustment.geometry.point.FeaturePoint;
import org.applied_geodesy.adjustment.statistic.TestStatisticDefinition;
import org.applied_geodesy.adjustment.statistic.TestStatisticParameterSet;
import org.applied_geodesy.adjustment.statistic.TestStatisticType;
import org.applied_geodesy.util.CellValueType;
import org.applied_geodesy.util.FormatterOptions;
import org.applied_geodesy.util.ObservableUniqueList;
import org.applied_geodesy.util.unit.UnitType;
import org.applied_geodesy.version.juniform.Version;

public class FTLReport {
    private static final freemarker.template.Version VERSION = Configuration.VERSION_2_3_33;
    private FormatterOptions options = FormatterOptions.getInstance();
    private Template template = null;
    private static HostServices hostServices;
    private Map<String, Object> data = new HashMap<String, Object>();
    public static final String TEMPLATE_PATH = "ftl/juniform/";
    private final Configuration cfg = new Configuration(VERSION);
    private FeatureAdjustment adjustment;

    public FTLReport(FeatureAdjustment adjustment) {
        this.adjustment = adjustment;
        this.init();
    }

    private void init() {
        try {
            Path path = Paths.get(FTLReport.class.getClassLoader().getResource(TEMPLATE_PATH).toURI());
            this.cfg.setDirectoryForTemplateLoading(path.toFile());
            this.cfg.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
            this.cfg.setLogTemplateExceptions(false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void setHostServices(HostServices hostServices) {
        FTLReport.hostServices = hostServices;
    }

    private void setParam(String key, Object value) {
        this.data.put(key, value);
    }

    public void setTemplate(String template) throws TemplateNotFoundException, MalformedTemplateNameException, ParseException, IOException {
        this.template = this.cfg.getTemplate(template);
    }

    private void createReport() throws ClassNotFoundException, TemplateModelException {
        this.data.clear();
        BeansWrapper wrapper = new BeansWrapperBuilder(VERSION).build();
        TemplateHashModel staticModels = wrapper.getStaticModels();
        TemplateHashModel mathStatics = (TemplateHashModel)staticModels.get("java.lang.Math");
        this.data.put("Math", mathStatics);
        this.initFormatterOptions();
        this.addMetaData();
        this.addGeometricPrimitives();
        this.addTeststatistics();
        this.addVarianceEstimation();
        this.addPoints();
        this.addUnknownFeatureParameters();
        this.addCorrelationMatrix();
    }

    public void toFilePath(Path report, boolean openFile) throws ClassNotFoundException, TemplateException, IOException {
        if (report == null) {
            return;
        }
        this.createReport();
        Throwable throwable = null;
        Object var4_5 = null;
        try (BufferedWriter writer = Files.newBufferedWriter(report, StandardCharsets.UTF_8, new OpenOption[0]);){
            this.template.process(this.data, (Writer)writer);
            ((Writer)writer).flush();
            if (hostServices != null && openFile) {
                hostServices.showDocument(report.toAbsolutePath().normalize().toString());
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void initFormatterOptions() {
        Map<CellValueType, FormatterOptions.FormatterOption> options = FormatterOptions.getInstance().getFormatterOptions();
        block17: for (FormatterOptions.FormatterOption option : options.values()) {
            String keyDigits = null;
            String keyUnit = null;
            String keySexagesimal = null;
            CellValueType cellValueType = option.getType();
            switch (cellValueType) {
                case ANGLE: {
                    keyDigits = "digits_angle";
                    keyUnit = "unit_abbr_angle";
                    keySexagesimal = option.getUnit().getType() == UnitType.DEGREE_SEXAGESIMAL ? "sexagesimal_angle" : null;
                    break;
                }
                case ANGLE_RESIDUAL: {
                    keyDigits = "digits_angle_residual";
                    keyUnit = "unit_abbr_angle_residual";
                    keySexagesimal = option.getUnit().getType() == UnitType.DEGREE_SEXAGESIMAL ? "sexagesimal_angle_residual" : null;
                    break;
                }
                case ANGLE_UNCERTAINTY: {
                    keyDigits = "digits_angle_uncertainty";
                    keyUnit = "unit_abbr_angle_uncertainty";
                    keySexagesimal = option.getUnit().getType() == UnitType.DEGREE_SEXAGESIMAL ? "sexagesimal_angle_uncertainty" : null;
                    break;
                }
                case LENGTH: {
                    keyDigits = "digits_length";
                    keyUnit = "unit_abbr_length";
                    break;
                }
                case LENGTH_RESIDUAL: {
                    keyDigits = "digits_length_residual";
                    keyUnit = "unit_abbr_length_residual";
                    break;
                }
                case LENGTH_UNCERTAINTY: {
                    keyDigits = "digits_length_uncertainty";
                    keyUnit = "unit_abbr_length_uncertainty";
                    break;
                }
                case SCALE: {
                    keyDigits = "digits_scale";
                    keyUnit = "unit_abbr_scale";
                    break;
                }
                case SCALE_RESIDUAL: {
                    keyDigits = "digits_scale_residual";
                    keyUnit = "unit_abbr_scale_residual";
                    break;
                }
                case SCALE_UNCERTAINTY: {
                    keyDigits = "digits_scale_uncertainty";
                    keyUnit = "unit_abbr_scale_uncertainty";
                    break;
                }
                case VECTOR: {
                    keyDigits = "digits_vector";
                    keyUnit = "unit_abbr_vector";
                    break;
                }
                case VECTOR_RESIDUAL: {
                    keyDigits = "digits_vector_residual";
                    keyUnit = "unit_abbr_vector_residual";
                    break;
                }
                case VECTOR_UNCERTAINTY: {
                    keyDigits = "digits_vector_uncertainty";
                    keyUnit = "unit_abbr_vector_uncertainty";
                    break;
                }
                case PERCENTAGE: {
                    keyDigits = "digits_percentage";
                    keyUnit = "unit_abbr_percentage";
                    break;
                }
                case STATISTIC: {
                    keyDigits = "digits_statistic";
                    break;
                }
                case DOUBLE: {
                    keyDigits = "digits_double";
                    break;
                }
                default: {
                    continue block17;
                }
            }
            if (keyDigits != null) {
                this.setParam(keyDigits, option.getFormatter().format(0.0));
            }
            if (keyUnit != null) {
                this.setParam(keyUnit, option.getUnit().getAbbreviation());
            }
            if (keySexagesimal == null) continue;
            this.setParam(keySexagesimal, Boolean.TRUE);
        }
    }

    private void addMetaData() {
        this.setParam("report_creation_date", new Date(System.currentTimeMillis()));
        this.setParam("version", Version.get());
        this.setParam("estimation_type", (Object)this.adjustment.getEstimationType());
    }

    private void addGeometricPrimitives() {
        Feature feature = this.adjustment.getFeature();
        ArrayList geometries = new ArrayList();
        for (GeometricPrimitive geometricPrimitive : feature) {
            HashMap<String, Object> geometry = new HashMap<String, Object>();
            geometry.put("name", geometricPrimitive.getName());
            geometry.put("type", geometricPrimitive.getPrimitiveType().name());
            geometry.put("unknown_parameters", this.getUnknownParameters());
            geometries.add(geometry);
        }
        this.setParam("geometric_primitives", geometries);
    }

    private void addTeststatistics() {
        TestStatisticParameterSet[] testStatisticParameterSets;
        TestStatisticDefinition testStatisticDefinition = this.adjustment.getTestStatisticDefinition();
        if (this.adjustment.getTestStatisticDefinition() == null || this.adjustment.getTestStatisticParameters() == null) {
            return;
        }
        TestStatisticType type = testStatisticDefinition.getTestStatisticType();
        double powerOfTest = testStatisticDefinition.getPowerOfTest();
        double probabilityValue = testStatisticDefinition.getProbabilityValue();
        this.setParam("test_statistic_method", type.name());
        this.setParam("test_statistic_probability_value", this.options.convertPercentToView(probabilityValue));
        this.setParam("test_statistic_power_of_test", this.options.convertPercentToView(powerOfTest));
        ArrayList testStatistics = new ArrayList();
        TestStatisticParameterSet[] testStatisticParameterSetArray = testStatisticParameterSets = this.adjustment.getTestStatisticParameters().getTestStatisticParameterSets();
        int n = testStatisticParameterSets.length;
        int n2 = 0;
        while (n2 < n) {
            TestStatisticParameterSet testStatisticParameterSet = testStatisticParameterSetArray[n2];
            if (testStatisticParameterSet.getNumeratorDof() >= 0.0 && testStatisticParameterSet.getDenominatorDof() > 0.0) {
                HashMap<String, Double> h = new HashMap<String, Double>();
                h.put("d1", testStatisticParameterSet.getNumeratorDof());
                h.put("d2", testStatisticParameterSet.getDenominatorDof());
                h.put("probability_value", this.options.convertPercentToView(testStatisticParameterSet.getProbabilityValue()));
                h.put("power_of_test", this.options.convertPercentToView(testStatisticParameterSet.getPowerOfTest()));
                h.put("quantile", testStatisticParameterSet.getQuantile());
                h.put("p_value", testStatisticParameterSet.getLogarithmicProbabilityValue());
                h.put("non_centrality_parameter", testStatisticParameterSet.getNoncentralityParameter());
                testStatistics.add(h);
            }
            ++n2;
        }
        if (!testStatistics.isEmpty()) {
            this.setParam("test_statistic_params", testStatistics);
        }
    }

    private void addUnknownFeatureParameters() {
        this.setParam("unknown_feature_parameters", this.getUnknownParameters());
    }

    private void addCorrelationMatrix() {
        UpperSymmPackMatrix correlationMatrix = this.adjustment.getCorrelationMatrix();
        if (correlationMatrix == null) {
            return;
        }
        ArrayList matrix = new ArrayList();
        ObservableUniqueList<UnknownParameter> unknownParameters = this.adjustment.getFeature().getUnknownParameters();
        int cols = correlationMatrix.numColumns();
        int rows = correlationMatrix.numRows();
        int r = 0;
        while (r < rows) {
            HashMap<String, Cloneable> row = new HashMap<String, Cloneable>(2);
            ArrayList<Double> rowVec = new ArrayList<Double>(rows);
            int c = 0;
            while (c < cols) {
                rowVec.add(correlationMatrix.get(r, c));
                ++c;
            }
            row.put("parameter", this.getUnknownParameter((UnknownParameter)unknownParameters.get(r)));
            row.put("data", rowVec);
            matrix.add(row);
            ++r;
        }
        this.setParam("correlation_matrix", matrix);
    }

    private List<HashMap<String, Object>> getUnknownParameters() {
        ArrayList<HashMap<String, Object>> parameters = new ArrayList<HashMap<String, Object>>();
        ObservableUniqueList<UnknownParameter> unknownParameters = this.adjustment.getFeature().getUnknownParameters();
        Iterator iterator = unknownParameters.iterator();
        while (iterator.hasNext()) {
            UnknownParameter unknownParameter = (UnknownParameter)iterator.next();
            parameters.add(this.getUnknownParameter(unknownParameter));
        }
        return parameters;
    }

    private HashMap<String, Object> getUnknownParameter(UnknownParameter unknownParameter) {
        HashMap<String, Object> parameter = new HashMap<String, Object>();
        ParameterType type = unknownParameter.getParameterType();
        parameter.put("name", unknownParameter.getName());
        parameter.put("description", unknownParameter.getDescription());
        parameter.put("processing_type", unknownParameter.getProcessingType().name());
        parameter.put("parameter_type", type.name());
        parameter.put("visible", unknownParameter.isVisible());
        parameter.put("indispensable", unknownParameter.isIndispensable());
        parameter.put("column", unknownParameter.getColumn());
        double value = unknownParameter.getValue();
        double sigma = unknownParameter.getUncertainty();
        switch (type) {
            case ORIGIN_COORDINATE_X: 
            case ORIGIN_COORDINATE_Y: 
            case ORIGIN_COORDINATE_Z: 
            case PRIMARY_FOCAL_COORDINATE_X: 
            case PRIMARY_FOCAL_COORDINATE_Y: 
            case PRIMARY_FOCAL_COORDINATE_Z: 
            case SECONDARY_FOCAL_COORDINATE_X: 
            case SECONDARY_FOCAL_COORDINATE_Y: 
            case SECONDARY_FOCAL_COORDINATE_Z: 
            case COORDINATE_X: 
            case COORDINATE_Y: 
            case COORDINATE_Z: 
            case RADIUS: 
            case LENGTH: {
                parameter.put("value", this.options.convertLengthToView(value));
                parameter.put("sigma", this.options.convertLengthUncertaintyToView(sigma));
                parameter.put("unit_type", "LENGTH");
                break;
            }
            case VECTOR_X: 
            case VECTOR_Y: 
            case VECTOR_Z: 
            case VECTOR_LENGTH: {
                parameter.put("value", this.options.convertVectorToView(value));
                parameter.put("sigma", this.options.convertVectorUncertaintyToView(sigma));
                parameter.put("unit_type", "VECTOR");
                break;
            }
            case ANGLE: {
                parameter.put("value", this.options.convertAngleToView(value));
                parameter.put("sigma", this.options.convertAngleUncertaintyToView(sigma));
                parameter.put("unit_type", "ANGLE");
                break;
            }
            default: {
                parameter.put("value", value);
                parameter.put("sigma", sigma);
                parameter.put("unit_type", "DOUBLE");
            }
        }
        return parameter;
    }

    private void addPoints() {
        HashMap<String, Serializable> points = new HashMap<String, Serializable>();
        ArrayList pointList = new ArrayList();
        List<FeaturePoint> featurePoints = this.adjustment.getFeature().getFeaturePoints();
        int dimension = -1;
        double maxResidualGroupX = 0.0;
        double maxResidualGroupY = 0.0;
        double maxResidualGroupZ = 0.0;
        double redundancyGroupX = 0.0;
        double redundancyGroupY = 0.0;
        double redundancyGroupZ = 0.0;
        double maxGrossErrorGroupX = 0.0;
        double maxGrossErrorGroupY = 0.0;
        double maxGrossErrorGroupZ = 0.0;
        boolean significantGroup = false;
        for (FeaturePoint point : featurePoints) {
            HashMap<String, Object> h = new HashMap<String, Object>();
            dimension = point.getDimension();
            boolean significant = point.isSignificant();
            if (!significantGroup && significant) {
                significantGroup = true;
            }
            h.put("name", point.getName());
            h.put("t_prio", point.getTestStatistic().getTestStatisticApriori());
            h.put("t_post", point.getTestStatistic().getTestStatisticAposteriori());
            h.put("p_prio", point.getTestStatistic().getPValueApriori());
            h.put("p_post", point.getTestStatistic().getPValueAposteriori());
            h.put("significant", significant);
            h.put("dimension", dimension);
            if (point.getDimension() != 1) {
                h.put("x0", this.options.convertLengthToView(point.getX0()));
                h.put("y0", this.options.convertLengthToView(point.getY0()));
                h.put("x", this.options.convertLengthToView(point.getX()));
                h.put("y", this.options.convertLengthToView(point.getY()));
                h.put("sigma_x", this.options.convertLengthUncertaintyToView(point.getUncertaintyX()));
                h.put("sigma_y", this.options.convertLengthUncertaintyToView(point.getUncertaintyY()));
                h.put("minimal_detectable_bias_x", this.options.convertLengthResidualToView(point.getMinimalDetectableBiasX()));
                h.put("minimal_detectable_bias_y", this.options.convertLengthResidualToView(point.getMinimalDetectableBiasY()));
                h.put("maximum_tolerable_bias_x", this.options.convertLengthResidualToView(point.getMaximumTolerableBiasX()));
                h.put("maximum_tolerable_bias_y", this.options.convertLengthResidualToView(point.getMaximumTolerableBiasY()));
                double residualX = this.options.convertLengthResidualToView(point.getResidualX());
                double residualY = this.options.convertLengthResidualToView(point.getResidualY());
                double grossErrorX = this.options.convertLengthResidualToView(point.getGrossErrorX());
                double grossErrorY = this.options.convertLengthResidualToView(point.getGrossErrorY());
                double redundancyX = point.getRedundancyX();
                double redundancyY = point.getRedundancyY();
                h.put("residual_x", residualX);
                h.put("residual_y", residualY);
                h.put("gross_error_x", grossErrorX);
                h.put("gross_error_y", grossErrorY);
                h.put("redundancy_x", this.options.convertPercentToView(redundancyX));
                h.put("redundancy_y", this.options.convertPercentToView(redundancyY));
                redundancyGroupX += redundancyX;
                redundancyGroupY += redundancyY;
                maxResidualGroupX = Math.abs(residualX) > Math.abs(maxResidualGroupX) ? residualX : maxResidualGroupX;
                maxResidualGroupY = Math.abs(residualY) > Math.abs(maxResidualGroupY) ? residualY : maxResidualGroupY;
                maxGrossErrorGroupX = Math.abs(grossErrorX) > Math.abs(maxGrossErrorGroupX) ? grossErrorX : maxGrossErrorGroupX;
                double d = maxGrossErrorGroupY = Math.abs(grossErrorY) > Math.abs(maxGrossErrorGroupY) ? grossErrorY : maxGrossErrorGroupY;
            }
            if (point.getDimension() != 2) {
                h.put("z0", this.options.convertLengthToView(point.getZ0()));
                h.put("z", this.options.convertLengthToView(point.getZ()));
                h.put("sigma_z", this.options.convertLengthUncertaintyToView(point.getUncertaintyZ()));
                h.put("minimal_detectable_bias_z", this.options.convertLengthResidualToView(point.getMinimalDetectableBiasZ()));
                h.put("maximum_tolerable_bias_z", this.options.convertLengthResidualToView(point.getMaximumTolerableBiasZ()));
                double residualZ = this.options.convertLengthResidualToView(point.getResidualZ());
                double grossErrorZ = this.options.convertLengthResidualToView(point.getGrossErrorZ());
                double redundancyZ = point.getRedundancyZ();
                h.put("residual_z", residualZ);
                h.put("gross_error_z", grossErrorZ);
                h.put("redundancy_z", this.options.convertPercentToView(redundancyZ));
                redundancyGroupZ += redundancyZ;
                maxResidualGroupZ = Math.abs(residualZ) > Math.abs(maxResidualGroupZ) ? residualZ : maxResidualGroupZ;
                maxGrossErrorGroupZ = Math.abs(grossErrorZ) > Math.abs(maxGrossErrorGroupZ) ? grossErrorZ : maxGrossErrorGroupZ;
            }
            pointList.add(h);
        }
        if (pointList != null && !pointList.isEmpty()) {
            points.put("points", pointList);
            points.put("significant", Boolean.valueOf(significantGroup));
            points.put("dimension", Integer.valueOf(dimension));
            points.put("redundancy_x", Double.valueOf(redundancyGroupX));
            points.put("redundancy_y", Double.valueOf(redundancyGroupY));
            points.put("redundancy_z", Double.valueOf(redundancyGroupZ));
            points.put("redundancy", Double.valueOf(redundancyGroupX + redundancyGroupY + redundancyGroupZ));
            points.put("max_residual_x", Double.valueOf(maxResidualGroupX));
            points.put("max_residual_y", Double.valueOf(maxResidualGroupY));
            points.put("max_residual_z", Double.valueOf(maxResidualGroupZ));
            points.put("max_gross_error_x", Double.valueOf(maxGrossErrorGroupX));
            points.put("max_gross_error_y", Double.valueOf(maxGrossErrorGroupY));
            points.put("max_gross_error_z", Double.valueOf(maxGrossErrorGroupZ));
            this.setParam("feature_points", points);
        }
    }

    private void addVarianceEstimation() {
        if (this.adjustment.getTestStatisticParameters() == null) {
            return;
        }
        ArrayList vces = new ArrayList();
        HashMap<String, Object> vce = new HashMap<String, Object>(6);
        VarianceComponent varianceComponentOfUnitWeight = this.adjustment.getVarianceComponentOfUnitWeight();
        VarianceComponentType varianceComponentType = varianceComponentOfUnitWeight.getVarianceComponentType();
        int dof = (int)varianceComponentOfUnitWeight.getRedundancy();
        int numberOfObservations = varianceComponentOfUnitWeight.getNumberOfObservations();
        double sigma2apost = varianceComponentOfUnitWeight.getUnitVariance();
        double omega = varianceComponentOfUnitWeight.getUnitOmega();
        boolean significant = varianceComponentOfUnitWeight.isSignificant();
        double quantile = this.adjustment.getTestStatisticParameters().getTestStatisticParameter((double)dof > 1.0E-6 ? dof : 0, Double.POSITIVE_INFINITY).getQuantile();
        vce.put("type", varianceComponentType.name());
        vce.put("omega", omega);
        vce.put("number_of_observations", numberOfObservations);
        vce.put("redundancy", dof);
        vce.put("sigma2apost", sigma2apost);
        vce.put("quantile", quantile);
        vce.put("significant", significant);
        vces.add(vce);
        if (vces.size() > 0) {
            this.setParam("vce", vces);
        }
    }

    public static List<Path> getTemplates() {
        URL url;
        ArrayList<Path> templates;
        block13: {
            templates = new ArrayList<Path>();
            url = FTLReport.class.getClassLoader().getResource(TEMPLATE_PATH);
            if (url != null) break block13;
            System.err.println("Template path not found");
            return null;
        }
        try {
            DirectoryStream.Filter<Path> ftlhFilter = new DirectoryStream.Filter<Path>(){

                @Override
                public boolean accept(Path entry) throws IOException {
                    String name = entry.getFileName().toString();
                    return name.toLowerCase().endsWith(".ftlh");
                }
            };
            Path root = Paths.get(url.toURI());
            Throwable throwable = null;
            Object var5_7 = null;
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(root, (DirectoryStream.Filter<? super Path>)ftlhFilter);){
                for (Path p : stream) {
                    if (!Files.isRegularFile(p, new LinkOption[0]) || !Files.isReadable(p)) continue;
                    templates.add(p);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return templates;
    }
}

