/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.juniform.io.reader;

import java.io.File;
import java.nio.file.Path;
import javafx.stage.FileChooser;
import org.applied_geodesy.adjustment.geometry.GeometricPrimitive;
import org.applied_geodesy.adjustment.geometry.parameter.ParameterType;
import org.applied_geodesy.adjustment.geometry.parameter.UnknownParameter;
import org.applied_geodesy.juniform.ui.i18n.I18N;
import org.applied_geodesy.util.io.SourceFileReader;

public class InitialGuessFileReader
extends SourceFileReader<GeometricPrimitive> {
    private final GeometricPrimitive geometricPrimitive;
    private boolean containsValidContent = false;

    public InitialGuessFileReader(GeometricPrimitive geometricPrimitive) {
        this.geometricPrimitive = geometricPrimitive;
        this.reset();
    }

    public InitialGuessFileReader(String fileName, GeometricPrimitive geometricPrimitive) {
        this(new File(fileName).toPath(), geometricPrimitive);
    }

    public InitialGuessFileReader(File sf, GeometricPrimitive geometricPrimitive) {
        this(sf.toPath(), geometricPrimitive);
    }

    public InitialGuessFileReader(Path path, GeometricPrimitive geometricPrimitive) {
        super(path);
        this.geometricPrimitive = geometricPrimitive;
        this.reset();
    }

    @Override
    public GeometricPrimitive readAndImport() throws Exception {
        this.ignoreLinesWhichStartWith("#");
        super.read();
        if (!this.containsValidContent) {
            throw new IllegalArgumentException("Error, selected file does not contain valid initial values!");
        }
        return this.geometricPrimitive;
    }

    @Override
    public void reset() {
        this.containsValidContent = false;
    }

    @Override
    public void parse(String line) {
        try {
            if (line == null || line.isBlank()) {
                return;
            }
            String[] data = line.trim().split("[;=\\s]+");
            if (data.length < 2) {
                return;
            }
            ParameterType type = ParameterType.valueOf(data[0]);
            double value0 = Double.parseDouble(data[1]);
            UnknownParameter parameter = this.geometricPrimitive.getUnknownParameter(type);
            if (parameter != null) {
                parameter.setValue0(value0);
                this.containsValidContent = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static FileChooser.ExtensionFilter[] getExtensionFilters() {
        return new FileChooser.ExtensionFilter[]{new FileChooser.ExtensionFilter(I18N.getInstance().getString("InitialGuessFileReader.extension.description", "All files"), new String[]{"*.*"})};
    }
}

