/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.juniform.io.reader;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.sql.SQLException;
import javafx.stage.FileChooser;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.UpperSymmBandMatrix;
import no.uib.cipr.matrix.UpperSymmPackMatrix;
import org.applied_geodesy.adjustment.geometry.FeatureType;
import org.applied_geodesy.adjustment.geometry.point.FeaturePoint;
import org.applied_geodesy.juniform.ui.i18n.I18N;
import org.applied_geodesy.util.FormatterOptions;
import org.applied_geodesy.util.ObservableUniqueList;
import org.applied_geodesy.util.io.SourceFileReader;

public class FeaturePointFileReader
extends SourceFileReader<ObservableUniqueList<FeaturePoint>> {
    private static long id = 0L;
    private final FeatureType featureType;
    private ObservableUniqueList<FeaturePoint> points;

    public FeaturePointFileReader(FeatureType featureType) {
        this.featureType = featureType;
        this.reset();
    }

    public FeaturePointFileReader(String fileName, FeatureType featureType) {
        this(new File(fileName).toPath(), featureType);
    }

    public FeaturePointFileReader(File sf, FeatureType featureType) {
        this(sf.toPath(), featureType);
    }

    public FeaturePointFileReader(Path path, FeatureType featureType) {
        super(path);
        this.featureType = featureType;
        this.reset();
    }

    public FeatureType getFeatureType() {
        return this.featureType;
    }

    @Override
    public ObservableUniqueList<FeaturePoint> readAndImport() throws IOException, SQLException {
        this.ignoreLinesWhichStartWith("#");
        super.read();
        if (this.isInterrupted()) {
            this.points.clear();
        }
        return this.points;
    }

    @Override
    public void reset() {
        if (this.points == null) {
            this.points = new ObservableUniqueList(10000);
        }
        this.points.clear();
        id = 0L;
    }

    @Override
    public void parse(String line) {
        line = line.trim();
        FeaturePoint point = null;
        try {
            switch (this.featureType) {
                case CURVE: {
                    point = FeaturePointFileReader.scanCurvePoint(line);
                    break;
                }
                case SURFACE: {
                    point = FeaturePointFileReader.scanSurfacePoint(line);
                }
            }
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            return;
        }
        if (point != null) {
            this.points.add(point);
        }
    }

    private static FeaturePoint scanCurvePoint(String str) throws NumberFormatException {
        double sigmaY;
        FormatterOptions options = FormatterOptions.getInstance();
        String[] columns = str.trim().split("[\\s;]+");
        if (columns.length == 2) {
            String name = String.valueOf(++id);
            double x = options.convertLengthToModel(Double.parseDouble(columns[0].replace(',', '.')));
            double y = options.convertLengthToModel(Double.parseDouble(columns[1].replace(',', '.')));
            return new FeaturePoint(name, x, y);
        }
        if (columns.length < 3) {
            return null;
        }
        String name = columns[0];
        double x = options.convertLengthToModel(Double.parseDouble(columns[1].replace(',', '.')));
        double y = options.convertLengthToModel(Double.parseDouble(columns[2].replace(',', '.')));
        FeaturePoint point = new FeaturePoint(name, x, y);
        if (columns.length < 4) {
            return point;
        }
        double sigmaX = sigmaY = options.convertLengthToModel(Double.parseDouble(columns[3].replace(',', '.')));
        if (columns.length < 5) {
            if (sigmaX <= 0.0 || sigmaY <= 0.0) {
                return point;
            }
            UpperSymmBandMatrix dispersion = new UpperSymmBandMatrix(point.getDimension(), 0);
            dispersion.set(0, 0, sigmaX * sigmaX);
            dispersion.set(1, 1, sigmaY * sigmaY);
            point.setDispersionApriori((Matrix)dispersion);
            return point;
        }
        sigmaY = options.convertLengthToModel(Double.parseDouble(columns[4].replace(',', '.')));
        if (columns.length < 6) {
            if (sigmaX <= 0.0 || sigmaY <= 0.0) {
                return point;
            }
            UpperSymmBandMatrix dispersion = new UpperSymmBandMatrix(point.getDimension(), 0);
            dispersion.set(0, 0, sigmaX * sigmaX);
            dispersion.set(1, 1, sigmaY * sigmaY);
            point.setDispersionApriori((Matrix)dispersion);
            return point;
        }
        double varX = options.convertLengthToModel(sigmaX);
        double covXY = options.convertLengthToModel(sigmaY);
        double varY = options.convertLengthToModel(options.convertLengthToModel(Double.parseDouble(columns[5].replace(',', '.'))));
        if (varX <= 0.0 || varY <= 0.0) {
            return point;
        }
        UpperSymmPackMatrix dispersion = null;
        if (covXY == 0.0) {
            dispersion = new UpperSymmBandMatrix(point.getDimension(), 0);
        } else {
            dispersion = new UpperSymmPackMatrix(point.getDimension());
            dispersion.set(0, 1, covXY);
        }
        dispersion.set(0, 0, varX);
        dispersion.set(1, 1, varY);
        point.setDispersionApriori((Matrix)dispersion);
        return point;
    }

    private static FeaturePoint scanSurfacePoint(String str) throws NumberFormatException {
        double sigmaZ;
        FormatterOptions options = FormatterOptions.getInstance();
        String[] columns = str.trim().split("[\\s;]+");
        if (columns.length == 3) {
            String name = String.valueOf(++id);
            double x = options.convertLengthToModel(Double.parseDouble(columns[0].replace(',', '.')));
            double y = options.convertLengthToModel(Double.parseDouble(columns[1].replace(',', '.')));
            double z = options.convertLengthToModel(Double.parseDouble(columns[2].replace(',', '.')));
            return new FeaturePoint(name, x, y, z);
        }
        if (columns.length < 4) {
            return null;
        }
        String name = columns[0];
        double x = options.convertLengthToModel(Double.parseDouble(columns[1].replace(',', '.')));
        double y = options.convertLengthToModel(Double.parseDouble(columns[2].replace(',', '.')));
        double z = options.convertLengthToModel(Double.parseDouble(columns[3].replace(',', '.')));
        FeaturePoint point = new FeaturePoint(name, x, y, z);
        if (columns.length < 5) {
            return point;
        }
        double sigmaY = sigmaZ = options.convertLengthToModel(Double.parseDouble(columns[4].replace(',', '.')));
        double sigmaX = sigmaZ;
        if (columns.length < 6) {
            if (sigmaX <= 0.0 || sigmaY <= 0.0 || sigmaZ <= 0.0) {
                return point;
            }
            UpperSymmBandMatrix dispersion = new UpperSymmBandMatrix(point.getDimension(), 0);
            dispersion.set(0, 0, sigmaX * sigmaX);
            dispersion.set(1, 1, sigmaY * sigmaY);
            dispersion.set(2, 2, sigmaZ * sigmaZ);
            point.setDispersionApriori((Matrix)dispersion);
            return point;
        }
        sigmaY = sigmaZ = options.convertLengthToModel(Double.parseDouble(columns[5].replace(',', '.')));
        if (columns.length < 7) {
            if (sigmaX <= 0.0 || sigmaY <= 0.0 || sigmaZ <= 0.0) {
                return point;
            }
            UpperSymmBandMatrix dispersion = new UpperSymmBandMatrix(point.getDimension(), 0);
            dispersion.set(0, 0, sigmaX * sigmaX);
            dispersion.set(1, 1, sigmaX * sigmaX);
            dispersion.set(2, 2, sigmaZ * sigmaZ);
            point.setDispersionApriori((Matrix)dispersion);
            return point;
        }
        sigmaZ = options.convertLengthToModel(Double.parseDouble(columns[6].replace(',', '.')));
        if (columns.length < 10) {
            if (sigmaX <= 0.0 || sigmaY <= 0.0 || sigmaZ <= 0.0) {
                return point;
            }
            UpperSymmBandMatrix dispersion = new UpperSymmBandMatrix(point.getDimension(), 0);
            dispersion.set(0, 0, sigmaX * sigmaX);
            dispersion.set(1, 1, sigmaY * sigmaY);
            dispersion.set(2, 2, sigmaZ * sigmaZ);
            point.setDispersionApriori((Matrix)dispersion);
            return point;
        }
        double varX = options.convertLengthToModel(sigmaX);
        double covXY = options.convertLengthToModel(sigmaY);
        double covXZ = options.convertLengthToModel(sigmaZ);
        double varY = options.convertLengthToModel(options.convertLengthToModel(Double.parseDouble(columns[7].replace(',', '.'))));
        double covYZ = options.convertLengthToModel(options.convertLengthToModel(Double.parseDouble(columns[8].replace(',', '.'))));
        double varZ = options.convertLengthToModel(options.convertLengthToModel(Double.parseDouble(columns[9].replace(',', '.'))));
        if (varX <= 0.0 || varY <= 0.0 || varZ <= 0.0) {
            return point;
        }
        UpperSymmPackMatrix dispersion = null;
        if (covXY == 0.0 && covXZ == 0.0 && covYZ == 0.0) {
            dispersion = new UpperSymmBandMatrix(point.getDimension(), 0);
        } else {
            dispersion = new UpperSymmPackMatrix(point.getDimension());
            dispersion.set(0, 1, covXY);
            dispersion.set(0, 2, covXZ);
            dispersion.set(1, 2, covYZ);
        }
        dispersion.set(0, 0, varX);
        dispersion.set(1, 1, varY);
        dispersion.set(2, 2, varZ);
        point.setDispersionApriori((Matrix)dispersion);
        return point;
    }

    public static FileChooser.ExtensionFilter[] getExtensionFilters() {
        return new FileChooser.ExtensionFilter[]{new FileChooser.ExtensionFilter(I18N.getInstance().getString("FeaturePointFileReader.extension.description", "All files"), new String[]{"*.*"})};
    }
}

