/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.jag3d.ui.tree;

import java.util.ArrayList;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleIntegerProperty;
import org.applied_geodesy.adjustment.network.DefaultUncertainty;
import org.applied_geodesy.adjustment.network.VerticalDeflectionGroupUncertaintyType;
import org.applied_geodesy.jag3d.ui.tabpane.TabType;
import org.applied_geodesy.jag3d.ui.tree.Groupable;
import org.applied_geodesy.jag3d.ui.tree.Sortable;
import org.applied_geodesy.jag3d.ui.tree.TreeItemType;
import org.applied_geodesy.jag3d.ui.tree.TreeItemValue;

public class VerticalDeflectionTreeItemValue
extends TreeItemValue
implements Sortable,
Groupable {
    private IntegerProperty groupId = new SimpleIntegerProperty(-1);
    private int orderId;

    VerticalDeflectionTreeItemValue(int groupId, TreeItemType type, String name, int orderId) throws IllegalArgumentException {
        this(groupId, type, name, Boolean.TRUE, orderId);
    }

    VerticalDeflectionTreeItemValue(int groupId, TreeItemType type, String name, boolean enable, int orderId) throws IllegalArgumentException {
        super(type, name);
        this.setGroupId(groupId);
        this.setEnable(enable);
        this.setOrderId(orderId);
    }

    public IntegerProperty groupIdProperty() {
        return this.groupId;
    }

    @Override
    public int getGroupId() {
        return this.groupIdProperty().get();
    }

    @Override
    public void setGroupId(int groupId) {
        this.groupIdProperty().set(groupId);
    }

    @Override
    public final int getDimension() {
        return 2;
    }

    @Override
    public TabType[] getTabTypes() {
        TreeItemType type = this.getItemType();
        ArrayList<TabType> tabTyps = new ArrayList<TabType>(5);
        tabTyps.add(TabType.RAW_DATA);
        if (type == TreeItemType.STOCHASTIC_VERTICAL_DEFLECTION_LEAF) {
            tabTyps.add(TabType.PROPERTIES);
        }
        tabTyps.add(TabType.RESULT_DATA);
        if (type == TreeItemType.STOCHASTIC_VERTICAL_DEFLECTION_LEAF) {
            tabTyps.add(TabType.VARIANCE_COMPONENT);
        }
        return tabTyps.toArray(new TabType[tabTyps.size()]);
    }

    public static double getDefaultUncertainty(VerticalDeflectionGroupUncertaintyType uncertaintyType) {
        switch (uncertaintyType) {
            case DEFLECTION_X: {
                return DefaultUncertainty.getUncertaintyDeflectionX();
            }
            case DEFLECTION_Y: {
                return DefaultUncertainty.getUncertaintyDeflectionY();
            }
        }
        return 0.0;
    }

    @Override
    public int getOrderId() {
        return this.orderId;
    }

    @Override
    public void setOrderId(int orderId) {
        this.orderId = orderId;
    }
}

