/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.jag3d.ui.tree;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import javafx.event.EventHandler;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBoxTreeItem;
import javafx.scene.control.MultipleSelectionModel;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TreeCell;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.util.Callback;
import org.applied_geodesy.jag3d.DefaultApplicationProperty;
import org.applied_geodesy.jag3d.sql.SQLManager;
import org.applied_geodesy.jag3d.ui.i18n.I18N;
import org.applied_geodesy.jag3d.ui.tabpane.UITabPaneBuilder;
import org.applied_geodesy.jag3d.ui.tree.CongruenceAnalysisTreeItemValue;
import org.applied_geodesy.jag3d.ui.tree.EditableMenuCheckBoxTreeCell;
import org.applied_geodesy.jag3d.ui.tree.ObservationTreeItemValue;
import org.applied_geodesy.jag3d.ui.tree.PointTreeItemValue;
import org.applied_geodesy.jag3d.ui.tree.RootTreeItemValue;
import org.applied_geodesy.jag3d.ui.tree.TreeItemType;
import org.applied_geodesy.jag3d.ui.tree.TreeItemValue;
import org.applied_geodesy.jag3d.ui.tree.VerticalDeflectionTreeItemValue;
import org.applied_geodesy.ui.dialog.OptionDialog;

public class UITreeBuilder {
    private static UITreeBuilder treeBuilder = new UITreeBuilder();
    private I18N i18n = I18N.getInstance();
    private UITabPaneBuilder tabPaneBuilder = UITabPaneBuilder.getInstance();
    private ObservableMap<TreeItemType, CheckBoxTreeItem<TreeItemValue>> directoryItemMap = FXCollections.observableHashMap();
    private TreeItem<TreeItemValue> lastValidSelectedTreeItem = null;
    private TreeView<TreeItemValue> treeView;
    private boolean ignoreExpanding = false;
    private BooleanProperty ignoreEvent = new SimpleBooleanProperty(Boolean.FALSE.booleanValue());
    private TreeListSelectionChangeListener treeListSelectionChangeListener = new TreeListSelectionChangeListener();
    private boolean ignoreTreeSelection = false;

    private UITreeBuilder() {
    }

    public static UITreeBuilder getInstance() {
        if (UITreeBuilder.treeBuilder.treeView == null) {
            treeBuilder.init();
        }
        return treeBuilder;
    }

    public TreeView<TreeItemValue> getTree() {
        return this.treeView;
    }

    private void init() {
        CheckBoxTreeItem checkBoxItem;
        TreeItem rootItem = new TreeItem((Object)new RootTreeItemValue(this.i18n.getString("UITreeBuiler.root", "JAG3D-Project")));
        TreeItem referencePointItem = new TreeItem((Object)new TreeItemValue(this.i18n.getString("UITreeBuiler.directory.points.reference", "Reference points")));
        CheckBoxTreeItem referencePoint1DItem = new CheckBoxTreeItem((Object)new TreeItemValue(TreeItemType.REFERENCE_POINT_1D_DIRECTORY, this.i18n.getString("UITreeBuiler.directory.points.reference.1d", "Reference points 1D")));
        CheckBoxTreeItem referencePoint2DItem = new CheckBoxTreeItem((Object)new TreeItemValue(TreeItemType.REFERENCE_POINT_2D_DIRECTORY, this.i18n.getString("UITreeBuiler.directory.points.reference.2d", "Reference points 2D")));
        CheckBoxTreeItem referencePoint3DItem = new CheckBoxTreeItem((Object)new TreeItemValue(TreeItemType.REFERENCE_POINT_3D_DIRECTORY, this.i18n.getString("UITreeBuiler.directory.points.reference.3d", "Reference points 3D")));
        referencePointItem.getChildren().addAll(Arrays.asList(referencePoint1DItem, referencePoint2DItem, referencePoint3DItem));
        TreeItem stochasticPointItem = new TreeItem((Object)new TreeItemValue(this.i18n.getString("UITreeBuiler.directory.points.stochastic", "Stochastic points")));
        CheckBoxTreeItem stochasticPoint1DItem = new CheckBoxTreeItem((Object)new TreeItemValue(TreeItemType.STOCHASTIC_POINT_1D_DIRECTORY, this.i18n.getString("UITreeBuiler.directory.points.stochastic.1d", "Stochastic points 1D")));
        CheckBoxTreeItem stochasticPoint2DItem = new CheckBoxTreeItem((Object)new TreeItemValue(TreeItemType.STOCHASTIC_POINT_2D_DIRECTORY, this.i18n.getString("UITreeBuiler.directory.points.stochastic.2d", "Stochastic points 2D")));
        CheckBoxTreeItem stochasticPoint3DItem = new CheckBoxTreeItem((Object)new TreeItemValue(TreeItemType.STOCHASTIC_POINT_3D_DIRECTORY, this.i18n.getString("UITreeBuiler.directory.points.stochastic.3d", "Stochastic points 3D")));
        stochasticPointItem.getChildren().addAll(Arrays.asList(stochasticPoint1DItem, stochasticPoint2DItem, stochasticPoint3DItem));
        TreeItem datumPointItem = new TreeItem((Object)new TreeItemValue(this.i18n.getString("UITreeBuiler.directory.points.datum", "Datum points")));
        CheckBoxTreeItem datumPoint1DItem = new CheckBoxTreeItem((Object)new TreeItemValue(TreeItemType.DATUM_POINT_1D_DIRECTORY, this.i18n.getString("UITreeBuiler.directory.points.datum.1d", "Datum points 1D")));
        CheckBoxTreeItem datumPoint2DItem = new CheckBoxTreeItem((Object)new TreeItemValue(TreeItemType.DATUM_POINT_2D_DIRECTORY, this.i18n.getString("UITreeBuiler.directory.points.datum.2d", "Datum points 2D")));
        CheckBoxTreeItem datumPoint3DItem = new CheckBoxTreeItem((Object)new TreeItemValue(TreeItemType.DATUM_POINT_3D_DIRECTORY, this.i18n.getString("UITreeBuiler.directory.points.datum.3d", "Datum points 3D")));
        datumPointItem.getChildren().addAll(Arrays.asList(datumPoint1DItem, datumPoint2DItem, datumPoint3DItem));
        TreeItem newPointItem = new TreeItem((Object)new TreeItemValue(this.i18n.getString("UITreeBuiler.directory.points.new", "New points")));
        CheckBoxTreeItem newPoint1DItem = new CheckBoxTreeItem((Object)new TreeItemValue(TreeItemType.NEW_POINT_1D_DIRECTORY, this.i18n.getString("UITreeBuiler.directory.points.new.1d", "New points 1D")));
        CheckBoxTreeItem newPoint2DItem = new CheckBoxTreeItem((Object)new TreeItemValue(TreeItemType.NEW_POINT_2D_DIRECTORY, this.i18n.getString("UITreeBuiler.directory.points.new.2d", "New points 2D")));
        CheckBoxTreeItem newPoint3DItem = new CheckBoxTreeItem((Object)new TreeItemValue(TreeItemType.NEW_POINT_3D_DIRECTORY, this.i18n.getString("UITreeBuiler.directory.points.new.3d", "New points 3D")));
        newPointItem.getChildren().addAll(Arrays.asList(newPoint1DItem, newPoint2DItem, newPoint3DItem));
        TreeItem verticalDeflectionItem = new TreeItem((Object)new TreeItemValue(this.i18n.getString("UITreeBuiler.directory.vertical_deflection", "Vertical deflection")));
        CheckBoxTreeItem referenceVerticalDeflectionItem = new CheckBoxTreeItem((Object)new TreeItemValue(TreeItemType.REFERENCE_VERTICAL_DEFLECTION_DIRECTORY, this.i18n.getString("UITreeBuiler.directory.vertical_deflection.reference", "Reference deflection")));
        CheckBoxTreeItem stochasticVerticalDeflectionItem = new CheckBoxTreeItem((Object)new TreeItemValue(TreeItemType.STOCHASTIC_VERTICAL_DEFLECTION_DIRECTORY, this.i18n.getString("UITreeBuiler.directory.vertical_deflection.stochastic", "Stochastic deflection")));
        CheckBoxTreeItem newVerticalDeflectionItem = new CheckBoxTreeItem((Object)new TreeItemValue(TreeItemType.UNKNOWN_VERTICAL_DEFLECTION_DIRECTORY, this.i18n.getString("UITreeBuiler.directory.vertical_deflection.unknown", "Unknown deflection")));
        verticalDeflectionItem.getChildren().addAll(Arrays.asList(referenceVerticalDeflectionItem, stochasticVerticalDeflectionItem, newVerticalDeflectionItem));
        TreeItem congruenceAnalysisItem = new TreeItem((Object)new TreeItemValue(this.i18n.getString("UITreeBuiler.directory.congruenceanalysis", "Congruence analysis")));
        CheckBoxTreeItem congruenceAnalysis1DItem = new CheckBoxTreeItem((Object)new TreeItemValue(TreeItemType.CONGRUENCE_ANALYSIS_1D_DIRECTORY, this.i18n.getString("UITreeBuiler.directory.congruenceanalysis.1d", "Point nexus 1D")));
        CheckBoxTreeItem congruenceAnalysis2DItem = new CheckBoxTreeItem((Object)new TreeItemValue(TreeItemType.CONGRUENCE_ANALYSIS_2D_DIRECTORY, this.i18n.getString("UITreeBuiler.directory.congruenceanalysis.2d", "Point nexus 2D")));
        CheckBoxTreeItem congruenceAnalysis3DItem = new CheckBoxTreeItem((Object)new TreeItemValue(TreeItemType.CONGRUENCE_ANALYSIS_3D_DIRECTORY, this.i18n.getString("UITreeBuiler.directory.congruenceanalysis.3d", "Point nexus 3D")));
        congruenceAnalysisItem.getChildren().addAll(Arrays.asList(congruenceAnalysis1DItem, congruenceAnalysis2DItem, congruenceAnalysis3DItem));
        TreeItem terrestrialObservationItem = new TreeItem((Object)new TreeItemValue(this.i18n.getString("UITreeBuiler.directory.observations", "Terrestrial Observations")));
        CheckBoxTreeItem levelingObservationItem = new CheckBoxTreeItem((Object)new TreeItemValue(TreeItemType.LEVELING_DIRECTORY, this.i18n.getString("UITreeBuiler.directory.observations.leveling", "Leveling data")));
        CheckBoxTreeItem directionObservationItem = new CheckBoxTreeItem((Object)new TreeItemValue(TreeItemType.DIRECTION_DIRECTORY, this.i18n.getString("UITreeBuiler.directory.observations.direction", "Direction sets")));
        CheckBoxTreeItem distance2dObservationItem = new CheckBoxTreeItem((Object)new TreeItemValue(TreeItemType.HORIZONTAL_DISTANCE_DIRECTORY, this.i18n.getString("UITreeBuiler.directory.observations.horizontal_distance", "Horizontal distances")));
        CheckBoxTreeItem distance3dObservationItem = new CheckBoxTreeItem((Object)new TreeItemValue(TreeItemType.SLOPE_DISTANCE_DIRECTORY, this.i18n.getString("UITreeBuiler.directory.observations.slope_distance", "Slope distances")));
        CheckBoxTreeItem zenithObservationItem = new CheckBoxTreeItem((Object)new TreeItemValue(TreeItemType.ZENITH_ANGLE_DIRECTORY, this.i18n.getString("UITreeBuiler.directory.observations.zenith_angle", "Zenith angles")));
        terrestrialObservationItem.getChildren().addAll(Arrays.asList(levelingObservationItem, directionObservationItem, distance2dObservationItem, distance3dObservationItem, zenithObservationItem));
        TreeItem gnssBaselineItem = new TreeItem((Object)new TreeItemValue(this.i18n.getString("UITreeBuiler.directory.gnss", "GNSS baselines")));
        CheckBoxTreeItem gnssBaseline1DItem = new CheckBoxTreeItem((Object)new TreeItemValue(TreeItemType.GNSS_1D_DIRECTORY, this.i18n.getString("UITreeBuiler.directory.gnss.1d", "GNSS baselines 1D")));
        CheckBoxTreeItem gnssBaseline2DItem = new CheckBoxTreeItem((Object)new TreeItemValue(TreeItemType.GNSS_2D_DIRECTORY, this.i18n.getString("UITreeBuiler.directory.gnss.2d", "GNSS baselines 2D")));
        CheckBoxTreeItem gnssBaseline3DItem = new CheckBoxTreeItem((Object)new TreeItemValue(TreeItemType.GNSS_3D_DIRECTORY, this.i18n.getString("UITreeBuiler.directory.gnss.3d", "GNSS baselines 3D")));
        gnssBaselineItem.getChildren().addAll(Arrays.asList(gnssBaseline1DItem, gnssBaseline2DItem, gnssBaseline3DItem));
        for (TreeItem item : referencePointItem.getChildren()) {
            item.expandedProperty().addListener((ChangeListener)new TreeItemExpandingChangeListener((TreeItem<TreeItemValue>)item));
            if (!(item instanceof CheckBoxTreeItem)) continue;
            checkBoxItem = (CheckBoxTreeItem)item;
            checkBoxItem.selectedProperty().addListener((ChangeListener)new TreeCheckBoxChangeListener((CheckBoxTreeItem<TreeItemValue>)checkBoxItem));
            checkBoxItem.setIndependent(true);
            this.directoryItemMap.put((Object)((TreeItemValue)item.getValue()).getItemType(), (Object)checkBoxItem);
        }
        for (TreeItem item : stochasticPointItem.getChildren()) {
            item.expandedProperty().addListener((ChangeListener)new TreeItemExpandingChangeListener((TreeItem<TreeItemValue>)item));
            if (!(item instanceof CheckBoxTreeItem)) continue;
            checkBoxItem = (CheckBoxTreeItem)item;
            checkBoxItem.selectedProperty().addListener((ChangeListener)new TreeCheckBoxChangeListener((CheckBoxTreeItem<TreeItemValue>)checkBoxItem));
            checkBoxItem.setIndependent(true);
            this.directoryItemMap.put((Object)((TreeItemValue)item.getValue()).getItemType(), (Object)checkBoxItem);
        }
        for (TreeItem item : datumPointItem.getChildren()) {
            item.expandedProperty().addListener((ChangeListener)new TreeItemExpandingChangeListener((TreeItem<TreeItemValue>)item));
            if (!(item instanceof CheckBoxTreeItem)) continue;
            checkBoxItem = (CheckBoxTreeItem)item;
            checkBoxItem.selectedProperty().addListener((ChangeListener)new TreeCheckBoxChangeListener((CheckBoxTreeItem<TreeItemValue>)checkBoxItem));
            checkBoxItem.setIndependent(true);
            this.directoryItemMap.put((Object)((TreeItemValue)item.getValue()).getItemType(), (Object)checkBoxItem);
        }
        for (TreeItem item : newPointItem.getChildren()) {
            item.expandedProperty().addListener((ChangeListener)new TreeItemExpandingChangeListener((TreeItem<TreeItemValue>)item));
            if (!(item instanceof CheckBoxTreeItem)) continue;
            checkBoxItem = (CheckBoxTreeItem)item;
            checkBoxItem.selectedProperty().addListener((ChangeListener)new TreeCheckBoxChangeListener((CheckBoxTreeItem<TreeItemValue>)checkBoxItem));
            checkBoxItem.setIndependent(true);
            this.directoryItemMap.put((Object)((TreeItemValue)item.getValue()).getItemType(), (Object)checkBoxItem);
        }
        for (TreeItem item : verticalDeflectionItem.getChildren()) {
            item.expandedProperty().addListener((ChangeListener)new TreeItemExpandingChangeListener((TreeItem<TreeItemValue>)item));
            if (!(item instanceof CheckBoxTreeItem)) continue;
            checkBoxItem = (CheckBoxTreeItem)item;
            checkBoxItem.selectedProperty().addListener((ChangeListener)new TreeCheckBoxChangeListener((CheckBoxTreeItem<TreeItemValue>)checkBoxItem));
            checkBoxItem.setIndependent(true);
            this.directoryItemMap.put((Object)((TreeItemValue)item.getValue()).getItemType(), (Object)checkBoxItem);
        }
        for (TreeItem item : congruenceAnalysisItem.getChildren()) {
            item.expandedProperty().addListener((ChangeListener)new TreeItemExpandingChangeListener((TreeItem<TreeItemValue>)item));
            if (!(item instanceof CheckBoxTreeItem)) continue;
            checkBoxItem = (CheckBoxTreeItem)item;
            checkBoxItem.selectedProperty().addListener((ChangeListener)new TreeCheckBoxChangeListener((CheckBoxTreeItem<TreeItemValue>)checkBoxItem));
            checkBoxItem.setIndependent(true);
            this.directoryItemMap.put((Object)((TreeItemValue)item.getValue()).getItemType(), (Object)checkBoxItem);
        }
        for (TreeItem item : terrestrialObservationItem.getChildren()) {
            item.expandedProperty().addListener((ChangeListener)new TreeItemExpandingChangeListener((TreeItem<TreeItemValue>)item));
            if (!(item instanceof CheckBoxTreeItem)) continue;
            checkBoxItem = (CheckBoxTreeItem)item;
            checkBoxItem.selectedProperty().addListener((ChangeListener)new TreeCheckBoxChangeListener((CheckBoxTreeItem<TreeItemValue>)checkBoxItem));
            checkBoxItem.setIndependent(true);
            this.directoryItemMap.put((Object)((TreeItemValue)item.getValue()).getItemType(), (Object)checkBoxItem);
        }
        for (TreeItem item : gnssBaselineItem.getChildren()) {
            item.expandedProperty().addListener((ChangeListener)new TreeItemExpandingChangeListener((TreeItem<TreeItemValue>)item));
            if (!(item instanceof CheckBoxTreeItem)) continue;
            checkBoxItem = (CheckBoxTreeItem)item;
            checkBoxItem.selectedProperty().addListener((ChangeListener)new TreeCheckBoxChangeListener((CheckBoxTreeItem<TreeItemValue>)checkBoxItem));
            checkBoxItem.setIndependent(true);
            this.directoryItemMap.put((Object)((TreeItemValue)item.getValue()).getItemType(), (Object)checkBoxItem);
        }
        rootItem.getChildren().addAll(Arrays.asList(referencePointItem, stochasticPointItem, datumPointItem, newPointItem, verticalDeflectionItem, congruenceAnalysisItem, terrestrialObservationItem, gnssBaselineItem));
        rootItem.setExpanded(true);
        this.treeView = new TreeView(rootItem);
        this.treeView.setEditable(true);
        this.treeView.setCellFactory((Callback)new Callback<TreeView<TreeItemValue>, TreeCell<TreeItemValue>>(){

            public TreeCell<TreeItemValue> call(TreeView<TreeItemValue> treeView) {
                EditableMenuCheckBoxTreeCell editableMenuCheckBoxTreeCell = new EditableMenuCheckBoxTreeCell();
                editableMenuCheckBoxTreeCell.ignoreEventProperty().bindBidirectional((Property)UITreeBuilder.this.ignoreEvent);
                return editableMenuCheckBoxTreeCell;
            }
        });
        this.treeView.getSelectionModel().select((Object)rootItem);
        this.treeView.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        this.treeView.getSelectionModel().getSelectedItems().addListener((ListChangeListener)this.treeListSelectionChangeListener);
        this.addTreeKeyEvents();
    }

    public void removeAllItems() {
        for (CheckBoxTreeItem item : this.directoryItemMap.values()) {
            item.getChildren().clear();
            item.setSelected(false);
        }
    }

    public TreeItem<TreeItemValue> addItem(TreeItemType parentType) {
        return this.addItem(parentType, null);
    }

    public TreeItem<TreeItemValue> addItem(TreeItemType parentType, boolean select) {
        return this.addItem(parentType, -1, null, Boolean.TRUE, select);
    }

    public TreeItem<TreeItemValue> addItem(TreeItemType parentType, String name) {
        return this.addItem(parentType, -1, name, Boolean.TRUE, Boolean.TRUE);
    }

    public TreeItem<TreeItemValue> addItem(TreeItemType parentType, int id, String name, boolean enable, boolean select) {
        TreeItemValue itemValue;
        TreeItemType itemType = null;
        if (parentType == null || parentType == TreeItemType.UNSPECIFIC) {
            return null;
        }
        if (!this.directoryItemMap.containsKey((Object)parentType) || (itemType = TreeItemType.getLeafByDirectoryType(parentType)) == null) {
            System.err.println(this.getClass().getSimpleName() + " : Error, unsupported parent tree node type " + String.valueOf((Object)parentType));
            return null;
        }
        int orderId = ((CheckBoxTreeItem)this.directoryItemMap.get((Object)parentType)).getChildren().size();
        if (TreeItemType.isPointTypeLeaf(itemType)) {
            itemValue = new PointTreeItemValue(id, itemType, name == null || name.trim().isEmpty() ? this.i18n.getString("UITreeBuiler.directory.points", "Points") : name, enable, orderId);
        } else if (TreeItemType.isObservationTypeLeaf(itemType) || TreeItemType.isGNSSObservationTypeLeaf(itemType)) {
            itemValue = new ObservationTreeItemValue(id, itemType, name == null || name.trim().isEmpty() ? this.i18n.getString("UITreeBuiler.directory.observations", "Observations") : name, enable, orderId);
        } else if (TreeItemType.isVerticalDeflectionTypeLeaf(itemType)) {
            itemValue = new VerticalDeflectionTreeItemValue(id, itemType, name == null || name.trim().isEmpty() ? this.i18n.getString("UITreeBuiler.directory.vertical_deflection", "Vertical deflection") : name, enable, orderId);
        } else if (TreeItemType.isCongruenceAnalysisTypeLeaf(itemType)) {
            itemValue = new CongruenceAnalysisTreeItemValue(id, itemType, name == null || name.trim().isEmpty() ? this.i18n.getString("UITreeBuiler.directory.congruenceanalysis", "Point nexus") : name, enable, orderId);
        } else {
            throw new IllegalArgumentException(this.getClass().getSimpleName() + " NOT IMPLEMENTED YET!");
        }
        CheckBoxTreeItem newItem = new CheckBoxTreeItem((Object)itemValue);
        ((CheckBoxTreeItem)this.directoryItemMap.get((Object)parentType)).getChildren().add((Object)newItem);
        this.treeView.getSelectionModel().clearSelection();
        this.expand((TreeItem<TreeItemValue>)newItem, true);
        if (select) {
            this.treeView.getSelectionModel().select((Object)newItem);
        }
        newItem.selectedProperty().bindBidirectional((Property)itemValue.enableProperty());
        newItem.selectedProperty().addListener((ChangeListener)new TreeCheckBoxChangeListener((CheckBoxTreeItem<TreeItemValue>)newItem));
        ((TreeItemValue)newItem.getValue()).nameProperty().addListener((ChangeListener)new TreeItemNameChangeListener((TreeItemValue)newItem.getValue()));
        return newItem;
    }

    public void removeItems(List<TreeItem<TreeItemValue>> items) {
        if (items != null && !items.isEmpty()) {
            TreeItemType parentItemType = null;
            for (TreeItem<TreeItemValue> item : items) {
                this.removeItem(item);
                if (parentItemType != null || item.getValue() == null) continue;
                parentItemType = TreeItemType.getDirectoryByLeafType(((TreeItemValue)item.getValue()).getItemType());
            }
        }
    }

    public void removeItem(TreeItem<TreeItemValue> treeItem) {
        if (treeItem == null || treeItem.getValue() == null || ((TreeItemValue)treeItem.getValue()).getItemType() == null) {
            return;
        }
        TreeItemValue itemValue = (TreeItemValue)treeItem.getValue();
        TreeItemType itemType = itemValue.getItemType();
        if (!(TreeItemType.isPointTypeLeaf(itemType) || TreeItemType.isObservationTypeLeaf(itemType) || TreeItemType.isGNSSObservationTypeLeaf(itemType) || TreeItemType.isVerticalDeflectionTypeLeaf(itemType) || TreeItemType.isCongruenceAnalysisTypeLeaf(itemType))) {
            return;
        }
        TreeItemType parentType = TreeItemType.getDirectoryByLeafType(itemType);
        if (parentType == null || !this.directoryItemMap.containsKey((Object)parentType)) {
            return;
        }
        if (this.remove(itemValue)) {
            try {
                this.setIgnoreEvent(true);
                CheckBoxTreeItem parent = (CheckBoxTreeItem)this.directoryItemMap.get((Object)parentType);
                parent.getChildren().remove(treeItem);
                this.updateSelectionStageOfParentNode((CheckBoxTreeItem<TreeItemValue>)parent);
            }
            finally {
                this.setIgnoreEvent(false);
            }
        }
    }

    public void moveItems(TreeItemType newItemType, List<TreeItem<TreeItemValue>> selectedItems) {
        TreeItemType newParentType = TreeItemType.getDirectoryByLeafType(newItemType);
        if (this.directoryItemMap.containsKey((Object)newParentType) && selectedItems != null && selectedItems.size() > 0 && (TreeItemType.isPointTypeLeaf(newItemType) || TreeItemType.isVerticalDeflectionTypeLeaf(newItemType))) {
            CheckBoxTreeItem newParent = (CheckBoxTreeItem)this.directoryItemMap.get((Object)newParentType);
            TreeItem<TreeItemValue> lastItem = null;
            try {
                this.setIgnoreEvent(true);
                for (TreeItem<TreeItemValue> selectedItem : selectedItems) {
                    TreeItemValue itemValue;
                    if (selectedItem == null || !selectedItem.isLeaf() || selectedItem.getValue() == null) continue;
                    if (selectedItem.getValue() instanceof PointTreeItemValue) {
                        itemValue = (PointTreeItemValue)selectedItem.getValue();
                    } else {
                        if (!(selectedItem.getValue() instanceof VerticalDeflectionTreeItemValue)) continue;
                        itemValue = (VerticalDeflectionTreeItemValue)selectedItem.getValue();
                    }
                    TreeItemType oldItemType = itemValue.getItemType();
                    TreeItemType oldParentType = TreeItemType.getDirectoryByLeafType(oldItemType);
                    if (!this.directoryItemMap.containsKey((Object)oldParentType)) continue;
                    itemValue.setItemType(newItemType);
                    if (!this.save(itemValue)) {
                        itemValue.setItemType(oldItemType);
                        continue;
                    }
                    lastItem = selectedItem;
                    CheckBoxTreeItem oldParent = (CheckBoxTreeItem)this.directoryItemMap.get((Object)oldParentType);
                    oldParent.getChildren().remove(selectedItem);
                    this.updateSelectionStageOfParentNode((CheckBoxTreeItem<TreeItemValue>)oldParent);
                    newParent.getChildren().add(selectedItem);
                    this.expand(selectedItem, true);
                }
                if (lastItem != null) {
                    this.updateSelectionStageOfParentNode((CheckBoxTreeItem<TreeItemValue>)newParent);
                }
            }
            finally {
                this.setIgnoreEvent(false);
                if (lastItem != null) {
                    this.treeView.getSelectionModel().select(lastItem);
                }
            }
        }
    }

    public void addEmptyGroup(TreeItemType parentType) {
        TreeItem<TreeItemValue> newMenuItem;
        if (this.directoryItemMap.containsKey((Object)parentType) && !this.save((TreeItemValue)(newMenuItem = this.addItem(parentType)).getValue())) {
            TreeItem parentItem = (TreeItem)this.directoryItemMap.get((Object)parentType);
            parentItem.getChildren().remove(newMenuItem);
        }
    }

    private void updateSelectionStageOfParentNode(CheckBoxTreeItem<TreeItemValue> parentNode) {
        if (parentNode.isLeaf()) {
            parentNode.setIndeterminate(false);
            parentNode.setSelected(false);
        } else if (parentNode.getChildren().get(0) instanceof CheckBoxTreeItem && ((TreeItem)parentNode.getChildren().get(0)).isLeaf()) {
            CheckBoxTreeItem firstChild;
            firstChild.setSelected(!(firstChild = (CheckBoxTreeItem)parentNode.getChildren().get(0)).isSelected());
            firstChild.setSelected(!firstChild.isSelected());
        }
    }

    private void expand(TreeItem<TreeItemValue> item, boolean expand) {
        try {
            this.ignoreExpanding = true;
            if (item != null) {
                if (!item.isExpanded()) {
                    item.setExpanded(expand);
                }
                this.expand((TreeItem<TreeItemValue>)item.getParent(), expand);
            }
        }
        finally {
            this.ignoreExpanding = false;
        }
    }

    public void handleTreeSelections() {
        this.handleTreeSelections(this.lastValidSelectedTreeItem);
    }

    private void handleTreeSelections(final TreeItem<TreeItemValue> currentTreeItem) {
        this.lastValidSelectedTreeItem = currentTreeItem;
        if (currentTreeItem == null) {
            return;
        }
        final MultipleSelectionModel selectionModel = this.treeView.getSelectionModel();
        try {
            this.ignoreTreeSelection = true;
            TreeItemType currentItemType = ((TreeItemValue)currentTreeItem.getValue()).getItemType();
            boolean isValidSelection = true;
            ObservableList treeItems = selectionModel.getSelectedItems();
            for (TreeItem item : treeItems) {
                if (item != null && item.getValue() != null && ((TreeItemValue)item.getValue()).getItemType() == currentItemType) continue;
                isValidSelection = false;
                break;
            }
            if (!isValidSelection) {
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        selectionModel.clearSelection();
                        selectionModel.select((Object)currentTreeItem);
                    }
                });
            } else if (currentTreeItem != null && currentTreeItem.getValue() != null) {
                TreeItemValue itemValue = (TreeItemValue)currentTreeItem.getValue();
                if (!currentTreeItem.isLeaf()) {
                    switch (itemValue.getItemType()) {
                        case ROOT: {
                            this.load(itemValue, (ObservableList<TreeItem<TreeItemValue>>)treeItems);
                            break;
                        }
                        case REFERENCE_POINT_1D_DIRECTORY: 
                        case STOCHASTIC_POINT_1D_DIRECTORY: 
                        case DATUM_POINT_1D_DIRECTORY: 
                        case NEW_POINT_1D_DIRECTORY: 
                        case REFERENCE_POINT_2D_DIRECTORY: 
                        case STOCHASTIC_POINT_2D_DIRECTORY: 
                        case DATUM_POINT_2D_DIRECTORY: 
                        case NEW_POINT_2D_DIRECTORY: 
                        case REFERENCE_POINT_3D_DIRECTORY: 
                        case STOCHASTIC_POINT_3D_DIRECTORY: 
                        case DATUM_POINT_3D_DIRECTORY: 
                        case NEW_POINT_3D_DIRECTORY: 
                        case LEVELING_DIRECTORY: 
                        case DIRECTION_DIRECTORY: 
                        case HORIZONTAL_DISTANCE_DIRECTORY: 
                        case SLOPE_DISTANCE_DIRECTORY: 
                        case ZENITH_ANGLE_DIRECTORY: 
                        case GNSS_1D_DIRECTORY: 
                        case GNSS_2D_DIRECTORY: 
                        case GNSS_3D_DIRECTORY: 
                        case CONGRUENCE_ANALYSIS_1D_DIRECTORY: 
                        case CONGRUENCE_ANALYSIS_2D_DIRECTORY: 
                        case CONGRUENCE_ANALYSIS_3D_DIRECTORY: 
                        case REFERENCE_VERTICAL_DEFLECTION_DIRECTORY: 
                        case STOCHASTIC_VERTICAL_DEFLECTION_DIRECTORY: 
                        case UNKNOWN_VERTICAL_DEFLECTION_DIRECTORY: {
                            this.selectChildren(currentTreeItem);
                            break;
                        }
                        default: {
                            this.tabPaneBuilder.setTreeItemValue(itemValue);
                            break;
                        }
                    }
                } else if (currentTreeItem.isLeaf()) {
                    this.load(itemValue, (ObservableList<TreeItem<TreeItemValue>>)treeItems);
                }
            }
        }
        finally {
            this.ignoreTreeSelection = false;
        }
    }

    private boolean save(TreeItemValue treeItemValue) {
        block6: {
            try {
                TreeItemType type = treeItemValue.getItemType();
                if (TreeItemType.isPointTypeLeaf(type) && treeItemValue instanceof PointTreeItemValue) {
                    SQLManager.getInstance().saveGroup((PointTreeItemValue)treeItemValue);
                    break block6;
                }
                if ((TreeItemType.isGNSSObservationTypeLeaf(type) || TreeItemType.isObservationTypeLeaf(type)) && treeItemValue instanceof ObservationTreeItemValue) {
                    SQLManager.getInstance().saveGroup((ObservationTreeItemValue)treeItemValue);
                    break block6;
                }
                if (TreeItemType.isCongruenceAnalysisTypeLeaf(type) && treeItemValue instanceof CongruenceAnalysisTreeItemValue) {
                    SQLManager.getInstance().saveGroup((CongruenceAnalysisTreeItemValue)treeItemValue);
                    break block6;
                }
                if (TreeItemType.isVerticalDeflectionTypeLeaf(type) && treeItemValue instanceof VerticalDeflectionTreeItemValue) {
                    SQLManager.getInstance().saveGroup((VerticalDeflectionTreeItemValue)treeItemValue);
                    break block6;
                }
                System.err.println(this.getClass().getSimpleName() + " : Error, item has no saveable properties " + String.valueOf(treeItemValue));
                return false;
            }
            catch (Exception e) {
                e.printStackTrace();
                OptionDialog.showThrowableDialog(this.i18n.getString("UITreeBuiler.message.error.save.exception.title", "Unexpected SQL-Error"), this.i18n.getString("UITreeBuiler.message.error.save.exception.header", "Error, could save group properties to database."), this.i18n.getString("UITreeBuiler.message.error.save.exception.message", "An exception has occurred during database transaction."), e);
                return false;
            }
        }
        return true;
    }

    private boolean remove(TreeItemValue treeItemValue) {
        block3: {
            TreeItemType type = treeItemValue.getItemType();
            if (!TreeItemType.isPointTypeLeaf(type) && !TreeItemType.isGNSSObservationTypeLeaf(type) && !TreeItemType.isObservationTypeLeaf(type) && !TreeItemType.isVerticalDeflectionTypeLeaf(type) && !TreeItemType.isCongruenceAnalysisTypeLeaf(type)) break block3;
            SQLManager.getInstance().removeGroup(treeItemValue);
            return true;
        }
        try {
            System.err.println(this.getClass().getSimpleName() + " : Error, item has no removeable properties " + String.valueOf(treeItemValue));
        }
        catch (Exception e) {
            e.printStackTrace();
            OptionDialog.showThrowableDialog(this.i18n.getString("UITreeBuiler.message.error.remove.exception.title", "Unexpected SQL-Error"), this.i18n.getString("UITreeBuiler.message.error.remove.exception.header", "Error, could remove group from database."), this.i18n.getString("UITreeBuiler.message.error.remove.exception.message", "An exception has occurred during database transaction."), e);
        }
        return false;
    }

    private void load(TreeItemValue itemValue, ObservableList<TreeItem<TreeItemValue>> treeItems) {
        try {
            TreeItemValue[] itemValues = new TreeItemValue[treeItems == null ? 0 : treeItems.size()];
            if (treeItems != null) {
                int i = 0;
                while (i < treeItems.size()) {
                    itemValues[i] = (TreeItemValue)((TreeItem)treeItems.get(i)).getValue();
                    ++i;
                }
            }
            SQLManager.getInstance().loadData(itemValue, itemValues);
            this.tabPaneBuilder.setTreeItemValue(itemValue);
        }
        catch (Exception e) {
            e.printStackTrace();
            OptionDialog.showThrowableDialog(this.i18n.getString("UITreeBuiler.message.error.load.exception.title", "Unexpected SQL-Error"), this.i18n.getString("UITreeBuiler.message.error.load.exception.header", "Error, could load group properties from database."), this.i18n.getString("UITreeBuiler.message.error.load.exception.message", "An exception has occurred during database transaction."), e);
        }
    }

    private void selectChildren(TreeItem<TreeItemValue> parent) {
        try {
            this.ignoreTreeSelection = true;
            if (!parent.isLeaf() && parent.isExpanded()) {
                this.treeView.getSelectionModel().clearSelection();
                ObservableList children = parent.getChildren();
                TreeItem lastSelectedChild = null;
                for (TreeItem child : children) {
                    this.treeView.getSelectionModel().select((Object)child);
                    lastSelectedChild = child;
                }
                if (lastSelectedChild != null) {
                    this.load((TreeItemValue)lastSelectedChild.getValue(), (ObservableList<TreeItem<TreeItemValue>>)parent.getChildren());
                }
            } else if (!parent.isLeaf() && !parent.isExpanded()) {
                this.load((TreeItemValue)parent.getValue(), null);
            }
        }
        finally {
            this.ignoreTreeSelection = false;
        }
    }

    final BooleanProperty ignoreEventProperty() {
        return this.ignoreEvent;
    }

    final boolean isIgnoreEvent() {
        return this.ignoreEventProperty().get();
    }

    final void setIgnoreEvent(boolean ignoreEvent) {
        this.ignoreEventProperty().set(ignoreEvent);
    }

    public TreeItem<TreeItemValue> getDirectoryItemByType(TreeItemType itemType) {
        return (TreeItem)this.directoryItemMap.get((Object)itemType);
    }

    void removeSelectedGroups() {
        boolean isDeleteConfirmed;
        ObservableList selectedItems = this.treeView.getSelectionModel().getSelectedItems();
        if (selectedItems == null || selectedItems.isEmpty()) {
            return;
        }
        boolean bl = isDeleteConfirmed = !DefaultApplicationProperty.showConfirmDialogOnDelete();
        if (!isDeleteConfirmed) {
            Optional<ButtonType> result = OptionDialog.showConfirmationDialog(this.i18n.getString("UITreeBuiler.message.confirmation.delete.title", "Delete groups"), this.i18n.getString("UITreeBuiler.message.confirmation.delete.header", "Delete groups permanently?"), this.i18n.getString("UITreeBuiler.message.confirmation.delete.message", "Are you sure you want to remove the selected groups?"));
            boolean bl2 = isDeleteConfirmed = result.isPresent() && result.get() == ButtonType.OK;
        }
        if (isDeleteConfirmed) {
            this.removeItems(new ArrayList<TreeItem<TreeItemValue>>((Collection<TreeItem<TreeItemValue>>)selectedItems));
        }
    }

    private void addTreeKeyEvents() {
        this.treeView.addEventFilter(KeyEvent.KEY_PRESSED, (EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent keyEvent) {
                if (keyEvent.getSource() == UITreeBuilder.this.treeView && keyEvent.getTarget() == UITreeBuilder.this.treeView && keyEvent.getCode() == KeyCode.DELETE) {
                    UITreeBuilder.this.removeSelectedGroups();
                    keyEvent.consume();
                }
            }
        });
    }

    private class TreeCheckBoxChangeListener
    implements ChangeListener<Boolean> {
        private final CheckBoxTreeItem<TreeItemValue> item;

        private TreeCheckBoxChangeListener(CheckBoxTreeItem<TreeItemValue> item) {
            this.item = item;
        }

        public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
            block7: {
                if (UITreeBuilder.this.isIgnoreEvent()) break block7;
                TreeItemValue treeItemValue = (TreeItemValue)this.item.getValue();
                TreeItemType itemType = treeItemValue.getItemType();
                MultipleSelectionModel selectionModel = UITreeBuilder.this.treeView.getSelectionModel();
                ObservableList treeItems = selectionModel.getSelectedItems();
                if (!this.item.isLeaf() || TreeItemType.isPointTypeDirectory(itemType) || TreeItemType.isObservationTypeDirectory(itemType) || TreeItemType.isGNSSObservationTypeDirectory(itemType) || TreeItemType.isVerticalDeflectionTypeDirectory(itemType) || TreeItemType.isCongruenceAnalysisTypeDirectory(itemType)) {
                    if (!this.item.isExpanded()) {
                        this.item.setExpanded(true);
                    }
                    UITreeBuilder.this.selectChildren((TreeItem<TreeItemValue>)this.item);
                    for (TreeItem treeItem : treeItems) {
                        ((TreeItemValue)treeItem.getValue()).setEnable(newValue);
                        UITreeBuilder.this.save((TreeItemValue)treeItem.getValue());
                    }
                } else if (this.item.isLeaf() && !treeItems.contains(this.item)) {
                    selectionModel.clearSelection();
                    UITreeBuilder.this.save((TreeItemValue)this.item.getValue());
                    selectionModel.select(this.item);
                } else {
                    for (TreeItem treeItem : treeItems) {
                        if (!treeItem.isLeaf() || ((TreeItemValue)treeItem.getValue()).getItemType() != treeItemValue.getItemType()) continue;
                        ((TreeItemValue)treeItem.getValue()).setEnable(newValue);
                        UITreeBuilder.this.save((TreeItemValue)treeItem.getValue());
                    }
                }
            }
        }
    }

    private class TreeItemExpandingChangeListener
    implements ChangeListener<Boolean> {
        private final TreeItem<TreeItemValue> treeItem;

        private TreeItemExpandingChangeListener(TreeItem<TreeItemValue> treeItem) {
            this.treeItem = treeItem;
        }

        public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
            if (newValue.booleanValue() && !UITreeBuilder.this.ignoreExpanding) {
                UITreeBuilder.this.selectChildren(this.treeItem);
            }
        }
    }

    private class TreeItemNameChangeListener
    implements ChangeListener<String> {
        private final TreeItemValue treeItemValue;

        private TreeItemNameChangeListener(TreeItemValue treeItemValue) {
            this.treeItemValue = treeItemValue;
        }

        public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
            if (UITreeBuilder.this.isIgnoreEvent() || newValue == null || newValue.trim().isEmpty()) {
                this.treeItemValue.setName(oldValue);
            } else if (!UITreeBuilder.this.isIgnoreEvent()) {
                UITreeBuilder.this.save(this.treeItemValue);
            }
        }
    }

    private class TreeListSelectionChangeListener
    implements ListChangeListener<TreeItem<TreeItemValue>> {
        private TreeListSelectionChangeListener() {
        }

        public void onChanged(ListChangeListener.Change<? extends TreeItem<TreeItemValue>> change) {
            if (!UITreeBuilder.this.ignoreTreeSelection && change != null && change.next() && UITreeBuilder.this.treeView != null && UITreeBuilder.this.treeView.getSelectionModel() != null && UITreeBuilder.this.treeView.getSelectionModel().getSelectedItems().size() > 0) {
                TreeItem treeItem = null;
                boolean hasValidTreeItem = false;
                try {
                    if ((change.wasAdded() || change.wasReplaced()) && change.getAddedSubList() != null && !change.getAddedSubList().isEmpty()) {
                        treeItem = (TreeItem)change.getAddedSubList().get(0);
                        hasValidTreeItem = true;
                    }
                }
                catch (Exception e) {
                    hasValidTreeItem = false;
                    e.printStackTrace();
                }
                if (!hasValidTreeItem) {
                    treeItem = (TreeItem)UITreeBuilder.this.treeView.getSelectionModel().getSelectedItem();
                    int treeItemIndex = UITreeBuilder.this.treeView.getSelectionModel().getSelectedIndex();
                    if (treeItemIndex < 0 || treeItem == null || !UITreeBuilder.this.treeView.getSelectionModel().isSelected(treeItemIndex)) {
                        treeItem = (TreeItem)UITreeBuilder.this.treeView.getSelectionModel().getSelectedItems().get(0);
                    }
                }
                UITreeBuilder.this.handleTreeSelections(treeItem);
            }
        }
    }
}

