/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.jag3d.ui.tree;

import org.applied_geodesy.adjustment.network.ObservationType;
import org.applied_geodesy.adjustment.network.PointType;
import org.applied_geodesy.adjustment.network.VerticalDeflectionType;

public enum TreeItemType {
    ROOT,
    UNSPECIFIC,
    REFERENCE_POINT_1D_DIRECTORY,
    STOCHASTIC_POINT_1D_DIRECTORY,
    DATUM_POINT_1D_DIRECTORY,
    NEW_POINT_1D_DIRECTORY,
    REFERENCE_POINT_2D_DIRECTORY,
    STOCHASTIC_POINT_2D_DIRECTORY,
    DATUM_POINT_2D_DIRECTORY,
    NEW_POINT_2D_DIRECTORY,
    REFERENCE_POINT_3D_DIRECTORY,
    STOCHASTIC_POINT_3D_DIRECTORY,
    DATUM_POINT_3D_DIRECTORY,
    NEW_POINT_3D_DIRECTORY,
    REFERENCE_POINT_1D_LEAF,
    STOCHASTIC_POINT_1D_LEAF,
    DATUM_POINT_1D_LEAF,
    NEW_POINT_1D_LEAF,
    REFERENCE_POINT_2D_LEAF,
    STOCHASTIC_POINT_2D_LEAF,
    DATUM_POINT_2D_LEAF,
    NEW_POINT_2D_LEAF,
    REFERENCE_POINT_3D_LEAF,
    STOCHASTIC_POINT_3D_LEAF,
    DATUM_POINT_3D_LEAF,
    NEW_POINT_3D_LEAF,
    LEVELING_DIRECTORY,
    DIRECTION_DIRECTORY,
    HORIZONTAL_DISTANCE_DIRECTORY,
    SLOPE_DISTANCE_DIRECTORY,
    ZENITH_ANGLE_DIRECTORY,
    LEVELING_LEAF,
    DIRECTION_LEAF,
    HORIZONTAL_DISTANCE_LEAF,
    SLOPE_DISTANCE_LEAF,
    ZENITH_ANGLE_LEAF,
    GNSS_1D_DIRECTORY,
    GNSS_2D_DIRECTORY,
    GNSS_3D_DIRECTORY,
    GNSS_1D_LEAF,
    GNSS_2D_LEAF,
    GNSS_3D_LEAF,
    CONGRUENCE_ANALYSIS_1D_DIRECTORY,
    CONGRUENCE_ANALYSIS_2D_DIRECTORY,
    CONGRUENCE_ANALYSIS_3D_DIRECTORY,
    CONGRUENCE_ANALYSIS_1D_LEAF,
    CONGRUENCE_ANALYSIS_2D_LEAF,
    CONGRUENCE_ANALYSIS_3D_LEAF,
    REFERENCE_VERTICAL_DEFLECTION_DIRECTORY,
    STOCHASTIC_VERTICAL_DEFLECTION_DIRECTORY,
    UNKNOWN_VERTICAL_DEFLECTION_DIRECTORY,
    REFERENCE_VERTICAL_DEFLECTION_LEAF,
    STOCHASTIC_VERTICAL_DEFLECTION_LEAF,
    UNKNOWN_VERTICAL_DEFLECTION_LEAF;


    public static TreeItemType getLeafByDirectoryType(TreeItemType type) {
        switch (type) {
            case REFERENCE_POINT_1D_DIRECTORY: {
                return REFERENCE_POINT_1D_LEAF;
            }
            case REFERENCE_POINT_2D_DIRECTORY: {
                return REFERENCE_POINT_2D_LEAF;
            }
            case REFERENCE_POINT_3D_DIRECTORY: {
                return REFERENCE_POINT_3D_LEAF;
            }
            case STOCHASTIC_POINT_1D_DIRECTORY: {
                return STOCHASTIC_POINT_1D_LEAF;
            }
            case STOCHASTIC_POINT_2D_DIRECTORY: {
                return STOCHASTIC_POINT_2D_LEAF;
            }
            case STOCHASTIC_POINT_3D_DIRECTORY: {
                return STOCHASTIC_POINT_3D_LEAF;
            }
            case DATUM_POINT_1D_DIRECTORY: {
                return DATUM_POINT_1D_LEAF;
            }
            case DATUM_POINT_2D_DIRECTORY: {
                return DATUM_POINT_2D_LEAF;
            }
            case DATUM_POINT_3D_DIRECTORY: {
                return DATUM_POINT_3D_LEAF;
            }
            case NEW_POINT_1D_DIRECTORY: {
                return NEW_POINT_1D_LEAF;
            }
            case NEW_POINT_2D_DIRECTORY: {
                return NEW_POINT_2D_LEAF;
            }
            case NEW_POINT_3D_DIRECTORY: {
                return NEW_POINT_3D_LEAF;
            }
            case LEVELING_DIRECTORY: {
                return LEVELING_LEAF;
            }
            case DIRECTION_DIRECTORY: {
                return DIRECTION_LEAF;
            }
            case HORIZONTAL_DISTANCE_DIRECTORY: {
                return HORIZONTAL_DISTANCE_LEAF;
            }
            case SLOPE_DISTANCE_DIRECTORY: {
                return SLOPE_DISTANCE_LEAF;
            }
            case ZENITH_ANGLE_DIRECTORY: {
                return ZENITH_ANGLE_LEAF;
            }
            case GNSS_1D_DIRECTORY: {
                return GNSS_1D_LEAF;
            }
            case GNSS_2D_DIRECTORY: {
                return GNSS_2D_LEAF;
            }
            case GNSS_3D_DIRECTORY: {
                return GNSS_3D_LEAF;
            }
            case CONGRUENCE_ANALYSIS_1D_DIRECTORY: {
                return CONGRUENCE_ANALYSIS_1D_LEAF;
            }
            case CONGRUENCE_ANALYSIS_2D_DIRECTORY: {
                return CONGRUENCE_ANALYSIS_2D_LEAF;
            }
            case CONGRUENCE_ANALYSIS_3D_DIRECTORY: {
                return CONGRUENCE_ANALYSIS_3D_LEAF;
            }
            case REFERENCE_VERTICAL_DEFLECTION_DIRECTORY: {
                return REFERENCE_VERTICAL_DEFLECTION_LEAF;
            }
            case STOCHASTIC_VERTICAL_DEFLECTION_DIRECTORY: {
                return STOCHASTIC_VERTICAL_DEFLECTION_LEAF;
            }
            case UNKNOWN_VERTICAL_DEFLECTION_DIRECTORY: {
                return UNKNOWN_VERTICAL_DEFLECTION_LEAF;
            }
        }
        return null;
    }

    public static TreeItemType getDirectoryByLeafType(TreeItemType type) {
        switch (type) {
            case REFERENCE_POINT_1D_LEAF: {
                return REFERENCE_POINT_1D_DIRECTORY;
            }
            case REFERENCE_POINT_2D_LEAF: {
                return REFERENCE_POINT_2D_DIRECTORY;
            }
            case REFERENCE_POINT_3D_LEAF: {
                return REFERENCE_POINT_3D_DIRECTORY;
            }
            case STOCHASTIC_POINT_1D_LEAF: {
                return STOCHASTIC_POINT_1D_DIRECTORY;
            }
            case STOCHASTIC_POINT_2D_LEAF: {
                return STOCHASTIC_POINT_2D_DIRECTORY;
            }
            case STOCHASTIC_POINT_3D_LEAF: {
                return STOCHASTIC_POINT_3D_DIRECTORY;
            }
            case DATUM_POINT_1D_LEAF: {
                return DATUM_POINT_1D_DIRECTORY;
            }
            case DATUM_POINT_2D_LEAF: {
                return DATUM_POINT_2D_DIRECTORY;
            }
            case DATUM_POINT_3D_LEAF: {
                return DATUM_POINT_3D_DIRECTORY;
            }
            case NEW_POINT_1D_LEAF: {
                return NEW_POINT_1D_DIRECTORY;
            }
            case NEW_POINT_2D_LEAF: {
                return NEW_POINT_2D_DIRECTORY;
            }
            case NEW_POINT_3D_LEAF: {
                return NEW_POINT_3D_DIRECTORY;
            }
            case LEVELING_LEAF: {
                return LEVELING_DIRECTORY;
            }
            case DIRECTION_LEAF: {
                return DIRECTION_DIRECTORY;
            }
            case HORIZONTAL_DISTANCE_LEAF: {
                return HORIZONTAL_DISTANCE_DIRECTORY;
            }
            case SLOPE_DISTANCE_LEAF: {
                return SLOPE_DISTANCE_DIRECTORY;
            }
            case ZENITH_ANGLE_LEAF: {
                return ZENITH_ANGLE_DIRECTORY;
            }
            case GNSS_1D_LEAF: {
                return GNSS_1D_DIRECTORY;
            }
            case GNSS_2D_LEAF: {
                return GNSS_2D_DIRECTORY;
            }
            case GNSS_3D_LEAF: {
                return GNSS_3D_DIRECTORY;
            }
            case CONGRUENCE_ANALYSIS_1D_LEAF: {
                return CONGRUENCE_ANALYSIS_1D_DIRECTORY;
            }
            case CONGRUENCE_ANALYSIS_2D_LEAF: {
                return CONGRUENCE_ANALYSIS_2D_DIRECTORY;
            }
            case CONGRUENCE_ANALYSIS_3D_LEAF: {
                return CONGRUENCE_ANALYSIS_3D_DIRECTORY;
            }
            case REFERENCE_VERTICAL_DEFLECTION_LEAF: {
                return REFERENCE_VERTICAL_DEFLECTION_DIRECTORY;
            }
            case STOCHASTIC_VERTICAL_DEFLECTION_LEAF: {
                return STOCHASTIC_VERTICAL_DEFLECTION_DIRECTORY;
            }
            case UNKNOWN_VERTICAL_DEFLECTION_LEAF: {
                return UNKNOWN_VERTICAL_DEFLECTION_DIRECTORY;
            }
        }
        return null;
    }

    public static PointType getPointTypeByTreeItemType(TreeItemType type) {
        switch (type) {
            case DATUM_POINT_1D_DIRECTORY: 
            case DATUM_POINT_2D_DIRECTORY: 
            case DATUM_POINT_3D_DIRECTORY: 
            case DATUM_POINT_1D_LEAF: 
            case DATUM_POINT_2D_LEAF: 
            case DATUM_POINT_3D_LEAF: {
                return PointType.DATUM_POINT;
            }
            case NEW_POINT_1D_DIRECTORY: 
            case NEW_POINT_2D_DIRECTORY: 
            case NEW_POINT_3D_DIRECTORY: 
            case NEW_POINT_1D_LEAF: 
            case NEW_POINT_2D_LEAF: 
            case NEW_POINT_3D_LEAF: {
                return PointType.NEW_POINT;
            }
            case REFERENCE_POINT_1D_DIRECTORY: 
            case REFERENCE_POINT_2D_DIRECTORY: 
            case REFERENCE_POINT_3D_DIRECTORY: 
            case REFERENCE_POINT_1D_LEAF: 
            case REFERENCE_POINT_2D_LEAF: 
            case REFERENCE_POINT_3D_LEAF: {
                return PointType.REFERENCE_POINT;
            }
            case STOCHASTIC_POINT_1D_DIRECTORY: 
            case STOCHASTIC_POINT_2D_DIRECTORY: 
            case STOCHASTIC_POINT_3D_DIRECTORY: 
            case STOCHASTIC_POINT_1D_LEAF: 
            case STOCHASTIC_POINT_2D_LEAF: 
            case STOCHASTIC_POINT_3D_LEAF: {
                return PointType.STOCHASTIC_POINT;
            }
        }
        return null;
    }

    public static VerticalDeflectionType getVerticalDeflectionTypeByTreeItemType(TreeItemType type) {
        switch (type) {
            case REFERENCE_VERTICAL_DEFLECTION_DIRECTORY: 
            case REFERENCE_VERTICAL_DEFLECTION_LEAF: {
                return VerticalDeflectionType.REFERENCE_VERTICAL_DEFLECTION;
            }
            case STOCHASTIC_VERTICAL_DEFLECTION_DIRECTORY: 
            case STOCHASTIC_VERTICAL_DEFLECTION_LEAF: {
                return VerticalDeflectionType.STOCHASTIC_VERTICAL_DEFLECTION;
            }
            case UNKNOWN_VERTICAL_DEFLECTION_DIRECTORY: 
            case UNKNOWN_VERTICAL_DEFLECTION_LEAF: {
                return VerticalDeflectionType.UNKNOWN_VERTICAL_DEFLECTION;
            }
        }
        return null;
    }

    public static ObservationType getObservationTypeByTreeItemType(TreeItemType type) {
        switch (type) {
            case LEVELING_DIRECTORY: 
            case LEVELING_LEAF: {
                return ObservationType.LEVELING;
            }
            case DIRECTION_DIRECTORY: 
            case DIRECTION_LEAF: {
                return ObservationType.DIRECTION;
            }
            case HORIZONTAL_DISTANCE_DIRECTORY: 
            case HORIZONTAL_DISTANCE_LEAF: {
                return ObservationType.HORIZONTAL_DISTANCE;
            }
            case SLOPE_DISTANCE_DIRECTORY: 
            case SLOPE_DISTANCE_LEAF: {
                return ObservationType.SLOPE_DISTANCE;
            }
            case ZENITH_ANGLE_DIRECTORY: 
            case ZENITH_ANGLE_LEAF: {
                return ObservationType.ZENITH_ANGLE;
            }
            case GNSS_1D_DIRECTORY: 
            case GNSS_1D_LEAF: {
                return ObservationType.GNSS1D;
            }
            case GNSS_2D_DIRECTORY: 
            case GNSS_2D_LEAF: {
                return ObservationType.GNSS2D;
            }
            case GNSS_3D_DIRECTORY: 
            case GNSS_3D_LEAF: {
                return ObservationType.GNSS3D;
            }
        }
        return null;
    }

    public static TreeItemType getTreeItemTypeByObservationType(ObservationType type) {
        switch (type) {
            case LEVELING: {
                return LEVELING_LEAF;
            }
            case DIRECTION: {
                return DIRECTION_LEAF;
            }
            case HORIZONTAL_DISTANCE: {
                return HORIZONTAL_DISTANCE_LEAF;
            }
            case SLOPE_DISTANCE: {
                return SLOPE_DISTANCE_LEAF;
            }
            case ZENITH_ANGLE: {
                return ZENITH_ANGLE_LEAF;
            }
            case GNSS1D: {
                return GNSS_1D_LEAF;
            }
            case GNSS2D: {
                return GNSS_2D_LEAF;
            }
            case GNSS3D: {
                return GNSS_3D_LEAF;
            }
        }
        return null;
    }

    public static TreeItemType getTreeItemTypeByVerticalDeflectionType(VerticalDeflectionType type) {
        switch (type) {
            case REFERENCE_VERTICAL_DEFLECTION: {
                return REFERENCE_VERTICAL_DEFLECTION_LEAF;
            }
            case STOCHASTIC_VERTICAL_DEFLECTION: {
                return STOCHASTIC_VERTICAL_DEFLECTION_LEAF;
            }
            case UNKNOWN_VERTICAL_DEFLECTION: {
                return UNKNOWN_VERTICAL_DEFLECTION_LEAF;
            }
        }
        return null;
    }

    public static TreeItemType getTreeItemTypeByPointType(PointType type, int dimension) {
        switch (type) {
            case REFERENCE_POINT: {
                if (dimension == 1) {
                    return REFERENCE_POINT_1D_LEAF;
                }
                if (dimension == 2) {
                    return REFERENCE_POINT_2D_LEAF;
                }
                if (dimension == 3) {
                    return REFERENCE_POINT_3D_LEAF;
                }
            }
            case STOCHASTIC_POINT: {
                if (dimension == 1) {
                    return STOCHASTIC_POINT_1D_LEAF;
                }
                if (dimension == 2) {
                    return STOCHASTIC_POINT_2D_LEAF;
                }
                if (dimension == 3) {
                    return STOCHASTIC_POINT_3D_LEAF;
                }
            }
            case DATUM_POINT: {
                if (dimension == 1) {
                    return DATUM_POINT_1D_LEAF;
                }
                if (dimension == 2) {
                    return DATUM_POINT_2D_LEAF;
                }
                if (dimension == 3) {
                    return DATUM_POINT_3D_LEAF;
                }
            }
            case NEW_POINT: {
                if (dimension == 1) {
                    return NEW_POINT_1D_LEAF;
                }
                if (dimension == 2) {
                    return NEW_POINT_2D_LEAF;
                }
                if (dimension != 3) break;
                return NEW_POINT_3D_LEAF;
            }
        }
        return null;
    }

    public static TreeItemType getTreeItemTypeByCongruenceAnalysisDimension(int dimension) {
        switch (dimension) {
            case 1: {
                return CONGRUENCE_ANALYSIS_1D_LEAF;
            }
            case 2: {
                return CONGRUENCE_ANALYSIS_2D_LEAF;
            }
            case 3: {
                return CONGRUENCE_ANALYSIS_3D_LEAF;
            }
        }
        return null;
    }

    public static boolean isPointTypeLeaf(TreeItemType type) {
        switch (type) {
            case REFERENCE_POINT_1D_LEAF: 
            case STOCHASTIC_POINT_1D_LEAF: 
            case DATUM_POINT_1D_LEAF: 
            case NEW_POINT_1D_LEAF: 
            case REFERENCE_POINT_2D_LEAF: 
            case STOCHASTIC_POINT_2D_LEAF: 
            case DATUM_POINT_2D_LEAF: 
            case NEW_POINT_2D_LEAF: 
            case REFERENCE_POINT_3D_LEAF: 
            case STOCHASTIC_POINT_3D_LEAF: 
            case DATUM_POINT_3D_LEAF: 
            case NEW_POINT_3D_LEAF: {
                return true;
            }
        }
        return false;
    }

    public static boolean isPointTypeDirectory(TreeItemType type) {
        TreeItemType child = TreeItemType.getLeafByDirectoryType(type);
        return child != null && TreeItemType.isPointTypeLeaf(child);
    }

    public static boolean isObservationTypeLeaf(TreeItemType type) {
        switch (type) {
            case LEVELING_LEAF: 
            case DIRECTION_LEAF: 
            case HORIZONTAL_DISTANCE_LEAF: 
            case SLOPE_DISTANCE_LEAF: 
            case ZENITH_ANGLE_LEAF: {
                return true;
            }
        }
        return false;
    }

    public static boolean isObservationTypeDirectory(TreeItemType type) {
        TreeItemType child = TreeItemType.getLeafByDirectoryType(type);
        return child != null && TreeItemType.isObservationTypeLeaf(child);
    }

    public static boolean isGNSSObservationTypeLeaf(TreeItemType type) {
        switch (type) {
            case GNSS_1D_LEAF: 
            case GNSS_2D_LEAF: 
            case GNSS_3D_LEAF: {
                return true;
            }
        }
        return false;
    }

    public static boolean isGNSSObservationTypeDirectory(TreeItemType type) {
        TreeItemType child = TreeItemType.getLeafByDirectoryType(type);
        return child != null && TreeItemType.isGNSSObservationTypeLeaf(child);
    }

    public static boolean isCongruenceAnalysisTypeLeaf(TreeItemType type) {
        switch (type) {
            case CONGRUENCE_ANALYSIS_1D_LEAF: 
            case CONGRUENCE_ANALYSIS_2D_LEAF: 
            case CONGRUENCE_ANALYSIS_3D_LEAF: {
                return true;
            }
        }
        return false;
    }

    public static boolean isCongruenceAnalysisTypeDirectory(TreeItemType type) {
        TreeItemType child = TreeItemType.getLeafByDirectoryType(type);
        return child != null && TreeItemType.isCongruenceAnalysisTypeLeaf(child);
    }

    public static boolean isVerticalDeflectionTypeLeaf(TreeItemType type) {
        switch (type) {
            case REFERENCE_VERTICAL_DEFLECTION_LEAF: 
            case STOCHASTIC_VERTICAL_DEFLECTION_LEAF: 
            case UNKNOWN_VERTICAL_DEFLECTION_LEAF: {
                return true;
            }
        }
        return false;
    }

    public static boolean isVerticalDeflectionTypeDirectory(TreeItemType type) {
        TreeItemType child = TreeItemType.getLeafByDirectoryType(type);
        return child != null && TreeItemType.isVerticalDeflectionTypeLeaf(child);
    }
}

