/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.jag3d.ui.tree;

import java.util.ArrayList;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleIntegerProperty;
import org.applied_geodesy.adjustment.network.DefaultUncertainty;
import org.applied_geodesy.adjustment.network.PointGroupUncertaintyType;
import org.applied_geodesy.jag3d.ui.tabpane.TabType;
import org.applied_geodesy.jag3d.ui.tree.Groupable;
import org.applied_geodesy.jag3d.ui.tree.Sortable;
import org.applied_geodesy.jag3d.ui.tree.TreeItemType;
import org.applied_geodesy.jag3d.ui.tree.TreeItemValue;

public class PointTreeItemValue
extends TreeItemValue
implements Sortable,
Groupable {
    private IntegerProperty groupId = new SimpleIntegerProperty(-1);
    private int orderId;

    PointTreeItemValue(int groupId, TreeItemType type, String name, int orderId) throws IllegalArgumentException {
        this(groupId, type, name, Boolean.TRUE, orderId);
    }

    PointTreeItemValue(int groupId, TreeItemType type, String name, boolean enable, int orderId) throws IllegalArgumentException {
        super(type, name);
        this.setGroupId(groupId);
        this.setEnable(enable);
        this.setOrderId(orderId);
    }

    public IntegerProperty groupIdProperty() {
        return this.groupId;
    }

    @Override
    public int getGroupId() {
        return this.groupIdProperty().get();
    }

    @Override
    public void setGroupId(int groupId) {
        this.groupIdProperty().set(groupId);
    }

    @Override
    public final int getDimension() {
        switch (this.getItemType()) {
            case REFERENCE_POINT_1D_LEAF: 
            case STOCHASTIC_POINT_1D_LEAF: 
            case DATUM_POINT_1D_LEAF: 
            case NEW_POINT_1D_LEAF: {
                return 1;
            }
            case REFERENCE_POINT_2D_LEAF: 
            case STOCHASTIC_POINT_2D_LEAF: 
            case DATUM_POINT_2D_LEAF: 
            case NEW_POINT_2D_LEAF: {
                return 2;
            }
            case REFERENCE_POINT_3D_LEAF: 
            case STOCHASTIC_POINT_3D_LEAF: 
            case DATUM_POINT_3D_LEAF: 
            case NEW_POINT_3D_LEAF: {
                return 3;
            }
        }
        throw new IllegalArgumentException(this.getClass().getSimpleName() + " : Error, TreeItemType does not refer to a PointType " + String.valueOf((Object)this.getItemType()));
    }

    @Override
    public TabType[] getTabTypes() {
        TreeItemType type = this.getItemType();
        ArrayList<TabType> tabTyps = new ArrayList<TabType>(5);
        tabTyps.add(TabType.RAW_DATA);
        switch (type) {
            case STOCHASTIC_POINT_1D_LEAF: 
            case STOCHASTIC_POINT_2D_LEAF: 
            case STOCHASTIC_POINT_3D_LEAF: {
                tabTyps.add(TabType.PROPERTIES);
                break;
            }
        }
        tabTyps.add(TabType.RESULT_DATA);
        switch (type) {
            case DATUM_POINT_1D_LEAF: 
            case DATUM_POINT_2D_LEAF: 
            case DATUM_POINT_3D_LEAF: {
                tabTyps.add(TabType.RESULT_CONGRUENCE_ANALYSIS);
                break;
            }
        }
        switch (type) {
            case STOCHASTIC_POINT_1D_LEAF: 
            case STOCHASTIC_POINT_2D_LEAF: 
            case STOCHASTIC_POINT_3D_LEAF: {
                tabTyps.add(TabType.VARIANCE_COMPONENT);
                break;
            }
        }
        return tabTyps.toArray(new TabType[tabTyps.size()]);
    }

    public static double getDefaultUncertainty(PointGroupUncertaintyType uncertaintyType) {
        switch (uncertaintyType) {
            case COMPONENT_X: {
                return DefaultUncertainty.getUncertaintyX();
            }
            case COMPONENT_Y: {
                return DefaultUncertainty.getUncertaintyY();
            }
            case COMPONENT_Z: {
                return DefaultUncertainty.getUncertaintyZ();
            }
        }
        return 0.0;
    }

    @Override
    public int getOrderId() {
        return this.orderId;
    }

    @Override
    public void setOrderId(int orderId) {
        this.orderId = orderId;
    }
}

