/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.jag3d.ui.tree;

import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleIntegerProperty;
import org.applied_geodesy.adjustment.network.DefaultUncertainty;
import org.applied_geodesy.adjustment.network.ObservationGroupUncertaintyType;
import org.applied_geodesy.adjustment.network.ParameterType;
import org.applied_geodesy.jag3d.ui.tabpane.TabType;
import org.applied_geodesy.jag3d.ui.tree.Groupable;
import org.applied_geodesy.jag3d.ui.tree.Sortable;
import org.applied_geodesy.jag3d.ui.tree.TreeItemType;
import org.applied_geodesy.jag3d.ui.tree.TreeItemValue;

public class ObservationTreeItemValue
extends TreeItemValue
implements Sortable,
Groupable {
    private IntegerProperty groupId = new SimpleIntegerProperty(-1);
    private int orderId;

    ObservationTreeItemValue(int groupId, TreeItemType type, String name, int orderId) throws IllegalArgumentException {
        this(groupId, type, name, Boolean.TRUE, orderId);
    }

    ObservationTreeItemValue(int groupId, TreeItemType type, String name, boolean enable, int orderId) throws IllegalArgumentException {
        super(type, name);
        this.setGroupId(groupId);
        this.setEnable(enable);
        this.setOrderId(orderId);
    }

    public IntegerProperty groupIdProperty() {
        return this.groupId;
    }

    @Override
    public int getGroupId() {
        return this.groupIdProperty().get();
    }

    @Override
    public void setGroupId(int groupId) {
        this.groupIdProperty().set(groupId);
    }

    @Override
    public final int getDimension() {
        switch (this.getItemType()) {
            case GNSS_2D_LEAF: {
                return 2;
            }
            case GNSS_3D_LEAF: {
                return 3;
            }
        }
        return 1;
    }

    @Override
    public TabType[] getTabTypes() {
        return new TabType[]{TabType.RAW_DATA, TabType.PROPERTIES, TabType.RESULT_DATA, TabType.ADDITIONAL_PARAMETER, TabType.VARIANCE_COMPONENT};
    }

    public static ParameterType[] getParameterTypes(TreeItemType itemType) {
        switch (itemType) {
            case LEVELING_LEAF: {
                return new ParameterType[]{ParameterType.SCALE};
            }
            case HORIZONTAL_DISTANCE_LEAF: 
            case SLOPE_DISTANCE_LEAF: {
                return new ParameterType[]{ParameterType.ZERO_POINT_OFFSET, ParameterType.SCALE};
            }
            case DIRECTION_LEAF: {
                return new ParameterType[]{ParameterType.ORIENTATION};
            }
            case ZENITH_ANGLE_LEAF: {
                return new ParameterType[]{ParameterType.REFRACTION_INDEX};
            }
            case GNSS_1D_LEAF: {
                return new ParameterType[]{ParameterType.ROTATION_Y, ParameterType.ROTATION_X, ParameterType.SCALE};
            }
            case GNSS_2D_LEAF: {
                return new ParameterType[]{ParameterType.ROTATION_Z, ParameterType.SCALE};
            }
            case GNSS_3D_LEAF: {
                return new ParameterType[]{ParameterType.ROTATION_Y, ParameterType.ROTATION_X, ParameterType.ROTATION_Z, ParameterType.SCALE};
            }
        }
        return new ParameterType[0];
    }

    public static double getDefaultUncertainty(TreeItemType itemType, ObservationGroupUncertaintyType uncertaintyType) {
        switch (itemType) {
            case LEVELING_LEAF: {
                switch (uncertaintyType) {
                    case ZERO_POINT_OFFSET: {
                        return DefaultUncertainty.getUncertaintyLevelingZeroPointOffset();
                    }
                    case SQUARE_ROOT_DISTANCE_DEPENDENT: {
                        return DefaultUncertainty.getUncertaintyLevelingSquareRootDistanceDependent();
                    }
                    case DISTANCE_DEPENDENT: {
                        return DefaultUncertainty.getUncertaintyLevelingDistanceDependent();
                    }
                }
            }
            case HORIZONTAL_DISTANCE_LEAF: 
            case SLOPE_DISTANCE_LEAF: {
                switch (uncertaintyType) {
                    case ZERO_POINT_OFFSET: {
                        return DefaultUncertainty.getUncertaintyDistanceZeroPointOffset();
                    }
                    case SQUARE_ROOT_DISTANCE_DEPENDENT: {
                        return DefaultUncertainty.getUncertaintyDistanceSquareRootDistanceDependent();
                    }
                    case DISTANCE_DEPENDENT: {
                        return DefaultUncertainty.getUncertaintyDistanceDistanceDependent();
                    }
                }
            }
            case DIRECTION_LEAF: 
            case ZENITH_ANGLE_LEAF: {
                switch (uncertaintyType) {
                    case ZERO_POINT_OFFSET: {
                        return DefaultUncertainty.getUncertaintyAngleZeroPointOffset();
                    }
                    case SQUARE_ROOT_DISTANCE_DEPENDENT: {
                        return DefaultUncertainty.getUncertaintyAngleSquareRootDistanceDependent();
                    }
                    case DISTANCE_DEPENDENT: {
                        return DefaultUncertainty.getUncertaintyAngleDistanceDependent();
                    }
                }
            }
            case GNSS_1D_LEAF: 
            case GNSS_2D_LEAF: 
            case GNSS_3D_LEAF: {
                switch (uncertaintyType) {
                    case ZERO_POINT_OFFSET: {
                        return DefaultUncertainty.getUncertaintyGNSSZeroPointOffset();
                    }
                    case SQUARE_ROOT_DISTANCE_DEPENDENT: {
                        return DefaultUncertainty.getUncertaintyGNSSSquareRootDistanceDependent();
                    }
                    case DISTANCE_DEPENDENT: {
                        return DefaultUncertainty.getUncertaintyGNSSDistanceDependent();
                    }
                }
            }
        }
        return 0.0;
    }

    @Override
    public int getOrderId() {
        return this.orderId;
    }

    @Override
    public void setOrderId(int orderId) {
        this.orderId = orderId;
    }
}

