/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.jag3d.ui.tree;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.RadioMenuItem;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleGroup;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.control.cell.CheckBoxTreeCell;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.DataFormat;
import javafx.scene.input.DragEvent;
import javafx.scene.input.Dragboard;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.TransferMode;
import javafx.scene.text.Text;
import javafx.stage.FileChooser;
import javafx.stage.Window;
import org.applied_geodesy.adjustment.network.PointType;
import org.applied_geodesy.adjustment.network.VerticalDeflectionType;
import org.applied_geodesy.jag3d.sql.ProjectDatabaseStateChangeListener;
import org.applied_geodesy.jag3d.sql.ProjectDatabaseStateEvent;
import org.applied_geodesy.jag3d.sql.ProjectDatabaseStateType;
import org.applied_geodesy.jag3d.sql.SQLManager;
import org.applied_geodesy.jag3d.ui.JAG3D;
import org.applied_geodesy.jag3d.ui.dialog.InstrumentAndReflectorHeightAdaptionDialog;
import org.applied_geodesy.jag3d.ui.dialog.SearchAndReplaceDialog;
import org.applied_geodesy.jag3d.ui.dnd.CongruenceAnalysisRowDnD;
import org.applied_geodesy.jag3d.ui.dnd.GNSSObservationRowDnD;
import org.applied_geodesy.jag3d.ui.dnd.GroupTreeItemDnD;
import org.applied_geodesy.jag3d.ui.dnd.PointRowDnD;
import org.applied_geodesy.jag3d.ui.dnd.TableRowDnD;
import org.applied_geodesy.jag3d.ui.dnd.TerrestrialObservationRowDnD;
import org.applied_geodesy.jag3d.ui.dnd.VerticalDeflectionRowDnD;
import org.applied_geodesy.jag3d.ui.i18n.I18N;
import org.applied_geodesy.jag3d.ui.table.UICongruenceAnalysisTableBuilder;
import org.applied_geodesy.jag3d.ui.table.UIGNSSObservationTableBuilder;
import org.applied_geodesy.jag3d.ui.table.UIPointTableBuilder;
import org.applied_geodesy.jag3d.ui.table.UITerrestrialObservationTableBuilder;
import org.applied_geodesy.jag3d.ui.table.UIVerticalDeflectionTableBuilder;
import org.applied_geodesy.jag3d.ui.table.row.CongruenceAnalysisRow;
import org.applied_geodesy.jag3d.ui.table.row.GNSSObservationRow;
import org.applied_geodesy.jag3d.ui.table.row.GroupRow;
import org.applied_geodesy.jag3d.ui.table.row.PointRow;
import org.applied_geodesy.jag3d.ui.table.row.TerrestrialObservationRow;
import org.applied_geodesy.jag3d.ui.table.row.VerticalDeflectionRow;
import org.applied_geodesy.jag3d.ui.tabpane.TabType;
import org.applied_geodesy.jag3d.ui.tabpane.UITabPaneBuilder;
import org.applied_geodesy.jag3d.ui.tree.CongruenceAnalysisTreeItemValue;
import org.applied_geodesy.jag3d.ui.tree.Groupable;
import org.applied_geodesy.jag3d.ui.tree.ObservationTreeItemValue;
import org.applied_geodesy.jag3d.ui.tree.PointTreeItemValue;
import org.applied_geodesy.jag3d.ui.tree.Sortable;
import org.applied_geodesy.jag3d.ui.tree.TreeItemType;
import org.applied_geodesy.jag3d.ui.tree.TreeItemValue;
import org.applied_geodesy.jag3d.ui.tree.UITreeBuilder;
import org.applied_geodesy.jag3d.ui.tree.VerticalDeflectionTreeItemValue;
import org.applied_geodesy.ui.dialog.OptionDialog;
import org.applied_geodesy.ui.io.DefaultFileChooser;

public class EditableMenuCheckBoxTreeCell
extends CheckBoxTreeCell<TreeItemValue> {
    public static final DataFormat TREE_PARENT_ITEM_TYPE_DATA_FORMAT = new DataFormat(new String[]{TreeItemType.class.toString()});
    public static final DataFormat TREE_ITEM_TYPE_DATA_FORMAT = new DataFormat(new String[]{EditableMenuCheckBoxTreeCell.class.toString()});
    public static final DataFormat GROUP_ID_DATA_FORMAT = new DataFormat(new String[]{TreeItemValue.class.toString()});
    public static final DataFormat DIMENSION_DATA_FORMAT = new DataFormat(new String[]{Integer.class.toString()});
    public static final DataFormat TERRESTRIAL_OBSERVATION_ROWS_DATA_FORMAT = new DataFormat(new String[]{TerrestrialObservationRowDnD.class.toString()});
    public static final DataFormat GNSS_OBSERVATION_ROWS_DATA_FORMAT = new DataFormat(new String[]{GNSSObservationRowDnD.class.toString()});
    public static final DataFormat VERTICAL_DEFLECTION_ROWS_DATA_FORMAT = new DataFormat(new String[]{VerticalDeflectionRowDnD.class.toString()});
    public static final DataFormat POINT_ROWS_DATA_FORMAT = new DataFormat(new String[]{PointRowDnD.class.toString()});
    public static final DataFormat CONGRUENCE_ANALYSIS_ROWS_DATA_FORMAT = new DataFormat(new String[]{CongruenceAnalysisRowDnD.class.toString()});
    private static final DataFormat TREE_ITEMS_DATA_FORMAT = new DataFormat(new String[]{GroupTreeItemDnD.class.toString()});
    private I18N i18n = I18N.getInstance();
    private BooleanProperty ignoreEvent = new SimpleBooleanProperty(Boolean.FALSE.booleanValue());
    private ContextMenu contextMenu;
    private TextField textField;
    private CheckBox checkBox;

    EditableMenuCheckBoxTreeCell() {
        DropEventHandler dropEventHandler = new DropEventHandler();
        DropMouseEventHandler dropMouseEventHandler = new DropMouseEventHandler();
        this.setOnDragOver(dropEventHandler);
        this.setOnDragDropped(dropEventHandler);
        this.setOnDragDetected(dropMouseEventHandler);
    }

    private void initContextMenu(TreeItemType itemType) {
        boolean disable = !SQLManager.getInstance().hasDatabase();
        SQLManager.getInstance().addProjectDatabaseStateChangeListener(new DatabaseStateChangeListener());
        ContextMenuEventHandler listener = new ContextMenuEventHandler();
        MenuItem addItem = new MenuItem(this.i18n.getString("EditableMenuCheckBoxTreeCell.contextmenu.add", "Add item"));
        addItem.setUserData((Object)ContextMenuType.ADD);
        addItem.setOnAction((EventHandler)listener);
        addItem.setDisable(disable);
        if (TreeItemType.isPointTypeDirectory(itemType) || TreeItemType.isObservationTypeDirectory(itemType) || TreeItemType.isGNSSObservationTypeDirectory(itemType) || TreeItemType.isVerticalDeflectionTypeDirectory(itemType) || TreeItemType.isCongruenceAnalysisTypeDirectory(itemType)) {
            this.contextMenu = new ContextMenu(new MenuItem[]{addItem});
            return;
        }
        MenuItem removeItem = new MenuItem(this.i18n.getString("EditableMenuCheckBoxTreeCell.contextmenu.remove", "Remove items"));
        removeItem.setUserData((Object)ContextMenuType.REMOVE);
        removeItem.setOnAction((EventHandler)listener);
        MenuItem exportItem = new MenuItem(this.i18n.getString("EditableMenuCheckBoxTreeCell.contextmenu.export", "Export items"));
        exportItem.setUserData((Object)ContextMenuType.EXPORT);
        exportItem.setOnAction((EventHandler)listener);
        MenuItem mergeItem = new MenuItem(this.i18n.getString("EditableMenuCheckBoxTreeCell.contextmenu.merge", "Merge items"));
        mergeItem.setUserData((Object)ContextMenuType.MERGE);
        mergeItem.setOnAction((EventHandler)listener);
        MenuItem searchAndReplaceItem = new MenuItem(this.i18n.getString("EditableMenuCheckBoxTreeCell.contextmenu.search_and_replace", "Search and replace"));
        searchAndReplaceItem.setUserData((Object)ContextMenuType.SEARCH_AND_REPLACE);
        searchAndReplaceItem.setOnAction((EventHandler)listener);
        this.contextMenu = new ContextMenu(new MenuItem[]{addItem, removeItem, mergeItem, exportItem, new SeparatorMenuItem(), searchAndReplaceItem});
        if (TreeItemType.isObservationTypeLeaf(itemType)) {
            MenuItem instrumentAndReflectorHeightItem = new MenuItem(this.i18n.getString("EditableMenuCheckBoxTreeCell.contextmenu.instrument_and_reflector_height", "Height adaption"));
            instrumentAndReflectorHeightItem.setUserData((Object)ContextMenuType.ADAPT_INSTRUMENT_AND_REFLECTOR_HEIGHT);
            instrumentAndReflectorHeightItem.setOnAction((EventHandler)listener);
            this.contextMenu.getItems().addAll((Object[])new MenuItem[]{instrumentAndReflectorHeightItem});
        } else if (TreeItemType.isPointTypeLeaf(itemType)) {
            ToggleGroup pointTypeToogleGroup = new ToggleGroup();
            RadioMenuItem referencePointMenuItem = EditableMenuCheckBoxTreeCell.createRadioMenuItem(this.i18n.getString("EditableMenuCheckBoxTreeCell.contextmenu.pointgroup.reference", "Reference point group"), itemType == TreeItemType.REFERENCE_POINT_1D_LEAF || itemType == TreeItemType.REFERENCE_POINT_2D_LEAF || itemType == TreeItemType.REFERENCE_POINT_3D_LEAF, pointTypeToogleGroup, ContextMenuType.CHANGE_TO_REFERENCE_POINT_GROUP);
            RadioMenuItem stochasticPointMenuItem = EditableMenuCheckBoxTreeCell.createRadioMenuItem(this.i18n.getString("EditableMenuCheckBoxTreeCell.contextmenu.pointgroup.stochastic", "Stochastic point group"), itemType == TreeItemType.STOCHASTIC_POINT_1D_LEAF || itemType == TreeItemType.STOCHASTIC_POINT_2D_LEAF || itemType == TreeItemType.STOCHASTIC_POINT_3D_LEAF, pointTypeToogleGroup, ContextMenuType.CHANGE_TO_STOCHASTIC_POINT_GROUP);
            RadioMenuItem datumPointMenuItem = EditableMenuCheckBoxTreeCell.createRadioMenuItem(this.i18n.getString("EditableMenuCheckBoxTreeCell.contextmenu.pointgroup.datum", "Datum point group"), itemType == TreeItemType.DATUM_POINT_1D_LEAF || itemType == TreeItemType.DATUM_POINT_2D_LEAF || itemType == TreeItemType.DATUM_POINT_3D_LEAF, pointTypeToogleGroup, ContextMenuType.CHANGE_TO_DATUM_POINT_GROUP);
            RadioMenuItem newPointMenuItem = EditableMenuCheckBoxTreeCell.createRadioMenuItem(this.i18n.getString("EditableMenuCheckBoxTreeCell.contextmenu.pointgroup.new", "New point group"), itemType == TreeItemType.NEW_POINT_1D_LEAF || itemType == TreeItemType.NEW_POINT_2D_LEAF || itemType == TreeItemType.NEW_POINT_3D_LEAF, pointTypeToogleGroup, ContextMenuType.CHANGE_TO_NEW_POINT_GROUP);
            pointTypeToogleGroup.selectedToggleProperty().addListener((ChangeListener)new PointGroupChangeListener());
            this.contextMenu.getItems().addAll((Object[])new MenuItem[]{new SeparatorMenuItem(), referencePointMenuItem, stochasticPointMenuItem, datumPointMenuItem, newPointMenuItem});
        } else if (TreeItemType.isVerticalDeflectionTypeLeaf(itemType)) {
            ToggleGroup deflectionTypeToogleGroup = new ToggleGroup();
            RadioMenuItem referenceDeflectionMenuItem = EditableMenuCheckBoxTreeCell.createRadioMenuItem(this.i18n.getString("EditableMenuCheckBoxTreeCell.contextmenu.deflectiongroup.reference", "Reference deflection group"), itemType == TreeItemType.REFERENCE_VERTICAL_DEFLECTION_LEAF, deflectionTypeToogleGroup, ContextMenuType.CHANGE_TO_REFERENCE_DEFLECTION_GROUP);
            RadioMenuItem stochasticDeflectionMenuItem = EditableMenuCheckBoxTreeCell.createRadioMenuItem(this.i18n.getString("EditableMenuCheckBoxTreeCell.contextmenu.deflectiongroup.stochastic", "Stochastic deflection group"), itemType == TreeItemType.STOCHASTIC_VERTICAL_DEFLECTION_LEAF, deflectionTypeToogleGroup, ContextMenuType.CHANGE_TO_STOCHASTIC_DEFLECTION_GROUP);
            RadioMenuItem datumDeflectionMenuItem = EditableMenuCheckBoxTreeCell.createRadioMenuItem(this.i18n.getString("EditableMenuCheckBoxTreeCell.contextmenu.deflectiongroup.unknown", "Unknown deflection group"), itemType == TreeItemType.UNKNOWN_VERTICAL_DEFLECTION_LEAF, deflectionTypeToogleGroup, ContextMenuType.CHANGE_TO_UNKNOWN_DEFLECTION_GROUP);
            deflectionTypeToogleGroup.selectedToggleProperty().addListener((ChangeListener)new VerticalDeflectionGroupChangeListener());
            this.contextMenu.getItems().addAll((Object[])new MenuItem[]{new SeparatorMenuItem(), referenceDeflectionMenuItem, stochasticDeflectionMenuItem, datumDeflectionMenuItem});
        }
        for (MenuItem item : this.contextMenu.getItems()) {
            item.setDisable(disable);
        }
    }

    private static RadioMenuItem createRadioMenuItem(String label, boolean selected, ToggleGroup group, ContextMenuType type) {
        RadioMenuItem radioMenuItem = new RadioMenuItem(label);
        radioMenuItem.setUserData((Object)type);
        radioMenuItem.setSelected(selected);
        radioMenuItem.setToggleGroup(group);
        return radioMenuItem;
    }

    public void commitEdit(TreeItemValue item) {
        if (!this.isEditing() && !item.equals(this.getItem())) {
            TreeItem treeItem = this.getTreeItem();
            TreeView treeView = this.getTreeView();
            if (treeView != null) {
                treeView.fireEvent((Event)new TreeView.EditEvent(treeView, TreeView.editCommitEvent(), treeItem, (Object)((TreeItemValue)this.getItem()), (Object)item));
            }
        }
        super.commitEdit((Object)item);
    }

    public void startEdit() {
        super.startEdit();
        if (this.getGraphic() != null && this.getGraphic() instanceof CheckBox) {
            this.checkBox = (CheckBox)this.getGraphic();
        }
        if (this.textField == null) {
            this.createTextField();
        }
        if (this.getItem() != null) {
            switch (((TreeItemValue)this.getItem()).getItemType()) {
                case REFERENCE_POINT_1D_LEAF: 
                case STOCHASTIC_POINT_1D_LEAF: 
                case DATUM_POINT_1D_LEAF: 
                case NEW_POINT_1D_LEAF: 
                case REFERENCE_POINT_2D_LEAF: 
                case STOCHASTIC_POINT_2D_LEAF: 
                case DATUM_POINT_2D_LEAF: 
                case NEW_POINT_2D_LEAF: 
                case REFERENCE_POINT_3D_LEAF: 
                case STOCHASTIC_POINT_3D_LEAF: 
                case DATUM_POINT_3D_LEAF: 
                case NEW_POINT_3D_LEAF: 
                case LEVELING_LEAF: 
                case DIRECTION_LEAF: 
                case HORIZONTAL_DISTANCE_LEAF: 
                case SLOPE_DISTANCE_LEAF: 
                case ZENITH_ANGLE_LEAF: 
                case GNSS_1D_LEAF: 
                case GNSS_2D_LEAF: 
                case GNSS_3D_LEAF: 
                case CONGRUENCE_ANALYSIS_1D_LEAF: 
                case CONGRUENCE_ANALYSIS_2D_LEAF: 
                case CONGRUENCE_ANALYSIS_3D_LEAF: 
                case REFERENCE_VERTICAL_DEFLECTION_LEAF: 
                case STOCHASTIC_VERTICAL_DEFLECTION_LEAF: 
                case UNKNOWN_VERTICAL_DEFLECTION_LEAF: {
                    this.setText(null);
                    this.setGraphic((Node)this.textField);
                    this.textField.setText(this.getString());
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            EditableMenuCheckBoxTreeCell.this.textField.selectAll();
                            EditableMenuCheckBoxTreeCell.this.textField.requestFocus();
                        }
                    });
                    break;
                }
                default: {
                    System.err.println(((Object)((Object)this)).getClass().getSimpleName() + " Error, changing node name is not supported for " + String.valueOf((Object)((TreeItemValue)this.getItem()).getItemType()));
                }
            }
        }
    }

    public void cancelEdit() {
        super.cancelEdit();
        this.setText(((TreeItemValue)this.getItem()).toString());
        this.setGraphic((Node)this.checkBox);
    }

    public void updateItem(TreeItemValue item, boolean empty) {
        super.updateItem((Object)item, empty);
        if (item != null) {
            switch (item.getItemType()) {
                case REFERENCE_POINT_1D_LEAF: 
                case STOCHASTIC_POINT_1D_LEAF: 
                case DATUM_POINT_1D_LEAF: 
                case NEW_POINT_1D_LEAF: 
                case REFERENCE_POINT_2D_LEAF: 
                case STOCHASTIC_POINT_2D_LEAF: 
                case DATUM_POINT_2D_LEAF: 
                case NEW_POINT_2D_LEAF: 
                case REFERENCE_POINT_3D_LEAF: 
                case STOCHASTIC_POINT_3D_LEAF: 
                case DATUM_POINT_3D_LEAF: 
                case NEW_POINT_3D_LEAF: 
                case LEVELING_LEAF: 
                case DIRECTION_LEAF: 
                case HORIZONTAL_DISTANCE_LEAF: 
                case SLOPE_DISTANCE_LEAF: 
                case ZENITH_ANGLE_LEAF: 
                case GNSS_1D_LEAF: 
                case GNSS_2D_LEAF: 
                case GNSS_3D_LEAF: 
                case CONGRUENCE_ANALYSIS_1D_LEAF: 
                case CONGRUENCE_ANALYSIS_2D_LEAF: 
                case CONGRUENCE_ANALYSIS_3D_LEAF: 
                case REFERENCE_VERTICAL_DEFLECTION_LEAF: 
                case STOCHASTIC_VERTICAL_DEFLECTION_LEAF: 
                case UNKNOWN_VERTICAL_DEFLECTION_LEAF: {
                    this.initContextMenu(item.getItemType());
                    this.setContextMenu(this.contextMenu);
                    break;
                }
                case REFERENCE_POINT_1D_DIRECTORY: 
                case STOCHASTIC_POINT_1D_DIRECTORY: 
                case DATUM_POINT_1D_DIRECTORY: 
                case NEW_POINT_1D_DIRECTORY: 
                case REFERENCE_POINT_2D_DIRECTORY: 
                case STOCHASTIC_POINT_2D_DIRECTORY: 
                case DATUM_POINT_2D_DIRECTORY: 
                case NEW_POINT_2D_DIRECTORY: 
                case REFERENCE_POINT_3D_DIRECTORY: 
                case STOCHASTIC_POINT_3D_DIRECTORY: 
                case DATUM_POINT_3D_DIRECTORY: 
                case NEW_POINT_3D_DIRECTORY: 
                case LEVELING_DIRECTORY: 
                case DIRECTION_DIRECTORY: 
                case HORIZONTAL_DISTANCE_DIRECTORY: 
                case SLOPE_DISTANCE_DIRECTORY: 
                case ZENITH_ANGLE_DIRECTORY: 
                case GNSS_1D_DIRECTORY: 
                case GNSS_2D_DIRECTORY: 
                case GNSS_3D_DIRECTORY: 
                case CONGRUENCE_ANALYSIS_1D_DIRECTORY: 
                case CONGRUENCE_ANALYSIS_2D_DIRECTORY: 
                case CONGRUENCE_ANALYSIS_3D_DIRECTORY: 
                case REFERENCE_VERTICAL_DEFLECTION_DIRECTORY: 
                case STOCHASTIC_VERTICAL_DEFLECTION_DIRECTORY: 
                case UNKNOWN_VERTICAL_DEFLECTION_DIRECTORY: {
                    if (this.getTreeItem() != null && this.getTreeItem().isLeaf()) {
                        this.initContextMenu(item.getItemType());
                        this.setContextMenu(this.contextMenu);
                        break;
                    }
                    this.setContextMenu(null);
                    break;
                }
                default: {
                    this.setContextMenu(null);
                }
            }
        }
        if (empty) {
            this.setText(null);
        } else if (this.isEditing()) {
            if (this.textField != null) {
                this.textField.setText(this.getString());
            }
            this.setText(null);
            this.setGraphic((Node)this.textField);
        } else {
            this.setText(this.getString());
            if (this.getTreeItem() != null && this.getTreeItem().getValue() != null && (((TreeItemValue)this.getTreeItem().getValue()).getItemType() == TreeItemType.ROOT || ((TreeItemValue)this.getTreeItem().getValue()).getItemType() == TreeItemType.UNSPECIFIC)) {
                this.setGraphic((Node)new Text());
            } else if (this.checkBox != null) {
                this.setGraphic((Node)this.checkBox);
            }
        }
    }

    private void createTextField() {
        this.textField = new TextField("");
        this.textField.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                if (EditableMenuCheckBoxTreeCell.this.getTreeItem() != null) {
                    TreeItemValue item = (TreeItemValue)EditableMenuCheckBoxTreeCell.this.getTreeItem().getValue();
                    item.setName(EditableMenuCheckBoxTreeCell.this.textField.getText());
                    EditableMenuCheckBoxTreeCell.this.commitEdit(item);
                }
            }
        });
        this.textField.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                if (!newValue.booleanValue()) {
                    TreeItemValue item = (TreeItemValue)EditableMenuCheckBoxTreeCell.this.getTreeItem().getValue();
                    item.setName(EditableMenuCheckBoxTreeCell.this.textField.getText());
                    EditableMenuCheckBoxTreeCell.this.commitEdit(item);
                }
            }
        });
        this.textField.addEventFilter(KeyEvent.KEY_PRESSED, (EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent event) {
                if (event.getCode() == KeyCode.ESCAPE) {
                    EditableMenuCheckBoxTreeCell.this.textField.setText(EditableMenuCheckBoxTreeCell.this.getString());
                    EditableMenuCheckBoxTreeCell.this.cancelEdit();
                    event.consume();
                }
            }
        });
    }

    private String getString() {
        return this.getItem() == null ? "" : ((TreeItemValue)this.getItem()).toString();
    }

    private void changeGroupType(TreeItemType newItemType) {
        ObservableList selectedItems = this.getTreeView().getSelectionModel().getSelectedItems();
        if (newItemType != null && selectedItems != null && !selectedItems.isEmpty()) {
            UITreeBuilder.getInstance().moveItems(newItemType, new ArrayList<TreeItem<TreeItemValue>>((Collection<TreeItem<TreeItemValue>>)selectedItems));
        }
    }

    private void addNewEmptyGroup(TreeItemType itemType) {
        TreeItemType parentType = null;
        parentType = TreeItemType.getDirectoryByLeafType(itemType);
        if (parentType != null && TreeItemType.getLeafByDirectoryType(itemType) == null) {
            UITreeBuilder.getInstance().addEmptyGroup(parentType);
        } else if (TreeItemType.getDirectoryByLeafType(itemType) == null && TreeItemType.getLeafByDirectoryType(itemType) != null) {
            parentType = itemType;
            UITreeBuilder.getInstance().addEmptyGroup(parentType);
        }
    }

    private void removeSelectedGroups() {
        UITreeBuilder.getInstance().removeSelectedGroups();
    }

    private void mergeSelectedGroups(TreeItem<TreeItemValue> selectedItem) {
        ObservableList selectedItems = this.getTreeView().getSelectionModel().getSelectedItems();
        if (selectedItem != null && selectedItem.getValue() != null && selectedItems != null && selectedItems.size() > 1) {
            TreeItemValue selectedItemValue = (TreeItemValue)selectedItem.getValue();
            ArrayList<TreeItem<TreeItemValue>> removeItems = new ArrayList<TreeItem<TreeItemValue>>(selectedItems.size());
            TreeItemType itemType = selectedItemValue.getItemType();
            if (!(TreeItemType.isPointTypeLeaf(itemType) || TreeItemType.isObservationTypeLeaf(itemType) || TreeItemType.isGNSSObservationTypeLeaf(itemType) || TreeItemType.isCongruenceAnalysisTypeLeaf(itemType) || TreeItemType.isVerticalDeflectionTypeLeaf(itemType) || selectedItemValue instanceof Groupable)) {
                return;
            }
            try {
                ArrayList<Groupable> treeItemValues = new ArrayList<Groupable>(selectedItems.size());
                for (TreeItem treeItem : selectedItems) {
                    TreeItemValue itemValue;
                    if (treeItem.getValue() == null || treeItem.getValue() == selectedItemValue || ((TreeItemValue)treeItem.getValue()).getItemType() != itemType || !((itemValue = (TreeItemValue)treeItem.getValue()) instanceof Groupable) || ((Groupable)((Object)itemValue)).getDimension() != ((Groupable)((Object)selectedItemValue)).getDimension()) continue;
                    treeItemValues.add((Groupable)((Object)itemValue));
                    removeItems.add((TreeItem<TreeItemValue>)treeItem);
                }
                SQLManager.getInstance().mergeGroups(selectedItemValue, treeItemValues);
                UITreeBuilder.getInstance().getTree().getSelectionModel().clearSelection();
                if (removeItems != null && !removeItems.isEmpty()) {
                    UITreeBuilder.getInstance().removeItems(removeItems);
                }
                UITreeBuilder.getInstance().getTree().getSelectionModel().select(selectedItem);
            }
            catch (Exception e) {
                e.printStackTrace();
                OptionDialog.showThrowableDialog(this.i18n.getString("EditableMenuCheckBoxTreeCell.message.error.merge.exception.title", "Unexpected SQL-Error"), this.i18n.getString("EditableMenuCheckBoxTreeCell.message.error.merge.exception.header", "Error, could not merge selected tree items."), this.i18n.getString("EditableMenuCheckBoxTreeCell.message.error.merge.exception.message", "An exception has occurred during database transaction."), e);
            }
        }
    }

    private void adaptInstrumentAndReflectorHeights(TreeItem<TreeItemValue> selectedItem) {
        ObservableList selectedItems = this.getTreeView().getSelectionModel().getSelectedItems();
        TreeItemValue[] selectedTreeItemValues = new TreeItemValue[selectedItems != null ? selectedItems.size() : 0];
        int i = 0;
        while (i < selectedItems.size()) {
            selectedTreeItemValues[i] = (TreeItemValue)((TreeItem)selectedItems.get(i)).getValue();
            ++i;
        }
        InstrumentAndReflectorHeightAdaptionDialog.showAndWait((TreeItemValue)selectedItem.getValue(), selectedTreeItemValues);
    }

    private void searchAndReplace(TreeItem<TreeItemValue> selectedItem) {
        ObservableList selectedItems = this.getTreeView().getSelectionModel().getSelectedItems();
        TreeItemValue[] selectedTreeItemValues = new TreeItemValue[selectedItems != null ? selectedItems.size() : 0];
        int i = 0;
        while (i < selectedItems.size()) {
            selectedTreeItemValues[i] = (TreeItemValue)((TreeItem)selectedItems.get(i)).getValue();
            ++i;
        }
        SearchAndReplaceDialog.showAndWait((TreeItemValue)selectedItem.getValue(), selectedTreeItemValues);
    }

    private void exportTableData(TreeItemValue itemValue) {
        try {
            TabPane tabPane = UITabPaneBuilder.getInstance().getTabPane();
            if (tabPane != null && tabPane.getSelectionModel().getSelectedItem() != null && ((Tab)tabPane.getSelectionModel().getSelectedItem()).getUserData() != null && ((Tab)tabPane.getSelectionModel().getSelectedItem()).getUserData() instanceof TabType) {
                TreeItemType itemType = itemValue.getItemType();
                TabType tabType = (TabType)((Object)((Tab)tabPane.getSelectionModel().getSelectedItem()).getUserData());
                boolean aprioriValues = tabType == TabType.RAW_DATA;
                File selectedFile = DefaultFileChooser.showSaveDialog((Window)JAG3D.getStage(), this.i18n.getString("EditableMenuCheckBoxTreeCell.filechooser.save.title", "Export table data"), ((TreeItemValue)this.getItem()).getName() + (aprioriValues ? "_apriori" : "_aposteriori") + ".txt", new FileChooser.ExtensionFilter[0]);
                if (selectedFile != null) {
                    if (TreeItemType.isPointTypeLeaf(itemType)) {
                        UIPointTableBuilder.getInstance().export(selectedFile, aprioriValues);
                    } else if (TreeItemType.isObservationTypeLeaf(itemType)) {
                        UITerrestrialObservationTableBuilder.getInstance().export(selectedFile, aprioriValues);
                    } else if (TreeItemType.isGNSSObservationTypeLeaf(itemType)) {
                        UIGNSSObservationTableBuilder.getInstance().export(selectedFile, aprioriValues);
                    } else if (TreeItemType.isCongruenceAnalysisTypeLeaf(itemType)) {
                        UICongruenceAnalysisTableBuilder.getInstance().export(selectedFile, aprioriValues);
                    } else if (TreeItemType.isVerticalDeflectionTypeLeaf(itemType)) {
                        UIVerticalDeflectionTableBuilder.getInstance().export(selectedFile, aprioriValues);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            OptionDialog.showThrowableDialog(this.i18n.getString("EditableMenuCheckBoxTreeCell.message.error.export.exception.title", "I/O Error"), this.i18n.getString("EditableMenuCheckBoxTreeCell.message.error.export.exception.header", "Error, could not export selected table data."), this.i18n.getString("EditableMenuCheckBoxTreeCell.message.error.export.exception.message", "An exception has occurred during data export."), e);
        }
    }

    final BooleanProperty ignoreEventProperty() {
        return this.ignoreEvent;
    }

    final boolean isIgnoreEvent() {
        return this.ignoreEventProperty().get();
    }

    final void setIgnoreEvent(boolean ignoreEvent) {
        this.ignoreEventProperty().set(ignoreEvent);
    }

    private class ContextMenuEventHandler
    implements EventHandler<ActionEvent> {
        private ContextMenuEventHandler() {
        }

        public void handle(ActionEvent event) {
            if (!EditableMenuCheckBoxTreeCell.this.isIgnoreEvent() && event.getSource() instanceof MenuItem && ((MenuItem)event.getSource()).getUserData() instanceof ContextMenuType && EditableMenuCheckBoxTreeCell.this.getTreeItem() != null && EditableMenuCheckBoxTreeCell.this.getTreeItem().getValue() != null) {
                ContextMenuType contextMenuType = (ContextMenuType)((Object)((MenuItem)event.getSource()).getUserData());
                TreeItem selectedItem = EditableMenuCheckBoxTreeCell.this.getTreeItem();
                TreeItemValue itemValue = (TreeItemValue)selectedItem.getValue();
                switch (contextMenuType) {
                    case ADD: {
                        EditableMenuCheckBoxTreeCell.this.addNewEmptyGroup(itemValue.getItemType());
                        break;
                    }
                    case REMOVE: {
                        EditableMenuCheckBoxTreeCell.this.removeSelectedGroups();
                        break;
                    }
                    case EXPORT: {
                        EditableMenuCheckBoxTreeCell.this.exportTableData(itemValue);
                        break;
                    }
                    case SEARCH_AND_REPLACE: {
                        EditableMenuCheckBoxTreeCell.this.searchAndReplace((TreeItem<TreeItemValue>)selectedItem);
                        break;
                    }
                    case ADAPT_INSTRUMENT_AND_REFLECTOR_HEIGHT: {
                        EditableMenuCheckBoxTreeCell.this.adaptInstrumentAndReflectorHeights((TreeItem<TreeItemValue>)selectedItem);
                        break;
                    }
                    case MERGE: {
                        EditableMenuCheckBoxTreeCell.this.mergeSelectedGroups((TreeItem<TreeItemValue>)selectedItem);
                        break;
                    }
                    default: {
                        System.out.println(this.getClass().getSimpleName() + " : " + String.valueOf(event));
                    }
                }
            }
        }
    }

    private static enum ContextMenuType {
        ADD,
        REMOVE,
        EXPORT,
        MERGE,
        SEARCH_AND_REPLACE,
        ADAPT_INSTRUMENT_AND_REFLECTOR_HEIGHT,
        CHANGE_TO_REFERENCE_POINT_GROUP,
        CHANGE_TO_STOCHASTIC_POINT_GROUP,
        CHANGE_TO_DATUM_POINT_GROUP,
        CHANGE_TO_NEW_POINT_GROUP,
        CHANGE_TO_REFERENCE_DEFLECTION_GROUP,
        CHANGE_TO_STOCHASTIC_DEFLECTION_GROUP,
        CHANGE_TO_UNKNOWN_DEFLECTION_GROUP;

    }

    private class DatabaseStateChangeListener
    implements ProjectDatabaseStateChangeListener {
        private DatabaseStateChangeListener() {
        }

        @Override
        public void projectDatabaseStateChanged(ProjectDatabaseStateEvent evt) {
            if (EditableMenuCheckBoxTreeCell.this.contextMenu == null || EditableMenuCheckBoxTreeCell.this.contextMenu.getItems().isEmpty()) {
                return;
            }
            boolean disable = evt.getEventType() != ProjectDatabaseStateType.OPENED;
            ObservableList items = EditableMenuCheckBoxTreeCell.this.contextMenu.getItems();
            for (MenuItem item : items) {
                this.disableItem(item, disable);
            }
        }

        private void disableItem(MenuItem item, boolean disable) {
            if (item instanceof Menu) {
                this.disableItem((MenuItem)((Menu)item), disable);
            } else {
                item.setDisable(disable);
            }
        }
    }

    private class DropEventHandler
    implements EventHandler<DragEvent> {
        private DropEventHandler() {
        }

        public void handle(DragEvent event) {
            if (event.getEventType() == DragEvent.DRAG_OVER) {
                if (this.acceptTransfer(event)) {
                    event.acceptTransferModes(new TransferMode[]{TransferMode.MOVE});
                }
            } else if (event.getEventType() == DragEvent.DRAG_DROPPED) {
                Dragboard db = event.getDragboard();
                boolean success = false;
                if (this.acceptTransfer(event)) {
                    success = true;
                    if (db.hasContent(TREE_ITEMS_DATA_FORMAT)) {
                        TreeItem droppedOverItem = EditableMenuCheckBoxTreeCell.this.getTreeItem();
                        boolean isDirectoryNode = db.hasContent(TREE_PARENT_ITEM_TYPE_DATA_FORMAT) && droppedOverItem != null && droppedOverItem.getValue() != null && ((TreeItemValue)droppedOverItem.getValue()).getItemType() == db.getContent(TREE_PARENT_ITEM_TYPE_DATA_FORMAT);
                        TreeItem droppedOverParentItem = isDirectoryNode ? droppedOverItem : droppedOverItem.getParent();
                        ObservableList childItems = droppedOverParentItem.getChildren();
                        List groupItemsDnD = (List)db.getContent(TREE_ITEMS_DATA_FORMAT);
                        final ArrayList<TreeItem> draggedItems = new ArrayList<TreeItem>(groupItemsDnD.size());
                        int i = 0;
                        while (i < groupItemsDnD.size()) {
                            if (groupItemsDnD.get(i) != null && groupItemsDnD.get(i) instanceof GroupTreeItemDnD) {
                                GroupTreeItemDnD itemDnD = (GroupTreeItemDnD)groupItemsDnD.get(i);
                                draggedItems.add((TreeItem)childItems.get(itemDnD.getIndex()));
                            }
                            ++i;
                        }
                        if (draggedItems.size() > 0) {
                            childItems.removeAll(draggedItems);
                            int indexInParent = isDirectoryNode ? 0 : childItems.indexOf(droppedOverItem) + 1;
                            childItems.addAll(indexInParent, draggedItems);
                            int orderId = 0;
                            while (orderId < childItems.size()) {
                                block36: {
                                    TreeItem item = (TreeItem)childItems.get(orderId);
                                    TreeItemValue itemValue = (TreeItemValue)item.getValue();
                                    if (itemValue instanceof Sortable && itemValue.getItemType() != null) {
                                        ((Sortable)((Object)itemValue)).setOrderId(orderId);
                                        try {
                                            if (TreeItemType.isObservationTypeLeaf(itemValue.getItemType())) {
                                                SQLManager.getInstance().saveGroup((ObservationTreeItemValue)itemValue);
                                                break block36;
                                            }
                                            if (TreeItemType.isGNSSObservationTypeLeaf(itemValue.getItemType())) {
                                                SQLManager.getInstance().saveGroup((ObservationTreeItemValue)itemValue);
                                                break block36;
                                            }
                                            if (TreeItemType.isPointTypeLeaf(itemValue.getItemType())) {
                                                SQLManager.getInstance().saveGroup((PointTreeItemValue)itemValue);
                                                break block36;
                                            }
                                            if (TreeItemType.isCongruenceAnalysisTypeLeaf(itemValue.getItemType())) {
                                                SQLManager.getInstance().saveGroup((CongruenceAnalysisTreeItemValue)itemValue);
                                                break block36;
                                            }
                                            if (!TreeItemType.isVerticalDeflectionTypeLeaf(itemValue.getItemType())) break block36;
                                            SQLManager.getInstance().saveGroup((VerticalDeflectionTreeItemValue)itemValue);
                                        }
                                        catch (Exception e) {
                                            e.printStackTrace();
                                            OptionDialog.showThrowableDialog(EditableMenuCheckBoxTreeCell.this.i18n.getString("EditableMenuCheckBoxTreeCell.message.error.save_dropped_tree_item.exception.title", "Unexpected SQL-Error"), EditableMenuCheckBoxTreeCell.this.i18n.getString("EditableMenuCheckBoxTreeCell.message.error.save_dropped_tree_item.exception.header", "Error, could not drop selected item to tree menu."), EditableMenuCheckBoxTreeCell.this.i18n.getString("EditableMenuCheckBoxTreeCell.message.error.save_dropped_tree_item.exception.message", "An exception has occurred during database transaction."), e);
                                            success = false;
                                            break;
                                        }
                                    }
                                }
                                ++orderId;
                            }
                            Platform.runLater((Runnable)new Runnable(){

                                @Override
                                public void run() {
                                    if (draggedItems.size() > 0) {
                                        EditableMenuCheckBoxTreeCell.this.getTreeView().getSelectionModel().clearSelection();
                                        EditableMenuCheckBoxTreeCell.this.getTreeView().getSelectionModel().select((Object)((TreeItem)draggedItems.get(0)));
                                    }
                                }
                            });
                        }
                    } else {
                        List droppedRows = null;
                        int targetGroupId = -1;
                        if (TreeItemType.isObservationTypeLeaf(((TreeItemValue)EditableMenuCheckBoxTreeCell.this.getItem()).getItemType()) && db.hasContent(TERRESTRIAL_OBSERVATION_ROWS_DATA_FORMAT)) {
                            targetGroupId = ((ObservationTreeItemValue)EditableMenuCheckBoxTreeCell.this.getItem()).getGroupId();
                            droppedRows = (List)db.getContent(TERRESTRIAL_OBSERVATION_ROWS_DATA_FORMAT);
                        } else if (TreeItemType.isGNSSObservationTypeLeaf(((TreeItemValue)EditableMenuCheckBoxTreeCell.this.getItem()).getItemType()) && db.hasContent(GNSS_OBSERVATION_ROWS_DATA_FORMAT)) {
                            targetGroupId = ((ObservationTreeItemValue)EditableMenuCheckBoxTreeCell.this.getItem()).getGroupId();
                            droppedRows = (List)db.getContent(GNSS_OBSERVATION_ROWS_DATA_FORMAT);
                        } else if (TreeItemType.isPointTypeLeaf(((TreeItemValue)EditableMenuCheckBoxTreeCell.this.getItem()).getItemType()) && db.hasContent(POINT_ROWS_DATA_FORMAT)) {
                            targetGroupId = ((PointTreeItemValue)EditableMenuCheckBoxTreeCell.this.getItem()).getGroupId();
                            droppedRows = (List)db.getContent(POINT_ROWS_DATA_FORMAT);
                        } else if (TreeItemType.isCongruenceAnalysisTypeLeaf(((TreeItemValue)EditableMenuCheckBoxTreeCell.this.getItem()).getItemType()) && db.hasContent(CONGRUENCE_ANALYSIS_ROWS_DATA_FORMAT)) {
                            targetGroupId = ((CongruenceAnalysisTreeItemValue)EditableMenuCheckBoxTreeCell.this.getItem()).getGroupId();
                            droppedRows = (List)db.getContent(CONGRUENCE_ANALYSIS_ROWS_DATA_FORMAT);
                        } else if (TreeItemType.isVerticalDeflectionTypeLeaf(((TreeItemValue)EditableMenuCheckBoxTreeCell.this.getItem()).getItemType()) && db.hasContent(VERTICAL_DEFLECTION_ROWS_DATA_FORMAT)) {
                            targetGroupId = ((VerticalDeflectionTreeItemValue)EditableMenuCheckBoxTreeCell.this.getItem()).getGroupId();
                            droppedRows = (List)db.getContent(VERTICAL_DEFLECTION_ROWS_DATA_FORMAT);
                        }
                        if (droppedRows != null && targetGroupId >= 0) {
                            int i = 0;
                            while (i < droppedRows.size()) {
                                block37: {
                                    if (droppedRows.get(i) != null) {
                                        try {
                                            GroupRow row;
                                            TableRowDnD rowDnD;
                                            if (droppedRows.get(i) instanceof TerrestrialObservationRowDnD) {
                                                rowDnD = (TerrestrialObservationRowDnD)droppedRows.get(i);
                                                row = ((TerrestrialObservationRowDnD)rowDnD).toTerrestrialObservationRow();
                                                row.setGroupId(targetGroupId);
                                                SQLManager.getInstance().saveItem((TerrestrialObservationRow)row);
                                                break block37;
                                            }
                                            if (droppedRows.get(i) instanceof GNSSObservationRowDnD) {
                                                rowDnD = (GNSSObservationRowDnD)droppedRows.get(i);
                                                row = ((GNSSObservationRowDnD)rowDnD).toGNSSObservationRow();
                                                row.setGroupId(targetGroupId);
                                                SQLManager.getInstance().saveItem((GNSSObservationRow)row);
                                                break block37;
                                            }
                                            if (droppedRows.get(i) instanceof PointRowDnD) {
                                                rowDnD = (PointRowDnD)droppedRows.get(i);
                                                row = ((PointRowDnD)rowDnD).toPointRow();
                                                row.setGroupId(targetGroupId);
                                                SQLManager.getInstance().saveItem((PointRow)row);
                                                break block37;
                                            }
                                            if (droppedRows.get(i) instanceof CongruenceAnalysisRowDnD) {
                                                rowDnD = (CongruenceAnalysisRowDnD)droppedRows.get(i);
                                                row = ((CongruenceAnalysisRowDnD)rowDnD).toCongruenceAnalysisRow();
                                                row.setGroupId(targetGroupId);
                                                SQLManager.getInstance().saveItem((CongruenceAnalysisRow)row);
                                                break block37;
                                            }
                                            if (!(droppedRows.get(i) instanceof VerticalDeflectionRowDnD)) break block37;
                                            rowDnD = (VerticalDeflectionRowDnD)droppedRows.get(i);
                                            row = ((VerticalDeflectionRowDnD)rowDnD).toVerticalDeflectionRow();
                                            row.setGroupId(targetGroupId);
                                            SQLManager.getInstance().saveItem((VerticalDeflectionRow)row);
                                        }
                                        catch (Exception e) {
                                            e.printStackTrace();
                                            OptionDialog.showThrowableDialog(EditableMenuCheckBoxTreeCell.this.i18n.getString("EditableMenuCheckBoxTreeCell.message.error.save_dropped_table_row.exception.title", "Unexpected SQL-Error"), EditableMenuCheckBoxTreeCell.this.i18n.getString("EditableMenuCheckBoxTreeCell.message.error.save_dropped_table_row.exception.header", "Error, could not drop selected row to new table."), EditableMenuCheckBoxTreeCell.this.i18n.getString("EditableMenuCheckBoxTreeCell.message.error.save_dropped_table_row.exception.message", "An exception has occurred during database transaction."), e);
                                            success = false;
                                            break;
                                        }
                                    }
                                }
                                ++i;
                            }
                        }
                        final TreeItem targetTreeItem = EditableMenuCheckBoxTreeCell.this.getTreeItem();
                        Platform.runLater((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                if (targetTreeItem != null) {
                                    EditableMenuCheckBoxTreeCell.this.getTreeView().getSelectionModel().clearSelection();
                                    EditableMenuCheckBoxTreeCell.this.getTreeView().getSelectionModel().select((Object)targetTreeItem);
                                }
                            }
                        });
                    }
                }
                event.setDropCompleted(success);
            }
            event.consume();
        }

        private boolean acceptTransfer(DragEvent event) {
            Dragboard db = event.getDragboard();
            TreeItemValue itemValue = (TreeItemValue)EditableMenuCheckBoxTreeCell.this.getItem();
            TreeItemType itemType = itemValue != null && itemValue.getItemType() != null ? itemValue.getItemType() : null;
            HashSet<Integer> groupItemIdsDnD = new HashSet<Integer>(0);
            if (db.hasContent(TREE_ITEMS_DATA_FORMAT)) {
                List groupItemsDnD = (List)db.getContent(TREE_ITEMS_DATA_FORMAT);
                groupItemIdsDnD = new HashSet(groupItemsDnD.size());
                int i = 0;
                while (i < groupItemsDnD.size()) {
                    if (groupItemsDnD.get(i) != null && groupItemsDnD.get(i) instanceof GroupTreeItemDnD) {
                        GroupTreeItemDnD itemDnD = (GroupTreeItemDnD)groupItemsDnD.get(i);
                        groupItemIdsDnD.add(itemDnD.getGroupId());
                    }
                    ++i;
                }
            }
            return itemType != null && (event.getGestureSource() instanceof TableView || event.getGestureSource() instanceof EditableMenuCheckBoxTreeCell) && db.hasContent(TREE_ITEM_TYPE_DATA_FORMAT) && db.hasContent(GROUP_ID_DATA_FORMAT) && db.hasContent(DIMENSION_DATA_FORMAT) && (db.hasContent(TREE_ITEMS_DATA_FORMAT) && db.hasContent(TREE_PARENT_ITEM_TYPE_DATA_FORMAT) && itemType == db.getContent(TREE_PARENT_ITEM_TYPE_DATA_FORMAT) || (db.hasContent(TERRESTRIAL_OBSERVATION_ROWS_DATA_FORMAT) || db.hasContent(TREE_ITEMS_DATA_FORMAT)) && TreeItemType.isObservationTypeLeaf(itemType) && itemType == db.getContent(TREE_ITEM_TYPE_DATA_FORMAT) && itemValue instanceof ObservationTreeItemValue && ((ObservationTreeItemValue)itemValue).getGroupId() != ((Integer)db.getContent(GROUP_ID_DATA_FORMAT)).intValue() && !groupItemIdsDnD.contains(((ObservationTreeItemValue)itemValue).getGroupId()) || (db.hasContent(GNSS_OBSERVATION_ROWS_DATA_FORMAT) || db.hasContent(TREE_ITEMS_DATA_FORMAT)) && TreeItemType.isGNSSObservationTypeLeaf(itemType) && itemType == db.getContent(TREE_ITEM_TYPE_DATA_FORMAT) && itemValue instanceof ObservationTreeItemValue && ((ObservationTreeItemValue)itemValue).getDimension() == ((Integer)db.getContent(DIMENSION_DATA_FORMAT)).intValue() && ((ObservationTreeItemValue)itemValue).getGroupId() != ((Integer)db.getContent(GROUP_ID_DATA_FORMAT)).intValue() && !groupItemIdsDnD.contains(((ObservationTreeItemValue)itemValue).getGroupId()) || (db.hasContent(POINT_ROWS_DATA_FORMAT) || db.hasContent(TREE_ITEMS_DATA_FORMAT)) && TreeItemType.isPointTypeLeaf(itemType) && TreeItemType.isPointTypeLeaf((TreeItemType)((Object)db.getContent(TREE_ITEM_TYPE_DATA_FORMAT))) && itemValue instanceof PointTreeItemValue && ((PointTreeItemValue)itemValue).getDimension() == ((Integer)db.getContent(DIMENSION_DATA_FORMAT)).intValue() && ((PointTreeItemValue)itemValue).getGroupId() != ((Integer)db.getContent(GROUP_ID_DATA_FORMAT)).intValue() && !groupItemIdsDnD.contains(((PointTreeItemValue)itemValue).getGroupId()) || (db.hasContent(VERTICAL_DEFLECTION_ROWS_DATA_FORMAT) || db.hasContent(TREE_ITEMS_DATA_FORMAT)) && TreeItemType.isVerticalDeflectionTypeLeaf(itemType) && TreeItemType.isVerticalDeflectionTypeLeaf((TreeItemType)((Object)db.getContent(TREE_ITEM_TYPE_DATA_FORMAT))) && itemValue instanceof VerticalDeflectionTreeItemValue && ((VerticalDeflectionTreeItemValue)itemValue).getGroupId() != ((Integer)db.getContent(GROUP_ID_DATA_FORMAT)).intValue() && !groupItemIdsDnD.contains(((VerticalDeflectionTreeItemValue)itemValue).getGroupId()) || (db.hasContent(CONGRUENCE_ANALYSIS_ROWS_DATA_FORMAT) || db.hasContent(TREE_ITEMS_DATA_FORMAT)) && TreeItemType.isCongruenceAnalysisTypeLeaf(itemType) && itemType == db.getContent(TREE_ITEM_TYPE_DATA_FORMAT) && itemValue instanceof CongruenceAnalysisTreeItemValue && ((CongruenceAnalysisTreeItemValue)itemValue).getDimension() == ((Integer)db.getContent(DIMENSION_DATA_FORMAT)).intValue() && ((CongruenceAnalysisTreeItemValue)itemValue).getGroupId() != ((Integer)db.getContent(GROUP_ID_DATA_FORMAT)).intValue() && !groupItemIdsDnD.contains(((CongruenceAnalysisTreeItemValue)itemValue).getGroupId()));
        }
    }

    private class DropMouseEventHandler
    implements EventHandler<MouseEvent> {
        private DropMouseEventHandler() {
        }

        public void handle(MouseEvent event) {
            if (event.getEventType() == MouseEvent.DRAG_DETECTED) {
                TreeItemType itemType;
                ArrayList draggedItems = new ArrayList(EditableMenuCheckBoxTreeCell.this.getTreeView().getSelectionModel().getSelectedItems());
                TreeItemType treeItemType = itemType = EditableMenuCheckBoxTreeCell.this.getItem() != null ? ((TreeItemValue)EditableMenuCheckBoxTreeCell.this.getItem()).getItemType() : null;
                if (itemType != null) {
                    ArrayList<GroupTreeItemDnD> groupItemsDnD = new ArrayList<GroupTreeItemDnD>(draggedItems.size());
                    for (TreeItem draggedItem : draggedItems) {
                        if (draggedItem.getValue() == null || ((TreeItemValue)draggedItem.getValue()).getItemType() != itemType) {
                            return;
                        }
                        GroupTreeItemDnD itemDnD = GroupTreeItemDnD.fromTreeItem((TreeItem<TreeItemValue>)draggedItem);
                        if (itemDnD == null) {
                            return;
                        }
                        groupItemsDnD.add(itemDnD);
                    }
                    if (groupItemsDnD.size() > 0) {
                        Dragboard db = EditableMenuCheckBoxTreeCell.this.startDragAndDrop(new TransferMode[]{TransferMode.MOVE});
                        TreeItemType parentType = ((GroupTreeItemDnD)groupItemsDnD.get(0)).getParentType();
                        int groupId = ((GroupTreeItemDnD)groupItemsDnD.get(0)).getGroupId();
                        int dimension = ((GroupTreeItemDnD)groupItemsDnD.get(0)).getDimension();
                        ClipboardContent content = new ClipboardContent();
                        content.put((Object)TREE_PARENT_ITEM_TYPE_DATA_FORMAT, (Object)parentType);
                        content.put((Object)TREE_ITEM_TYPE_DATA_FORMAT, (Object)itemType);
                        content.put((Object)GROUP_ID_DATA_FORMAT, (Object)groupId);
                        content.put((Object)DIMENSION_DATA_FORMAT, (Object)dimension);
                        content.put((Object)TREE_ITEMS_DATA_FORMAT, groupItemsDnD);
                        db.setContent((Map)content);
                        event.consume();
                    }
                }
            }
        }
    }

    private class PointGroupChangeListener
    implements ChangeListener<Toggle> {
        private PointGroupChangeListener() {
        }

        public void changed(ObservableValue<? extends Toggle> observable, Toggle oldValue, Toggle newValue) {
            if (!EditableMenuCheckBoxTreeCell.this.isIgnoreEvent() && newValue != null && newValue.getUserData() instanceof ContextMenuType && EditableMenuCheckBoxTreeCell.this.getTreeItem() != null && EditableMenuCheckBoxTreeCell.this.getTreeItem().getValue() != null && EditableMenuCheckBoxTreeCell.this.getTreeItem().getValue() instanceof PointTreeItemValue) {
                ContextMenuType menuItemType = (ContextMenuType)((Object)newValue.getUserData());
                PointTreeItemValue itemValue = (PointTreeItemValue)EditableMenuCheckBoxTreeCell.this.getTreeItem().getValue();
                int dimension = itemValue.getDimension();
                PointType pointType = TreeItemType.getPointTypeByTreeItemType(itemValue.getItemType());
                switch (menuItemType) {
                    case CHANGE_TO_REFERENCE_POINT_GROUP: {
                        if (pointType == PointType.REFERENCE_POINT) {
                            return;
                        }
                        if (dimension == 1) {
                            EditableMenuCheckBoxTreeCell.this.changeGroupType(TreeItemType.REFERENCE_POINT_1D_LEAF);
                            break;
                        }
                        if (dimension == 2) {
                            EditableMenuCheckBoxTreeCell.this.changeGroupType(TreeItemType.REFERENCE_POINT_2D_LEAF);
                            break;
                        }
                        if (dimension != 3) break;
                        EditableMenuCheckBoxTreeCell.this.changeGroupType(TreeItemType.REFERENCE_POINT_3D_LEAF);
                        break;
                    }
                    case CHANGE_TO_STOCHASTIC_POINT_GROUP: {
                        if (pointType == PointType.STOCHASTIC_POINT) {
                            return;
                        }
                        if (dimension == 1) {
                            EditableMenuCheckBoxTreeCell.this.changeGroupType(TreeItemType.STOCHASTIC_POINT_1D_LEAF);
                            break;
                        }
                        if (dimension == 2) {
                            EditableMenuCheckBoxTreeCell.this.changeGroupType(TreeItemType.STOCHASTIC_POINT_2D_LEAF);
                            break;
                        }
                        if (dimension != 3) break;
                        EditableMenuCheckBoxTreeCell.this.changeGroupType(TreeItemType.STOCHASTIC_POINT_3D_LEAF);
                        break;
                    }
                    case CHANGE_TO_DATUM_POINT_GROUP: {
                        if (pointType == PointType.DATUM_POINT) {
                            return;
                        }
                        if (dimension == 1) {
                            EditableMenuCheckBoxTreeCell.this.changeGroupType(TreeItemType.DATUM_POINT_1D_LEAF);
                            break;
                        }
                        if (dimension == 2) {
                            EditableMenuCheckBoxTreeCell.this.changeGroupType(TreeItemType.DATUM_POINT_2D_LEAF);
                            break;
                        }
                        if (dimension != 3) break;
                        EditableMenuCheckBoxTreeCell.this.changeGroupType(TreeItemType.DATUM_POINT_3D_LEAF);
                        break;
                    }
                    case CHANGE_TO_NEW_POINT_GROUP: {
                        if (pointType == PointType.NEW_POINT) {
                            return;
                        }
                        if (dimension == 1) {
                            EditableMenuCheckBoxTreeCell.this.changeGroupType(TreeItemType.NEW_POINT_1D_LEAF);
                            break;
                        }
                        if (dimension == 2) {
                            EditableMenuCheckBoxTreeCell.this.changeGroupType(TreeItemType.NEW_POINT_2D_LEAF);
                            break;
                        }
                        if (dimension != 3) break;
                        EditableMenuCheckBoxTreeCell.this.changeGroupType(TreeItemType.NEW_POINT_3D_LEAF);
                        break;
                    }
                    default: {
                        System.err.println(EditableMenuCheckBoxTreeCell.class.getSimpleName() + " : Error, unsupported context menu item type " + String.valueOf((Object)menuItemType));
                    }
                }
            }
        }
    }

    private class VerticalDeflectionGroupChangeListener
    implements ChangeListener<Toggle> {
        private VerticalDeflectionGroupChangeListener() {
        }

        public void changed(ObservableValue<? extends Toggle> observable, Toggle oldValue, Toggle newValue) {
            if (!EditableMenuCheckBoxTreeCell.this.isIgnoreEvent() && newValue != null && newValue.getUserData() instanceof ContextMenuType && EditableMenuCheckBoxTreeCell.this.getTreeItem() != null && EditableMenuCheckBoxTreeCell.this.getTreeItem().getValue() != null && EditableMenuCheckBoxTreeCell.this.getTreeItem().getValue() instanceof VerticalDeflectionTreeItemValue) {
                ContextMenuType menuItemType = (ContextMenuType)((Object)newValue.getUserData());
                VerticalDeflectionTreeItemValue itemValue = (VerticalDeflectionTreeItemValue)EditableMenuCheckBoxTreeCell.this.getTreeItem().getValue();
                VerticalDeflectionType verticalDeflectionType = TreeItemType.getVerticalDeflectionTypeByTreeItemType(itemValue.getItemType());
                switch (menuItemType) {
                    case CHANGE_TO_REFERENCE_DEFLECTION_GROUP: {
                        if (verticalDeflectionType == VerticalDeflectionType.REFERENCE_VERTICAL_DEFLECTION) {
                            return;
                        }
                        EditableMenuCheckBoxTreeCell.this.changeGroupType(TreeItemType.REFERENCE_VERTICAL_DEFLECTION_LEAF);
                        break;
                    }
                    case CHANGE_TO_STOCHASTIC_DEFLECTION_GROUP: {
                        if (verticalDeflectionType == VerticalDeflectionType.STOCHASTIC_VERTICAL_DEFLECTION) {
                            return;
                        }
                        EditableMenuCheckBoxTreeCell.this.changeGroupType(TreeItemType.STOCHASTIC_VERTICAL_DEFLECTION_LEAF);
                        break;
                    }
                    case CHANGE_TO_UNKNOWN_DEFLECTION_GROUP: {
                        if (verticalDeflectionType == VerticalDeflectionType.UNKNOWN_VERTICAL_DEFLECTION) {
                            return;
                        }
                        EditableMenuCheckBoxTreeCell.this.changeGroupType(TreeItemType.UNKNOWN_VERTICAL_DEFLECTION_LEAF);
                        break;
                    }
                    default: {
                        System.err.println(EditableMenuCheckBoxTreeCell.class.getSimpleName() + " : Error, unsupported context menu item type " + String.valueOf((Object)menuItemType));
                    }
                }
            }
        }
    }
}

