/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.jag3d.ui.tree;

import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleIntegerProperty;
import org.applied_geodesy.adjustment.network.ParameterType;
import org.applied_geodesy.adjustment.network.congruence.strain.RestrictionType;
import org.applied_geodesy.jag3d.ui.tabpane.TabType;
import org.applied_geodesy.jag3d.ui.tree.Groupable;
import org.applied_geodesy.jag3d.ui.tree.ObservationTreeItemValue;
import org.applied_geodesy.jag3d.ui.tree.Sortable;
import org.applied_geodesy.jag3d.ui.tree.TreeItemType;
import org.applied_geodesy.jag3d.ui.tree.TreeItemValue;

public class CongruenceAnalysisTreeItemValue
extends TreeItemValue
implements Sortable,
Groupable {
    private IntegerProperty groupId = new SimpleIntegerProperty(-1);
    private int orderId;

    CongruenceAnalysisTreeItemValue(int groupId, TreeItemType type, String name, int orderId) throws IllegalArgumentException {
        this(groupId, type, name, Boolean.TRUE, orderId);
    }

    CongruenceAnalysisTreeItemValue(int groupId, TreeItemType type, String name, boolean enable, int orderId) throws IllegalArgumentException {
        super(type, name);
        this.setGroupId(groupId);
        this.setEnable(enable);
        this.setOrderId(orderId);
    }

    public IntegerProperty groupIdProperty() {
        return this.groupId;
    }

    @Override
    public int getGroupId() {
        return this.groupIdProperty().get();
    }

    @Override
    public void setGroupId(int groupId) {
        this.groupIdProperty().set(groupId);
    }

    @Override
    public final int getDimension() {
        switch (this.getItemType()) {
            case CONGRUENCE_ANALYSIS_1D_LEAF: {
                return 1;
            }
            case CONGRUENCE_ANALYSIS_2D_LEAF: {
                return 2;
            }
            case CONGRUENCE_ANALYSIS_3D_LEAF: {
                return 3;
            }
        }
        throw new IllegalArgumentException(this.getClass().getSimpleName() + " : Error, TreeItemType does not refer to an object point nexus (congruence analysis) " + String.valueOf((Object)this.getItemType()));
    }

    public static RestrictionType[] getRestrictionTypes(TreeItemType itemType) {
        switch (itemType) {
            case CONGRUENCE_ANALYSIS_1D_LEAF: {
                return new RestrictionType[]{RestrictionType.FIXED_TRANSLATION_Z, RestrictionType.FIXED_SCALE_Z};
            }
            case CONGRUENCE_ANALYSIS_2D_LEAF: {
                return new RestrictionType[]{RestrictionType.FIXED_TRANSLATION_Y, RestrictionType.FIXED_TRANSLATION_X, RestrictionType.FIXED_ROTATION_Z, RestrictionType.FIXED_SCALE_Y, RestrictionType.FIXED_SCALE_X, RestrictionType.FIXED_SHEAR_Z, RestrictionType.IDENT_SCALES_XY};
            }
            case CONGRUENCE_ANALYSIS_3D_LEAF: {
                return new RestrictionType[]{RestrictionType.FIXED_TRANSLATION_Y, RestrictionType.FIXED_TRANSLATION_X, RestrictionType.FIXED_TRANSLATION_Z, RestrictionType.FIXED_ROTATION_Y, RestrictionType.FIXED_ROTATION_X, RestrictionType.FIXED_ROTATION_Z, RestrictionType.FIXED_SCALE_Y, RestrictionType.FIXED_SCALE_X, RestrictionType.FIXED_SCALE_Z, RestrictionType.FIXED_SHEAR_Y, RestrictionType.FIXED_SHEAR_X, RestrictionType.FIXED_SHEAR_Z, RestrictionType.IDENT_SCALES_XY, RestrictionType.IDENT_SCALES_XZ, RestrictionType.IDENT_SCALES_YZ};
            }
        }
        throw new IllegalArgumentException(ObservationTreeItemValue.class.getSimpleName() + " : Error, TreeItemType does not refer to a congruence analysis type " + String.valueOf((Object)itemType));
    }

    public static ParameterType[] getParameterTypes(TreeItemType itemType) {
        switch (itemType) {
            case CONGRUENCE_ANALYSIS_1D_LEAF: {
                return new ParameterType[]{ParameterType.STRAIN_TRANSLATION_Z, ParameterType.STRAIN_SCALE_Z};
            }
            case CONGRUENCE_ANALYSIS_2D_LEAF: {
                return new ParameterType[]{ParameterType.STRAIN_TRANSLATION_Y, ParameterType.STRAIN_TRANSLATION_X, ParameterType.STRAIN_ROTATION_Z, ParameterType.STRAIN_SCALE_Y, ParameterType.STRAIN_SCALE_X, ParameterType.STRAIN_SHEAR_Z};
            }
            case CONGRUENCE_ANALYSIS_3D_LEAF: {
                return new ParameterType[]{ParameterType.STRAIN_TRANSLATION_Y, ParameterType.STRAIN_TRANSLATION_X, ParameterType.STRAIN_TRANSLATION_Z, ParameterType.STRAIN_ROTATION_Y, ParameterType.STRAIN_ROTATION_X, ParameterType.STRAIN_ROTATION_Z, ParameterType.STRAIN_SCALE_Y, ParameterType.STRAIN_SCALE_X, ParameterType.STRAIN_SHEAR_Y, ParameterType.STRAIN_SHEAR_X, ParameterType.STRAIN_SHEAR_Z};
            }
        }
        throw new IllegalArgumentException(ObservationTreeItemValue.class.getSimpleName() + " : Error, TreeItemType does not refer to a congruence analysis type " + String.valueOf((Object)itemType));
    }

    @Override
    public TabType[] getTabTypes() {
        return new TabType[]{TabType.RAW_DATA, TabType.PROPERTIES, TabType.RESULT_CONGRUENCE_ANALYSIS, TabType.ADDITIONAL_PARAMETER};
    }

    @Override
    public int getOrderId() {
        return this.orderId;
    }

    @Override
    public void setOrderId(int orderId) {
        this.orderId = orderId;
    }
}

