/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.jag3d.ui.tabpane;

import java.util.Collection;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import javafx.geometry.Side;
import javafx.scene.Node;
import javafx.scene.control.SingleSelectionModel;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.Tooltip;
import org.applied_geodesy.jag3d.ui.graphic.UIGraphicPaneBuilder;
import org.applied_geodesy.jag3d.ui.i18n.I18N;
import org.applied_geodesy.jag3d.ui.metadata.UIMetaDataPaneBuilder;
import org.applied_geodesy.jag3d.ui.propertiespane.UICongruenceAnalysisPropertiesPaneBuilder;
import org.applied_geodesy.jag3d.ui.propertiespane.UIObservationPropertiesPaneBuilder;
import org.applied_geodesy.jag3d.ui.propertiespane.UIPointPropertiesPaneBuilder;
import org.applied_geodesy.jag3d.ui.propertiespane.UIVerticalDeflectionPropertiesPaneBuilder;
import org.applied_geodesy.jag3d.ui.resultpane.UIGlobalResultPaneBuilder;
import org.applied_geodesy.jag3d.ui.table.UIAdditionalParameterTableBuilder;
import org.applied_geodesy.jag3d.ui.table.UICongruenceAnalysisTableBuilder;
import org.applied_geodesy.jag3d.ui.table.UIGNSSObservationTableBuilder;
import org.applied_geodesy.jag3d.ui.table.UIPointTableBuilder;
import org.applied_geodesy.jag3d.ui.table.UITerrestrialObservationTableBuilder;
import org.applied_geodesy.jag3d.ui.table.UIVarianceComponentTableBuilder;
import org.applied_geodesy.jag3d.ui.table.UIVerticalDeflectionTableBuilder;
import org.applied_geodesy.jag3d.ui.table.row.CongruenceAnalysisRow;
import org.applied_geodesy.jag3d.ui.table.row.GNSSObservationRow;
import org.applied_geodesy.jag3d.ui.table.row.PointRow;
import org.applied_geodesy.jag3d.ui.table.row.Row;
import org.applied_geodesy.jag3d.ui.table.row.TerrestrialObservationRow;
import org.applied_geodesy.jag3d.ui.table.row.VarianceComponentRow;
import org.applied_geodesy.jag3d.ui.table.row.VerticalDeflectionRow;
import org.applied_geodesy.jag3d.ui.tabpane.TabType;
import org.applied_geodesy.jag3d.ui.tree.CongruenceAnalysisTreeItemValue;
import org.applied_geodesy.jag3d.ui.tree.ObservationTreeItemValue;
import org.applied_geodesy.jag3d.ui.tree.PointTreeItemValue;
import org.applied_geodesy.jag3d.ui.tree.TreeItemType;
import org.applied_geodesy.jag3d.ui.tree.TreeItemValue;
import org.applied_geodesy.jag3d.ui.tree.VerticalDeflectionTreeItemValue;
import org.applied_geodesy.ui.table.ColumnType;

public class UITabPaneBuilder {
    private TabPane tabPane = null;
    private static UITabPaneBuilder tabPaneBuilder = new UITabPaneBuilder();
    private I18N i18n = I18N.getInstance();
    private TabSelectionChangeListener tabSelectionChangeListener = new TabSelectionChangeListener();
    private UIPointTableBuilder pointTableBuilder = UIPointTableBuilder.getInstance();
    private UITerrestrialObservationTableBuilder observationTableBuilder = UITerrestrialObservationTableBuilder.getInstance();
    private UIGNSSObservationTableBuilder gnssObservationTableBuilder = UIGNSSObservationTableBuilder.getInstance();
    private UICongruenceAnalysisTableBuilder congruenceAnalysisTableBuilder = UICongruenceAnalysisTableBuilder.getInstance();
    private UIVerticalDeflectionTableBuilder verticalDeflectionTableBuilder = UIVerticalDeflectionTableBuilder.getInstance();
    private ObservableMap<TabType, Tab> tapMap = FXCollections.observableHashMap();
    private TreeItemValue lastTreeItemValue = null;
    private Tab lastSelectedTab = null;

    public static UITabPaneBuilder getInstance() {
        return tabPaneBuilder;
    }

    public TabPane getTabPane() {
        if (this.tabPane == null) {
            this.init();
        }
        return this.tabPane;
    }

    private void init() {
        this.createTab(this.i18n.getString("UITabPaneBuilder.tab.metadata.label", "Metadata"), this.i18n.getString("UITabPaneBuilder.tab.metadata.tooltip", "Project-specific metadata"), TabType.META_DATA, null);
        this.createTab(this.i18n.getString("UITabPaneBuilder.tab.graphic.label", "Graphic"), this.i18n.getString("UITabPaneBuilder.tab.graphic.tooltip", "Graphical visualisation of the network"), TabType.GRAPHIC, null);
        this.createTab(this.i18n.getString("UITabPaneBuilder.tab.raw.label", "Raw data"), this.i18n.getString("UITabPaneBuilder.tab.raw.tooltip", "Table of raw data"), TabType.RAW_DATA, null);
        this.createTab(this.i18n.getString("UITabPaneBuilder.tab.properties.label", "Properties"), this.i18n.getString("UITabPaneBuilder.tab.properties.tooltip", "Properties of group"), TabType.PROPERTIES, null);
        this.createTab(this.i18n.getString("UITabPaneBuilder.tab.result.label", "Result data"), this.i18n.getString("UITabPaneBuilder.tab.result.tooltip", "Table of estimated data"), TabType.RESULT_DATA, null);
        this.createTab(this.i18n.getString("UITabPaneBuilder.tab.param.label", "Additional parameters"), this.i18n.getString("UITabPaneBuilder.tab.param.tooltip", "Table of additional parameters"), TabType.ADDITIONAL_PARAMETER, null);
        this.createTab(this.i18n.getString("UITabPaneBuilder.tab.congruence.point.label", "Congruence of points"), this.i18n.getString("UITabPaneBuilder.tab.congruence.point.tooltip", "Result of congruence analysis of point"), TabType.RESULT_CONGRUENCE_ANALYSIS, null);
        this.createTab(this.i18n.getString("UITabPaneBuilder.tab.variance_component.label", "Variance components"), this.i18n.getString("UITabPaneBuilder.tab.variance_component.tooltip", "Table of variance components estimation"), TabType.VARIANCE_COMPONENT, null);
        this.tabPane = new TabPane();
        this.tabPane.setSide(Side.BOTTOM);
        this.tabPane.getSelectionModel().selectedItemProperty().addListener((ChangeListener)this.tabSelectionChangeListener);
    }

    private Tab createTab(String name, String tooltip, TabType type, Node node) {
        Tab tab = new Tab(name, node);
        tab.setClosable(false);
        tab.setTooltip(new Tooltip(tooltip));
        tab.setUserData((Object)type);
        this.tapMap.put((Object)type, (Object)tab);
        return tab;
    }

    private Node getNode(TabType tabType) {
        if (this.lastTreeItemValue == null || tabType == null) {
            return null;
        }
        TableView<VarianceComponentRow> node = null;
        TreeItemType treeItemType = this.lastTreeItemValue.getItemType();
        block0 : switch (treeItemType) {
            case ROOT: {
                if (tabType == TabType.META_DATA) {
                    node = UIMetaDataPaneBuilder.getInstance().getNode();
                    break;
                }
                if (tabType == TabType.RESULT_DATA) {
                    node = UIGlobalResultPaneBuilder.getInstance().getNode();
                    break;
                }
                if (tabType != TabType.GRAPHIC) break;
                final UIGraphicPaneBuilder graphicPaneBuilder = UIGraphicPaneBuilder.getInstance();
                node = graphicPaneBuilder.getPane();
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        graphicPaneBuilder.getLayerManager().redraw();
                    }
                });
                break;
            }
            case REFERENCE_POINT_1D_LEAF: 
            case STOCHASTIC_POINT_1D_LEAF: 
            case DATUM_POINT_1D_LEAF: 
            case NEW_POINT_1D_LEAF: 
            case REFERENCE_POINT_2D_LEAF: 
            case STOCHASTIC_POINT_2D_LEAF: 
            case DATUM_POINT_2D_LEAF: 
            case NEW_POINT_2D_LEAF: 
            case REFERENCE_POINT_3D_LEAF: 
            case STOCHASTIC_POINT_3D_LEAF: 
            case DATUM_POINT_3D_LEAF: 
            case NEW_POINT_3D_LEAF: {
                PointTreeItemValue pointItemValue = (PointTreeItemValue)this.lastTreeItemValue;
                if (tabType == TabType.RAW_DATA || tabType == TabType.RESULT_DATA || tabType == TabType.RESULT_CONGRUENCE_ANALYSIS) {
                    TableView<PointRow> pointTableView = this.pointTableBuilder.getTable(pointItemValue);
                    this.setTableColumnView(tabType, pointTableView);
                    node = pointTableView;
                    break;
                }
                if (tabType == TabType.PROPERTIES) {
                    UIPointPropertiesPaneBuilder pointPropertiesBuilder = UIPointPropertiesPaneBuilder.getInstance();
                    node = pointPropertiesBuilder.getPointPropertiesPane(pointItemValue.getItemType()).getNode();
                    break;
                }
                if (tabType != TabType.VARIANCE_COMPONENT) break;
                UIVarianceComponentTableBuilder tableBuilder = UIVarianceComponentTableBuilder.getInstance();
                TableView<VarianceComponentRow> table = tableBuilder.getTable(UIVarianceComponentTableBuilder.VarianceComponentDisplayType.SELECTED_GROUP_COMPONENTS);
                this.setTableColumnView(tabType, table);
                node = table;
                break;
            }
            case LEVELING_LEAF: 
            case DIRECTION_LEAF: 
            case HORIZONTAL_DISTANCE_LEAF: 
            case SLOPE_DISTANCE_LEAF: 
            case ZENITH_ANGLE_LEAF: 
            case GNSS_1D_LEAF: 
            case GNSS_2D_LEAF: 
            case GNSS_3D_LEAF: {
                ObservationTreeItemValue observationItemValue = (ObservationTreeItemValue)this.lastTreeItemValue;
                if (tabType == TabType.RAW_DATA || tabType == TabType.RESULT_DATA) {
                    switch (treeItemType) {
                        case LEVELING_LEAF: 
                        case DIRECTION_LEAF: 
                        case HORIZONTAL_DISTANCE_LEAF: 
                        case SLOPE_DISTANCE_LEAF: 
                        case ZENITH_ANGLE_LEAF: {
                            TableView<TerrestrialObservationRow> observationTableView = this.observationTableBuilder.getTable(observationItemValue);
                            this.setTableColumnView(tabType, observationTableView);
                            node = observationTableView;
                            break block0;
                        }
                        case GNSS_1D_LEAF: 
                        case GNSS_2D_LEAF: 
                        case GNSS_3D_LEAF: {
                            TableView<GNSSObservationRow> gnssObservationTableView = this.gnssObservationTableBuilder.getTable(observationItemValue);
                            this.setTableColumnView(tabType, gnssObservationTableView);
                            node = gnssObservationTableView;
                            break block0;
                        }
                    }
                    break;
                }
                if (tabType == TabType.PROPERTIES) {
                    UIObservationPropertiesPaneBuilder terrestrialPropertiesBuilder = UIObservationPropertiesPaneBuilder.getInstance();
                    node = terrestrialPropertiesBuilder.getObservationPropertiesPane(observationItemValue.getItemType()).getNode();
                    break;
                }
                if (tabType == TabType.ADDITIONAL_PARAMETER) {
                    UIAdditionalParameterTableBuilder tableBuilder = UIAdditionalParameterTableBuilder.getInstance();
                    TableView table = tableBuilder.getTable();
                    node = table;
                    break;
                }
                if (tabType != TabType.VARIANCE_COMPONENT) break;
                UIVarianceComponentTableBuilder tableBuilder = UIVarianceComponentTableBuilder.getInstance();
                TableView<VarianceComponentRow> table = tableBuilder.getTable(UIVarianceComponentTableBuilder.VarianceComponentDisplayType.SELECTED_GROUP_COMPONENTS);
                this.setTableColumnView(tabType, table);
                node = table;
                break;
            }
            case CONGRUENCE_ANALYSIS_1D_LEAF: 
            case CONGRUENCE_ANALYSIS_2D_LEAF: 
            case CONGRUENCE_ANALYSIS_3D_LEAF: {
                CongruenceAnalysisTreeItemValue congruenceAnalysisItemValue = (CongruenceAnalysisTreeItemValue)this.lastTreeItemValue;
                if (tabType == TabType.RAW_DATA || tabType == TabType.RESULT_CONGRUENCE_ANALYSIS) {
                    TableView<CongruenceAnalysisRow> congruenceAnalysisTableView = this.congruenceAnalysisTableBuilder.getTable(congruenceAnalysisItemValue);
                    this.setTableColumnView(tabType, congruenceAnalysisTableView);
                    node = congruenceAnalysisTableView;
                    break;
                }
                if (tabType == TabType.PROPERTIES) {
                    UICongruenceAnalysisPropertiesPaneBuilder congruenceAnalysisPropertiesBuilder = UICongruenceAnalysisPropertiesPaneBuilder.getInstance();
                    node = congruenceAnalysisPropertiesBuilder.getCongruenceAnalysisPropertiesPane(congruenceAnalysisItemValue.getItemType()).getNode();
                    break;
                }
                if (tabType != TabType.ADDITIONAL_PARAMETER) break;
                UIAdditionalParameterTableBuilder tableBuilder = UIAdditionalParameterTableBuilder.getInstance();
                TableView table = tableBuilder.getTable();
                node = table;
                break;
            }
            case REFERENCE_VERTICAL_DEFLECTION_LEAF: 
            case STOCHASTIC_VERTICAL_DEFLECTION_LEAF: 
            case UNKNOWN_VERTICAL_DEFLECTION_LEAF: {
                VerticalDeflectionTreeItemValue verticalDeflectionTreeItemValue = (VerticalDeflectionTreeItemValue)this.lastTreeItemValue;
                if (tabType == TabType.RAW_DATA || tabType == TabType.RESULT_DATA) {
                    TableView<VerticalDeflectionRow> verticalDeflectionTableView = this.verticalDeflectionTableBuilder.getTable(verticalDeflectionTreeItemValue);
                    this.setTableColumnView(tabType, verticalDeflectionTableView);
                    node = verticalDeflectionTableView;
                    break;
                }
                if (tabType == TabType.PROPERTIES) {
                    UIVerticalDeflectionPropertiesPaneBuilder verticalDeflectionPropertiesPaneBuilder = UIVerticalDeflectionPropertiesPaneBuilder.getInstance();
                    node = verticalDeflectionPropertiesPaneBuilder.getVerticalDeflectionPropertiesPane(verticalDeflectionTreeItemValue.getItemType()).getNode();
                    break;
                }
                if (tabType != TabType.VARIANCE_COMPONENT) break;
                UIVarianceComponentTableBuilder tableBuilder = UIVarianceComponentTableBuilder.getInstance();
                TableView<VarianceComponentRow> table = tableBuilder.getTable(UIVarianceComponentTableBuilder.VarianceComponentDisplayType.SELECTED_GROUP_COMPONENTS);
                this.setTableColumnView(tabType, table);
                node = table;
                break;
            }
            default: {
                node = null;
            }
        }
        return node;
    }

    private void setTableColumnView(TabType tabType, TableView<? extends Row> tableView) {
        int columnCount = tableView.getColumns().size();
        int columnIndex = 0;
        while (columnIndex < columnCount) {
            TableColumn column = (TableColumn)tableView.getColumns().get(columnIndex);
            if (column.getUserData() instanceof ColumnType) {
                ColumnType columnType = (ColumnType)((Object)column.getUserData());
                switch (columnType) {
                    case VISIBLE: {
                        column.setVisible(true);
                        break;
                    }
                    case HIDDEN: {
                        column.setVisible(false);
                        break;
                    }
                    case APRIORI_TERRESTRIAL_OBSERVATION: 
                    case APRIORI_GNSS_OBSERVATION: 
                    case APRIORI_POINT: 
                    case APRIORI_DEFLECTION: 
                    case APRIORI_POINT_CONGRUENCE: {
                        column.setVisible(tabType == TabType.RAW_DATA);
                        break;
                    }
                    case APOSTERIORI_TERRESTRIAL_OBSERVATION: 
                    case APOSTERIORI_GNSS_OBSERVATION: 
                    case APOSTERIORI_POINT: 
                    case APOSTERIORI_DEFLECTION: {
                        column.setVisible(tabType == TabType.RESULT_DATA);
                        break;
                    }
                    case APOSTERIORI_POINT_CONGRUENCE: {
                        column.setVisible(tabType == TabType.RESULT_CONGRUENCE_ANALYSIS);
                        break;
                    }
                }
            }
            ++columnIndex;
        }
    }

    public void setTreeItemValue(TreeItemValue treeItemValue) {
        SingleSelectionModel selectionModel = this.tabPane.getSelectionModel();
        this.lastSelectedTab = this.lastSelectedTab != null ? this.lastSelectedTab : (Tab)selectionModel.getSelectedItem();
        selectionModel.clearSelection();
        this.lastTreeItemValue = treeItemValue;
        if (this.tabPane != null && treeItemValue != null) {
            TabType[] newTabTypes = treeItemValue.getTabTypes();
            if (newTabTypes != null && newTabTypes.length > 0) {
                boolean equalTabOrderAndTypes;
                Tab selectedTab = null;
                ObservableList oldTabList = this.tabPane.getTabs();
                boolean bl = equalTabOrderAndTypes = oldTabList.size() == newTabTypes.length;
                if (equalTabOrderAndTypes) {
                    int idx = 0;
                    while (idx < newTabTypes.length) {
                        Tab tab = (Tab)oldTabList.get(idx);
                        if (tab.getUserData() == null || tab.getUserData() != newTabTypes[idx]) {
                            equalTabOrderAndTypes = false;
                            break;
                        }
                        ++idx;
                    }
                }
                if (!equalTabOrderAndTypes) {
                    ObservableList newTabList = FXCollections.observableArrayList();
                    this.tabPane.getTabs().clear();
                    TabType[] tabTypeArray = newTabTypes;
                    int n = newTabTypes.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TabType tabType = tabTypeArray[n2];
                        if (this.tapMap.containsKey((Object)tabType)) {
                            newTabList.add((Object)((Tab)this.tapMap.get((Object)tabType)));
                            if (this.lastSelectedTab != null && this.lastSelectedTab.getUserData() == tabType) {
                                selectedTab = (Tab)this.tapMap.get((Object)tabType);
                            }
                        }
                        ++n2;
                    }
                    this.tabPane.getTabs().setAll((Collection)newTabList);
                } else {
                    boolean validLastSelectedTabType = false;
                    TabType[] tabTypeArray = newTabTypes;
                    int n = newTabTypes.length;
                    int n3 = 0;
                    while (n3 < n) {
                        TabType newType = tabTypeArray[n3];
                        if (this.lastSelectedTab.getUserData() == newType) {
                            validLastSelectedTabType = true;
                            break;
                        }
                        ++n3;
                    }
                    Tab tab = selectedTab = validLastSelectedTabType ? this.lastSelectedTab : null;
                }
                if (selectedTab == null && this.tabPane.getTabs().size() > 0) {
                    selectedTab = (Tab)this.tabPane.getTabs().get(0);
                }
                selectionModel.select((Object)selectedTab);
            } else {
                this.tabPane.getTabs().clear();
            }
        }
    }

    private class TabSelectionChangeListener
    implements ChangeListener<Tab> {
        private TabSelectionChangeListener() {
        }

        public void changed(ObservableValue<? extends Tab> observable, Tab oldTab, Tab newTab) {
            Tab tab = UITabPaneBuilder.this.lastSelectedTab = newTab == null ? UITabPaneBuilder.this.lastSelectedTab : newTab;
            if (oldTab != null) {
                oldTab.setContent(null);
            }
            if (newTab != null && newTab.getUserData() instanceof TabType) {
                TabType tabType = (TabType)((Object)newTab.getUserData());
                newTab.setContent(UITabPaneBuilder.this.getNode(tabType));
            }
        }
    }
}

