/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.jag3d.ui.table.rowhighlight;

import java.util.HashMap;
import java.util.Map;
import javafx.scene.paint.Color;
import org.applied_geodesy.jag3d.ui.table.UICongruenceAnalysisTableBuilder;
import org.applied_geodesy.jag3d.ui.table.UIGNSSObservationTableBuilder;
import org.applied_geodesy.jag3d.ui.table.UIPointTableBuilder;
import org.applied_geodesy.jag3d.ui.table.UITerrestrialObservationTableBuilder;
import org.applied_geodesy.jag3d.ui.table.UIVerticalDeflectionTableBuilder;
import org.applied_geodesy.jag3d.ui.table.rowhighlight.DefaultTableRowHighlightValue;
import org.applied_geodesy.jag3d.ui.table.rowhighlight.TableRowHighlightRangeType;
import org.applied_geodesy.jag3d.ui.table.rowhighlight.TableRowHighlightType;

public class TableRowHighlight {
    private static TableRowHighlight tableRowHighlight = new TableRowHighlight();
    private Color excellentColor = DefaultTableRowHighlightValue.getExcellentColor();
    private Color satisfactoryColor = DefaultTableRowHighlightValue.getSatisfactoryColor();
    private Color inadequateColor = DefaultTableRowHighlightValue.getInadequateColor();
    private Map<TableRowHighlightType, Double> leftBoundaries = new HashMap<TableRowHighlightType, Double>(TableRowHighlightType.values().length);
    private Map<TableRowHighlightType, Double> rightBoundaries = new HashMap<TableRowHighlightType, Double>(TableRowHighlightType.values().length);
    private TableRowHighlightType tableRowHighlightType = TableRowHighlightType.NONE;

    private TableRowHighlight() {
        TableRowHighlightType[] tableRowHighlightTypeArray = TableRowHighlightType.values();
        int n = tableRowHighlightTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableRowHighlightType tableRowHighlightType = tableRowHighlightTypeArray[n2];
            double[] range = DefaultTableRowHighlightValue.getRange(tableRowHighlightType);
            if (range != null && range.length >= 2) {
                this.setRange(tableRowHighlightType, range[0], range[1]);
            }
            ++n2;
        }
    }

    public static TableRowHighlight getInstance() {
        return tableRowHighlight;
    }

    public void setSelectedTableRowHighlightType(TableRowHighlightType tableRowHighlightType) {
        this.tableRowHighlightType = tableRowHighlightType;
    }

    public void setRange(TableRowHighlightType tableRowHighlightType, double leftBoundary, double rightBoundary) {
        double left = Math.min(leftBoundary, rightBoundary);
        double right = Math.max(leftBoundary, rightBoundary);
        this.leftBoundaries.put(tableRowHighlightType, left);
        this.rightBoundaries.put(tableRowHighlightType, right);
    }

    public double getLeftBoundary(TableRowHighlightType tableRowHighlightType) {
        return this.leftBoundaries.containsKey((Object)tableRowHighlightType) ? this.leftBoundaries.get((Object)tableRowHighlightType) : Double.NEGATIVE_INFINITY;
    }

    public double getRightBoundary(TableRowHighlightType tableRowHighlightType) {
        return this.rightBoundaries.containsKey((Object)tableRowHighlightType) ? this.rightBoundaries.get((Object)tableRowHighlightType) : Double.POSITIVE_INFINITY;
    }

    public TableRowHighlightType getSelectedTableRowHighlightType() {
        return this.tableRowHighlightType;
    }

    public void setColor(TableRowHighlightRangeType type, Color color) {
        switch (type) {
            case EXCELLENT: {
                this.excellentColor = color;
                break;
            }
            case SATISFACTORY: {
                this.satisfactoryColor = color;
                break;
            }
            case INADEQUATE: {
                this.inadequateColor = color;
                break;
            }
        }
    }

    public Color getColor(TableRowHighlightRangeType type) {
        switch (type) {
            case EXCELLENT: {
                return this.excellentColor;
            }
            case SATISFACTORY: {
                return this.satisfactoryColor;
            }
            case INADEQUATE: {
                return this.inadequateColor;
            }
            case NONE: {
                return Color.TRANSPARENT;
            }
        }
        return Color.TRANSPARENT;
    }

    public void refreshTables() {
        UITerrestrialObservationTableBuilder.getInstance().refreshTable();
        UIGNSSObservationTableBuilder.getInstance().refreshTable();
        UIPointTableBuilder.getInstance().refreshTable();
        UICongruenceAnalysisTableBuilder.getInstance().refreshTable();
        UIVerticalDeflectionTableBuilder.getInstance().refreshTable();
    }

    public String toString() {
        return "TableRowHighlight [excellentColor=" + String.valueOf(this.excellentColor) + ", satisfactoryColor=" + String.valueOf(this.satisfactoryColor) + ", inadequateColor=" + String.valueOf(this.inadequateColor) + ", leftBoundaries=" + String.valueOf(this.leftBoundaries) + ", rightBoundaries=" + String.valueOf(this.rightBoundaries) + ", tableRowHighlightType=" + String.valueOf((Object)this.tableRowHighlightType) + "]";
    }
}

