/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.jag3d.ui.table.rowhighlight;

import java.io.BufferedInputStream;
import java.util.Properties;
import javafx.scene.paint.Color;
import org.applied_geodesy.jag3d.ui.table.rowhighlight.TableRowHighlightRangeType;
import org.applied_geodesy.jag3d.ui.table.rowhighlight.TableRowHighlightType;

public class DefaultTableRowHighlightValue {
    private static final double[] REDUNDANCY = new double[]{0.3, 0.7};
    private static final double[] P_PRIO_VALUE = new double[]{0.01, 0.05};
    private static final double[] INFLUENCE_ON_POSITION = new double[]{0.001, 0.005};
    private static final Color EXCELLENT_COLOR = Color.web((String)"#bcee68");
    private static final Color SATISFACTORY_COLOR = Color.web((String)"#ffec8b");
    private static final Color INADEQUATE_COLOR = Color.web((String)"#ff3030");
    private static final Properties PROPERTIES = new Properties();

    static {
        BufferedInputStream bis = null;
        String path = "properties/tablerowhighlight.default";
        try {
            try {
                if (DefaultTableRowHighlightValue.class.getClassLoader().getResourceAsStream("properties/tablerowhighlight.default") != null) {
                    bis = new BufferedInputStream(DefaultTableRowHighlightValue.class.getClassLoader().getResourceAsStream("properties/tablerowhighlight.default"));
                    PROPERTIES.load(bis);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    if (bis != null) {
                        bis.close();
                    }
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (bis != null) {
                    bis.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private DefaultTableRowHighlightValue() {
    }

    public static Color getExcellentColor() {
        try {
            return Color.web((String)PROPERTIES.getProperty("EXCELLENT_COLOR", "#bcee68"));
        }
        catch (Exception e) {
            return EXCELLENT_COLOR;
        }
    }

    public static Color getSatisfactoryColor() {
        try {
            return Color.web((String)PROPERTIES.getProperty("SATISFACTORY_COLOR", "#ffec8b"));
        }
        catch (Exception e) {
            return SATISFACTORY_COLOR;
        }
    }

    public static Color getInadequateColor() {
        try {
            return Color.web((String)PROPERTIES.getProperty("INADEQUATE_COLOR", "#ff3030"));
        }
        catch (Exception e) {
            return INADEQUATE_COLOR;
        }
    }

    public static double[] getRangeOfRedundancy() {
        double[] dArray;
        double leftBoundary = -1.0;
        double rightBoundary = -1.0;
        try {
            leftBoundary = Double.parseDouble(PROPERTIES.getProperty("REDUNDANCY_LEFT_BOUNDARY"));
            rightBoundary = Double.parseDouble(PROPERTIES.getProperty("REDUNDANCY_RIGHT_BOUNDARY"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (leftBoundary >= 0.0 && rightBoundary >= 0.0 && leftBoundary <= 1.0 && rightBoundary <= 1.0 && leftBoundary < rightBoundary) {
            double[] dArray2 = new double[2];
            dArray2[0] = leftBoundary;
            dArray = dArray2;
            dArray2[1] = rightBoundary;
        } else {
            double[] dArray3 = new double[2];
            dArray3[0] = REDUNDANCY[0];
            dArray = dArray3;
            dArray3[1] = REDUNDANCY[1];
        }
        return dArray;
    }

    public static double[] getRangeOfPprioValue() {
        double[] dArray;
        double leftBoundary = -1.0;
        double rightBoundary = -1.0;
        try {
            leftBoundary = Double.parseDouble(PROPERTIES.getProperty("P_PRIO_VALUE_LEFT_BOUNDARY"));
            rightBoundary = Double.parseDouble(PROPERTIES.getProperty("P_PRIO_VALUE_RIGHT_BOUNDARY"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (leftBoundary > 0.0 && rightBoundary > 0.0 && leftBoundary < 1.0 && rightBoundary < 1.0 && leftBoundary < rightBoundary) {
            double[] dArray2 = new double[2];
            dArray2[0] = leftBoundary;
            dArray = dArray2;
            dArray2[1] = rightBoundary;
        } else {
            double[] dArray3 = new double[2];
            dArray3[0] = P_PRIO_VALUE[0];
            dArray = dArray3;
            dArray3[1] = P_PRIO_VALUE[1];
        }
        return dArray;
    }

    public static double[] getRangeOfInfluenceOnPosition() {
        double[] dArray;
        double leftBoundary = -1.0;
        double rightBoundary = -1.0;
        try {
            leftBoundary = Double.parseDouble(PROPERTIES.getProperty("INFLUENCE_ON_POSITION_LEFT_BOUNDARY"));
            rightBoundary = Double.parseDouble(PROPERTIES.getProperty("INFLUENCE_ON_POSITION_RIGHT_BOUNDARY"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (leftBoundary >= 0.0 && rightBoundary >= 0.0 && leftBoundary <= rightBoundary) {
            double[] dArray2 = new double[2];
            dArray2[0] = leftBoundary;
            dArray = dArray2;
            dArray2[1] = rightBoundary;
        } else {
            double[] dArray3 = new double[2];
            dArray3[0] = INFLUENCE_ON_POSITION[0];
            dArray = dArray3;
            dArray3[1] = INFLUENCE_ON_POSITION[1];
        }
        return dArray;
    }

    public static double[] getRange(TableRowHighlightType type) {
        switch (type) {
            case INFLUENCE_ON_POSITION: {
                return DefaultTableRowHighlightValue.getRangeOfInfluenceOnPosition();
            }
            case P_PRIO_VALUE: {
                return DefaultTableRowHighlightValue.getRangeOfPprioValue();
            }
            case REDUNDANCY: {
                return DefaultTableRowHighlightValue.getRangeOfRedundancy();
            }
            case NONE: 
            case TEST_STATISTIC: 
            case GROSS_ERROR: {
                return null;
            }
        }
        return null;
    }

    public static Color getColor(TableRowHighlightRangeType type) {
        switch (type) {
            case EXCELLENT: {
                return DefaultTableRowHighlightValue.getExcellentColor();
            }
            case SATISFACTORY: {
                return DefaultTableRowHighlightValue.getSatisfactoryColor();
            }
            case INADEQUATE: {
                return DefaultTableRowHighlightValue.getInadequateColor();
            }
            case NONE: {
                return Color.TRANSPARENT;
            }
        }
        return Color.TRANSPARENT;
    }
}

