/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.jag3d.ui.table.row;

import java.util.Locale;
import java.util.Scanner;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import org.applied_geodesy.adjustment.network.ObservationType;
import org.applied_geodesy.jag3d.ui.table.row.ObservationRow;
import org.applied_geodesy.util.FormatterOptions;

public class TerrestrialObservationRow
extends ObservationRow {
    private ObjectProperty<Double> valueApriori = new SimpleObjectProperty((Object)this, "valueApriori", (Object)0.0);
    private ObjectProperty<Double> valueAposteriori = new SimpleObjectProperty((Object)this, "valueAposteriori");
    private ObjectProperty<Double> distanceApriori = new SimpleObjectProperty((Object)this, "distanceApriori");
    private ObjectProperty<Double> instrumentHeight = new SimpleObjectProperty((Object)this, "instrumentHeight", (Object)0.0);
    private ObjectProperty<Double> reflectorHeight = new SimpleObjectProperty((Object)this, "reflectorHeight", (Object)0.0);
    private ObjectProperty<Double> sigmaApriori = new SimpleObjectProperty((Object)this, "sigmaApriori");
    private ObjectProperty<Double> sigmaAposteriori = new SimpleObjectProperty((Object)this, "sigmaAposteriori");
    private ObjectProperty<Double> residual = new SimpleObjectProperty((Object)this, "residual");
    private ObjectProperty<Double> redundancy = new SimpleObjectProperty((Object)this, "redundancy");
    private ObjectProperty<Double> grossError = new SimpleObjectProperty((Object)this, "grossError");
    private ObjectProperty<Double> influenceOnPointPosition = new SimpleObjectProperty((Object)this, "influenceOnPointPosition");
    private ObjectProperty<Double> minimalDetectableBias = new SimpleObjectProperty((Object)this, "minimalDetectableBias");
    private ObjectProperty<Double> maximumTolerableBias = new SimpleObjectProperty((Object)this, "maximumTolerableBias");

    public ObjectProperty<Double> valueAprioriProperty() {
        return this.valueApriori;
    }

    public Double getValueApriori() {
        return (Double)this.valueAprioriProperty().get();
    }

    public void setValueApriori(Double valueApriori) {
        this.valueAprioriProperty().set((Object)valueApriori);
    }

    public ObjectProperty<Double> valueAposterioriProperty() {
        return this.valueAposteriori;
    }

    public Double getValueAposteriori() {
        return (Double)this.valueAposterioriProperty().get();
    }

    public void setValueAposteriori(Double valueAposteriori) {
        this.valueAposterioriProperty().set((Object)valueAposteriori);
    }

    public ObjectProperty<Double> distanceAprioriProperty() {
        return this.distanceApriori;
    }

    public Double getDistanceApriori() {
        return (Double)this.distanceAprioriProperty().get();
    }

    public void setDistanceApriori(Double distanceApriori) {
        this.distanceAprioriProperty().set((Object)distanceApriori);
    }

    public ObjectProperty<Double> instrumentHeightProperty() {
        return this.instrumentHeight;
    }

    public Double getInstrumentHeight() {
        return (Double)this.instrumentHeightProperty().get();
    }

    public void setInstrumentHeight(Double instrumentHeight) {
        this.instrumentHeightProperty().set((Object)instrumentHeight);
    }

    public ObjectProperty<Double> reflectorHeightProperty() {
        return this.reflectorHeight;
    }

    public Double getReflectorHeight() {
        return (Double)this.reflectorHeightProperty().get();
    }

    public void setReflectorHeight(Double reflectorHeight) {
        this.reflectorHeightProperty().set((Object)reflectorHeight);
    }

    public ObjectProperty<Double> sigmaAprioriProperty() {
        return this.sigmaApriori;
    }

    public Double getSigmaApriori() {
        return (Double)this.sigmaAprioriProperty().get();
    }

    public void setSigmaApriori(Double sigmaApriori) {
        this.sigmaAprioriProperty().set((Object)sigmaApriori);
    }

    public ObjectProperty<Double> sigmaAposterioriProperty() {
        return this.sigmaAposteriori;
    }

    public Double getSigmaAposteriori() {
        return (Double)this.sigmaAposterioriProperty().get();
    }

    public void setSigmaAposteriori(Double sigmaAposteriori) {
        this.sigmaAposterioriProperty().set((Object)sigmaAposteriori);
    }

    public final ObjectProperty<Double> residualProperty() {
        return this.residual;
    }

    public final Double getResidual() {
        return (Double)this.residualProperty().get();
    }

    public final void setResidual(Double residual) {
        this.residualProperty().set((Object)residual);
    }

    public ObjectProperty<Double> redundancyProperty() {
        return this.redundancy;
    }

    public Double getRedundancy() {
        return (Double)this.redundancyProperty().get();
    }

    public void setRedundancy(Double redundancy) {
        this.redundancyProperty().set((Object)redundancy);
    }

    public ObjectProperty<Double> grossErrorProperty() {
        return this.grossError;
    }

    public Double getGrossError() {
        return (Double)this.grossErrorProperty().get();
    }

    public void setGrossError(Double nabla) {
        this.grossErrorProperty().set((Object)nabla);
    }

    public ObjectProperty<Double> influenceOnPointPositionProperty() {
        return this.influenceOnPointPosition;
    }

    public Double getInfluenceOnPointPosition() {
        return (Double)this.influenceOnPointPositionProperty().get();
    }

    public void setInfluenceOnPointPosition(Double influenceOnPointPosition) {
        this.influenceOnPointPositionProperty().set((Object)influenceOnPointPosition);
    }

    public ObjectProperty<Double> minimalDetectableBiasProperty() {
        return this.minimalDetectableBias;
    }

    public Double getMinimalDetectableBias() {
        return (Double)this.minimalDetectableBiasProperty().get();
    }

    public void setMinimalDetectableBias(Double minimalDetectableBias) {
        this.minimalDetectableBiasProperty().set((Object)minimalDetectableBias);
    }

    public ObjectProperty<Double> maximumTolerableBiasProperty() {
        return this.maximumTolerableBias;
    }

    public Double getMaximumTolerableBias() {
        return (Double)this.maximumTolerableBiasProperty().get();
    }

    public void setMaximumTolerableBias(Double maximumTolerableBias) {
        this.maximumTolerableBiasProperty().set((Object)maximumTolerableBias);
    }

    public static TerrestrialObservationRow cloneRowApriori(TerrestrialObservationRow row) {
        TerrestrialObservationRow clone = new TerrestrialObservationRow();
        clone.setId(-1);
        clone.setGroupId(row.getGroupId());
        clone.setEnable(row.isEnable());
        clone.setStartPointName(row.getStartPointName());
        clone.setEndPointName(row.getEndPointName());
        clone.setInstrumentHeight(row.getInstrumentHeight());
        clone.setReflectorHeight(row.getReflectorHeight());
        clone.setValueApriori(row.getValueApriori());
        clone.setSigmaApriori(row.getSigmaApriori());
        clone.setDistanceApriori(row.getDistanceApriori());
        return clone;
    }

    public static TerrestrialObservationRow scan(String str, ObservationType type) {
        FormatterOptions options = FormatterOptions.getInstance();
        try (Scanner scanner = new Scanner(str.trim());){
            scanner.useLocale(Locale.ENGLISH);
            double ih = 0.0;
            double th = 0.0;
            double value = 0.0;
            double sigma = 0.0;
            double distance = 0.0;
            TerrestrialObservationRow row = new TerrestrialObservationRow();
            if (!scanner.hasNext()) {
                return null;
            }
            String startPointName = scanner.next();
            if (!scanner.hasNext()) {
                return null;
            }
            String endPointName = scanner.next();
            if (startPointName.equals(endPointName)) {
                return null;
            }
            row.setStartPointName(startPointName);
            row.setEndPointName(endPointName);
            if (!scanner.hasNextDouble()) {
                return null;
            }
            ih = value = scanner.nextDouble();
            ih = options.convertLengthToModel(ih);
            switch (type) {
                case DIRECTION: 
                case ZENITH_ANGLE: {
                    value = options.convertAngleToModel(value);
                    break;
                }
                default: {
                    value = options.convertLengthToModel(value);
                }
            }
            row.setValueApriori(value);
            if (type == ObservationType.HORIZONTAL_DISTANCE || type == ObservationType.SLOPE_DISTANCE) {
                row.setDistanceApriori(value);
            }
            if (!scanner.hasNextDouble()) {
                TerrestrialObservationRow terrestrialObservationRow = row;
                return terrestrialObservationRow;
            }
            sigma = distance = scanner.nextDouble();
            th = distance;
            th = options.convertLengthToModel(th);
            distance = options.convertLengthToModel(distance);
            switch (type) {
                case DIRECTION: 
                case ZENITH_ANGLE: {
                    sigma = options.convertAngleToModel(sigma);
                    break;
                }
                default: {
                    sigma = options.convertLengthToModel(sigma);
                }
            }
            if (distance < 1.0) {
                row.setSigmaApriori(sigma);
                if (type != ObservationType.HORIZONTAL_DISTANCE && type != ObservationType.SLOPE_DISTANCE) {
                    row.setDistanceApriori(null);
                } else {
                    row.setDistanceApriori(value);
                }
            } else {
                row.setSigmaApriori(null);
                if (type != ObservationType.HORIZONTAL_DISTANCE && type != ObservationType.SLOPE_DISTANCE) {
                    row.setDistanceApriori(distance);
                }
            }
            if (!scanner.hasNextDouble()) {
                TerrestrialObservationRow terrestrialObservationRow = row;
                return terrestrialObservationRow;
            }
            value = scanner.nextDouble();
            switch (type) {
                case DIRECTION: 
                case ZENITH_ANGLE: {
                    value = options.convertAngleToModel(value);
                    break;
                }
                default: {
                    value = options.convertLengthToModel(value);
                }
            }
            row.setInstrumentHeight(ih);
            row.setReflectorHeight(th);
            row.setValueApriori(value);
            row.setSigmaApriori(null);
            if (type != ObservationType.HORIZONTAL_DISTANCE && type != ObservationType.SLOPE_DISTANCE) {
                row.setDistanceApriori(null);
            } else {
                row.setDistanceApriori(value);
            }
            if (!scanner.hasNextDouble()) {
                TerrestrialObservationRow terrestrialObservationRow = row;
                return terrestrialObservationRow;
            }
            sigma = distance = scanner.nextDouble();
            distance = options.convertLengthToModel(distance);
            switch (type) {
                case DIRECTION: 
                case ZENITH_ANGLE: {
                    sigma = options.convertAngleToModel(sigma);
                    break;
                }
                default: {
                    sigma = options.convertLengthToModel(sigma);
                }
            }
            if (distance < 1.0) {
                row.setSigmaApriori(sigma);
                if (type != ObservationType.HORIZONTAL_DISTANCE && type != ObservationType.SLOPE_DISTANCE) {
                    row.setDistanceApriori(null);
                } else {
                    row.setDistanceApriori(value);
                }
            } else {
                row.setSigmaApriori(null);
                if (type != ObservationType.HORIZONTAL_DISTANCE && type != ObservationType.SLOPE_DISTANCE) {
                    row.setDistanceApriori(distance);
                }
            }
            TerrestrialObservationRow terrestrialObservationRow = row;
            return terrestrialObservationRow;
        }
    }
}

