/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.jag3d.ui.table.row;

import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import org.applied_geodesy.jag3d.ui.table.row.GroupRow;
import org.applied_geodesy.util.FormatterOptions;

public class PointRow
extends GroupRow {
    private ObjectProperty<String> name = new SimpleObjectProperty((Object)this, "name");
    private ObjectProperty<String> code = new SimpleObjectProperty((Object)this, "code", (Object)"0");
    private ObjectProperty<Double> xApriori = new SimpleObjectProperty((Object)this, "xApriori", (Object)0.0);
    private ObjectProperty<Double> yApriori = new SimpleObjectProperty((Object)this, "yApriori", (Object)0.0);
    private ObjectProperty<Double> zApriori = new SimpleObjectProperty((Object)this, "zApriori", (Object)0.0);
    private ObjectProperty<Double> sigmaXapriori = new SimpleObjectProperty((Object)this, "sigmaXapriori");
    private ObjectProperty<Double> sigmaYapriori = new SimpleObjectProperty((Object)this, "sigmaYapriori");
    private ObjectProperty<Double> sigmaZapriori = new SimpleObjectProperty((Object)this, "sigmaZapriori");
    private ObjectProperty<Double> xAposteriori = new SimpleObjectProperty((Object)this, "xAposteriori");
    private ObjectProperty<Double> yAposteriori = new SimpleObjectProperty((Object)this, "yAposteriori");
    private ObjectProperty<Double> zAposteriori = new SimpleObjectProperty((Object)this, "zAposteriori");
    private ObjectProperty<Double> sigmaXaposteriori = new SimpleObjectProperty((Object)this, "sigmaXaposteriori");
    private ObjectProperty<Double> sigmaYaposteriori = new SimpleObjectProperty((Object)this, "sigmaYaposteriori");
    private ObjectProperty<Double> sigmaZaposteriori = new SimpleObjectProperty((Object)this, "sigmaZaposteriori");
    private ObjectProperty<Double> minimalDetectableBiasX = new SimpleObjectProperty((Object)this, "minimalDetectableBiasX");
    private ObjectProperty<Double> minimalDetectableBiasY = new SimpleObjectProperty((Object)this, "minimalDetectableBiasY");
    private ObjectProperty<Double> minimalDetectableBiasZ = new SimpleObjectProperty((Object)this, "minimalDetectableBiasZ");
    private ObjectProperty<Double> maximumTolerableBiasX = new SimpleObjectProperty((Object)this, "maximumTolerableBiasX");
    private ObjectProperty<Double> maximumTolerableBiasY = new SimpleObjectProperty((Object)this, "maximumTolerableBiasY");
    private ObjectProperty<Double> maximumTolerableBiasZ = new SimpleObjectProperty((Object)this, "maximumTolerableBiasZ");
    private ObjectProperty<Double> residualX = new SimpleObjectProperty((Object)this, "residualX");
    private ObjectProperty<Double> residualY = new SimpleObjectProperty((Object)this, "residualY");
    private ObjectProperty<Double> residualZ = new SimpleObjectProperty((Object)this, "residualZ");
    private ObjectProperty<Double> redundancyX = new SimpleObjectProperty((Object)this, "redundancyX");
    private ObjectProperty<Double> redundancyY = new SimpleObjectProperty((Object)this, "redundancyY");
    private ObjectProperty<Double> redundancyZ = new SimpleObjectProperty((Object)this, "redundancyZ");
    private ObjectProperty<Double> grossErrorX = new SimpleObjectProperty((Object)this, "grossErrorX");
    private ObjectProperty<Double> grossErrorY = new SimpleObjectProperty((Object)this, "grossErrorY");
    private ObjectProperty<Double> grossErrorZ = new SimpleObjectProperty((Object)this, "grossErrorZ");
    private ObjectProperty<Double> omega = new SimpleObjectProperty((Object)this, "omega");
    private ObjectProperty<Double> testStatisticApriori = new SimpleObjectProperty((Object)this, "testStatisticApriori");
    private ObjectProperty<Double> testStatisticAposteriori = new SimpleObjectProperty((Object)this, "testStatisticAposteriori");
    private ObjectProperty<Double> pValueApriori = new SimpleObjectProperty((Object)this, "pValueApriori");
    private ObjectProperty<Double> pValueAposteriori = new SimpleObjectProperty((Object)this, "pValueAposteriori");
    private ObjectProperty<Double> confidenceA = new SimpleObjectProperty((Object)this, "confidenceA");
    private ObjectProperty<Double> confidenceB = new SimpleObjectProperty((Object)this, "confidenceB");
    private ObjectProperty<Double> confidenceC = new SimpleObjectProperty((Object)this, "confidenceC");
    private ObjectProperty<Double> confidenceAlpha = new SimpleObjectProperty((Object)this, "confidenceAlpha");
    private ObjectProperty<Double> confidenceBeta = new SimpleObjectProperty((Object)this, "confidenceBeta");
    private ObjectProperty<Double> confidenceGamma = new SimpleObjectProperty((Object)this, "confidenceGamma");
    private BooleanProperty significant = new SimpleBooleanProperty((Object)this, "significant", Boolean.FALSE.booleanValue());
    private BooleanProperty enable = new SimpleBooleanProperty((Object)this, "enable", Boolean.TRUE.booleanValue());
    private ObjectProperty<Double> firstPrincipalComponentX = new SimpleObjectProperty((Object)this, "firstPrincipalComponentX");
    private ObjectProperty<Double> firstPrincipalComponentY = new SimpleObjectProperty((Object)this, "firstPrincipalComponentY");
    private ObjectProperty<Double> firstPrincipalComponentZ = new SimpleObjectProperty((Object)this, "firstPrincipalComponentZ");
    private ObjectProperty<Double> influenceOnPointPositionX = new SimpleObjectProperty((Object)this, "influenceOnPointPositionX");
    private ObjectProperty<Double> influenceOnPointPositionY = new SimpleObjectProperty((Object)this, "influenceOnPointPositionY");
    private ObjectProperty<Double> influenceOnPointPositionZ = new SimpleObjectProperty((Object)this, "influenceOnPointPositionZ");
    private ObjectProperty<Double> influenceOnNetworkDistortion = new SimpleObjectProperty((Object)this, "influenceOnNetworkDistortion");
    private ObjectProperty<Integer> numberOfObservations = new SimpleObjectProperty((Object)this, "numberOfObservations", (Object)0);

    public BooleanProperty enableProperty() {
        return this.enable;
    }

    public Boolean isEnable() {
        return this.enableProperty().get();
    }

    public void setEnable(Boolean enable) {
        this.enableProperty().set(enable.booleanValue());
    }

    public ObjectProperty<String> nameProperty() {
        return this.name;
    }

    public String getName() {
        return (String)this.nameProperty().get();
    }

    public void setName(String name) {
        this.nameProperty().set((Object)name);
    }

    public ObjectProperty<String> codeProperty() {
        return this.code;
    }

    public String getCode() {
        return (String)this.codeProperty().get();
    }

    public void setCode(String code) {
        this.codeProperty().set((Object)code);
    }

    public ObjectProperty<Double> xAprioriProperty() {
        return this.xApriori;
    }

    public Double getXApriori() {
        return (Double)this.xAprioriProperty().get();
    }

    public void setXApriori(Double xApriori) {
        this.xAprioriProperty().set((Object)xApriori);
    }

    public ObjectProperty<Double> yAprioriProperty() {
        return this.yApriori;
    }

    public Double getYApriori() {
        return (Double)this.yAprioriProperty().get();
    }

    public void setYApriori(Double yApriori) {
        this.yAprioriProperty().set((Object)yApriori);
    }

    public ObjectProperty<Double> zAprioriProperty() {
        return this.zApriori;
    }

    public Double getZApriori() {
        return (Double)this.zAprioriProperty().get();
    }

    public void setZApriori(Double zApriori) {
        this.zAprioriProperty().set((Object)zApriori);
    }

    public ObjectProperty<Double> sigmaXaprioriProperty() {
        return this.sigmaXapriori;
    }

    public Double getSigmaXapriori() {
        return (Double)this.sigmaXaprioriProperty().get();
    }

    public void setSigmaXapriori(Double sigmaXapriori) {
        this.sigmaXaprioriProperty().set((Object)sigmaXapriori);
    }

    public ObjectProperty<Double> sigmaYaprioriProperty() {
        return this.sigmaYapriori;
    }

    public Double getSigmaYapriori() {
        return (Double)this.sigmaYaprioriProperty().get();
    }

    public void setSigmaYapriori(Double sigmaYapriori) {
        this.sigmaYaprioriProperty().set((Object)sigmaYapriori);
    }

    public ObjectProperty<Double> sigmaZaprioriProperty() {
        return this.sigmaZapriori;
    }

    public Double getSigmaZapriori() {
        return (Double)this.sigmaZaprioriProperty().get();
    }

    public void setSigmaZapriori(Double sigmaZapriori) {
        this.sigmaZaprioriProperty().set((Object)sigmaZapriori);
    }

    public ObjectProperty<Double> xAposterioriProperty() {
        return this.xAposteriori;
    }

    public Double getXAposteriori() {
        return (Double)this.xAposterioriProperty().get();
    }

    public void setXAposteriori(Double xAposteriori) {
        this.xAposterioriProperty().set((Object)xAposteriori);
    }

    public ObjectProperty<Double> yAposterioriProperty() {
        return this.yAposteriori;
    }

    public Double getYAposteriori() {
        return (Double)this.yAposterioriProperty().get();
    }

    public void setYAposteriori(Double yAposteriori) {
        this.yAposterioriProperty().set((Object)yAposteriori);
    }

    public ObjectProperty<Double> zAposterioriProperty() {
        return this.zAposteriori;
    }

    public Double getZAposteriori() {
        return (Double)this.zAposterioriProperty().get();
    }

    public void setZAposteriori(Double zAposteriori) {
        this.zAposterioriProperty().set((Object)zAposteriori);
    }

    public ObjectProperty<Double> sigmaXaposterioriProperty() {
        return this.sigmaXaposteriori;
    }

    public Double getSigmaXaposteriori() {
        return (Double)this.sigmaXaposterioriProperty().get();
    }

    public void setSigmaXaposteriori(Double sigmaXaposteriori) {
        this.sigmaXaposterioriProperty().set((Object)sigmaXaposteriori);
    }

    public ObjectProperty<Double> sigmaYaposterioriProperty() {
        return this.sigmaYaposteriori;
    }

    public Double getSigmaYaposteriori() {
        return (Double)this.sigmaYaposterioriProperty().get();
    }

    public void setSigmaYaposteriori(Double sigmaYaposteriori) {
        this.sigmaYaposterioriProperty().set((Object)sigmaYaposteriori);
    }

    public ObjectProperty<Double> sigmaZaposterioriProperty() {
        return this.sigmaZaposteriori;
    }

    public Double getSigmaZaposteriori() {
        return (Double)this.sigmaZaposterioriProperty().get();
    }

    public void setSigmaZaposteriori(Double sigmaZaposteriori) {
        this.sigmaZaposterioriProperty().set((Object)sigmaZaposteriori);
    }

    public ObjectProperty<Double> minimalDetectableBiasXProperty() {
        return this.minimalDetectableBiasX;
    }

    public Double getMinimalDetectableBiasX() {
        return (Double)this.minimalDetectableBiasXProperty().get();
    }

    public void setMinimalDetectableBiasX(Double minimalDetectableBiasX) {
        this.minimalDetectableBiasXProperty().set((Object)minimalDetectableBiasX);
    }

    public ObjectProperty<Double> minimalDetectableBiasYProperty() {
        return this.minimalDetectableBiasY;
    }

    public Double getMinimalDetectableBiasY() {
        return (Double)this.minimalDetectableBiasYProperty().get();
    }

    public void setMinimalDetectableBiasY(Double minimalDetectableBiasY) {
        this.minimalDetectableBiasYProperty().set((Object)minimalDetectableBiasY);
    }

    public ObjectProperty<Double> minimalDetectableBiasZProperty() {
        return this.minimalDetectableBiasZ;
    }

    public Double getMinimalDetectableBiasZ() {
        return (Double)this.minimalDetectableBiasZProperty().get();
    }

    public void setMinimalDetectableBiasZ(Double minimalDetectableBiasZ) {
        this.minimalDetectableBiasZProperty().set((Object)minimalDetectableBiasZ);
    }

    public ObjectProperty<Double> maximumTolerableBiasXProperty() {
        return this.maximumTolerableBiasX;
    }

    public Double getMaximumTolerableBiasX() {
        return (Double)this.maximumTolerableBiasXProperty().get();
    }

    public void setMaximumTolerableBiasX(Double maximumTolerableBiasX) {
        this.maximumTolerableBiasXProperty().set((Object)maximumTolerableBiasX);
    }

    public ObjectProperty<Double> maximumTolerableBiasYProperty() {
        return this.maximumTolerableBiasY;
    }

    public Double getMaximumTolerableBiasY() {
        return (Double)this.maximumTolerableBiasYProperty().get();
    }

    public void setMaximumTolerableBiasY(Double maximumTolerableBiasY) {
        this.maximumTolerableBiasYProperty().set((Object)maximumTolerableBiasY);
    }

    public ObjectProperty<Double> maximumTolerableBiasZProperty() {
        return this.maximumTolerableBiasZ;
    }

    public Double getMaximumTolerableBiasZ() {
        return (Double)this.maximumTolerableBiasZProperty().get();
    }

    public void setMaximumTolerableBiasZ(Double maximumTolerableBiasZ) {
        this.maximumTolerableBiasZProperty().set((Object)maximumTolerableBiasZ);
    }

    public final ObjectProperty<Double> residualXProperty() {
        return this.residualX;
    }

    public final Double getResidualX() {
        return (Double)this.residualXProperty().get();
    }

    public final void setResidualX(Double residualX) {
        this.residualXProperty().set((Object)residualX);
    }

    public final ObjectProperty<Double> residualYProperty() {
        return this.residualY;
    }

    public final Double getResidualY() {
        return (Double)this.residualYProperty().get();
    }

    public final void setResidualY(Double residualY) {
        this.residualYProperty().set((Object)residualY);
    }

    public final ObjectProperty<Double> residualZProperty() {
        return this.residualZ;
    }

    public final Double getResidualZ() {
        return (Double)this.residualZProperty().get();
    }

    public final void setResidualZ(Double residualZ) {
        this.residualZProperty().set((Object)residualZ);
    }

    public ObjectProperty<Double> redundancyXProperty() {
        return this.redundancyX;
    }

    public Double getRedundancyX() {
        return (Double)this.redundancyXProperty().get();
    }

    public void setRedundancyX(Double redundancyX) {
        this.redundancyXProperty().set((Object)redundancyX);
    }

    public ObjectProperty<Double> redundancyYProperty() {
        return this.redundancyY;
    }

    public Double getRedundancyY() {
        return (Double)this.redundancyYProperty().get();
    }

    public void setRedundancyY(Double redundancyY) {
        this.redundancyYProperty().set((Object)redundancyY);
    }

    public ObjectProperty<Double> redundancyZProperty() {
        return this.redundancyZ;
    }

    public Double getRedundancyZ() {
        return (Double)this.redundancyZProperty().get();
    }

    public void setRedundancyZ(Double redundancyZ) {
        this.redundancyZProperty().set((Object)redundancyZ);
    }

    public ObjectProperty<Double> grossErrorXProperty() {
        return this.grossErrorX;
    }

    public Double getGrossErrorX() {
        return (Double)this.grossErrorXProperty().get();
    }

    public void setGrossErrorX(Double nablaX) {
        this.grossErrorXProperty().set((Object)nablaX);
    }

    public ObjectProperty<Double> grossErrorYProperty() {
        return this.grossErrorY;
    }

    public Double getGrossErrorY() {
        return (Double)this.grossErrorYProperty().get();
    }

    public void setGrossErrorY(Double nablaY) {
        this.grossErrorYProperty().set((Object)nablaY);
    }

    public ObjectProperty<Double> grossErrorZProperty() {
        return this.grossErrorZ;
    }

    public Double getGrossErrorZ() {
        return (Double)this.grossErrorZProperty().get();
    }

    public void setGrossErrorZ(Double nablaZ) {
        this.grossErrorZProperty().set((Object)nablaZ);
    }

    public ObjectProperty<Double> omegaProperty() {
        return this.omega;
    }

    public Double getOmega() {
        return (Double)this.omegaProperty().get();
    }

    public void setOmega(Double omega) {
        this.omegaProperty().set((Object)omega);
    }

    public ObjectProperty<Double> testStatisticAprioriProperty() {
        return this.testStatisticApriori;
    }

    public Double getTestStatisticApriori() {
        return (Double)this.testStatisticAprioriProperty().get();
    }

    public void setTestStatisticApriori(Double testStatisticApriori) {
        this.testStatisticAprioriProperty().set((Object)testStatisticApriori);
    }

    public ObjectProperty<Double> testStatisticAposterioriProperty() {
        return this.testStatisticAposteriori;
    }

    public Double getTestStatisticAposteriori() {
        return (Double)this.testStatisticAposterioriProperty().get();
    }

    public void setTestStatisticAposteriori(Double testStatisticAposteriori) {
        this.testStatisticAposterioriProperty().set((Object)testStatisticAposteriori);
    }

    public ObjectProperty<Double> pValueAprioriProperty() {
        return this.pValueApriori;
    }

    public Double getPValueApriori() {
        return (Double)this.pValueAprioriProperty().get();
    }

    public void setPValueApriori(Double pValueApriori) {
        this.pValueAprioriProperty().set((Object)pValueApriori);
    }

    public ObjectProperty<Double> pValueAposterioriProperty() {
        return this.pValueAposteriori;
    }

    public Double getPValueAposteriori() {
        return (Double)this.pValueAposterioriProperty().get();
    }

    public void setPValueAposteriori(Double pValueAposteriori) {
        this.pValueAposterioriProperty().set((Object)pValueAposteriori);
    }

    public ObjectProperty<Double> confidenceAProperty() {
        return this.confidenceA;
    }

    public Double getConfidenceA() {
        return (Double)this.confidenceAProperty().get();
    }

    public void setConfidenceA(Double confidenceA) {
        this.confidenceAProperty().set((Object)confidenceA);
    }

    public ObjectProperty<Double> confidenceBProperty() {
        return this.confidenceB;
    }

    public Double getConfidenceB() {
        return (Double)this.confidenceBProperty().get();
    }

    public void setConfidenceB(Double confidenceB) {
        this.confidenceBProperty().set((Object)confidenceB);
    }

    public ObjectProperty<Double> confidenceCProperty() {
        return this.confidenceC;
    }

    public Double getConfidenceC() {
        return (Double)this.confidenceCProperty().get();
    }

    public void setConfidenceC(Double confidenceC) {
        this.confidenceCProperty().set((Object)confidenceC);
    }

    public ObjectProperty<Double> confidenceAlphaProperty() {
        return this.confidenceAlpha;
    }

    public Double getConfidenceAlpha() {
        return (Double)this.confidenceAlphaProperty().get();
    }

    public void setConfidenceAlpha(Double confidenceAlpha) {
        this.confidenceAlphaProperty().set((Object)confidenceAlpha);
    }

    public ObjectProperty<Double> confidenceBetaProperty() {
        return this.confidenceBeta;
    }

    public Double getConfidenceBeta() {
        return (Double)this.confidenceBetaProperty().get();
    }

    public void setConfidenceBeta(Double confidenceBeta) {
        this.confidenceBetaProperty().set((Object)confidenceBeta);
    }

    public ObjectProperty<Double> confidenceGammaProperty() {
        return this.confidenceGamma;
    }

    public Double getConfidenceGamma() {
        return (Double)this.confidenceGammaProperty().get();
    }

    public void setConfidenceGamma(Double confidenceGamma) {
        this.confidenceGammaProperty().set((Object)confidenceGamma);
    }

    public ObjectProperty<Double> firstPrincipalComponentXProperty() {
        return this.firstPrincipalComponentX;
    }

    public Double getFirstPrincipalComponentX() {
        return (Double)this.firstPrincipalComponentXProperty().get();
    }

    public void setFirstPrincipalComponentX(Double firstPrincipalComponentX) {
        this.firstPrincipalComponentXProperty().set((Object)firstPrincipalComponentX);
    }

    public ObjectProperty<Double> firstPrincipalComponentYProperty() {
        return this.firstPrincipalComponentY;
    }

    public Double getFirstPrincipalComponentY() {
        return (Double)this.firstPrincipalComponentYProperty().get();
    }

    public void setFirstPrincipalComponentY(Double firstPrincipalComponentY) {
        this.firstPrincipalComponentYProperty().set((Object)firstPrincipalComponentY);
    }

    public ObjectProperty<Double> firstPrincipalComponentZProperty() {
        return this.firstPrincipalComponentZ;
    }

    public Double getFirstPrincipalComponentZ() {
        return (Double)this.firstPrincipalComponentZProperty().get();
    }

    public void setFirstPrincipalComponentZ(Double firstPrincipalComponentZ) {
        this.firstPrincipalComponentZProperty().set((Object)firstPrincipalComponentZ);
    }

    public ObjectProperty<Double> influenceOnPointPositionXProperty() {
        return this.influenceOnPointPositionX;
    }

    public Double getInfluenceOnPointPositionX() {
        return (Double)this.influenceOnPointPositionXProperty().get();
    }

    public void setInfluenceOnPointPositionX(Double influenceOnPointPositionX) {
        this.influenceOnPointPositionXProperty().set((Object)influenceOnPointPositionX);
    }

    public ObjectProperty<Double> influenceOnPointPositionYProperty() {
        return this.influenceOnPointPositionY;
    }

    public Double getInfluenceOnPointPositionY() {
        return (Double)this.influenceOnPointPositionYProperty().get();
    }

    public void setInfluenceOnPointPositionY(Double influenceOnPointPositionY) {
        this.influenceOnPointPositionYProperty().set((Object)influenceOnPointPositionY);
    }

    public ObjectProperty<Double> influenceOnPointPositionZProperty() {
        return this.influenceOnPointPositionZ;
    }

    public Double getInfluenceOnPointPositionZ() {
        return (Double)this.influenceOnPointPositionZProperty().get();
    }

    public void setInfluenceOnPointPositionZ(Double influenceOnPointPositionZ) {
        this.influenceOnPointPositionZProperty().set((Object)influenceOnPointPositionZ);
    }

    public ObjectProperty<Double> influenceOnNetworkDistortionProperty() {
        return this.influenceOnNetworkDistortion;
    }

    public Double getInfluenceOnNetworkDistortion() {
        return (Double)this.influenceOnNetworkDistortionProperty().get();
    }

    public void setInfluenceOnNetworkDistortion(Double influenceOnNetworkDistortion) {
        this.influenceOnNetworkDistortionProperty().set((Object)influenceOnNetworkDistortion);
    }

    public ObjectProperty<Integer> numberOfObservationsProperty() {
        return this.numberOfObservations;
    }

    public Integer getNumberOfObservations() {
        return (Integer)this.numberOfObservationsProperty().get();
    }

    public void setNumberOfObservations(Integer numberOfObservations) {
        this.numberOfObservationsProperty().set((Object)numberOfObservations);
    }

    public final BooleanProperty significantProperty() {
        return this.significant;
    }

    public final boolean isSignificant() {
        return this.significantProperty().get();
    }

    public final void setSignificant(boolean significant) {
        this.significantProperty().set(significant);
    }

    public static PointRow cloneRowApriori(PointRow row) {
        PointRow clone = new PointRow();
        clone.setId(-1);
        clone.setGroupId(row.getGroupId());
        clone.setEnable(row.isEnable());
        clone.setName(row.getName());
        clone.setCode(row.getCode());
        clone.setXApriori(row.getXApriori());
        clone.setYApriori(row.getYApriori());
        clone.setZApriori(row.getZApriori());
        clone.setSigmaXapriori(row.getSigmaXapriori());
        clone.setSigmaYapriori(row.getSigmaYapriori());
        clone.setSigmaZapriori(row.getSigmaZapriori());
        return clone;
    }

    private static PointRow scan1D(String str) {
        String[] data;
        FormatterOptions options;
        block6: {
            options = FormatterOptions.getInstance();
            try {
                data = str.trim().split("[\\s;]+");
                if (data.length >= 2) break block6;
                return null;
            }
            catch (Exception exception) {
                return null;
            }
        }
        PointRow row = new PointRow();
        String name = data[0];
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        double sigmaZ = 0.0;
        row.setName(name);
        y = z = options.convertLengthToModel(Double.parseDouble(data[1].replace(',', '.')));
        if (data.length < 3) {
            row.setZApriori(z);
            return row;
        }
        x = sigmaZ = options.convertLengthToModel(Double.parseDouble(data[2].replace(',', '.')));
        if (data.length < 4) {
            row.setZApriori(z);
            row.setSigmaZapriori(sigmaZ);
            return row;
        }
        z = options.convertLengthToModel(Double.parseDouble(data[3].replace(',', '.')));
        if (data.length < 5) {
            row.setYApriori(y);
            row.setXApriori(x);
            row.setZApriori(z);
            return row;
        }
        sigmaZ = options.convertLengthToModel(Double.parseDouble(data[4].replace(',', '.')));
        row.setYApriori(y);
        row.setXApriori(x);
        row.setZApriori(z);
        row.setSigmaZapriori(sigmaZ);
        return row;
    }

    private static PointRow scan2D(String str) {
        String[] data;
        FormatterOptions options;
        block5: {
            options = FormatterOptions.getInstance();
            try {
                data = str.trim().split("[\\s;]+");
                if (data.length >= 3) break block5;
                return null;
            }
            catch (Exception exception) {
                return null;
            }
        }
        PointRow row = new PointRow();
        String name = data[0];
        double x = 0.0;
        double y = 0.0;
        double sigmaY = 0.0;
        double sigmaX = 0.0;
        row.setName(name);
        y = options.convertLengthToModel(Double.parseDouble(data[1].replace(',', '.')));
        x = options.convertLengthToModel(Double.parseDouble(data[2].replace(',', '.')));
        if (data.length < 4) {
            row.setYApriori(y);
            row.setXApriori(x);
            return row;
        }
        sigmaY = sigmaX = options.convertLengthToModel(Double.parseDouble(data[3].replace(',', '.')));
        if (data.length < 5) {
            row.setYApriori(y);
            row.setXApriori(x);
            row.setSigmaYapriori(sigmaY);
            row.setSigmaXapriori(sigmaX);
            return row;
        }
        sigmaX = options.convertLengthToModel(Double.parseDouble(data[4].replace(',', '.')));
        row.setYApriori(y);
        row.setXApriori(x);
        row.setSigmaYapriori(sigmaY);
        row.setSigmaXapriori(sigmaX);
        return row;
    }

    private static PointRow scan3D(String str) {
        String[] data;
        FormatterOptions options;
        block6: {
            options = FormatterOptions.getInstance();
            try {
                data = str.trim().split("[\\s;]+");
                if (data.length >= 4) break block6;
                return null;
            }
            catch (Exception exception) {
                return null;
            }
        }
        PointRow row = new PointRow();
        String name = data[0];
        double y = 0.0;
        double x = 0.0;
        double z = 0.0;
        double sigmaY = 0.0;
        double sigmaX = 0.0;
        double sigmaZ = 0.0;
        row.setName(name);
        y = options.convertLengthToModel(Double.parseDouble(data[1].replace(',', '.')));
        x = options.convertLengthToModel(Double.parseDouble(data[2].replace(',', '.')));
        z = options.convertLengthToModel(Double.parseDouble(data[3].replace(',', '.')));
        if (data.length < 5) {
            row.setYApriori(y);
            row.setXApriori(x);
            row.setZApriori(z);
            return row;
        }
        sigmaX = sigmaZ = options.convertLengthToModel(Double.parseDouble(data[4].replace(',', '.')));
        sigmaY = sigmaZ;
        if (data.length < 6) {
            row.setYApriori(y);
            row.setXApriori(x);
            row.setZApriori(z);
            row.setSigmaYapriori(sigmaY);
            row.setSigmaXapriori(sigmaX);
            row.setSigmaZapriori(sigmaZ);
            return row;
        }
        sigmaX = sigmaZ = options.convertLengthToModel(Double.parseDouble(data[5].replace(',', '.')));
        if (data.length < 7) {
            row.setYApriori(y);
            row.setXApriori(x);
            row.setZApriori(z);
            row.setSigmaYapriori(sigmaY);
            row.setSigmaXapriori(sigmaY);
            row.setSigmaZapriori(sigmaZ);
            return row;
        }
        sigmaZ = options.convertLengthToModel(Double.parseDouble(data[6].replace(',', '.')));
        row.setYApriori(y);
        row.setXApriori(x);
        row.setZApriori(z);
        row.setSigmaYapriori(sigmaY);
        row.setSigmaXapriori(sigmaX);
        row.setSigmaZapriori(sigmaZ);
        return row;
    }

    public static PointRow scan(String str, int dimension) {
        if (dimension == 1) {
            return PointRow.scan1D(str);
        }
        if (dimension == 2) {
            return PointRow.scan2D(str);
        }
        if (dimension == 3) {
            return PointRow.scan3D(str);
        }
        return null;
    }
}

