/*
 * Decompiled with CFR 0.152.
 */
package org.applied_geodesy.jag3d.ui.table.row;

import java.util.Locale;
import java.util.Scanner;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import org.applied_geodesy.jag3d.ui.table.row.ObservationRow;
import org.applied_geodesy.util.FormatterOptions;

public class GNSSObservationRow
extends ObservationRow {
    private ObjectProperty<Double> xApriori = new SimpleObjectProperty((Object)this, "xApriori", (Object)0.0);
    private ObjectProperty<Double> yApriori = new SimpleObjectProperty((Object)this, "yApriori", (Object)0.0);
    private ObjectProperty<Double> zApriori = new SimpleObjectProperty((Object)this, "zApriori", (Object)0.0);
    private ObjectProperty<Double> sigmaXapriori = new SimpleObjectProperty((Object)this, "sigmaXapriori");
    private ObjectProperty<Double> sigmaYapriori = new SimpleObjectProperty((Object)this, "sigmaYapriori");
    private ObjectProperty<Double> sigmaZapriori = new SimpleObjectProperty((Object)this, "sigmaZapriori");
    private ObjectProperty<Double> xAposteriori = new SimpleObjectProperty((Object)this, "xAposteriori");
    private ObjectProperty<Double> yAposteriori = new SimpleObjectProperty((Object)this, "yAposteriori");
    private ObjectProperty<Double> zAposteriori = new SimpleObjectProperty((Object)this, "zAposteriori");
    private ObjectProperty<Double> sigmaXaposteriori = new SimpleObjectProperty((Object)this, "sigmaXaposteriori");
    private ObjectProperty<Double> sigmaYaposteriori = new SimpleObjectProperty((Object)this, "sigmaYaposteriori");
    private ObjectProperty<Double> sigmaZaposteriori = new SimpleObjectProperty((Object)this, "sigmaZaposteriori");
    private ObjectProperty<Double> minimalDetectableBiasX = new SimpleObjectProperty((Object)this, "minimalDetectableBiasX");
    private ObjectProperty<Double> minimalDetectableBiasY = new SimpleObjectProperty((Object)this, "minimalDetectableBiasY");
    private ObjectProperty<Double> minimalDetectableBiasZ = new SimpleObjectProperty((Object)this, "minimalDetectableBiasZ");
    private ObjectProperty<Double> maximumTolerableBiasX = new SimpleObjectProperty((Object)this, "maximumTolerableBiasX");
    private ObjectProperty<Double> maximumTolerableBiasY = new SimpleObjectProperty((Object)this, "maximumTolerableBiasY");
    private ObjectProperty<Double> maximumTolerableBiasZ = new SimpleObjectProperty((Object)this, "maximumTolerableBiasZ");
    private ObjectProperty<Double> residualX = new SimpleObjectProperty((Object)this, "residualX");
    private ObjectProperty<Double> residualY = new SimpleObjectProperty((Object)this, "residualY");
    private ObjectProperty<Double> residualZ = new SimpleObjectProperty((Object)this, "residualZ");
    private ObjectProperty<Double> redundancyX = new SimpleObjectProperty((Object)this, "redundancyX");
    private ObjectProperty<Double> redundancyY = new SimpleObjectProperty((Object)this, "redundancyY");
    private ObjectProperty<Double> redundancyZ = new SimpleObjectProperty((Object)this, "redundancyZ");
    private ObjectProperty<Double> grossErrorX = new SimpleObjectProperty((Object)this, "grossErrorX");
    private ObjectProperty<Double> grossErrorY = new SimpleObjectProperty((Object)this, "grossErrorY");
    private ObjectProperty<Double> grossErrorZ = new SimpleObjectProperty((Object)this, "grossErrorZ");
    private ObjectProperty<Double> influenceOnPointPositionX = new SimpleObjectProperty((Object)this, "influenceOnPointPositionX");
    private ObjectProperty<Double> influenceOnPointPositionY = new SimpleObjectProperty((Object)this, "influenceOnPointPositionY");
    private ObjectProperty<Double> influenceOnPointPositionZ = new SimpleObjectProperty((Object)this, "influenceOnPointPositionZ");

    public ObjectProperty<Double> xAprioriProperty() {
        return this.xApriori;
    }

    public Double getXApriori() {
        return (Double)this.xAprioriProperty().get();
    }

    public void setXApriori(Double xApriori) {
        this.xAprioriProperty().set((Object)xApriori);
    }

    public ObjectProperty<Double> yAprioriProperty() {
        return this.yApriori;
    }

    public Double getYApriori() {
        return (Double)this.yAprioriProperty().get();
    }

    public void setYApriori(Double yApriori) {
        this.yAprioriProperty().set((Object)yApriori);
    }

    public ObjectProperty<Double> zAprioriProperty() {
        return this.zApriori;
    }

    public Double getZApriori() {
        return (Double)this.zAprioriProperty().get();
    }

    public void setZApriori(Double zApriori) {
        this.zAprioriProperty().set((Object)zApriori);
    }

    public ObjectProperty<Double> sigmaXaprioriProperty() {
        return this.sigmaXapriori;
    }

    public Double getSigmaXapriori() {
        return (Double)this.sigmaXaprioriProperty().get();
    }

    public void setSigmaXapriori(Double sigmaXapriori) {
        this.sigmaXaprioriProperty().set((Object)sigmaXapriori);
    }

    public ObjectProperty<Double> sigmaYaprioriProperty() {
        return this.sigmaYapriori;
    }

    public Double getSigmaYapriori() {
        return (Double)this.sigmaYaprioriProperty().get();
    }

    public void setSigmaYapriori(Double sigmaYapriori) {
        this.sigmaYaprioriProperty().set((Object)sigmaYapriori);
    }

    public ObjectProperty<Double> sigmaZaprioriProperty() {
        return this.sigmaZapriori;
    }

    public Double getSigmaZapriori() {
        return (Double)this.sigmaZaprioriProperty().get();
    }

    public void setSigmaZapriori(Double sigmaZapriori) {
        this.sigmaZaprioriProperty().set((Object)sigmaZapriori);
    }

    public ObjectProperty<Double> xAposterioriProperty() {
        return this.xAposteriori;
    }

    public Double getXAposteriori() {
        return (Double)this.xAposterioriProperty().get();
    }

    public void setXAposteriori(Double xAposteriori) {
        this.xAposterioriProperty().set((Object)xAposteriori);
    }

    public ObjectProperty<Double> yAposterioriProperty() {
        return this.yAposteriori;
    }

    public Double getYAposteriori() {
        return (Double)this.yAposterioriProperty().get();
    }

    public void setYAposteriori(Double yAposteriori) {
        this.yAposterioriProperty().set((Object)yAposteriori);
    }

    public ObjectProperty<Double> zAposterioriProperty() {
        return this.zAposteriori;
    }

    public Double getZAposteriori() {
        return (Double)this.zAposterioriProperty().get();
    }

    public void setZAposteriori(Double zAposteriori) {
        this.zAposterioriProperty().set((Object)zAposteriori);
    }

    public ObjectProperty<Double> sigmaXaposterioriProperty() {
        return this.sigmaXaposteriori;
    }

    public Double getSigmaXaposteriori() {
        return (Double)this.sigmaXaposterioriProperty().get();
    }

    public void setSigmaXaposteriori(Double sigmaXaposteriori) {
        this.sigmaXaposterioriProperty().set((Object)sigmaXaposteriori);
    }

    public ObjectProperty<Double> sigmaYaposterioriProperty() {
        return this.sigmaYaposteriori;
    }

    public Double getSigmaYaposteriori() {
        return (Double)this.sigmaYaposterioriProperty().get();
    }

    public void setSigmaYaposteriori(Double sigmaYaposteriori) {
        this.sigmaYaposterioriProperty().set((Object)sigmaYaposteriori);
    }

    public ObjectProperty<Double> sigmaZaposterioriProperty() {
        return this.sigmaZaposteriori;
    }

    public Double getSigmaZaposteriori() {
        return (Double)this.sigmaZaposterioriProperty().get();
    }

    public void setSigmaZaposteriori(Double sigmaZaposteriori) {
        this.sigmaZaposterioriProperty().set((Object)sigmaZaposteriori);
    }

    public ObjectProperty<Double> minimalDetectableBiasXProperty() {
        return this.minimalDetectableBiasX;
    }

    public Double getMinimalDetectableBiasX() {
        return (Double)this.minimalDetectableBiasXProperty().get();
    }

    public void setMinimalDetectableBiasX(Double minimalDetectableBiasX) {
        this.minimalDetectableBiasXProperty().set((Object)minimalDetectableBiasX);
    }

    public ObjectProperty<Double> minimalDetectableBiasYProperty() {
        return this.minimalDetectableBiasY;
    }

    public Double getMinimalDetectableBiasY() {
        return (Double)this.minimalDetectableBiasYProperty().get();
    }

    public void setMinimalDetectableBiasY(Double minimalDetectableBiasY) {
        this.minimalDetectableBiasYProperty().set((Object)minimalDetectableBiasY);
    }

    public ObjectProperty<Double> minimalDetectableBiasZProperty() {
        return this.minimalDetectableBiasZ;
    }

    public Double getMinimalDetectableBiasZ() {
        return (Double)this.minimalDetectableBiasZProperty().get();
    }

    public void setMinimalDetectableBiasZ(Double minimalDetectableBiasZ) {
        this.minimalDetectableBiasZProperty().set((Object)minimalDetectableBiasZ);
    }

    public ObjectProperty<Double> maximumTolerableBiasXProperty() {
        return this.maximumTolerableBiasX;
    }

    public Double getMaximumTolerableBiasX() {
        return (Double)this.maximumTolerableBiasXProperty().get();
    }

    public void setMaximumTolerableBiasX(Double maximumTolerableBiasX) {
        this.maximumTolerableBiasXProperty().set((Object)maximumTolerableBiasX);
    }

    public ObjectProperty<Double> maximumTolerableBiasYProperty() {
        return this.maximumTolerableBiasY;
    }

    public Double getMaximumTolerableBiasY() {
        return (Double)this.maximumTolerableBiasYProperty().get();
    }

    public void setMaximumTolerableBiasY(Double maximumTolerableBiasY) {
        this.maximumTolerableBiasYProperty().set((Object)maximumTolerableBiasY);
    }

    public ObjectProperty<Double> maximumTolerableBiasZProperty() {
        return this.maximumTolerableBiasZ;
    }

    public Double getMaximumTolerableBiasZ() {
        return (Double)this.maximumTolerableBiasZProperty().get();
    }

    public void setMaximumTolerableBiasZ(Double maximumTolerableBiasZ) {
        this.maximumTolerableBiasZProperty().set((Object)maximumTolerableBiasZ);
    }

    public final ObjectProperty<Double> residualXProperty() {
        return this.residualX;
    }

    public final Double getResidualX() {
        return (Double)this.residualXProperty().get();
    }

    public final void setResidualX(Double residualX) {
        this.residualXProperty().set((Object)residualX);
    }

    public final ObjectProperty<Double> residualYProperty() {
        return this.residualY;
    }

    public final Double getResidualY() {
        return (Double)this.residualYProperty().get();
    }

    public final void setResidualY(Double residualY) {
        this.residualYProperty().set((Object)residualY);
    }

    public final ObjectProperty<Double> residualZProperty() {
        return this.residualZ;
    }

    public final Double getResidualZ() {
        return (Double)this.residualZProperty().get();
    }

    public final void setResidualZ(Double residualZ) {
        this.residualZProperty().set((Object)residualZ);
    }

    public ObjectProperty<Double> redundancyXProperty() {
        return this.redundancyX;
    }

    public Double getRedundancyX() {
        return (Double)this.redundancyXProperty().get();
    }

    public void setRedundancyX(Double redundancyX) {
        this.redundancyXProperty().set((Object)redundancyX);
    }

    public ObjectProperty<Double> redundancyYProperty() {
        return this.redundancyY;
    }

    public Double getRedundancyY() {
        return (Double)this.redundancyYProperty().get();
    }

    public void setRedundancyY(Double redundancyY) {
        this.redundancyYProperty().set((Object)redundancyY);
    }

    public ObjectProperty<Double> redundancyZProperty() {
        return this.redundancyZ;
    }

    public Double getRedundancyZ() {
        return (Double)this.redundancyZProperty().get();
    }

    public void setRedundancyZ(Double redundancyZ) {
        this.redundancyZProperty().set((Object)redundancyZ);
    }

    public ObjectProperty<Double> grossErrorXProperty() {
        return this.grossErrorX;
    }

    public Double getGrossErrorX() {
        return (Double)this.grossErrorXProperty().get();
    }

    public void setGrossErrorX(Double nablaX) {
        this.grossErrorXProperty().set((Object)nablaX);
    }

    public ObjectProperty<Double> grossErrorYProperty() {
        return this.grossErrorY;
    }

    public Double getGrossErrorY() {
        return (Double)this.grossErrorYProperty().get();
    }

    public void setGrossErrorY(Double nablaY) {
        this.grossErrorYProperty().set((Object)nablaY);
    }

    public ObjectProperty<Double> grossErrorZProperty() {
        return this.grossErrorZ;
    }

    public Double getGrossErrorZ() {
        return (Double)this.grossErrorZProperty().get();
    }

    public void setGrossErrorZ(Double nablaZ) {
        this.grossErrorZProperty().set((Object)nablaZ);
    }

    public ObjectProperty<Double> influenceOnPointPositionXProperty() {
        return this.influenceOnPointPositionX;
    }

    public Double getInfluenceOnPointPositionX() {
        return (Double)this.influenceOnPointPositionXProperty().get();
    }

    public void setInfluenceOnPointPositionX(Double influenceOnPointPositionX) {
        this.influenceOnPointPositionXProperty().set((Object)influenceOnPointPositionX);
    }

    public ObjectProperty<Double> influenceOnPointPositionYProperty() {
        return this.influenceOnPointPositionY;
    }

    public Double getInfluenceOnPointPositionY() {
        return (Double)this.influenceOnPointPositionYProperty().get();
    }

    public void setInfluenceOnPointPositionY(Double influenceOnPointPositionY) {
        this.influenceOnPointPositionYProperty().set((Object)influenceOnPointPositionY);
    }

    public ObjectProperty<Double> influenceOnPointPositionZProperty() {
        return this.influenceOnPointPositionZ;
    }

    public Double getInfluenceOnPointPositionZ() {
        return (Double)this.influenceOnPointPositionZProperty().get();
    }

    public void setInfluenceOnPointPositionZ(Double influenceOnPointPositionZ) {
        this.influenceOnPointPositionZProperty().set((Object)influenceOnPointPositionZ);
    }

    public static GNSSObservationRow cloneRowApriori(GNSSObservationRow row) {
        GNSSObservationRow clone = new GNSSObservationRow();
        clone.setId(-1);
        clone.setGroupId(row.getGroupId());
        clone.setEnable(row.isEnable());
        clone.setStartPointName(row.getStartPointName());
        clone.setEndPointName(row.getEndPointName());
        clone.setXApriori(row.getXApriori());
        clone.setYApriori(row.getYApriori());
        clone.setZApriori(row.getZApriori());
        clone.setSigmaXapriori(row.getSigmaXapriori());
        clone.setSigmaYapriori(row.getSigmaYapriori());
        clone.setSigmaZapriori(row.getSigmaZapriori());
        return clone;
    }

    public static GNSSObservationRow scan(String str, int dim) {
        if (dim == 1) {
            return GNSSObservationRow.scan1D(str);
        }
        if (dim == 2) {
            return GNSSObservationRow.scan2D(str);
        }
        if (dim == 3) {
            return GNSSObservationRow.scan3D(str);
        }
        return null;
    }

    private static GNSSObservationRow scan1D(String str) {
        FormatterOptions options = FormatterOptions.getInstance();
        try (Scanner scanner = new Scanner(str.trim());){
            scanner.useLocale(Locale.ENGLISH);
            String startPointName = new String();
            String endPointName = new String();
            double x = 0.0;
            double y = 0.0;
            double z = 0.0;
            double sigmaZ = 0.0;
            GNSSObservationRow row = new GNSSObservationRow();
            if (!scanner.hasNext()) {
                return null;
            }
            startPointName = scanner.next();
            if (!scanner.hasNext()) {
                return null;
            }
            endPointName = scanner.next();
            if (startPointName.equals(endPointName)) {
                return null;
            }
            row.setStartPointName(startPointName);
            row.setEndPointName(endPointName);
            if (!scanner.hasNextDouble()) {
                return null;
            }
            y = z = options.convertLengthToModel(scanner.nextDouble());
            if (!scanner.hasNextDouble()) {
                row.setZApriori(z);
                GNSSObservationRow gNSSObservationRow = row;
                return gNSSObservationRow;
            }
            x = sigmaZ = options.convertLengthToModel(scanner.nextDouble());
            if (!scanner.hasNextDouble()) {
                row.setZApriori(z);
                row.setSigmaZapriori(sigmaZ);
                GNSSObservationRow gNSSObservationRow = row;
                return gNSSObservationRow;
            }
            z = options.convertLengthToModel(scanner.nextDouble());
            if (!scanner.hasNextDouble()) {
                row.setXApriori(x);
                row.setYApriori(y);
                row.setZApriori(z);
                GNSSObservationRow gNSSObservationRow = row;
                return gNSSObservationRow;
            }
            sigmaZ = options.convertLengthToModel(scanner.nextDouble());
            row.setXApriori(x);
            row.setYApriori(y);
            row.setZApriori(z);
            row.setSigmaZapriori(sigmaZ);
            GNSSObservationRow gNSSObservationRow = row;
            return gNSSObservationRow;
        }
    }

    private static GNSSObservationRow scan2D(String str) {
        FormatterOptions options = FormatterOptions.getInstance();
        try (Scanner scanner = new Scanner(str.trim());){
            scanner.useLocale(Locale.ENGLISH);
            String startPointName = new String();
            String endPointName = new String();
            double x = 0.0;
            double y = 0.0;
            double sigmaX = 0.0;
            double sigmaY = 0.0;
            GNSSObservationRow row = new GNSSObservationRow();
            if (!scanner.hasNext()) {
                return null;
            }
            startPointName = scanner.next();
            if (!scanner.hasNext()) {
                return null;
            }
            endPointName = scanner.next();
            if (startPointName.equals(endPointName)) {
                return null;
            }
            row.setStartPointName(startPointName);
            row.setEndPointName(endPointName);
            if (!scanner.hasNextDouble()) {
                return null;
            }
            y = options.convertLengthToModel(scanner.nextDouble());
            if (!scanner.hasNextDouble()) {
                return null;
            }
            x = options.convertLengthToModel(scanner.nextDouble());
            if (!scanner.hasNextDouble()) {
                row.setXApriori(x);
                row.setYApriori(y);
                GNSSObservationRow gNSSObservationRow = row;
                return gNSSObservationRow;
            }
            sigmaX = sigmaY = options.convertLengthToModel(scanner.nextDouble());
            if (!scanner.hasNextDouble()) {
                row.setXApriori(x);
                row.setYApriori(y);
                row.setSigmaXapriori(sigmaX);
                row.setSigmaYapriori(sigmaY);
                GNSSObservationRow gNSSObservationRow = row;
                return gNSSObservationRow;
            }
            sigmaX = options.convertLengthToModel(scanner.nextDouble());
            row.setXApriori(x);
            row.setYApriori(y);
            row.setSigmaXapriori(sigmaX);
            row.setSigmaYapriori(sigmaY);
            GNSSObservationRow gNSSObservationRow = row;
            return gNSSObservationRow;
        }
    }

    private static GNSSObservationRow scan3D(String str) {
        FormatterOptions options = FormatterOptions.getInstance();
        try (Scanner scanner = new Scanner(str.trim());){
            scanner.useLocale(Locale.ENGLISH);
            String startPointName = new String();
            String endPointName = new String();
            double x = 0.0;
            double y = 0.0;
            double z = 0.0;
            double sigmaX = 0.0;
            double sigmaY = 0.0;
            double sigmaZ = 0.0;
            GNSSObservationRow row = new GNSSObservationRow();
            if (!scanner.hasNext()) {
                return null;
            }
            startPointName = scanner.next();
            if (!scanner.hasNext()) {
                return null;
            }
            endPointName = scanner.next();
            if (startPointName.equals(endPointName)) {
                return null;
            }
            row.setStartPointName(startPointName);
            row.setEndPointName(endPointName);
            if (!scanner.hasNextDouble()) {
                return null;
            }
            y = options.convertLengthToModel(scanner.nextDouble());
            if (!scanner.hasNextDouble()) {
                return null;
            }
            x = options.convertLengthToModel(scanner.nextDouble());
            if (!scanner.hasNextDouble()) {
                return null;
            }
            z = options.convertLengthToModel(scanner.nextDouble());
            if (!scanner.hasNextDouble()) {
                row.setXApriori(x);
                row.setYApriori(y);
                row.setZApriori(z);
                GNSSObservationRow gNSSObservationRow = row;
                return gNSSObservationRow;
            }
            sigmaX = sigmaZ = options.convertLengthToModel(scanner.nextDouble());
            sigmaY = sigmaZ;
            if (!scanner.hasNextDouble()) {
                row.setXApriori(x);
                row.setYApriori(y);
                row.setZApriori(z);
                row.setSigmaXapriori(sigmaX);
                row.setSigmaYapriori(sigmaY);
                row.setSigmaZapriori(sigmaZ);
                GNSSObservationRow gNSSObservationRow = row;
                return gNSSObservationRow;
            }
            sigmaX = sigmaZ = options.convertLengthToModel(scanner.nextDouble());
            if (!scanner.hasNextDouble()) {
                row.setXApriori(x);
                row.setYApriori(y);
                row.setZApriori(z);
                row.setSigmaXapriori(sigmaY);
                row.setSigmaYapriori(sigmaY);
                row.setSigmaZapriori(sigmaZ);
                GNSSObservationRow gNSSObservationRow = row;
                return gNSSObservationRow;
            }
            sigmaZ = options.convertLengthToModel(scanner.nextDouble());
            row.setXApriori(x);
            row.setYApriori(y);
            row.setZApriori(z);
            row.setSigmaXapriori(sigmaX);
            row.setSigmaYapriori(sigmaY);
            row.setSigmaZapriori(sigmaZ);
            GNSSObservationRow gNSSObservationRow = row;
            return gNSSObservationRow;
        }
    }
}

